(function () {
    "use strict";

    // jalali datepicker
    $(".jalali-datepicker").each(function () {
        let options = {
            autoApply: false,
            singleMode: false,
            numberOfColumns: 2,
            numberOfMonths: 2,
            showWeekNumbers: true,
            format: "D MMM, YYYY",
            dropdowns: {
                minYear: 1990,
                maxYear: null,
                months: true,
                years: true,
            },
        };

        if ($(this).data("single-mode")) {
            options.singleMode = true;
            options.numberOfColumns = 1;
            options.numberOfMonths = 1;
        }

        if ($(this).data("format")) {
            options.format = $(this).data("format");
        }

        if (!$(this).val()) {
            // Create the date object
            const date = new Date(); // You can pass any Date object here

            // Create Intl.DateTimeFormat for Persian calendar with desired options
            const formatter = new Intl.DateTimeFormat('fa-IR-u-ca-persian', {
                year: 'numeric',
                month: '2-digit',
                day: '2-digit',
                numberingSystem: 'latn' // This ensures Latin digits
            });

            // Format the date
            const formattedDate = formatter.format(date);
            console.log(formattedDate);

            $(this).val(formattedDate);
        }

        jalaliDatepicker.startWatch(options);
    });
})();
