@props(['variant' => null, 'type' => null, 'src' => null])

<div {{ $attributes->merge($attributes->whereDoesntStartWith('class')->getAttributes()) }}>
    <div @class([
        'relative block bg-center bg-no-repeat bg-contain',
        'before:content-[\'\'] before:pt-[100%] before:w-full before:block',
        'bg-file-icon-empty-directory' => $variant == 'empty-directory',
        'bg-file-icon-directory' => $variant == 'directory',
        'bg-file-icon-file' => $variant == 'file',
    ])>
        @if ($variant == 'file')
            <div class="absolute bottom-0 start-0 end-0 top-0 m-auto flex items-center justify-center text-white">
                {{ $type }}
            </div>
        @elseif ($variant == 'image')
            <div class="image-fit absolute start-0 top-0 h-full w-full">
                <img
                    class="rounded-md"
                    src="{{ $src }}"
                    alt="تیل وایز - قالب داشبورد مدیریتی"
                >
            </div>
        @endif
    </div>
</div>
