@props(['icon' => null, 'width' => 24, 'height' => 24])

@php
    // Assuming you have a helper or session value to determine the current direction
    $direction = session('direction', 'rtl'); // You can adjust this based on your app logic

    // Use a local closure to avoid function redeclaration errors
    $transformedIcon = (function($icon, $direction) {
        if ($direction === 'rtl') {
            // First replace 'Left' with a placeholder, then 'Right' with 'Left', and finally the placeholder with 'Right'
            if ($icon !== 'LayoutPanelLeft') {
                return str_replace('Temp', 'Right', str_replace('Right', 'Left', str_replace('Left', 'Temp', $icon)));
            }
        }
        return $icon; // Return the original icon for LTR
    })($icon, $direction); // Immediately call the closure
@endphp

<i
    data-tw-merge
    data-lucide="{{ uncamelize($transformedIcon, '-') }}"
    {{ $attributes->class(merge(['stroke-[1] w-5 h-5', $attributes->whereStartsWith('class')->first()]))->merge($attributes->whereDoesntStartWith('class')->getAttributes()) }}
></i>

@pushOnce('vendors')
    @vite('resources/js/vendors/lucide.js')
@endPushOnce

@pushOnce('scripts')
    @vite('resources/js/components/base/lucide.js')
@endPushOnce
