@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    آکاردئون
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    مؤلفه آکاردئون ما را کاوش کنید، سازماندهی محتوای بی‌دردسر و
                    ارائه!
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    آکاردئون پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه آکاردئون پایه یک روش قدرتمند و انعطاف‌پذیر
                                    برای سازماندهی و ارائه اطلاعات در وب‌سایت شما است
                                    یا برنامه. این به شما امکان می‌دهد که بخش‌های قابل جمع‌شدنی ایجاد کنید
                                    از محتوا، که برای کاربران دسترسی آسان به اطلاعات را فراهم می‌کند
                                    بدون آن‌که با متن بیش از حدی آن‌ها را متاثر کند.
                                    یا جزئیات به طور همزمان.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.disclosure.group>
                                                <x-base.disclosure
                                                    id="faq-accordion-1"
                                                    :index="0"
                                                >
                                                    <x-base.disclosure.button>
                                                        اساسات OpenSSL: کار با گواهی‌نامه‌های SSL،
                                                        کلیدهای خصوصی
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-2"
                                                    :index="1"
                                                >
                                                    <x-base.disclosure.button>
                                                        درک آدرس‌های IP، زیرشبکه‌ها و نمادهای CIDR
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-3"
                                                    :index="2"
                                                >
                                                    <x-base.disclosure.button>
                                                        رفع مشکل کدهای خطای معمول HTTP
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-4"
                                                    :index="3"
                                                >
                                                    <x-base.disclosure.button>
                                                        معرفی امنیت وی‌پی‌اس لینوکس شما
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                            </x-base.disclosure.group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.disclosure.group>
                                                    <x-base.disclosure
                                                        id="faq-accordion-1"
                                                        :index="0"
                                                    >
                                                        <x-base.disclosure.button>
                                                            اساسات OpenSSL: کار با گواهی‌نامه‌های SSL،
                                                            کلیدهای خصوصی
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-2"
                                                        :index="1"
                                                    >
                                                        <x-base.disclosure.button>
                                                            درک آدرس‌های IP، زیرشبکه‌ها و نمادهای CIDR
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-3"
                                                        :index="2"
                                                    >
                                                        <x-base.disclosure.button>
                                                            رفع مشکل کدهای خطای معمول HTTP
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-4"
                                                        :index="3"
                                                    >
                                                        <x-base.disclosure.button>
                                                            معرفی امنیت وی‌پی‌اس لینوکس شما
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                </x-base.disclosure.group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    ظاهر بخش‌های آکاردئون خود را سفارشی‌سازی کنید و
                                    تا به سبک و طراحی برندتان بخورد.
                                    ترجیحات. با انواع مختلف محتوا و
                                    طرح‌ها برای ایجاد تجربه‌های جذاب و کاربرپسند
                                    experiences.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    آکاردئون با قالب
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "آکاردئون با قالب" روشی شیک و
                                    منظم برای ایجاد بخش‌های محتوای جمع‌شونده
                                    با ظاهری با قالب است. این نوعی از آکاردئون
                                    بسیار مناسب برای ارائه اطلاعات به صورت ساختارمند
                                    و جذاب است.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.disclosure.group variant="boxed">
                                                <x-base.disclosure
                                                    id="faq-accordion-5"
                                                    :index="0"
                                                >
                                                    <x-base.disclosure.button>
                                                        اساسات OpenSSL: کار با گواهی‌نامه‌های SSL،
                                                        کلیدهای خصوصی
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-6"
                                                    :index="1"
                                                >
                                                    <x-base.disclosure.button>
                                                        درک آدرس‌های IP، زیرشبکه‌ها و نمادهای CIDR
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-7"
                                                    :index="2"
                                                >
                                                    <x-base.disclosure.button>
                                                        رفع مشکل کدهای خطای معمول HTTP
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                                <x-base.disclosure
                                                    id="faq-accordion-8"
                                                    :index="3"
                                                >
                                                    <x-base.disclosure.button>
                                                        معرفی امنیت وی‌پی‌اس لینوکس شما
                                                    </x-base.disclosure.button>
                                                    <x-base.disclosure.panel
                                                        class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                    >
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                        متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                        زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                        آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                        نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                        به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                        unchanged.
                                                    </x-base.disclosure.panel>
                                                </x-base.disclosure>
                                            </x-base.disclosure.group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.disclosure.group variant="boxed">
                                                    <x-base.disclosure
                                                        id="faq-accordion-5"
                                                        :index="0"
                                                    >
                                                        <x-base.disclosure.button>
                                                            اساسات OpenSSL: کار با گواهی‌نامه‌های SSL،
                                                            کلیدهای خصوصی
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-6"
                                                        :index="1"
                                                    >
                                                        <x-base.disclosure.button>
                                                            درک آدرس‌های IP، زیرشبکه‌ها و نمادهای CIDR
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-7"
                                                        :index="2"
                                                    >
                                                        <x-base.disclosure.button>
                                                            رفع مشکل کدهای خطای معمول HTTP
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                    <x-base.disclosure
                                                        id="faq-accordion-8"
                                                        :index="3"
                                                    >
                                                        <x-base.disclosure.button>
                                                            معرفی امنیت وی‌پی‌اس لینوکس شما
                                                        </x-base.disclosure.button>
                                                        <x-base.disclosure.panel
                                                            class="leading-relaxed text-slate-600 dark:text-slate-500"
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            unchanged.
                                                        </x-base.disclosure.panel>
                                                    </x-base.disclosure>
                                                </x-base.disclosure.group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه آکاردئون با قالب یک راه زیبا و
                                    ترتیب و ارائه محتوا را که کاربران می‌توانند
                                    آن را گسترش و جمع کنند. آن را برای وفق به نیازهای پروژه‌تان
                                    سفارشی‌سازی کنید و تجربه کاربری را بر روی وب‌سایت یا
                                    برنامه‌تان بهبود بخشید. لذت ببرید از استفاده از آکاردئون با قالب!
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Disclosure</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Disclosure.Group</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML یا کامپوننت React.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`selectedIndex`</x-base.table.td>
                                                <x-base.table.td>`number`</x-base.table.td>
                                                <x-base.table.td>
                                                    فهرستی که در آن فعال است.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`variant`</x-base.table.td>
                                                <x-base.table.td>نوع ('default' یا 'boxed')</x-base.table.td>
                                                <x-base.table.td>Disclosure.Group با نوع ظاهری.</x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Disclosure.Button</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Disclosure.Panel</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    آکاردئون پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    آکاردئون با قالب
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
