@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex flex-col mt-4 gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    افزودن محصول
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative flex flex-col col-span-12 gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                اطلاعات محصول
                            </div>
                            <div class="mt-5">
                                <x-base.alert
                                    class="flex items-center px-4 mb-2 border-warning/30 bg-warning/5"
                                    variant="outline-warning"
                                >
                                    <div>
                                        <x-base.lucide
                                            class="me-3 h-4 w-4 stroke-[1.3] 2xl:me-2"
                                            icon="Lightbulb"
                                        />
                                    </div>
                                    <div class="me-5 leading-relaxed">
                                        از فروش محصولات قلباز / نقض حقوق مالکیت فکری اجتناب کنید،
                                        حقوق مالکیت فکری، تا محصولات شما
                                        حذف نشوند.
                                        <a
                                            class="ms-1 font-medium underline decoration-warning/50 decoration-dotted underline-offset-[3px]"
                                            href=""
                                        >
                                            بیشتر بدانید
                                        </a>
                                        <x-base.alert.dismiss-button class="inset-y-0 btn-close">
                                            <x-base.lucide
                                                class="w-4 h-4"
                                                icon="X"
                                            />
                                        </x-base.alert.dismiss-button>
                                    </div>
                                </x-base.alert>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نام محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نام یکتای محصول خود را وارد کنید. آن را
                                                توصیفی کنید و برای مشتریان به یادآوری آسان باشد.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="Product name"
                                        />
                                        <x-base.form-help>حداکثر تعداد کاراکتر 0/70</x-base.form-help>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">دسته</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                دسته‌ی اصلی را که بهترین نمایانگر محصول شماست انتخاب کنید. این به مشتریان کمک می‌کند که محصول شما را
                                                به‌طور آسان‌تر پیدا کنند.
                                                بسادگی.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-select id="category">
                                            @foreach ($categories as $fakerKey => $faker)
                                                <option value="{{ $fakerKey }}">
                                                    {{ $faker['name'] }}
                                                </option>
                                            @endforeach
                                        </x-base.form-select>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">زیردسته</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                زیردسته‌ای را که به نزدیکی
                                                متناسب با محصول شماست انتخاب کنید. این اطلاعات جزئی‌تری را
                                                درباره مورد شما فراهم می‌کند.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.tom-select
                                            class="w-full"
                                            data-placeholder="Etalase"
                                            multiple
                                        >
                                            @foreach ($categories as $fakerKey => $faker)
                                                <option value="{{ $fakerKey }}">
                                                    {{ $faker['name'] }}
                                                </option>
                                            @endforeach
                                        </x-base.tom-select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/80 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/80 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                بارگذاری محصول
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">تصاویر محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                تصاویر با کیفیت بالا می‌توانند به شدت تأثیرگذار باشند
                                                بر جذابیت محصول شما. تصاویر واضح و روشنی بارگذاری کنید که
                                                محصول شما را از زوایا و دیدگاه‌های مختلف نشان دهند.
                                                پرسپکتیو.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="border border-dashed rounded-md border-slate-300/80">
                                            <div class="grid grid-cols-9 gap-5 px-5 pt-5 sm:grid-cols-10">
                                                @foreach ($products->take(5) as $fakerKey => $faker)
                                                    <div
                                                        class="relative h-24 col-span-3 cursor-pointer image-fit zoom-in md:col-span-2">
                                                        <img
                                                            class="rounded-lg"
                                                            src="{{ Vite::asset($faker['images'][0]['path']) }}"
                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                        >
                                                        <x-base.tippy
                                                            class="absolute top-0 end-0 w-5 h-5 -mt-2 -me-2 bg-white rounded-full"
                                                            content="حذف این تصویر؟?"
                                                        >
                                                            <span
                                                                class="flex items-center justify-center w-full h-full text-white border rounded-full border-danger/50 bg-danger/80">
                                                                <x-base.lucide
                                                                    class="h-4 w-4 stroke-[1.3]"
                                                                    icon="X"
                                                                />
                                                            </span>
                                                        </x-base.tippy>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div
                                                class="relative flex items-center justify-center px-4 pb-4 mt-5 cursor-pointer">
                                                <x-base.lucide
                                                    class="w-4 h-4 me-2"
                                                    icon="Image"
                                                />
                                                <span class="me-1 text-primary">
                                                    بارگذاری یک فایل
                                                </span>
                                                یا کشیدن و رها کردن
                                                <x-base.form-input
                                                    class="absolute top-0 start-0 w-full h-full opacity-0"
                                                    id="horizontal-form-1"
                                                    type="file"
                                                />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                جزئیات محصول
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">شرایط</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                شرایط محصول خود را به دقت انتخاب کنید تا
                                                انتظارات واضحی را برای خریداران تعیین کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="flex flex-col sm:flex-row">
                                            <x-base.form-check class="me-4">
                                                <x-base.form-check.input
                                                    id="condition-new"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-chris-evans"
                                                />
                                                <x-base.form-check.label for="condition-new">
                                                    New
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                            <x-base.form-check class="mt-2 me-4 sm:mt-0">
                                                <x-base.form-check.input
                                                    id="condition-second"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-liam-neeson"
                                                />
                                                <x-base.form-check.label for="condition-second">
                                                    ثانیه
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">توضیحات محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                یک توضیح جامع ایجاد کنید که ویژگی‌های یکتای، مزایا و مشخصات
                                                محصول شما را برجسته کند.
                                                product.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.classic-editor />
                                        <x-base.form-help class="text-end">
                                            حداکثر تعداد کاراکتر 0/2000
                                        </x-base.form-help>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">ویدئو محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                یک ویدئویی که محصول شما در حالت عملی را نشان می‌دهد اضافه کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.button
                                            class="w-40 border-primary/50"
                                            variant="outline-primary"
                                        >
                                            <x-base.lucide
                                                class="me-2 h-4 w-4 stroke-[1.3]"
                                                icon="Camera"
                                            />
                                            آدرس ویدئو را وارد کنید
                                        </x-base.button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                جزئیات محصول
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نسخه محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نام کامل و قانونی خود را به همان شکلی که در
                                                شناسنامه رسمی شما ظاهر می‌شود وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.button
                                            class="w-40 border-primary/50"
                                            variant="outline-primary"
                                        >
                                            <x-base.lucide
                                                class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                icon="KanbanSquare"
                                            />
                                            افزودن نسخه
                                        </x-base.button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                نسخه محصول (جزئیات)
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نسخه 1</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                وارد کردن تغییرات مختلف محصول شما، مانند
                                                اندازه، رنگ یا سبک.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div
                                            class="relative py-10 ps-5 pe-5 border rounded-md border-slate-200/80 bg-slate-50/80 dark:border dark:bg-transparent xl:pe-10">
                                            <a
                                                class="absolute top-0 end-0 mt-4 me-4 text-slate-500"
                                                href=""
                                            >
                                                <x-base.lucide
                                                    class="w-5 h-5"
                                                    icon="X"
                                                />
                                            </a>
                                            <div>
                                                <x-base.form-inline class="mt-5 first:mt-0">
                                                    <x-base.form-label class="sm:w-20">Name</x-base.form-label>
                                                    <div class="flex items-center flex-1 xl:pe-20">
                                                        <x-base.input-group class="flex-1">
                                                            <x-base.form-input
                                                                type="text"
                                                                placeholder="Size"
                                                            />
                                                            <x-base.input-group.text>6/14</x-base.input-group.text>
                                                        </x-base.input-group>
                                                    </div>
                                                </x-base.form-inline>
                                                <x-base.form-inline class="items-start mt-5 first:mt-0">
                                                    <x-base.form-label class="mt-2 sm:w-20">
                                                        گزینه‌ها
                                                    </x-base.form-label>
                                                    <div class="flex-1">
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="کوچک"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="متوسط"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="بزرگ"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </x-base.form-inline>
                                                <div class="mt-5 first:mt-0 xl:ms-20 xl:ps-5 xl:pe-20">
                                                    <x-base.button
                                                        class="w-full border-dashed"
                                                        variant="outline-primary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4 stroke-[1.3]"
                                                            icon="Plus"
                                                        />
                                                        افزودن گزینه
                                                    </x-base.button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-2 mt-2 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نوع ۲</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                وارد کردن تغییرات مختلف محصول شما، مانند
                                                اندازه، رنگ یا سبک.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div
                                            class="relative py-10 ps-5 pe-5 border rounded-md border-slate-200/80 bg-slate-50/80 dark:border dark:bg-transparent xl:pe-10">
                                            <a
                                                class="absolute top-0 end-0 mt-4 me-4 text-slate-500"
                                                href=""
                                            >
                                                <x-base.lucide
                                                    class="w-5 h-5"
                                                    icon="X"
                                                />
                                            </a>
                                            <div>
                                                <x-base.form-inline class="mt-5 first:mt-0">
                                                    <x-base.form-label class="sm:w-20">Name</x-base.form-label>
                                                    <div class="flex items-center flex-1 xl:pe-20">
                                                        <x-base.input-group class="flex-1">
                                                            <x-base.form-input
                                                                type="text"
                                                                placeholder="Size"
                                                            />
                                                            <x-base.input-group.text>6/14</x-base.input-group.text>
                                                        </x-base.input-group>
                                                    </div>
                                                </x-base.form-inline>
                                                <x-base.form-inline class="items-start mt-5 first:mt-0">
                                                    <x-base.form-label class="mt-2 sm:w-20">
                                                        گزینه‌ها
                                                    </x-base.form-label>
                                                    <div class="flex-1">
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="کوچک"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="متوسط"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="items-center mt-5 first:mt-0 xl:flex">
                                                            <x-base.input-group class="flex-1">
                                                                <x-base.form-input
                                                                    type="text"
                                                                    placeholder="بزرگ"
                                                                />
                                                                <x-base.input-group.text>6/14</x-base.input-group.text>
                                                            </x-base.input-group>
                                                            <div class="flex w-20 mt-3 text-slate-500 xl:mt-0">
                                                                <a
                                                                    class="xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Move"
                                                                    />
                                                                </a>
                                                                <a
                                                                    class="ms-3 xl:ms-5"
                                                                    href=""
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-4 h-4"
                                                                        icon="Trash2"
                                                                    />
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </x-base.form-inline>
                                                <div class="mt-5 first:mt-0 xl:ms-20 xl:ps-5 xl:pe-20">
                                                    <x-base.button
                                                        class="w-full border-dashed"
                                                        variant="outline-primary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4 stroke-[1.3]"
                                                            icon="Plus"
                                                        />
                                                        افزودن گزینه
                                                    </x-base.button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="pt-2 mt-2 first:mt-0 first:pt-0 xl:ms-60 xl:ps-14">
                                    <x-base.button
                                        class="w-full py-3 border-slate-200/80 bg-slate-50/80"
                                        variant="outline-secondary"
                                    >
                                        <x-base.lucide
                                            class="me-2 h-4 w-4 stroke-[1.3]"
                                            icon="Plus"
                                        />
                                        افزودن نوع جدید
                                    </x-base.button>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">اطلاعات نوع</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                از این بخش برای مشخص کردن گزینه‌ها،
                                                پیکربندی‌ها، یا انواع موجود برای
                                                product.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="grid-cols-4 gap-2 sm:grid">
                                            <x-base.input-group>
                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                <x-base.form-input
                                                    type="text"
                                                    placeholder="قیمت"
                                                />
                                            </x-base.input-group>
                                            <x-base.form-input
                                                class="mt-2 sm:mt-0"
                                                type="text"
                                                placeholder="موجودی"
                                            />
                                            <x-base.form-input
                                                class="mt-2 sm:mt-0"
                                                type="text"
                                                placeholder="کد نوع"
                                            />
                                            <x-base.button
                                                class="mt-2 border-primary/50 bg-primary/5 sm:mt-0"
                                                variant="outline-primary"
                                            >
                                                اعمال برای همه
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">لیست انواع</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                از این بخش برای نمایش انواع محصولات مختلف، گزینه‌ها، یا پیکربندی‌های موجود به
                                                مشتریان استفاده کنید.
                                                customers.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="overflow-x-auto">
                                            <x-base.table class="border">
                                                <x-base.table.thead>
                                                    <x-base.table.tr>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            Size
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            <div class="flex items-center">
                                                                رنگ
                                                                <x-base.lucide
                                                                    class="w-4 h-4 ms-2"
                                                                    icon="HelpCircle"
                                                                />
                                                            </div>
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !px-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            قیمت
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !px-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            <div class="flex items-center">
                                                                <div
                                                                    class="relative -mt-0.5 me-2 h-4 w-4 before:absolute before:h-4 before:w-4 before:rounded-full before:bg-primary/20 before:content-[''] after:absolute after:h-4 after:w-4 after:rounded-full after:border-4 after:border-white/60 after:bg-primary after:content-[''] after:dark:border-darkmode-300 lg:before:animate-ping">
                                                                </div>
                                                                موجودی
                                                                <x-base.lucide
                                                                    class="w-4 h-4 ms-2"
                                                                    icon="HelpCircle"
                                                                />
                                                            </div>
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !ps-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            کد نوع
                                                        </x-base.table.th>
                                                    </x-base.table.tr>
                                                </x-base.table.thead>
                                                <x-base.table.tbody>
                                                    <x-base.table.tr>
                                                        <x-base.table.td
                                                            class="border-e"
                                                            rowspan="3"
                                                        >
                                                            کوچک
                                                        </x-base.table.td>
                                                        <x-base.table.td>سیاه</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>سفید</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>Gray</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td
                                                            class="border-e"
                                                            rowspan="3"
                                                        >
                                                            متوسط
                                                        </x-base.table.td>
                                                        <x-base.table.td>سیاه</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>سفید</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>Gray</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td
                                                            class="border-e"
                                                            rowspan="3"
                                                        >
                                                            بزرگ
                                                        </x-base.table.td>
                                                        <x-base.table.td>سیاه</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>سفید</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td>Gray</x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="موجودی"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="کد نوع"
                                                            />
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                </x-base.table.tbody>
                                            </x-base.table>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">قیمت عمده فروشی</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                قیمت تخفیف داده شده برای خرید محصولات به تعداد
                                                بیشتر تنظیم کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="overflow-x-auto">
                                            <x-base.table class="border">
                                                <x-base.table.thead>
                                                    <x-base.table.tr>
                                                        <x-base.table.th
                                                            class="bg-slate-50 !ps-2 dark:bg-darkmode-800"></x-base.table.th>
                                                        <x-base.table.th
                                                            class="bg-slate-50 dark:bg-darkmode-800"></x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !px-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            Min.
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !px-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            Max.
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="whitespace-nowrap bg-slate-50 !px-2 text-slate-500 dark:bg-darkmode-800"
                                                        >
                                                            قیمت واحد
                                                        </x-base.table.th>
                                                        <x-base.table.th
                                                            class="bg-slate-50 !px-2 dark:bg-darkmode-800"></x-base.table.th>
                                                    </x-base.table.tr>
                                                </x-base.table.thead>
                                                <x-base.table.tbody>
                                                    <x-base.table.tr>
                                                        <x-base.table.td class="!ps-2">1.</x-base.table.td>
                                                        <x-base.table.td class="whitespace-nowrap">
                                                            قیمت عمده فروشی ۱
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Min Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Max Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-4 text-slate-500">
                                                            <a href="">
                                                                <x-base.lucide
                                                                    class="w-4 h-4"
                                                                    icon="Trash2"
                                                                />
                                                            </a>
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td class="!ps-2">2.</x-base.table.td>
                                                        <x-base.table.td class="whitespace-nowrap">
                                                            قیمت عمده فروشی ۲
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Min Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Max Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-4 text-slate-500">
                                                            <a href="">
                                                                <x-base.lucide
                                                                    class="w-4 h-4"
                                                                    icon="Trash2"
                                                                />
                                                            </a>
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                    <x-base.table.tr>
                                                        <x-base.table.td class="!ps-2">3.</x-base.table.td>
                                                        <x-base.table.td class="whitespace-nowrap">
                                                            قیمت عمده فروشی ۳
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Min Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.form-input
                                                                class="min-w-[6rem]"
                                                                type="text"
                                                                placeholder="Max Qty"
                                                            />
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!px-2">
                                                            <x-base.input-group>
                                                                <x-base.input-group.text>$</x-base.input-group.text>
                                                                <x-base.form-input
                                                                    class="min-w-[6rem]"
                                                                    type="text"
                                                                    placeholder="قیمت"
                                                                />
                                                            </x-base.input-group>
                                                        </x-base.table.td>
                                                        <x-base.table.td class="!ps-4 text-slate-500">
                                                            <a href="">
                                                                <x-base.lucide
                                                                    class="w-4 h-4"
                                                                    icon="Trash2"
                                                                />
                                                            </a>
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                </x-base.table.tbody>
                                            </x-base.table>
                                        </div>
                                        <x-base.button
                                            class="w-full mt-4 border-dashed"
                                            variant="outline-primary"
                                        >
                                            <x-base.lucide
                                                class="me-2 h-4 w-4 stroke-[1.3]"
                                                icon="Plus"
                                            />
                                            افزودن قیمت عمده فروشی جدید
                                        </x-base.button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                مدیریت محصول
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">وضعیت محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                وضعیتی را که بهترین بازتاب موجودی
                                                این محصول برای مشتریان را نشان می‌دهد انتخاب کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-switch>
                                            <x-base.form-switch.input
                                                id="product-status-active"
                                                type="checkbox"
                                            />
                                            <x-base.form-switch.label for="product-status-active">
                                                فعال
                                            </x-base.form-switch.label>
                                        </x-base.form-switch>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">موجودی محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                مقدار کل این محصول که در حال حاضر موجود است را وارد کنید.
                                                stock.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-input
                                            id="product-stock"
                                            type="text"
                                            placeholder="Input موجودی محصول"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">واحد نگهداری موجودی</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                یک شناسه ممیز برای این محصول در
                                                انبار خود وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-input
                                            id="sku"
                                            type="text"
                                            placeholder="Input SKU"
                                        />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div class="rounded-[0.6rem] border border-slate-200/60 p-5 dark:border-darkmode-400">
                            <div
                                class="flex items-center border-b border-slate-200/60 pb-5 text-[0.94rem] font-medium dark:border-darkmode-400">
                                <x-base.lucide
                                    class="me-2 h-5 w-5 stroke-[1.3]"
                                    icon="ChevronDown"
                                />
                                حمل و نقل
                            </div>
                            <div class="mt-5">
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">وزن محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                وزن محصول را در واحد اندازه‌گیری ترجیحی
                                                (مثلاً پوند، کیلوگرم، اونس) وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="grid-cols-4 gap-2 sm:grid">
                                            <x-base.form-select>
                                                <option value="گرم (گرم)">گرم (گرم)</option>
                                                <option value="کیلوگرم (کیلوگرم)">کیلوگرم (کیلوگرم)</option>
                                            </x-base.form-select>
                                            <x-base.form-input
                                                class="mt-2 sm:mt-0"
                                                id="product-weight"
                                                type="text"
                                                placeholder="موجودی"
                                            />
                                        </div>
                                        <x-base.alert
                                            class="flex items-center px-4 mt-5 mb-2 border-primary/20 bg-primary/5"
                                            variant="outline-primary"
                                        >
                                            <x-base.lucide
                                                class="me-3 h-[1.15rem] w-[1.15rem]"
                                                icon="AlertTriangle"
                                            />
                                            <div class="me-5 leading-relaxed">
                                                به وزن محصول به دقت توجه کنید تا تفاوتی در داده‌ها با
                                                پیک پستی وجود نداشته باشد.
                                                پیک حمل و نقل
                                                <a
                                                    class="ms-1 font-medium underline decoration-primary/50 decoration-dotted underline-offset-[3px]"
                                                    href=""
                                                >
                                                    بیشتر بدانید
                                                </a>
                                            </div>
                                            <x-base.alert.dismiss-button class="btn-close">
                                                <x-base.lucide
                                                    class="w-4 h-4"
                                                    icon="X"
                                                />
                                            </x-base.alert.dismiss-button>
                                        </x-base.alert>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">اندازه محصول</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                ابعاد یا اندازه محصول را شامل
                                                طول، عرض و ارتفاع، در واحد ترجیحی
                                                (مثلاً اینچ، سانتیمتر) وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="grid-cols-3 gap-2 sm:grid">
                                            <x-base.input-group>
                                                <x-base.form-input
                                                    type="text"
                                                    placeholder="Width"
                                                />
                                                <x-base.input-group.text>cm</x-base.input-group.text>
                                            </x-base.input-group>
                                            <x-base.input-group class="mt-2 sm:mt-0">
                                                <x-base.form-input
                                                    type="text"
                                                    placeholder="Height"
                                                />
                                                <x-base.input-group.text>cm</x-base.input-group.text>
                                            </x-base.input-group>
                                            <x-base.input-group class="mt-2 sm:mt-0">
                                                <x-base.form-input
                                                    type="text"
                                                    placeholder="Length"
                                                />
                                                <x-base.input-group.text>cm</x-base.input-group.text>
                                            </x-base.input-group>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">بیمه حمل و نقل</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نشان دهید که آیا بیمه حمل و نقل برای
                                                این محصول ارائه می‌شود تا در مقابل از دست رفتن یا آسیب
                                                در طول انتقال محافظت شود.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="flex flex-col gap-y-2 sm:flex-row">
                                            <x-base.form-check class="me-4">
                                                <x-base.form-check.input
                                                    id="shipping-insurance-required"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-chris-evans"
                                                />
                                                <x-base.form-check.label>
                                                    <span class="font-medium">ضروری</span>
                                                    <span class="w-56 mt-1 text-xs leading-relaxed text-slate-500">
                                                        You
                                                        <span class="font-medium text-slate-600 dark:text-slate-300">
                                                            require
                                                        </span>
                                                        خریدار را فعال سازی بیمه حمل و نقل
                                                    </span>
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                            <x-base.form-check class="mt-2 me-4 sm:mt-0">
                                                <x-base.form-check.input
                                                    id="shipping-insurance-optional"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-liam-neeson"
                                                />
                                                <x-base.form-check.label>
                                                    <span class="block font-medium">اختیاری</span>
                                                    <span class="block w-56 mt-1 text-xs leading-relaxed text-slate-500">
                                                        You
                                                        <span class="font-medium text-slate-600 dark:text-slate-300">
                                                            به خریدار گزینه‌ی
                                                        </span>
                                                        فعال کردن بیمه حمل و نقل را بدهید.
                                                    </span>
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">خدمات حمل و نقل</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                خدمات حمل و نقل یا روش ترجیحی برای
                                                تحویل این محصول به مشتریان را وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <div class="flex flex-col sm:flex-row">
                                            <x-base.form-check class="me-4">
                                                <x-base.form-check.input
                                                    id="shipping-service-standard"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-chris-evans"
                                                />
                                                <x-base.form-check.label for="shipping-service-standard">
                                                    Standard
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                            <x-base.form-check class="mt-2 me-4 sm:mt-0">
                                                <x-base.form-check.input
                                                    id="shipping-service-custom"
                                                    name="horizontal_radio_button"
                                                    type="radio"
                                                    value="horizontal-radio-liam-neeson"
                                                />
                                                <x-base.form-check.label for="shipping-service-custom">
                                                    Custom
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                        </div>
                                        <div class="mt-3 text-xs leading-relaxed text-slate-500">
                                            خدمات تحویل برای این محصول مانند
                                            تنظیمات حمل و نقل
                                            <a
                                                class="ms-1 font-medium text-primary"
                                                href=""
                                            >
                                                خواهد بود.
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="flex-col block pt-5 mt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="inline-block mb-2 sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">سفارش پیش‌فروش</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                اگر این محصول هنوز در دسترس نیست، سفارش پیش‌فروش را فعال کنید تا به مشتریان اجازه دهید آن را
                                                قبل از زمان موجودی رزرو کنند.
                                                قبل از زمان.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="flex-1 w-full mt-3 xl:mt-0">
                                        <x-base.form-switch>
                                            <x-base.form-switch.input
                                                id="preorder-active"
                                                type="checkbox"
                                            />
                                            <x-base.form-switch.label
                                                class="text-xs leading-relaxed text-slate-500"
                                                for="preorder-active"
                                            >
                                                اگر نیاز به یک فرآیند حمل و نقل بلندتر دارید، سفارش پیش‌فروش را فعال کنید.
                                                process.
                                                <a
                                                    class="ms-1 font-medium text-primary"
                                                    href=""
                                                >
                                                    بیشتر بدانید.
                                                </a>
                                            </x-base.form-switch.label>
                                        </x-base.form-switch>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col justify-end gap-3 mt-1 md:flex-row">
                        <x-base.button
                            class="w-full rounded-[0.5rem] border-slate-300/80 bg-white/80 py-2.5 md:w-56"
                            variant="outline-secondary"
                        >
                            <x-base.lucide
                                class="me-2 h-4 w-4 stroke-[1.3]"
                                icon="PenLine"
                            />
                            Cancel
                        </x-base.button>
                        <x-base.button
                            class="w-full rounded-[0.5rem] border-slate-300/80 bg-white/80 py-2.5 md:w-56"
                            variant="outline-secondary"
                        >
                            <x-base.lucide
                                class="me-2 h-4 w-4 stroke-[1.3]"
                                icon="PenLine"
                            />
                            ذخیره و افزودن جدید
                        </x-base.button>
                        <x-base.button
                            class="w-full rounded-[0.5rem] py-2.5 md:w-56"
                            variant="primary"
                        >
                            <x-base.lucide
                                class="me-2 h-4 w-4 stroke-[1.3]"
                                icon="PenLine"
                            />
                            Save
                        </x-base.button>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    بارگذاری محصول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    اطلاعات محصول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    جزئیات محصول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    نسخه محصول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    نسخه محصول (جزئیات)
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    مدیریت محصول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    وزن و حمل و نقل
                                </a>
                            </li>
                        </ul>
                        <div
                            class="relative mt-7 rounded-[0.6rem] border border-warning/[0.15] bg-warning/[0.07] p-5 dark:border-0 dark:bg-darkmode-600">
                            <x-base.lucide
                                class="absolute top-0 end-0 w-12 h-12 mt-5 me-3 text-warning/80"
                                icon="Lightbulb"
                            />
                            <h2 class="text-lg font-medium">Tips</h2>
                            <div class="mt-4 font-medium">قیمت</div>
                            <div class="mt-2 text-xs leading-relaxed text-slate-600/90 dark:text-slate-500">
                                <div>
                                    فرمت تصویر .jpg .jpeg .png و حداقل اندازه
                                    300 x 300 پیکسل (برای تصاویر بهینه حداقل اندازه
                                    700 x 700 پیکسل است).
                                </div>
                                <div class="mt-2">
                                    تصاویر محصول را انتخاب یا تا 5 تصویر را در یک بار اینجا رها کنید. حداقل 3 تصویر جذاب را در نظر بگیرید تا محصول را برای خریداران جذاب‌تر کنید.
                                    یک بار اینجا. حداقل ۳ تصویر جذاب را اضافه کنید تا
                                    محصول را برای خریداران جذاب‌تر کنید.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
