@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12 sm:col-span-10 sm:col-start-2">
            <div class="flex flex-col gap-y-2 lg:flex-row lg:items-center">
                <div @class([
                    'flex items-center lg:justify-center flex-1 lg:first:justify-start lg:last:justify-end group active',
                    'after:hidden before:hidden after:lg:block before:lg:block',
                    "first:after:content-[''] first:after:w-full first:after:bg-slate-300/60 first:after:h-[2px] first:after:ms-5 group-[.mode--light]:first:after:bg-slate-300/20",
                    "last:before:content-[''] last:before:w-full last:before:bg-slate-300/60 last:before:h-[2px] last:before:me-5 group-[.mode--light]:last:before:bg-slate-300/20",
                    "last:after:hidden after:content-[''] after:w-full after:bg-slate-300/60 after:h-[2px] after:ms-5 group-[.mode--light]:after:bg-slate-300/20",
                    "first:before:hidden before:content-[''] before:w-full before:bg-slate-300/60 before:h-[2px] before:me-5 group-[.mode--light]:before:bg-slate-300/20",
                ])>
                    <div class="flex items-center">
                        <div
                            class="rounded-full border bg-white group-[.mode--light]:!border-white/[0.25] group-[.active]:bg-primary group-[.mode--light]:!bg-transparent group-[.active]:text-white group-[.mode--light]:!text-slate-200 [.group.mode--light_.group.active_&]:!border-white/[0.15] [.group.mode--light_.group.active_&]:!bg-white/[0.12]">
                            <div class="flex h-10 w-10 items-center justify-center">
                                1
                            </div>
                        </div>
                        <div
                            class="ms-3.5 whitespace-nowrap font-medium text-slate-500 group-[.active]:text-current group-[.mode--light]:!text-slate-300 [.group.mode--light_.group.active_&]:!text-slate-100">
                            اطلاعات شخصی
                        </div>
                    </div>
                </div>
                <div @class([
                    'flex items-center lg:justify-center flex-1 lg:first:justify-start lg:last:justify-end group',
                    'after:hidden before:hidden after:lg:block before:lg:block',
                    "first:after:content-[''] first:after:w-full first:after:bg-slate-300/60 first:after:h-[2px] first:after:ms-5 group-[.mode--light]:first:after:bg-slate-300/20",
                    "last:before:content-[''] last:before:w-full last:before:bg-slate-300/60 last:before:h-[2px] last:before:me-5 group-[.mode--light]:last:before:bg-slate-300/20",
                    "last:after:hidden after:content-[''] after:w-full after:bg-slate-300/60 after:h-[2px] after:ms-5 group-[.mode--light]:after:bg-slate-300/20",
                    "first:before:hidden before:content-[''] before:w-full before:bg-slate-300/60 before:h-[2px] before:me-5 group-[.mode--light]:before:bg-slate-300/20",
                ])>
                    <div class="flex items-center">
                        <div
                            class="rounded-full border bg-white group-[.mode--light]:!border-white/[0.25] group-[.active]:bg-primary group-[.mode--light]:!bg-transparent group-[.active]:text-white group-[.mode--light]:!text-slate-200 [.group.mode--light_.group.active_&]:!border-white/[0.15] [.group.mode--light_.group.active_&]:!bg-white/[0.12]">
                            <div class="flex h-10 w-10 items-center justify-center">
                                2
                            </div>
                        </div>
                        <div
                            class="ms-3.5 whitespace-nowrap font-medium text-slate-500 group-[.active]:text-current group-[.mode--light]:!text-slate-300 [.group.mode--light_.group.active_&]:!text-slate-100">
                            راه‌اندازی حساب کاربری
                        </div>
                    </div>
                </div>
                <div @class([
                    'flex items-center lg:justify-center flex-1 lg:first:justify-start lg:last:justify-end group',
                    'after:hidden before:hidden after:lg:block before:lg:block',
                    "first:after:content-[''] first:after:w-full first:after:bg-slate-300/60 first:after:h-[2px] first:after:ms-5 group-[.mode--light]:first:after:bg-slate-300/20",
                    "last:before:content-[''] last:before:w-full last:before:bg-slate-300/60 last:before:h-[2px] last:before:me-5 group-[.mode--light]:last:before:bg-slate-300/20",
                    "last:after:hidden after:content-[''] after:w-full after:bg-slate-300/60 after:h-[2px] after:ms-5 group-[.mode--light]:after:bg-slate-300/20",
                    "first:before:hidden before:content-[''] before:w-full before:bg-slate-300/60 before:h-[2px] before:me-5 group-[.mode--light]:before:bg-slate-300/20",
                ])>
                    <div class="flex items-center">
                        <div
                            class="rounded-full border bg-white group-[.mode--light]:!border-white/[0.25] group-[.active]:bg-primary group-[.mode--light]:!bg-transparent group-[.active]:text-white group-[.mode--light]:!text-slate-200 [.group.mode--light_.group.active_&]:!border-white/[0.15] [.group.mode--light_.group.active_&]:!bg-white/[0.12]">
                            <div class="flex h-10 w-10 items-center justify-center">
                                3
                            </div>
                        </div>
                        <div
                            class="ms-3.5 whitespace-nowrap font-medium text-slate-500 group-[.active]:text-current group-[.mode--light]:!text-slate-300 [.group.mode--light_.group.active_&]:!text-slate-100">
                            جزئیات اضافی
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-7">
                <div class="box box--stacked flex flex-col">
                    <div class="p-7">
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">عکس پروفایل</div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        یک عکس پروفایل واضح و جدید بارگذاری کنید.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <div class="flex items-center">
                                    <div
                                        class="relative flex h-24 w-24 items-center justify-center rounded-full border border-primary/10 bg-primary/5">
                                        <x-base.lucide
                                            class="-mt-1.5 h-[65%] w-[65%] fill-slate-300/70 stroke-slate-400/50 stroke-[0.5]"
                                            icon="User"
                                        />
                                        <a
                                            class="box absolute bottom-0 end-0 flex h-7 w-7 items-center justify-center rounded-full"
                                            href=""
                                        >
                                            <x-base.lucide
                                                class="h-3.5 w-3.5 stroke-[1.3] text-slate-500"
                                                icon="Pencil"
                                            />
                                        </a>
                                    </div>
                                    <x-base.button
                                        class="ms-8 me-2 h-8 ps-3.5 pe-4"
                                        variant="outline-secondary"
                                        size="sm"
                                    >
                                        <x-base.lucide
                                            class="me-1.5 h-3.5 w-3.5 stroke-[1.3]"
                                            icon="Trash2"
                                        />
                                        حذف
                                    </x-base.button>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">نام کامل</div>
                                        <div
                                            class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                            ضروری
                                        </div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        نام کامل و قانونی خود را وارد کنید، همانطور که در مدارک رسمی شما ظاهر شده است.
                                        شناسایی.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <div class="flex flex-col items-center md:flex-row">
                                    <x-base.form-input
                                        class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                        type="text"
                                        placeholder="{{ explode(' ', $users[0]['name'])[0] }}"
                                    />
                                    <x-base.form-input
                                        class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                        type="text"
                                        placeholder="{{ explode(' ', $users[0]['name'])[1] }}"
                                    />
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">تاریخ تولد</div>
                                        <div
                                            class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                            ضروری
                                        </div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        این اطلاعات برای تأیید سن شما و
                                        ارائه خدمات مناسب سن مورد نیاز است.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <x-base.jalali-datepicker />
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">جنسیت</div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        جنسیت خود را از گزینه‌ها انتخاب کنید.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <div class="flex flex-col items-center md:flex-row">
                                    <div
                                        class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                        <x-base.form-check>
                                            <x-base.form-check.input
                                                id="checkbox-switch-1"
                                                type="radio"
                                                value=""
                                            />
                                            <x-base.form-check.label for="checkbox-switch-1">
                                                Male
                                            </x-base.form-check.label>
                                        </x-base.form-check>
                                    </div>
                                    <div
                                        class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                        <x-base.form-check>
                                            <x-base.form-check.input
                                                id="checkbox-switch-2"
                                                type="radio"
                                                value=""
                                            />
                                            <x-base.form-check.label for="checkbox-switch-2">
                                                زن
                                            </x-base.form-check.label>
                                        </x-base.form-check>
                                    </div>
                                    <div
                                        class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                        <x-base.form-check>
                                            <x-base.form-check.input
                                                id="checkbox-switch-3"
                                                type="radio"
                                                value=""
                                            />
                                            <x-base.form-check.label for="checkbox-switch-3">
                                                ترجیح می‌دهم بگویم
                                            </x-base.form-check.label>
                                        </x-base.form-check>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">ایمیل</div>
                                        <div
                                            class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                            ضروری
                                        </div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        لطفاً یک آدرس ایمیل معتبر که به آن دسترسی دارید، ارائه دهید.
                                        to.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <x-base.form-input
                                    type="text"
                                    placeholder="{{ $users[0]['email'] }}"
                                />
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">شماره تلفن</div>
                                        <div
                                            class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                            ضروری
                                        </div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        لطفاً یک شماره تلفن معتبر که ما بتوانیم با آن تماس بگیریم، ارائه دهید.
                                        اگر نیاز باشد.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <div class="flex flex-col items-center md:flex-row">
                                    <x-base.form-input
                                        class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                        type="text"
                                        placeholder="{{ $users[0]['phone'] }}"
                                    />
                                    <x-base.form-select
                                        class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 md:w-36 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                    >
                                        <option value="office">دفتر</option>
                                        <option value="home">Home</option>
                                    </x-base.form-select>
                                </div>
                                <a
                                    class="-mb-1 mt-3.5 flex items-center font-medium text-primary"
                                    href=""
                                >
                                    <x-base.lucide
                                        class="me-1 h-4 w-4 stroke-[1.3]"
                                        icon="Plus"
                                    />
                                    افزودن تلفن
                                </a>
                            </div>
                        </div>
                        <div class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                            <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                <div class="text-start">
                                    <div class="flex items-center">
                                        <div class="font-medium">بخش</div>
                                    </div>
                                    <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                        بخش یا بخش خود را از لیست
                                        گزینه‌های موجود انتخاب کنید.
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3 w-full flex-1 xl:mt-0">
                                <x-base.form-select>
                                    @foreach ($users->take(5) as $fakerKey => $faker)
                                        <option value="{{ $faker['department'] }}">
                                            {{ $faker['department'] }}
                                        </option>
                                    @endforeach
                                </x-base.form-select>
                            </div>
                        </div>
                    </div>
                    <div class="flex border-t border-slate-200/80 px-7 py-5 md:justify-end">
                        <x-base.button
                            class="w-full border-primary/50 px-10 md:w-auto"
                            variant="outline-primary"
                        >
                            <x-base.lucide
                                class="-ms-2 me-2 h-4 w-4 stroke-[1.3]"
                                icon="Pocket"
                            />
                            Next
                        </x-base.button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
