@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    هشدار
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت مؤلفه هشدارهای ما را برای ارسال پیام‌ها و اعلان‌های مهم به کاربران خود کشف کنید.
                    پیام‌ها و اعلان‌ها به کاربران شما.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارها برای ارتباط با پیام‌ها، هشدارها یا به‌روزرسانی‌های مهم به کاربران ضروری هستند. در این
                                    بخش، شما خواهید آموخت که چگونه از هشدارهای پایه
                                    به طور مؤثر برای ارائه اطلاعات و بهبود تجربه کاربر استفاده کنید
                                    به طور مؤثر برای ارائه اطلاعات و بهبود تجربه کاربر
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.alert variant="primary">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="secondary">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="success">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="warning">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="pending">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="danger">
                                                    هشدار ساده عالی
                                                </x-base.alert>
                                                <x-base.alert variant="dark">هشدار ساده عالی</x-base.alert>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.alert variant="primary">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="secondary">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="success">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="warning">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="pending">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="danger">
                                                        هشدار ساده عالی
                                                    </x-base.alert>
                                                    <x-base.alert variant="dark">هشدار ساده عالی</x-base.alert>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای پایه عنصر اساسی طراحی رابط کاربری هستند، که به عنوان یک وسیله برای ارتباط پیام‌های مهم به صورت روشن و مؤثر به‌کار می‌روند. برای ساخت وب‌سایت یا برنامه، اضافه کردن
                                    به عنوان یک وسیله برای ارتباط پیام‌های مهم به صورت روشن و مؤثر
                                    آیا شما در حال ساخت یک وب‌سایت یا برنامه هستید، اضافه کردن
                                    می‌تواند تجربه کاربر را بهبود بخشیده و با ارائه اطلاعات و بازخورد به موقع
                                    واکنش به پیام‌های مهم را بهبود بخشد.
                                    با ارائه اطلاعات و بازخورد به موقع
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای آیکن
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارهای آیکن پیام‌های اطلاعاتی را با اعلان‌هایی که به راحتی
                                    آیکون‌های قابل تشخیص برای انتقال اطلاعات مهم به کاربران به طور مؤثر استفاده می‌شوند.
                                    کاربران را به طور مؤثر هدایت می‌کند. این بخش به شما راهنمایی می‌کند که چگونه
                                    از هشدارهای آیکونی در پروژه خود استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="primary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="secondary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="success"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="warning"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="pending"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="danger"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="dark"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="primary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertCircle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="secondary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertOctagon"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="success"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="warning"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertCircle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="pending"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="danger"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertOctagon"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="dark"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای آیکونی ابزار مهمی برای بهبود تعامل کاربران است
                                    که با ارائه پیام‌های واضح و جذاب به طریق بصری، تعامل کاربران را افزایش می‌دهند.
                                    پیام‌ها. با پیگیری مراحل فوق، به راحتی می‌توانید
                                    هشدارهای آیکونی را به پروژه خود ادغام کنید و به طور مؤثر
                                    اطلاعات مهم را به کاربران خود ارسال کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای محتوای اضافی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارهای محتوای اضافی به شما اجازه می‌دهند که اطلاعات بیشتری را به کاربران ارائه دهید
                                    با اضافه کردن عناصر اضافی درون هشدار، مانند آیکون‌ها، برچسب‌ها یا متن اضافی.
                                    هشدار، مانند آیکون‌ها، برچسب‌ها یا متن اضافی.
                                    این بخش راهنمایی در مورد استفاده موثر از هشدارهای محتوای اضافی ارائه می‌دهد.
                                    هشدارهای محتوا را به طور موثر استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.alert variant="primary">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="secondary">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-slate-500 px-1 text-xs text-white">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="success">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="warning">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="pending">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="danger">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                                <x-base.alert variant="dark">
                                                    <div class="flex items-center">
                                                        <div class="text-lg font-medium">
                                                            هشدار شگفت‌انگیز با اطلاعات اضافی
                                                        </div>
                                                        <div
                                                            class="ms-auto rounded-md bg-slate-500 px-1 text-xs text-white">
                                                            New
                                                        </div>
                                                    </div>
                                                    <div class="mt-3">
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        متن آزمایشی بوده است.
                                                    </div>
                                                </x-base.alert>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.alert variant="primary">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="secondary">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-slate-500 px-1 text-xs text-white">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="success">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="warning">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="pending">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="danger">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-white px-1 text-xs text-slate-700">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                    <x-base.alert variant="dark">
                                                        <div class="flex items-center">
                                                            <div class="text-lg font-medium">
                                                                هشدار شگفت‌انگیز با اطلاعات اضافی
                                                            </div>
                                                            <div
                                                                class="ms-auto rounded-md bg-slate-500 px-1 text-xs text-white">
                                                                New
                                                            </div>
                                                        </div>
                                                        <div class="mt-3">
                                                            متن آزمایشی است
                                                            صنعت چاپ و تنظیم‌مجدد متن است.
                                                            این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                            متن آزمایشی بوده است.
                                                        </div>
                                                    </x-base.alert>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای محتوای اضافی ابزار مهمی برای
                                    ارسال اطلاعات غنی‌تر به کاربران هستند، همچنین
                                    طراحی تمیز و منظم را حفظ می‌کنند. با پیگیری مراحل
                                    فوق، می‌توانید به راحتی هشدارهای محتوای اضافی را
                                    به پروژه خود اضافه کرده و ارتباط خود را با کاربران بهبود بخشید.
                                    با کاربران.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای آیکونی و رد کردن
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارهای آیکونی و رد کردن آیکون‌ها را با قابلیت رد کردن
                                    ترکیب می‌کنند، این امکان را به شما می‌دهند که پیام‌های مهم را نمایش دهید
                                    و به کاربران امکان می‌دهند که گزینه بستن هشدار را داشته باشند
                                    هنگامی که آن را خوانده‌اند. این بخش راهنمایی در مورد استفاده موثر از این هشدارها ارائه می‌دهد.
                                    راهنمایی در مورد استفاده موثر از این هشدارها.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertCircle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="text-white">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="secondary"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertOctagon"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="success"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertTriangle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="warning"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertCircle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="pending"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertTriangle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="danger"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertOctagon"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="text-white">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="dark"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertTriangle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="text-white">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="primary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="text-white">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="secondary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="success"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="warning"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="pending"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="danger"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="text-white">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="dark"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="text-white">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای آیکونی و رد کردن روش کاربر پسندی است
                                    برای ارائه اطلاعات و اجازه دادن به کاربران برای مدیریت
                                    هشدارهای خود. با پیگیری مراحل فوق، می‌توانید
                                    این هشدارها را به طور بی‌درنگ به پروژه خود ادغام کنید و
                                    تعامل کاربر و ارتباط را بهبود بخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای خطی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارهای خطی روشی تمیز و کم‌حجم برای
                                    نمایش پیام‌های مهم با مرزهای مشخص است.
                                    این بخش راهنمایی در مورد استفاده موثر از این هشدارها ارائه می‌دهد
                                    تا اطلاعات را به کاربران خود منتقل کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-primary"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertCircle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-secondary"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertOctagon"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-success"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertTriangle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-warning"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertCircle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-pending"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertCircle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-danger"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertOctagon"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                            <x-base.alert
                                                class="mb-2 flex items-center"
                                                variant="outline-dark"
                                            >
                                                <x-base.lucide
                                                    class="me-2 h-6 w-6"
                                                    icon="AlertTriangle"
                                                />
                                                هشدار شگفت‌انگیز با آیکون
                                                <x-base.alert.dismiss-button class="btn-close">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="X"
                                                    />
                                                </x-base.alert.dismiss-button>
                                            </x-base.alert>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-primary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-secondary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-success"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-warning"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-pending"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-danger"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="mb-2 flex items-center"
                                                    variant="outline-dark"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                    <x-base.alert.dismiss-button class="btn-close">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="X"
                                                        />
                                                    </x-base.alert.dismiss-button>
                                                </x-base.alert>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای خطی راهی شیک و موثر برای
                                    اطلاعات اساسی را به کاربران منتقل کنید در حالی که
                                    طراحی تمیزی را حفظ کنید. با پیگیری مراحل
                                    فوق، می‌توانید به طور بی‌درنگ این هشدارها را وارد کنید به
                                    پروژه خود و تجربه کاربر را بهبود بخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    هشدارهای رنگی نرم
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    هشدارهای رنگی نرم یک روش دلپذیر و ملایم برای انتقال پیام‌های مهم با رنگ‌های نرم ارائه می‌دهند.
                                    این بخش راهنمایی در مورد استفاده موثر از این هشدارها را برای بهبود تجربه کاربر ارائه می‌دهد.
                                    این بخش راهنمایی در مورد استفاده موثر از این
                                    هشدارها برای بهبود تجربه کاربر ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-primary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-secondary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-success"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-warning"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertCircle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-pending"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-danger"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertOctagon"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                                <x-base.alert
                                                    class="flex items-center"
                                                    variant="soft-dark"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-6 w-6"
                                                        icon="AlertTriangle"
                                                    />
                                                    هشدار شگفت‌انگیز با آیکون
                                                </x-base.alert>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-primary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertCircle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-secondary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertOctagon"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-success"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-warning"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertCircle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-pending"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-danger"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertOctagon"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                    <x-base.alert
                                                        class="flex items-center"
                                                        variant="soft-dark"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-6 w-6"
                                                            icon="AlertTriangle"
                                                        />
                                                        هشدار شگفت‌انگیز با آیکون
                                                    </x-base.alert>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    هشدارهای رنگی نرم یک راه ملایم و دلپذیر برای
                                    اطلاعات اساسی را به کاربران منتقل کنید در حالی که
                                    حفظ زیبایی ملایم ارائه می‌دهند. با پیگیری مراحل
                                    فوق، می‌توانید به طور بی‌درنگ این هشدارها را وارد کنید به
                                    پروژه خود و ایجاد یک تجربه کاربری جذاب ارائه می‌دهند.
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">هشدار</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`dismissible`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    نشان می‌دهد که آیا می‌توان هشدار را رد کرد
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`variant`</x-base.table.td>
                                                <x-base.table.td>`Variant`</x-base.table.td>
                                                <x-base.table.td>نوعی از سبک هشدار</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onShow`</x-base.table.td>
                                                <x-base.table.td>`() =&gt; {}`</x-base.table.td>
                                                <x-base.table.td>پس از نشان داده شدن هشدار، تابع فراخوانی می‌شود</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onShown`</x-base.table.td>
                                                <x-base.table.td>`() =&gt; {}`</x-base.table.td>
                                                <x-base.table.td>پس از نشان داده شدن هشدار، تابع فراخوانی می‌شود</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onHide`</x-base.table.td>
                                                <x-base.table.td>`() =&gt; {}`</x-base.table.td>
                                                <x-base.table.td>
                                                    پیش از مخفی شدن هشدار، تابع فراخوانی می‌شود
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onHidden`</x-base.table.td>
                                                <x-base.table.td>`() =&gt; {}`</x-base.table.td>
                                                <x-base.table.td>
                                                    پس از مخفی شدن هشدار، تابع فراخوانی می‌شود
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Alert.DismissButton</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    HTML element type for the dismiss button (default is
                                                    ("دکمه" یا "لینک")
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای آیکن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای محتوای اضافی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای آیکونی و رد کردن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای خطی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    هشدارهای رنگی نرم
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
