@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    دکمه‌ها
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    تنوع اجزای دکمه ما را برای بهبود تعامل کاربر در برنامه خود کاوش کنید.
                    تعاملات روی برنامه‌ی شما.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های ابتدایی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌ها عناصر اساسی در طراحی وب و برنامه هستند،
                                    که به کاربران اجازه می دهند با محتوای شما تعامل داشته و اقداماتی انجام دهند.
                                    اقدامات. اجزای دکمه‌های ابتدایی یک مجموعه از
                                    استایل‌های دکمه را که به راحتی می‌توانید در پروژه خود
                                    اضافه کنید. این دکمه‌ها در انواع متفاوت رنگ برای
                                    رضایت از نیازهای طراحی شما آمده‌اند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="success"
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="warning"
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="pending"
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="danger"
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="dark"
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="success"
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="warning"
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="pending"
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="danger"
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="dark"
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    دکمه‌ها برای تعامل کاربر در وب شما ضروری هستند،
                                    یا پروژه برنامه. اجزای دکمه‌های ابتدایی یک
                                    مجموعه گسترده از استایل‌ها و گزینه‌های سفارشی‌سازی را ارائه می‌دهد تا
                                    اطمینان حاصل شود که دکمه‌های شما نه تنها کارآمدند بلکه به نظر هم زیبا باشند.
                                    جذاب.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اندازه‌های دکمه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای اندازه‌های دکمه به شما امکان می‌دهد اندازه
                                    دکمه‌ها را با نیازهای طراحی خود هماهنگ کنید. چه
                                    آیا نیاز به دکمه‌های کوچک، متوسط یا بزرگ دارید، این ویژگی
                                    تضمین می‌کند که دکمه‌های شما به طور ساده در
                                    رابط کاربری شما جا بیافتند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                    size="sm"
                                                >
                                                    کوچک
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                >
                                                    متوسط
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                    size="lg"
                                                >
                                                    بزرگ
                                                </x-base.button>
                                            </div>
                                            <div class="mt-5 flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                    size="sm"
                                                >
                                                    کوچک
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                >
                                                    متوسط
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                    size="lg"
                                                >
                                                    بزرگ
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                        size="sm"
                                                    >
                                                        کوچک
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                    >
                                                        متوسط
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                        size="lg"
                                                    >
                                                        بزرگ
                                                    </x-base.button>
                                                </div>
                                                <div class="mt-5 flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                        size="sm"
                                                    >
                                                        کوچک
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                    >
                                                        متوسط
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                        size="lg"
                                                    >
                                                        بزرگ
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اندازه‌های دکمه انعطاف‌پذیری که نیاز دارید برای ایجاد
                                    دکمه‌هایی که به طور ساده با پروژه شما
                                    هماهنگ شوند، فراهم می‌کنند. آیا می‌خواهید کوچک، متوسط یا بزرگ
                                    دکمه‌ها، می‌توانید به راحتی به اندازه دکمه مورد نظر برسید
                                    با این اجزا.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    کار با پیوندها
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای دکمه پیوند به شما امکان می‌دهد که دکمه‌ها را ایجاد کنید
                                    این دکمه‌ها کارایی به عنوان لینک دارند. این دکمه‌ها چند منظوره هستند و
                                    می‌توانند برای راهبری به بخش‌های مختلف وب‌سایت شما یا آدرس‌های خارجی استفاده شوند.
                                    وب‌سایت یا آدرس‌های خارجی.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    Link
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="secondary"
                                                >
                                                    دکمه
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="success"
                                                >
                                                    Input
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="warning"
                                                >
                                                    ثبت
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="pending"
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="danger"
                                                >
                                                    تنظیم مجدد
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    href=""
                                                    as="a"
                                                    variant="dark"
                                                >
                                                    فلزی
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        Link
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="secondary"
                                                    >
                                                        دکمه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="success"
                                                    >
                                                        Input
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="warning"
                                                    >
                                                        ثبت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="pending"
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="danger"
                                                    >
                                                        تنظیم مجدد
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        href=""
                                                        as="a"
                                                        variant="dark"
                                                    >
                                                        فلزی
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای دکمه لینک یک راه ساده برای
                                    درج لینک‌های تعاملی در پروژه وب خود را ارائه می‌دهند. از آن‌ها برای ایجاد دکمه‌هایی که کاربران را به بخش‌های مختلف
                                    وب‌سایت یا آدرس‌های خارجی هدایت می‌کنند، از طریق افزایش تجربه کاربری و راهبری.
                                    بخش‌های وب‌سایت یا آدرس‌های خارجی، باعث افزایش
                                    تجربه کاربری و راهبری می‌شوند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های بلند
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های بلند برای استفاده و ارائه عمق بصری طراحی شده‌اند. آن‌ها حس تعاملی را به رابط کاربری شما اضافه می‌کنند و واضح می‌کنند که این عناصر قابل کلیک هستند.
                                    عمق بصری. آن‌ها حس تعاملی را به
                                    رابط کاربری شما اضافه می‌کنند و واضح می‌کنند که این‌ها قابل کلیک هستند.
                                    عناصر هستند. این بخش دکمه‌های بلند را به
                                    سبک‌های مختلف پوشش می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                    elevated
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                    elevated
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="success"
                                                    elevated
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="warning"
                                                    elevated
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="pending"
                                                    elevated
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="danger"
                                                    elevated
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="dark"
                                                    elevated
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                            <div class="mt-5 flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                    elevated
                                                    rounded
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                    elevated
                                                    rounded
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="success"
                                                    elevated
                                                    rounded
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="warning"
                                                    elevated
                                                    rounded
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="pending"
                                                    elevated
                                                    rounded
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="danger"
                                                    elevated
                                                    rounded
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="dark"
                                                    elevated
                                                    rounded
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                        elevated
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                        elevated
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="success"
                                                        elevated
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="warning"
                                                        elevated
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="pending"
                                                        elevated
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="danger"
                                                        elevated
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="dark"
                                                        elevated
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                                <div class="mt-5 flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                        elevated
                                                        rounded
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                        elevated
                                                        rounded
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="success"
                                                        elevated
                                                        rounded
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="warning"
                                                        elevated
                                                        rounded
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="pending"
                                                        elevated
                                                        rounded
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="danger"
                                                        elevated
                                                        rounded
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="dark"
                                                        elevated
                                                        rounded
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    دکمه‌های بلند یک راه موثر برای افزایش
                                    تعامل و جذابیت بصری رابط کاربری شما هستند.
                                    آن‌ها نشانه‌گذاری واضحی از عناصر قابل کلیک ارائه می‌دهند و
                                    می‌توانند برای تطبیق با ترجیحات طراحی شما سفارشی شوند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های رسانه‌های اجتماعی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های رسانه‌های اجتماعی برای ارتباط با
                                    مخاطبان خود و تبلیغ محتوای شما در اینترنت
                                    ضروری هستند. این بخش دکمه‌های رسانه‌های اجتماعی با
                                    آیکون‌ها و سبک‌های مختلف را پوشش می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mt-5 flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-32"
                                                    variant="facebook"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Facebook"
                                                    />
                                                    فیس‌بوک
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="twitter"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Twitter"
                                                    />
                                                    توییتر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="instagram"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Instagram"
                                                    />
                                                    اینستاگرام
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="linkedin"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Linkedin"
                                                    />
                                                    لینکداین
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mt-5 flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="facebook"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Facebook"
                                                        />
                                                        فیس‌بوک
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="twitter"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Twitter"
                                                        />
                                                        توییتر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="instagram"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Instagram"
                                                        />
                                                        اینستاگرام
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="linkedin"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Linkedin"
                                                        />
                                                        لینکداین
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    از این دکمه‌های رسانه‌های اجتماعی به صورت استراتژیک برای تبلیغ
                                    محتوای خود و ارتباط برقرار کنید با مخاطبان خود در
                                    پلتفرم‌های ترجیحی‌شان، در نهایت افزایش ارتباط و
                                    رشد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های خط مرزی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های خط مرزی یک راه ملایم و شیک برای
                                    ارائه اعمال یا گزینه‌ها به کاربران شما فراهم می‌کنند. آن‌ها
                                    ظاهری تمیز و حداقلیت را حفظ می‌کنند در حالی که امکان ارتباط را
                                    اعلام می‌کنند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-primary"
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-secondary"
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-success"
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-warning"
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-pending"
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-danger"
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="inline-block w-24"
                                                    variant="outline-dark"
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-primary"
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-secondary"
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-success"
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-warning"
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-pending"
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-danger"
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="inline-block w-24"
                                                        variant="outline-dark"
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    از دکمه‌های خط مرزی برای اعمالی مانند ارسال فرم،
                                    راهبری، یا به عنوان جایگزین‌هایی برای دکمه‌های معمولی برای
                                    افزایش کلی رابط کاربری وب‌سایت یا برنامه‌ی شما
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های وضعیت بارگذاری
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های وضعیت بارگذاری بخشی ضروری از
                                    رابط کاربری کاربرپسند هستند. آن‌ها اعمالی مداوم را نشان می‌دهند،
                                    مانند ذخیره، افزودن، بارگذاری، یا حذف، و
                                    به کاربران باقی می‌مانند در حالی که منتظر یک
                                    پروسه برای تکمیل است.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button variant="primary">
                                                    ذخیره کردن
                                                    <x-base.loading-icon
                                                        class="ms-2 h-4 w-4"
                                                        icon="oval"
                                                        color="white"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="success">
                                                    افزودن
                                                    <x-base.loading-icon
                                                        class="ms-2 h-4 w-4"
                                                        icon="spinning-circles"
                                                        color="white"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="warning">
                                                    بارگذاری
                                                    <x-base.loading-icon
                                                        class="ms-2 h-4 w-4"
                                                        icon="three-dots"
                                                        color="1a202c"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="danger">
                                                    حذف
                                                    <x-base.loading-icon
                                                        class="ms-2 h-4 w-4"
                                                        icon="puff"
                                                        color="white"
                                                    />
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button variant="primary">
                                                        ذخیره کردن
                                                        <x-base.loading-icon
                                                            class="ms-2 h-4 w-4"
                                                            icon="oval"
                                                            color="white"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="success">
                                                        افزودن
                                                        <x-base.loading-icon
                                                            class="ms-2 h-4 w-4"
                                                            icon="spinning-circles"
                                                            color="white"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="warning">
                                                        بارگذاری
                                                        <x-base.loading-icon
                                                            class="ms-2 h-4 w-4"
                                                            icon="three-dots"
                                                            color="1a202c"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="danger">
                                                        حذف
                                                        <x-base.loading-icon
                                                            class="ms-2 h-4 w-4"
                                                            icon="puff"
                                                            color="white"
                                                        />
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در نظر گرفتن استفاده از دکمه‌های وضعیت بارگذاری برای اعمالی مانند
                                    ذخیره، افزودن، بارگذاری داده، یا حذف موارد برای بهبود کلیت قابلیت استفاده از وب‌سایت شما یا
                                    بهبود قابلیت استفاده کلی از وب‌سایت یا
                                    اپلیکیشن
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های گرد
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-8"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-8"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های گرد لمس بصری و مدرنی را به رابط کاربری شما ارائه می‌دهند. آن‌ها لبه‌های دکمه‌های سنتی را نرم می‌کنند، باعث می‌شوند که بیشتر دعوت‌کننده و کاربرپسند به نظر بیایند.
                                    لمس بصری به رابط کاربری شما اضافه می‌کنند. آن‌ها لبه‌های دکمه‌های سنتی را نرم می‌کنند، باعث می‌شوند که بیشتر دعوت‌کننده و کاربرپسند به نظر بیایند.
                                    دکمه‌های سنتی را نرم می‌کنند، باعث می‌شوند که بیشتر دعوت‌کننده و کاربرپسند به نظر بیایند.
                                    و کاربرپسند به نظر بیایند. این بخش بررسی می‌کند که چگونه باید از
                                    دکمه‌های گرد به طور موثر در پروژه‌ی شما استفاده کرد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="primary"
                                                    rounded
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="secondary"
                                                    rounded
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="success"
                                                    rounded
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="warning"
                                                    rounded
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="pending"
                                                    rounded
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="danger"
                                                    rounded
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="dark"
                                                    rounded
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="primary"
                                                        rounded
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="secondary"
                                                        rounded
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="success"
                                                        rounded
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="warning"
                                                        rounded
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="pending"
                                                        rounded
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="danger"
                                                        rounded
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="dark"
                                                        rounded
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در نظر بگیرید که از دکمه‌های گرد برای اعمال مختلف، مانند
                                    اعمال اولیه، اعمال ثانویه، اعلان‌های موفقیت، و موارد دیگر، برای
                                    اعمال اولیه، اعمال ثانویه، اعلان‌های موفقیت، و موارد دیگر، برای
                                    اعمال اولیه، اعمال ثانویه، اعلان‌های موفقیت، و موارد دیگر، برای
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های رنگی نرم
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-9"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-9"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های رنگی نرم لمسی از شیکی و ظرافت به رابط کاربری شما اضافه می‌کنند. این دکمه‌ها از رنگ‌های نرم و آرامی استفاده می‌کنند که به چشم می‌آیند بدون آنکه زیادی غلظت داشته باشند.
                                    به رابط کاربری شما اضافه می‌کنند. این دکمه‌ها از رنگ‌های نرم و آرامی استفاده می‌کنند که به چشم می‌آیند بدون آنکه زیادی غلظت داشته باشند.
                                    به رابط کاربری شما اضافه می‌کنند. این دکمه‌ها از رنگ‌های نرم و آرامی استفاده می‌کنند که به چشم می‌آیند بدون آنکه زیادی غلظت داشته باشند.
                                    به رابط کاربری شما اضافه می‌کنند. این دکمه‌ها از رنگ‌های نرم و آرامی استفاده می‌کنند که به چشم می‌آیند بدون آنکه زیادی غلظت داشته باشند.
                                    به رابط کاربری شما اضافه می‌کنند. این بخش به شما نشان می‌دهد که چگونه از دکمه‌های رنگی نرم به طور موثر در پروژه‌ی خود استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-primary"
                                                    rounded
                                                >
                                                    اصلی
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-secondary"
                                                    rounded
                                                >
                                                    ثانویه
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-success"
                                                    rounded
                                                >
                                                    موفقیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-warning"
                                                    rounded
                                                >
                                                    اخطار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-pending"
                                                    rounded
                                                >
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-danger"
                                                    rounded
                                                >
                                                    خطر
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-24"
                                                    variant="soft-dark"
                                                    rounded
                                                >
                                                    Dark
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-primary"
                                                        rounded
                                                    >
                                                        اصلی
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-secondary"
                                                        rounded
                                                    >
                                                        ثانویه
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-success"
                                                        rounded
                                                    >
                                                        موفقیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-warning"
                                                        rounded
                                                    >
                                                        اخطار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-pending"
                                                        rounded
                                                    >
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-danger"
                                                        rounded
                                                    >
                                                        خطر
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-24"
                                                        variant="soft-dark"
                                                        rounded
                                                    >
                                                        Dark
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    دکمه‌های رنگی نرم یک گزینه ظریف اما لمس بصری برای عناصر رابط کاربری شما فراهم می‌کنند. رنگ‌های نرم آن‌ها می‌تواند ظاهر رابط کاربری شما را بهبود بخشد بدون اینکه کاربر را بیش از حد متاثر کند.
                                    گزینه‌ی جذاب برای عناصر رابط کاربری شما هستند. رنگ‌های نرم آن‌ها می‌تواند ظاهر رابط کاربری شما را بهبود بخشد بدون اینکه کاربر را بیش از حد متاثر کند.
                                    گزینه‌ی جذاب برای عناصر رابط کاربری شما هستند. رنگ‌های نرم آن‌ها می‌تواند ظاهر رابط کاربری شما را بهبود بخشد بدون اینکه کاربر را بیش از حد متاثر کند.
                                    کاربر را بیش از حد متاثر کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های آیکون
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-10"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-10"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های آیکون به شما اجازه می‌دهند تا آیکون‌های معنی‌دار را به رابط کاربری خود برای اعمال یا عملکردهای مختلف اضافه کنید. در این بخش، چگونگی استفاده از دکمه‌های آیکون به طور موثر و افزایش انگیزه کاربر را خواهید آموخت.
                                    به رابط کاربری خود برای اعمال یا عملکردهای مختلف اضافه کنید. در این بخش، چگونگی استفاده از دکمه‌های آیکون به طور موثر و افزایش انگیزه کاربر را خواهید آموخت.
                                    به رابط کاربری خود برای اعمال یا عملکردهای مختلف اضافه کنید. در این بخش، چگونگی استفاده از دکمه‌های آیکون به طور موثر و افزایش انگیزه کاربر را خواهید آموخت.
                                    به رابط کاربری خود برای اعمال یا عملکردهای مختلف اضافه کنید. در این بخش، چگونگی استفاده از دکمه‌های آیکون به طور موثر و افزایش انگیزه کاربر را خواهید آموخت.
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button
                                                    class="w-32"
                                                    variant="primary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Activity"
                                                    />
                                                    فعالیت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="secondary"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="HardDrive"
                                                    />
                                                    دیسک سخت
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="success"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Calendar"
                                                    />
                                                    تقویم
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="warning"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Share2"
                                                    />
                                                    اشتراک گذاری
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="pending"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Download"
                                                    />
                                                    در انتظار
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="danger"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Trash"
                                                    />
                                                    زباله
                                                </x-base.button>
                                                <x-base.button
                                                    class="w-32"
                                                    variant="dark"
                                                >
                                                    <x-base.lucide
                                                        class="me-2 h-4 w-4"
                                                        icon="Image"
                                                    />
                                                    Image
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="primary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Activity"
                                                        />
                                                        فعالیت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="secondary"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="HardDrive"
                                                        />
                                                        دیسک سخت
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="success"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Calendar"
                                                        />
                                                        تقویم
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="warning"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Share2"
                                                        />
                                                        اشتراک گذاری
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="pending"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Download"
                                                        />
                                                        در انتظار
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="danger"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Trash"
                                                        />
                                                        زباله
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="w-32"
                                                        variant="dark"
                                                    >
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Image"
                                                        />
                                                        Image
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در نظر بگیرید که از دکمه‌های آیکون برای ساده‌سازی تعاملات کاربر، بیان معنی به یک نگاه، و ایجاد یک رابط کاربری بیشتر به سمت بینایی برای مخاطبان خود استفاده کنید.
                                    تعاملات کاربر، بیان معنی به یک نگاه، و ایجاد یک رابط کاربری بیشتر به سمت بینایی برای مخاطبان خود استفاده کنید.
                                    بیشتر به سمت بینایی برای مخاطبان خود استفاده کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    دکمه‌های فقط آیکون
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-11"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-11"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    دکمه‌های فقط آیکون یک ابزار قدرتمند برای ایجاد
                                    رابط‌های کاربری حداقلی و شهودی هستند. در این
                                    بخش، چگونگی استفاده از دکمه‌های فقط آیکون را خواهید آموخت
                                    تا به بهبود قابلیت استفاده و زیبایی
                                    پروژه‌ی وب یا برنامه خود بپردازید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-wrap items-center gap-2">
                                                <x-base.button variant="primary">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Activity"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="secondary">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="HardDrive"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="success">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Calendar"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="warning">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Share2"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="pending">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Download"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="danger">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Trash"
                                                    />
                                                </x-base.button>
                                                <x-base.button variant="dark">
                                                    <x-base.lucide
                                                        class="h-5 w-5"
                                                        icon="Image"
                                                    />
                                                </x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-wrap items-center gap-2">
                                                    <x-base.button variant="primary">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Activity"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="secondary">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="HardDrive"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="success">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Calendar"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="warning">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Share2"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="pending">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Download"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="danger">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Trash"
                                                        />
                                                    </x-base.button>
                                                    <x-base.button variant="dark">
                                                        <x-base.lucide
                                                            class="h-5 w-5"
                                                            icon="Image"
                                                        />
                                                    </x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    دکمه‌های فقط آیکون یک انتخاب عالی برای رابط‌های کاربری مدرن هستند، با ارائه سادگی، وضوح، و طراحی براق. آیا شما دارید یک برنامه‌ی تلفن همراه طراحی می‌کنید یا یک برنامه وب، در نظر بگیرید که از دکمه‌های فقط آیکون برای ایجاد یک رابط کاربری کاربرپسند و ظاهری جذاب استفاده کنید که کاربران را درگیر و مطلع نگه دارد.
                                    رابط‌های کاربری مدرن هستند، با ارائه سادگی، وضوح، و طراحی براق. آیا شما دارید یک برنامه‌ی تلفن همراه طراحی می‌کنید یا یک برنامه وب، در نظر بگیرید که از دکمه‌های فقط آیکون برای ایجاد یک رابط کاربری کاربرپسند و ظاهری جذاب استفاده کنید که کاربران را درگیر و مطلع نگه دارد.
                                    طراحی براق. آیا شما دارید یک برنامه‌ی تلفن همراه طراحی می‌کنید یا یک برنامه وب، در نظر بگیرید که از دکمه‌های فقط آیکون برای ایجاد یک رابط کاربری کاربرپسند و ظاهری جذاب استفاده کنید که کاربران را درگیر و مطلع نگه دارد.
                                    برنامه وب، در نظر بگیرید که از دکمه‌های فقط آیکون برای ایجاد یک رابط کاربری کاربرپسند و ظاهری جذاب استفاده کنید که کاربران را درگیر و مطلع نگه دارد.
                                    ایجاد یک رابط کاربری کاربرپسند و ظاهری جذاب
                                    که کاربران را درگیر و مطلع نگه دارد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">دکمه</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای دکمه (پیش‌فرض
                                                    ("دکمه" یا "لینک")
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`size`</x-base.table.td>
                                                <x-base.table.td>`Size`</x-base.table.td>
                                                <x-base.table.td>اندازه دکمه ("sm" یا "lg")</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`variant`</x-base.table.td>
                                                <x-base.table.td>`Variant`</x-base.table.td>
                                                <x-base.table.td>نوعی از سبک دکمه</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`elevated`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    نشان می‌دهد که آیا دکمه دارای سایه بلند می‌باشد یا خیر
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`rounded`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    نشان می‌دهد که دکمه گرد می‌باشد یا خیر
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های ابتدایی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اندازه‌های دکمه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    کار با لینک‌ها
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های بلند
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های رسانه‌های اجتماعی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های خط مرزی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های وضعیت بارگذاری
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های گرد
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های رنگی نرم
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های آیکون
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    دکمه‌های فقط آیکون
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
