@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    نمودار
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    پتانسیل بصری‌سازی داده را با مؤلفه نمودار ما فعال کنید.
                    به آسانی نمودارهای شگفت‌انگیز و اطلاعاتی ایجاد کنید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار میله‌ای عمودی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار میله‌ای عمودی» به شما اجازه می‌دهد تا
                                    داده‌ها را به صورت بصری در قالب یک نمودار میله‌ای عمودی نمایش دهید.
                                    نمودارهای میله‌ای عمودی برای نمایش و
                                    مقایسه داده‌های عددی در دسته‌ها یا گروه‌ها موثر هستند.
                                    این بخش نحوه ایجاد و سفارشی‌سازی نمودارهای
                                    میله‌ای عمودی با استفاده از یک کتابخانه نمودار محبوب را نشان می‌دهد.
                                    مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-vertical-bar-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-vertical-bar-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نمودارهای میله‌ای عمودی یک روش قدرتمند برای تصویرسازی داده‌ها هستند،
                                    که باعث می‌شوند درک و مقایسه ارزش‌ها آسان‌تر شود
                                    در دسته‌ها یا گروه‌های مختلف. با دنبال کردن
                                    مراحل بالا و سفارشی‌سازی نمودار برای مناسب کردن آن با
                                    نیازهای داده‌ها و طرح خاص خود، شما می‌توانید
                                    به طور موثر نمودارهای میله‌ای عمودی را در
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانده شوید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار میله‌ای افقی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار میله‌ای افقی» به شما اجازه می‌دهد تا
                                    داده‌ها را به صورت بصری در یک نمودار میله‌ای افقی
                                    نمایش دهید. نمودارهای میله‌ای افقی برای
                                    نمایش و مقایسه داده‌های عددی در
                                    دسته‌ها یا گروه‌ها موثر هستند. این بخش نشان می‌دهد که چگونه
                                    نمودارهای میله‌ای افقی را با استفاده از
                                    یک کتابخانه نمودارسازی محبوب مانند نمودار.js ایجاد و سفارشی کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-horizontal-bar-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-horizontal-bar-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نمودارهای میله‌ای افقی راهی موثر برای
                                    تصویرسازی داده‌ها فراهم می‌کنند، که باعث می‌شود درک و
                                    مقایسه ارزش‌ها در دسته‌ها یا گروه‌های مختلف آسان‌تر شود. با
                                    دنبال کردن مراحل بالا و سفارشی‌سازی نمودار برای
                                    به منظور تطابق با نیازهای داده‌ها و طراحی خاص خود، می‌توانید
                                    به طور موثر نمودارهای میله‌ای افقی را در
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانده شوید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار دونات
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار دونات» نوعی نمودار دایره‌ای است
                                    که برای نمایش داده‌ها به شکلی جذاب استفاده می‌شود. نمودار دونات
                                    نوعی تغییر در نمودارهای پایه با یک حفره در
                                    وسط است که آنها را برای نمایش داده‌ها
                                    توزیع و مقایسه مفید می‌سازد. این بخش نشان می‌دهد که
                                    چگونگی ایجاد و سفارشی‌سازی نمودار دونات با استفاده از یک
                                    کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-donut-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-donut-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار دونات» نوعی نمودار دایره‌ای است
                                    که برای نمایش داده‌ها به شکلی جذاب استفاده می‌شود. نمودار دونات
                                    نوعی تغییر در نمودارهای پایه با یک حفره در
                                    وسط است که آنها را برای نمایش داده‌ها
                                    توزیع و مقایسه مفید می‌سازد. این بخش نشان می‌دهد که
                                    چگونگی ایجاد و سفارشی‌سازی نمودار دونات با استفاده از یک
                                    کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار میله‌ای توده‌ای
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار میله‌ای توده‌ای» ابزار قدرتمندی برای تصویرسازی داده است
                                    که به شما اجازه می‌دهد داده‌ها را به صورت
                                    توده‌ای نمایش دهید. نمودارهای میله‌ای توده‌ای برای
                                    تصویرسازی داده‌ها با چندین دسته و مقایسه
                                    ترکیب هر دسته در گروه‌ها یا دوره‌های زمانی مختلف موثر هستند. این بخش نشان می‌دهد که چگونه
                                    نمودارهای میله‌ای توده‌ای را ایجاد و سفارشی کنید با استفاده از
                                    یک کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                    کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-stacked-bar-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-stacked-bar-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نمودارهای میله‌ای توده‌ای یک راه چندمنظوره برای نمایش داده‌ها هستند
                                    که آن را آسان‌تر می‌کنند برای مقایسه و
                                    تجزیه و تحلیل ترکیب هر دسته. با
                                    دنبال کردن مراحل بالا و سفارشی‌سازی نمودار برای
                                    به منظور تطابق با نیازهای داده‌ها و طراحی خاص خود، می‌توانید
                                    به طور موثر نمودارهای میله‌ای توده‌ای را به
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار خطی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار خطی» ابزار ارزشمندی برای تصویرسازی داده است
                                    که به شما اجازه می‌دهد داده‌ها را به عنوان یک سری نشانگر داده متصل نمایید
                                    تشکیل خط می‌دهد. نمودارهای خطی برای نمایش روندها در طول زمان موثر هستند
                                    ، مقایسه‌ها را انجام داده و داده‌ها با متغیرهای پیوسته را تصویرسازی می‌کنند. این بخش نشان می‌دهد که چگونه
                                    نمودارهای خطی را ایجاد و سفارشی کنید با استفاده از
                                    یک کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js. نمودارهای خطی ابزار قدرتمندی برای تصویرسازی روندها و الگوهای داده‌های شما هستند.
                                    با دنبال کردن مراحل بالا و سفارشی‌سازی نمودار
                                    کتابخانه نمودارسازی محبوب مانند یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-line-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-line-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    برای تطابق با داده‌ها و نیازهای طراحی خاص خود می‌توانید
                                    به طور موثر نمودارهای خطی را به
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانید.
                                    با رعایت نیازهای طراحی، می‌توانید به طور موثر
                                    نمودارهای خطی را به برنامه وب خود برای تصویرسازی داده
                                    گنجانید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمودار دایره‌ای
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه «نمودار دایره‌ای» یک ابزار محبوب برای تصویرسازی داده است
                                    که برای نمایش داده‌ها به عنوان یک نمودار دایره‌ای استفاده می‌شود
                                    هر نقطه داده به عنوان یک برش از
                                    دایره نمایش داده می‌شود، با اندازه هر برش به تناسب
                                    داده‌ای که نمایانگر آن است. نمودارهای دایره‌ای برای
                                    نمایش داده با چندین دسته و نمایش
                                    نسبت‌های نسبی هر دسته در مجموعه کاربرد دارند. این بخش نشان می‌دهد که چگونه
                                    این بخش نحوه ایجاد و سفارشی‌سازی نمودارهای
                                    نمودارهای دایره‌ای را ایجاد و سفارشی کنید با استفاده از
                                    یک کتابخانه نمودارسازی محبوب مانند نمودار.js.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-pie-chart height="h-[400px]" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-pie-chart height="h-[400px]" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نمودارهای دایره‌ای ابزار مفیدی برای تصویرسازی
                                    توزیع داده بین دسته‌ها یا نمایش
                                    نسبت‌های نسبی اجزا مختلف در یک کل می‌باشند. با دنبال کردن مراحل بالا و سفارشی‌سازی نمودار
                                    به منظور تطابق با داده‌های و نیازهای طراحی خاص خود می‌توانید
                                    نمودارهای دایره‌ای را به
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانید.
                                    برنامه وب خود برای تصویرسازی داده‌ها گنجانید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">نمودار</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`type`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    The type of chart (e.g., "line", "bar", "pie").
                                                    پیش‌فرض "خطی" است.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`data`</x-base.table.td>
                                                <x-base.table.td>`ChartConfiguration['data']`</x-base.table.td>
                                                <x-base.table.td>
                                                    پیکربندی داده‌ها برای نمودار.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`ChartConfiguration['options']`</x-base.table.td>
                                                <x-base.table.td>
                                                    پیکربندی گزینه‌ها برای نمودار.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`width`</x-base.table.td>
                                                <x-base.table.td>`number`, `auto`</x-base.table.td>
                                                <x-base.table.td>
                                                    عرض کانوس نمودار به پیکسل یا "اتو" برای
                                                    استفاده از عرض مخزن والد. پیش‌فرض:
                                                    "auto".
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`height`</x-base.table.td>
                                                <x-base.table.td>`number`, `auto`</x-base.table.td>
                                                <x-base.table.td>
                                                    ارتفاع کانوس نمودار به پیکسل یا "اتو"
                                                    برای استفاده از ارتفاع مخزن والد. پیش‌فرض:
                                                    "auto".
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: ChartElement | null) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابع که یک مرجع به عنصر کانوس نمودار دریافت می‌کند.
                                                    عنصر کانوس.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار میله‌ای عمودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار میله‌ای افقی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار دونات
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار میله‌ای توده‌ای
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار خطی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمودار دایره‌ای
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
