@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12 2xl:col-span-3">
            <div class="grid grid-cols-12 gap-x-6 gap-y-10">
                <div class="col-span-12 lg:col-span-4 2xl:col-span-12">
                    <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                        <div class="text-base font-medium group-[.mode--light]:text-white">
                            موجودی فعلی
                        </div>
                    </div>
                    <div class="box box--stacked mt-3.5 p-5">
                        <x-base.menu class="absolute end-0 top-0 me-5 mt-5">
                            <x-base.menu.button class="h-5 w-5 text-slate-500">
                                <x-base.lucide
                                    class="h-6 w-6 fill-slate-400/70 stroke-slate-400/70"
                                    icon="MoreVertical"
                                />
                            </x-base.menu.button>
                            <x-base.menu.items class="w-40">
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Copy"
                                    /> کپی لینک
                                </x-base.menu.item>
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Trash"
                                    />
                                    حذف
                                </x-base.menu.item>
                            </x-base.menu.items>
                        </x-base.menu>
                        <div
                            class="flex h-12 w-12 items-center justify-center rounded-full border border-info/10 bg-info/10">
                            <x-base.lucide
                                class="h-6 w-6 fill-info/10 text-info"
                                icon="Box"
                            />
                        </div>
                        <div class="mb-6 mt-8 lg:mb-7 lg:mt-16 2xl:mb-5 2xl:mt-7">
                            <div class="text-base text-slate-500">در دسترس</div>
                            <div class="mt-1 flex items-center text-2xl font-medium">
                                <span class="text-[1.3rem]">$</span>
                                <span class="ms-px me-1.5">435,220,00</span>
                                <span class="mt-0.5 text-base">USD</span>
                            </div>
                        </div>
                        <a
                            class="flex items-center font-medium text-primary"
                            href=""
                        >
                            تنظیم انتقال خودکار
                            <x-base.lucide
                                class="ms-1.5 h-4 w-4"
                                icon="MoveRight"
                            />
                        </a>
                    </div>
                </div>
                <div class="col-span-12 sm:col-span-6 lg:col-span-4 2xl:col-span-12">
                    <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                        <div
                            class="text-base font-medium lg:group-[.mode--light]:text-white 2xl:group-[.mode--light]:text-current">
                            پول وارد شده
                        </div>
                    </div>
                    <div class="box box--stacked mt-3.5 p-5">
                        <x-base.menu class="absolute end-0 top-0 me-5 mt-5">
                            <x-base.menu.button class="h-5 w-5 text-slate-500">
                                <x-base.lucide
                                    class="h-6 w-6 fill-slate-400/70 stroke-slate-400/70"
                                    icon="MoreVertical"
                                />
                            </x-base.menu.button>
                            <x-base.menu.items class="w-40">
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Copy"
                                    /> کپی لینک
                                </x-base.menu.item>
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Trash"
                                    />
                                    حذف
                                </x-base.menu.item>
                            </x-base.menu.items>
                        </x-base.menu>
                        <div class="mb-5 border-b border-dashed border-slate-300/70 pb-5">
                            <div class="text-base text-slate-500">مجموع دریافتی</div>
                            <div class="mt-1 flex items-center">
                                <div class="flex items-center text-xl font-medium">
                                    <span class="me-px">$</span>2,176,221
                                    <span class="ms-1.5 text-sm">USD</span>
                                </div>
                            </div>
                        </div>
                        <x-report-bar-chart-3
                            class="relative z-10 -ms-1"
                            height="h-[80px]"
                        />
                        <a
                            class="mt-6 flex items-center font-medium text-primary"
                            href=""
                        >
                            درخواست پول
                            <x-base.lucide
                                class="ms-1.5 h-4 w-4"
                                icon="MoveRight"
                            />
                        </a>
                    </div>
                </div>
                <div class="col-span-12 sm:col-span-6 lg:col-span-4 2xl:col-span-12">
                    <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                        <div
                            class="text-base font-medium lg:group-[.mode--light]:text-white 2xl:group-[.mode--light]:text-current">
                            پول خارج شده
                        </div>
                    </div>
                    <div class="box box--stacked mt-3.5 p-5">
                        <x-base.menu class="absolute end-0 top-0 me-5 mt-5">
                            <x-base.menu.button class="h-5 w-5 text-slate-500">
                                <x-base.lucide
                                    class="h-6 w-6 fill-slate-400/70 stroke-slate-400/70"
                                    icon="MoreVertical"
                                />
                            </x-base.menu.button>
                            <x-base.menu.items class="w-40">
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Copy"
                                    /> کپی لینک
                                </x-base.menu.item>
                                <x-base.menu.item>
                                    <x-base.lucide
                                        class="me-2 h-4 w-4"
                                        icon="Trash"
                                    />
                                    حذف
                                </x-base.menu.item>
                            </x-base.menu.items>
                        </x-base.menu>
                        <div class="mb-5 border-b border-dashed border-slate-300/70 pb-5">
                            <div class="text-base text-slate-500">
                                مجموع ارسال شده یا هزینه شده
                            </div>
                            <div class="mt-1 flex items-center">
                                <div class="flex items-center text-xl font-medium">
                                    <span class="me-px">$</span>4,176,132
                                    <span class="ms-1.5 text-sm">USD</span>
                                </div>
                            </div>
                        </div>
                        <x-report-bar-chart-4
                            class="relative z-10 -ms-1"
                            height="h-[80px]"
                        />
                        <a
                            class="mt-6 flex items-center font-medium text-primary"
                            href=""
                        >
                            ارسال پول
                            <x-base.lucide
                                class="ms-1.5 h-4 w-4"
                                icon="MoveRight"
                            />
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-span-12 flex flex-col gap-y-10 2xl:col-span-9">
            <div>
                <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                    <div class="text-base font-medium 2xl:group-[.mode--light]:text-white">
                        لینک‌های سریع
                    </div>
                </div>
                <div class="box box--stacked mt-3.5">
                    <div class="grid grid-cols-2 gap-y-5 border-b px-5 py-10 sm:grid-cols-3 md:grid-cols-5 lg:grid-cols-7">
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-primary/10 text-primary"
                                    icon="CreditCard"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">ابزارهای تجاری</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-info/10 bg-info/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-info/10 text-info"
                                    icon="WalletCards"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">صورتحساب</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-info/10 bg-info/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-info/10 text-info"
                                    icon="Airplay"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">درخواست پول</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-success/10 bg-success/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-success/10 text-success"
                                    icon="Banknote"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">ارسال پول</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-pending/10 bg-pending/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-pending/10 text-pending"
                                    icon="Users"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">اشتراک گذاری پروفایل</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-primary/10 text-primary"
                                    icon="ShoppingBag"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">پرداخت</div>
                        </a>
                        <a
                            class="flex flex-col items-center"
                            href=""
                        >
                            <div
                                class="flex h-12 w-12 items-center justify-center rounded-full border border-warning/10 bg-warning/10">
                                <x-base.lucide
                                    class="h-6 w-6 fill-warning/10 text-warning"
                                    icon="CircleDollarSign"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">پذیرش پرداخت‌ها</div>
                        </a>
                    </div>
                    <div class="flex flex-col items-center gap-5 rounded-b-lg bg-slate-50 px-6 pb-6 pt-5 md:flex-row">
                        <div
                            class="flex h-12 w-12 items-center justify-center rounded-full border border-info/10 bg-info/10">
                            <x-base.lucide
                                class="h-6 w-6 fill-info/10 text-info"
                                icon="Box"
                            />
                        </div>
                        <div class="text-center md:text-start">
                            <div class="mt-1 text-lg font-medium">صورتحساب</div>
                            <div class="mt-1 leading-relaxed text-slate-600">
                                در چند دقیقه یک فاکتور یا تخمین ارسال کنید. مشتریان می‌توانند با
                                کارت‌ها یا تیلوایس پرداخت کنند.
                            </div>
                        </div>
                        <div class="flex w-full flex-col gap-3 sm:w-auto sm:flex-row md:ms-auto">
                            <x-base.button
                                class="w-full sm:w-36"
                                href=""
                                as="a"
                                rounded
                            >
                                الان نه
                            </x-base.button>
                            <x-base.button
                                class="w-full border-primary/50 sm:w-36"
                                href=""
                                as="a"
                                variant="outline-primary"
                                rounded
                            >
                                بیشتر بدانید
                            </x-base.button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="grid grid-cols-1 gap-x-6 gap-y-10 md:grid-cols-2">
                <div class="flex flex-col gap-y-10">
                    <div>
                        <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                            <div class="text-base font-medium">ارسال پرداخت‌ها</div>
                        </div>
                        <div class="box box--stacked mt-3.5 p-5">
                            <x-base.form-input
                                class="py-3"
                                type="text"
                                placeholder="Add an email or name"
                            />
                            <x-base.button
                                class="mt-6 border-primary/50 px-10"
                                variant="outline-primary"
                                rounded
                            >
                                Next
                            </x-base.button>
                        </div>
                    </div>
                    <div>
                        <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                            <div class="text-base font-medium">درخواست پول</div>
                        </div>
                        <div class="box box--stacked mt-3.5 p-5">
                            <div class="flex">
                                <div class="flex items-center text-2xl">
                                    <span class="-mt-1 me-1.5 text-base font-medium">
                                        $
                                    </span>
                                    <span
                                        class="outline-none"
                                        contenteditable="true"
                                    >
                                        0,00
                                    </span>
                                    <div class="relative ms-2 flex items-center text-primary">
                                        <x-base.form-select
                                            class="border-0 bg-none p-0 pe-4 text-sm shadow-none focus:ring-0"
                                        >
                                            <option value="USD">USD</option>
                                            <option value="AUD">AUD</option>
                                            <option value="BRL">BRL</option>
                                            <option value="CAD">CAD</option>
                                            <option value="CHF">CHF</option>
                                            <option value="CZK">CZK</option>
                                            <option value="DKK">DKK</option>
                                            <option value="EUR">EUR</option>
                                            <option value="GBP">GBP</option>
                                            <option value="HKD">HKD</option>
                                            <option value="HUF">HUF</option>
                                            <option value="ILS">ILS</option>
                                            <option value="JPY">JPY</option>
                                            <option value="MXN">MXN</option>
                                            <option value="NOK">NOK</option>
                                            <option value="NZD">NZD</option>
                                            <option value="PHP">PHP</option>
                                            <option value="PLN">PLN</option>
                                            <option value="RUB">RUB</option>
                                            <option value="SEK">SEK</option>
                                            <option value="SGD">SGD</option>
                                            <option value="THB">THB</option>
                                            <option value="TWD">TWD</option>
                                        </x-base.form-select>
                                        <x-base.lucide
                                            class="absolute inset-y-0 end-0 my-auto ms-1 h-4 w-4 stroke-[1.3]"
                                            icon="ChevronDown"
                                        />
                                    </div>
                                </div>
                            </div>
                            <x-base.form-input
                                class="mt-5 py-3"
                                type="text"
                                placeholder="Add an email or name"
                            />
                            <x-base.button
                                class="mt-6 border-primary/50 px-10"
                                variant="outline-primary"
                                rounded
                            >
                                Next
                            </x-base.button>
                        </div>
                    </div>
                    <div>
                        <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                            <div class="text-base font-medium">صدور بازپرداخت</div>
                        </div>
                        <div class="box box--stacked mt-3.5 p-5">
                            <div class="relative">
                                <x-base.lucide
                                    class="absolute inset-y-0 start-0 my-auto ms-3 h-6 w-6 text-slate-400"
                                    icon="Search"
                                />
                                <x-base.form-input
                                    class="py-3 ps-11"
                                    type="text"
                                    placeholder="Transaction id, invoice id or email"
                                />
                            </div>
                            <div class="mt-3 text-slate-500">
                                هر پرداختی که قابل بازپرداخت است و با هیچ یک از بازهای باز نیست را پیدا کنید
                                موارد. مقدار بازپرداخت را وارد کنید و ارسال کنید.
                            </div>
                            <div class="mt-5 text-slate-500">
                                <a
                                    class="font-medium text-primary"
                                    href=""
                                >
                                    بیشتر بدانید
                                </a>
                                درباره بازپرداخت
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex flex-col gap-y-10">
                    <div>
                        <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                            <div class="text-base font-medium">
                                ایجاد یک اشتراک
                            </div>
                        </div>
                        <div class="box box--stacked mt-3.5 p-5">
                            <x-base.form-input
                                class="py-3"
                                type="text"
                                placeholder="Enter product name"
                            />
                            <x-base.form-input
                                class="mt-3 py-3"
                                type="text"
                                placeholder="Enter plan name"
                            />
                            <div class="mt-3 flex gap-3">
                                <x-base.form-select class="py-3">
                                    <option value="USD">USD</option>
                                    <option value="AUD">AUD</option>
                                    <option value="BRL">BRL</option>
                                    <option value="CAD">CAD</option>
                                    <option value="CHF">CHF</option>
                                    <option value="CZK">CZK</option>
                                    <option value="DKK">DKK</option>
                                    <option value="EUR">EUR</option>
                                    <option value="GBP">GBP</option>
                                    <option value="HKD">HKD</option>
                                    <option value="HUF">HUF</option>
                                    <option value="ILS">ILS</option>
                                    <option value="JPY">JPY</option>
                                    <option value="MXN">MXN</option>
                                    <option value="NOK">NOK</option>
                                    <option value="NZD">NZD</option>
                                    <option value="PHP">PHP</option>
                                    <option value="PLN">PLN</option>
                                    <option value="RUB">RUB</option>
                                    <option value="SEK">SEK</option>
                                    <option value="SGD">SGD</option>
                                    <option value="THB">THB</option>
                                    <option value="TWD">TWD</option>
                                </x-base.form-select>
                                <x-base.form-input
                                    class="py-3"
                                    type="text"
                                    placeholder="0,00"
                                />
                                <x-base.form-select class="py-3">
                                    <option value="monthly">ماهانه</option>
                                    <option value="yearly">سالیانه</option>
                                    <option value="weekly">Weekly</option>
                                    <option value="daily">روزانه</option>
                                </x-base.form-select>
                            </div>
                            <div class="mt-6 flex gap-3">
                                <x-base.button
                                    class="border-primary/50 px-7"
                                    rounded
                                    variant="primary"
                                >
                                    اکنون ایجاد کنید
                                </x-base.button>
                                <x-base.button
                                    class="border-primary/50 px-7"
                                    rounded
                                    variant="outline-primary"
                                >
                                    گزینه‌های بیشتر
                                </x-base.button>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                            <div class="text-base font-medium">ایجاد یک فاکتور</div>
                        </div>
                        <div class="box box--stacked mt-3.5 p-5">
                            <x-base.form-input
                                class="py-3"
                                type="text"
                                placeholder="Customers email's"
                            />
                            <x-base.form-input
                                class="mt-3 py-3"
                                type="text"
                                placeholder="Item name"
                            />
                            <div class="mt-3 flex gap-3">
                                <x-base.form-input
                                    class="py-3"
                                    type="text"
                                    placeholder="Item amount"
                                />
                                <x-base.form-select class="py-3">
                                    <option value="USD">USD</option>
                                    <option value="AUD">AUD</option>
                                    <option value="BRL">BRL</option>
                                    <option value="CAD">CAD</option>
                                    <option value="CHF">CHF</option>
                                    <option value="CZK">CZK</option>
                                    <option value="DKK">DKK</option>
                                    <option value="EUR">EUR</option>
                                    <option value="GBP">GBP</option>
                                    <option value="HKD">HKD</option>
                                    <option value="HUF">HUF</option>
                                    <option value="ILS">ILS</option>
                                    <option value="JPY">JPY</option>
                                    <option value="MXN">MXN</option>
                                    <option value="NOK">NOK</option>
                                    <option value="NZD">NZD</option>
                                    <option value="PHP">PHP</option>
                                    <option value="PLN">PLN</option>
                                    <option value="RUB">RUB</option>
                                    <option value="SEK">SEK</option>
                                    <option value="SGD">SGD</option>
                                    <option value="THB">THB</option>
                                    <option value="TWD">TWD</option>
                                </x-base.form-select>
                            </div>
                            <div class="mt-6 flex gap-3">
                                <x-base.button
                                    class="border-primary/50 px-7"
                                    rounded
                                    variant="primary"
                                >
                                    Send
                                </x-base.button>
                                <x-base.button
                                    class="ms-2.5 border-transparent px-0 text-primary shadow-none"
                                    href=""
                                    as="a"
                                    rounded
                                >
                                    اضافه کردن جزئیات بیشتر
                                </x-base.button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
