@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    انتخاب تاریخ
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت مؤلفه انتخاب تاریخ ما را برای تاریخ ساده شده کشف کنید
                    و ورود در برنامه‌های وب خود.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب تاریخ پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب تاریخ پایه" به کاربران اجازه می‌دهد که انتخاب کنند
                                    تاریخ‌ها را از یک تقویم. این یک عنصر ورودی اساسی است
                                    در بسیاری از برنامه‌های وب، به خصوص در فرم‌هایی که
                                    نیاز به ورود یا انتخاب تاریخ دارند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.jalali-datepicker
                                                class="mx-auto block w-56"
                                                data-single-mode="true"
                                            />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.jalali-datepicker
                                                    class="mx-auto block w-56"
                                                    data-single-mode="true"
                                                />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب تاریخ پایه" با استفاده از Litepicker
                                    یک راه دوستانه برای انتخاب تاریخ‌ها برای شما ارائه می‌دهد
                                    برنامه وب شما. این قابلیت پیکربندی بالایی دارد و آسان است برای
                                    ادغام در پروژه‌های شما.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    گروه ورودی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "گروه ورودی" یک فیلد ورودی را با هم ترکیب می‌کند
                                    یک نماد تقویم و یک datepicker برای تسهیل در تاریخ
                                    انتخاب در برنامه وب شما. این مؤلفه
                                    مفید برای بهبود تجربه کاربری هنگام ورود
                                    تاریخ‌ها در فرم‌ها است.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="relative mx-auto w-56">
                                                <div
                                                    class="absolute flex h-full w-10 items-center justify-center rounded-s border bg-slate-100 text-slate-500 dark:border-darkmode-800 dark:bg-darkmode-700 dark:text-slate-400">
                                                    <x-base.lucide
                                                        class="h-4 w-4"
                                                        icon="Calendar"
                                                    />
                                                </div>
                                                <x-base.jalali-datepicker
                                                    class="ps-12"
                                                    data-single-mode="true"
                                                />
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="relative mx-auto w-56">
                                                    <div
                                                        class="absolute flex h-full w-10 items-center justify-center rounded-s border bg-slate-100 text-slate-500 dark:border-darkmode-800 dark:bg-darkmode-700 dark:text-slate-400">
                                                        <x-base.lucide
                                                            class="h-4 w-4"
                                                            icon="Calendar"
                                                        />
                                                    </div>
                                                    <x-base.jalali-datepicker
                                                        class="ps-12"
                                                        data-single-mode="true"
                                                    />
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "گروه ورودی انتخاب تاریخ" یک
                                    روش شیک و کاربرپسند برای انتخاب تاریخ‌ها در برنامه
                                    وب شما فراهم می‌کند. با ترکیب یک فیلد ورودی با یک
                                    نماد تقویم و Litepicker، کاربران می‌توانند به راحتی ورودی
                                    تاریخ‌ها، فرم‌های شما را بیشتر شیوا و قابل دسترس می‌کنند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب کننده محدوده تاریخ
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب کننده محدوده تاریخ" به کاربران اجازه می‌دهد که انتخاب کنند
                                    یک محدوده تاریخ در برنامه وب شما. این مؤلفه
                                    مفید برای حالت‌هایی که نیاز به جمع‌آوری تاریخ دارید
                                    مانند سیستم‌های رزرو یا فیلترینگ بر اساس تاریخ.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.jalali-datepicker class="mx-auto block w-56" />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.jalali-datepicker class="mx-auto block w-56" />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب کننده محدوده تاریخ" وب شما را بهبود می‌بخشد
                                    با ارائه راهی آسان و شهودی برای
                                    کاربران برای انتخاب محدوده تاریخ. برای ساختن یک
                                    سیستم رزرو یا اجرای فیلترینگ بر اساس تاریخ،
                                    این مؤلفه فرایند جمع‌آوری
                                    محدوده تاریخ را ساده‌تر می‌کند، برنامه شما را دوستانه‌تر
                                    و کارآمدتر می‌کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب تاریخ مودال
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب تاریخ مودال" عملکرد یک datepicker را با یک پنجره مودال ترکیب می‌کند،
                                    که به کاربران اجازه می‌دهد تا تاریخ‌ها را در یک رابط مودال انتخاب کنند.
                                    این مؤلفه در حالت‌هایی کاربردی است که می‌خواهید انتخاب تاریخی متمرکز و بدون مزاحمت فراهم کنید
                                    این مؤلفه برای حالت‌هایی کاربردی است که می‌خواهید
                                    انتخاب تاریخی متمرکز و بدون مزاحمت فراهم کنید
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Show Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#datepicker-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Show Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="datepicker-modal-preview">
                                                <x-base.dialog.panel>
                                                    <!-- BEGIN: Modal Header -->
                                                    <x-base.dialog.title>
                                                        <h2 class="me-auto text-base font-medium">
                                                            فیلتر بر اساس تاریخ
                                                        </h2>
                                                        <x-base.button
                                                            class="hidden sm:flex"
                                                            variant="outline-secondary"
                                                        >
                                                            <x-base.lucide
                                                                class="me-2 h-4 w-4"
                                                                icon="File"
                                                            />
                                                            دانلود اسناد
                                                        </x-base.button>
                                                        <x-base.menu class="sm:hidden">
                                                            <x-base.menu.button
                                                                class="block h-5 w-5"
                                                                href="#"
                                                                as="a"
                                                            >
                                                                <x-base.lucide
                                                                    class="h-5 w-5 text-slate-500"
                                                                    icon="MoreHorizontal"
                                                                />
                                                            </x-base.menu.button>
                                                            <x-base.menu.items class="w-40">
                                                                <x-base.menu.item>
                                                                    <x-base.lucide
                                                                        class="me-2 h-4 w-4"
                                                                        icon="File"
                                                                    />
                                                                    دانلود اسناد
                                                                </x-base.menu.item>
                                                            </x-base.menu.items>
                                                        </x-base.menu>
                                                    </x-base.dialog.title>
                                                    <!-- END: Modal Header -->
                                                    <!-- BEGIN: Modal Body -->
                                                    <x-base.dialog.description class="grid grid-cols-12 gap-4 gap-y-3">
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-datepicker-1">
                                                                From
                                                            </x-base.form-label>
                                                            <x-base.jalali-datepicker
                                                                id="modal-datepicker-1"
                                                                data-single-mode="true"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-datepicker-2">
                                                                To
                                                            </x-base.form-label>
                                                            <x-base.jalali-datepicker
                                                                id="modal-datepicker-2"
                                                                data-single-mode="true"
                                                            />
                                                        </div>
                                                    </x-base.dialog.description>
                                                    <!-- END: Modal Body -->
                                                    <!-- BEGIN: Modal Footer -->
                                                    <x-base.dialog.footer class="text-end">
                                                        <x-base.button
                                                            class="me-1 w-20"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="outline-secondary"
                                                        >
                                                            Cancel
                                                        </x-base.button>
                                                        <x-base.button
                                                            class="w-20"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            ثبت
                                                        </x-base.button>
                                                    </x-base.dialog.footer>
                                                    <!-- END: Modal Footer -->
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Show Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#datepicker-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Show Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="datepicker-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <!-- BEGIN: Modal Header -->
                                                        <x-base.dialog.title>
                                                            <h2 class="me-auto text-base font-medium">
                                                                فیلتر بر اساس تاریخ
                                                            </h2>
                                                            <x-base.button
                                                                class="hidden sm:flex"
                                                                variant="outline-secondary"
                                                            >
                                                                <x-base.lucide
                                                                    class="me-2 h-4 w-4"
                                                                    icon="File"
                                                                />
                                                                دانلود اسناد
                                                            </x-base.button>
                                                            <x-base.menu class="sm:hidden">
                                                                <x-base.menu.button
                                                                    class="block h-5 w-5"
                                                                    href="#"
                                                                    as="a"
                                                                >
                                                                    <x-base.lucide
                                                                        class="h-5 w-5 text-slate-500"
                                                                        icon="MoreHorizontal"
                                                                    />
                                                                </x-base.menu.button>
                                                                <x-base.menu.items class="w-40">
                                                                    <x-base.menu.item>
                                                                        <x-base.lucide
                                                                            class="me-2 h-4 w-4"
                                                                            icon="File"
                                                                        />
                                                                        دانلود اسناد
                                                                    </x-base.menu.item>
                                                                </x-base.menu.items>
                                                            </x-base.menu>
                                                        </x-base.dialog.title>
                                                        <!-- END: Modal Header -->
                                                        <!-- BEGIN: Modal Body -->
                                                        <x-base.dialog.description class="grid grid-cols-12 gap-4 gap-y-3">
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-datepicker-1">
                                                                    From
                                                                </x-base.form-label>
                                                                <x-base.jalali-datepicker
                                                                    id="modal-datepicker-1"
                                                                    data-single-mode="true"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-datepicker-2">
                                                                    To
                                                                </x-base.form-label>
                                                                <x-base.jalali-datepicker
                                                                    id="modal-datepicker-2"
                                                                    data-single-mode="true"
                                                                />
                                                            </div>
                                                        </x-base.dialog.description>
                                                        <!-- END: Modal Body -->
                                                        <!-- BEGIN: Modal Footer -->
                                                        <x-base.dialog.footer class="text-end">
                                                            <x-base.button
                                                                class="me-1 w-20"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="outline-secondary"
                                                            >
                                                                Cancel
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="w-20"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                ثبت
                                                            </x-base.button>
                                                        </x-base.dialog.footer>
                                                        <!-- END: Modal Footer -->
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "انتخاب تاریخ مودال" عملکرد یک datepicker را با یک پنجره مودال ترکیب می‌کند،
                                    راحتی یک datepicker با تجربه کاربری دوستانه
                                    پنجره مودال. این ادغام، راهی تمیز و منظم برای انتخاب تاریخ توسط کاربران در
                                    برنامه وب شما فراهم می‌کند، که برای فیلترینگ بر اساس تاریخ یا هر حالتی که انتخاب تاریخ لازم است،
                                    ایده‌آل است.
                                    فیلتر کردن یا هر سناریویی که انتخاب تاریخ مورد نیاز است
                                    required.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">JalaliDatepicker</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انتخاب تاریخ پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    گروه ورودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انتخاب کننده محدوده تاریخ
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انتخاب تاریخ مودال
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
