@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex items-center h-10">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    کشویی
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    از انعطاف‌پذیری مؤلفه کشویی ما برای ایجاد
                    منوهای تعاملی و گزینه‌های انتخابی در برنامه‌های وب شما.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative flex flex-col col-span-12 gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منوی پایه
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای کشویی واسط کاربر اصلی هستند
                                    که به کاربران اجازه می‌دهند از یک لیست گزینه انتخاب کنند
                                    گزینه‌ها در یک فرمت قابل جمع شدن. این بخش شامل موارد زیر می‌شود:
                                    ایجاد و استفاده از منوهای پایه در برنامه‌های وب شما با استفاده از مؤلفه `Menu`.
                                    برنامه‌هایی که از مؤلفه Menu استفاده می‌کنند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex justify-center">
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    با کد ارائه شده آزمایش کنید و آن را سفارشی سازی کنید تا
                                    به نیازهای خاص شما پاسخ دهد. منوها می‌توانند تجربه کاربر را بهبود بخشید
                                    با ساده‌سازی ناوبری و تعامل در
                                    برنامه شما.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منوی سربرگ و پاورقی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای کشویی اغلب نیاز به عناصر اضافی مانند
                                    سربرگ‌ها و پاورقی‌ها دارند تا زمینه یا اطلاعات اضافی را ارائه دهند.
                                    این بخش به چگونگی ایجاد منوها با هم سربرگ و پاورقی با استفاده از مؤلفه `Menu` پرداخته می‌شود.
                                    با هم سربرگ و پاورقی با استفاده از مؤلفه `Menu`
                                    component.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex justify-center">
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-56">
                                                        <x-base.menu.header>گزینه‌های صادرات</x-base.menu.header>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Activity"
                                                            />
                                                            انگلیسی
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Box"
                                                            />
                                                            اندونزی
                                                            <div
                                                                class="px-1 ms-auto text-xs text-white rounded-full bg-danger">
                                                                10
                                                            </div>
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Layout"
                                                            />
                                                            انگلیسی
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="PanelRight"
                                                            />
                                                            اندونزی
                                                        </x-base.menu.item>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.footer>
                                                            <x-base.button
                                                                class="px-2 py-1"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                تنظیمات
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="px-2 py-1 ms-auto"
                                                                type="button"
                                                                variant="secondary"
                                                            >
                                                                مشاهده پروفایل
                                                            </x-base.button>
                                                        </x-base.menu.footer>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-56">
                                                        <x-base.menu.header>گزینه‌های صادرات</x-base.menu.header>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Activity"
                                                            />
                                                            انگلیسی
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Box"
                                                            />
                                                            اندونزی
                                                            <div
                                                                class="px-1 ms-auto text-xs text-white rounded-full bg-danger">
                                                                10
                                                            </div>
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Layout"
                                                            />
                                                            انگلیسی
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Sidebar"
                                                            />
                                                            اندونزی
                                                        </x-base.menu.item>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.footer>
                                                            <x-base.button
                                                                class="px-2 py-1"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                تنظیمات
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="px-2 py-1 ms-auto"
                                                                type="button"
                                                                variant="secondary"
                                                            >
                                                                مشاهده پروفایل
                                                            </x-base.button>
                                                        </x-base.menu.footer>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    منوهای با سربرگ و پاورقی یک ساختار فرماندهی شده را فراهم می‌کنند
                                    برای ارائه گزینه‌ها و اطلاعات به کاربران. آنها
                                    به طور خاص مفید هستند در مواقعی که نیاز دارید
                                    به گروه‌بندی موارد مرتبط یا ارائه زمینه‌ای اضافی.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منو آیکون
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای آیکون می‌توانند نشانه‌های بصری اضافه کنند و تجربه کاربر را بهبود بخشند
                                    هنگام انتخاب گزینه‌ها. این بخش به چگونگی ایجاد منوها با آیکون با استفاده از مؤلفه `Menu` پرداخته می‌شود.
                                    چگونگی ایجاد منوهای دارای آیکون با استفاده از مؤلفه Menu
                                    component.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex justify-center">
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-48">
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="FileEdit"
                                                            />
                                                            منو جدید
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Trash"
                                                            />
                                                            حذف منو
                                                        </x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-48">
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Edit2"
                                                            /> New
                                                            کشویی
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Trash"
                                                            />
                                                            حذف منو
                                                        </x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    منوهای آیکون به کاربران کمک بصری می‌کنند زمانی که
                                    گزینه‌ها را انتخاب می‌کنند و رابط کاربری را بیشتر خرد می‌کنند
                                    و کاربرپسندتر می‌سازند. با آیکون‌های مختلف آزمایش کنید و
                                    استایل‌ها را برای ایجاد منوهایی که بهترین
                                    مناسبی برای طراحی و نیازهای کاربر شما هستند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منو با دکمه بستن
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای با دکمه بستن یک راه کاربرپسند برای
                                    ارائه گزینه‌ها هستند در حالی که به کاربران اجازه می‌دهند تا
                                    منو را از بین ببرند هنگام لازم. این بخش به چگونگی ایجاد
                                    منوها با دکمه بستن با استفاده از مؤلفه `Menu` پرداخته می‌شود.
                                    component.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <x-base.popover
                                                    class="inline-block"
                                                    placement="bottom-start"
                                                >
                                                    <x-base.popover.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        منوی فیلتر
                                                        <x-base.lucide
                                                            class="w-4 h-4 ms-2"
                                                            icon="ChevronDown"
                                                        />
                                                    </x-base.popover.button>
                                                    <x-base.popover.panel>
                                                        <div class="p-2">
                                                            <div>
                                                                <div class="text-xs text-start">From</div>
                                                                <x-base.form-input
                                                                    class="flex-1 mt-2"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <div class="text-xs text-start">To</div>
                                                                <x-base.form-input
                                                                    class="flex-1 mt-2"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="flex items-center mt-3">
                                                                <x-base.button
                                                                    class="w-32 ms-auto"
                                                                    data-dismiss="dropdown"
                                                                    variant="secondary"
                                                                >
                                                                    Close
                                                                </x-base.button>
                                                                <x-base.button
                                                                    class="w-32 ms-2"
                                                                    variant="primary"
                                                                >
                                                                    Search
                                                                </x-base.button>
                                                            </div>
                                                        </div>
                                                    </x-base.popover.panel>
                                                </x-base.popover>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <x-base.popover
                                                        class="inline-block"
                                                        placement="bottom-start"
                                                    >
                                                        <x-base.popover.button
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            منوی فیلتر
                                                            <x-base.lucide
                                                                class="w-4 h-4 ms-2"
                                                                icon="ChevronDown"
                                                            />
                                                        </x-base.popover.button>
                                                        <x-base.popover.panel>
                                                            <div class="p-2">
                                                                <div>
                                                                    <div class="text-xs text-start">From</div>
                                                                    <x-base.form-input
                                                                        class="flex-1 mt-2"
                                                                        type="text"
                                                                        placeholder="example@gmail.com"
                                                                    />
                                                                </div>
                                                                <div class="mt-3">
                                                                    <div class="text-xs text-start">To</div>
                                                                    <x-base.form-input
                                                                        class="flex-1 mt-2"
                                                                        type="text"
                                                                        placeholder="example@gmail.com"
                                                                    />
                                                                </div>
                                                                <div class="flex items-center mt-3">
                                                                    <x-base.button
                                                                        class="w-32 ms-auto"
                                                                        data-dismiss="dropdown"
                                                                        variant="secondary"
                                                                    >
                                                                        Close
                                                                    </x-base.button>
                                                                    <x-base.button
                                                                        class="w-32 ms-2"
                                                                        variant="primary"
                                                                    >
                                                                        Search
                                                                    </x-base.button>
                                                                </div>
                                                            </div>
                                                        </x-base.popover.panel>
                                                    </x-base.popover>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    منوهای با دکمه بستن تعامل بهتری را ارائه می‌دهند
                                    که به کاربران اجازه می‌دهند به راحتی منو را از بین ببرند
                                    هنگامی که دیگر لازم نیست. ظاهر و رفتار دکمه بستن را به نیازهای خود سفارشی سازی کنید
                                    ظاهر و رفتار دکمه بستن را به سبک و نیازهای برنامه‌ی شما تنظیم کنید.
                                    ایجاد کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منوی مرتبط
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای مرتبط زمانی که یک لیست طولانی دارید مفید هستند
                                    برای نمایش در یک منوی کشویی. با محدود کردن
                                    ارتفاع منو و فعال کردن اسکرولینگ، شما می‌توانید
                                    یک رابط کاربری کمتر و کاربرپسندتر ارائه دهید.
                                    این بخش به چگونگی ایجاد منوهای مرتبط با استفاده از مؤلفه `Menu` پرداخته می‌شود.
                                    استفاده از مؤلفه Menu.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex justify-center">
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40 h-32 overflow-y-auto">
                                                        <x-base.menu.item>ژانویه</x-base.menu.item>
                                                        <x-base.menu.item>فوریه</x-base.menu.item>
                                                        <x-base.menu.item>مارس</x-base.menu.item>
                                                        <x-base.menu.item>June</x-base.menu.item>
                                                        <x-base.menu.item>July</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40 h-32 overflow-y-auto">
                                                        <x-base.menu.item>ژانویه</x-base.menu.item>
                                                        <x-base.menu.item>فوریه</x-base.menu.item>
                                                        <x-base.menu.item>مارس</x-base.menu.item>
                                                        <x-base.menu.item>June</x-base.menu.item>
                                                        <x-base.menu.item>July</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    منوهای مرتبط یک راه حل عملی هستند زمانی که با مواجهه
                                    با لیست‌های طولانی از گزینه‌ها در یک فضای محدود. با
                                    فعال کردن اسکرولینگ، شما می‌توانید منو را کم حجم نگه دارید
                                    و کاربرپسند. ظاهر و رفتار اسکرولبار و منو را سفارشی سازی کنید
                                    با سبک و نیازهای برنامه‌ی شما هماهنگ کنید.
                                    سبک و نیازهای برنامه.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    منوی سربرگ و آیکون
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    منوهای سربرگ و آیکون یک راه عالی برای دسته بندی هستند
                                    و بهبود بصری منوهای کشویی شما هستند. این بخش
                                    به چگونگی ایجاد منوهای با سربرگ و آیکون پرداخته می‌شود
                                    استفاده از مؤلفه Menu.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex justify-center">
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.header>ابزارهای صادرات</x-base.menu.header>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Printer"
                                                            />
                                                            چاپ
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="ExternalLink"
                                                            />
                                                            اکسل
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="FileText"
                                                            />
                                                            CSV
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Archive"
                                                            />
                                                            PDF
                                                        </x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.menu>
                                                    <x-base.menu.button
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        نمایش منو
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.header>ابزارهای صادرات</x-base.menu.header>
                                                        <x-base.menu.divider />
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Printer"
                                                            />
                                                            چاپ
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="ExternalLink"
                                                            />
                                                            اکسل
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="FileText"
                                                            />
                                                            CSV
                                                        </x-base.menu.item>
                                                        <x-base.menu.item>
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="Archive"
                                                            />
                                                            PDF
                                                        </x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    منوهای سربرگ و آیکون یک راه واضح و بصری ارائه می‌دهند
                                    برای ارائه موارد منو گروه‌بندی شده. ظاهر و رفتار سربرگ، آیکون‌ها و
                                    موارد منو را سفارشی کنید تا با سبک و نیازهای برنامه‌ی شما هماهنگ شود.
                                    موارد منو را با سبک برنامه‌ی خود هماهنگ کنید
                                    و نیازها.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    قرارگیری منو کشویی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    قرارگیری منو کشویی به شما امکان می‌دهد که کنترل کنید که
                                    منو کشویی در رابطه با المان محرکی که
                                    آن ظاهر می‌شود را کنترل کنید. این بخش به چگونگی مشخص کردن
                                    قرارگیری منو کشویی با استفاده از مؤلفه `Menu` پرداخته می‌شود.
                                    component.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="top-start"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        شروع بالا
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="top"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        Top
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="top-end"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        پایان بالا
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="end-start"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        شروع راست
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="right"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        راست
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="end-end"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        پایان راست
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="bottom-end"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        پایان پایین
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="bottom"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        پایین
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="bottom-start"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        شروع پایین
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="start-start"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        شروع چپ
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="left"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        Left
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                                <x-base.menu
                                                    class="inline-block mb-2 me-1"
                                                    placement="start-end"
                                                >
                                                    <x-base.menu.button
                                                        class="w-32"
                                                        as="x-base.button"
                                                        variant="primary"
                                                    >
                                                        پایان چپ
                                                    </x-base.menu.button>
                                                    <x-base.menu.items class="w-40">
                                                        <x-base.menu.item>منو جدید</x-base.menu.item>
                                                        <x-base.menu.item>حذف منو</x-base.menu.item>
                                                    </x-base.menu.items>
                                                </x-base.menu>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="top-start"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            شروع بالا
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="top"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            Top
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="top-end"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            پایان بالا
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="end-start"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            شروع راست
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="right"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            راست
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="end-end"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            پایان راست
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="bottom-end"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            پایان پایین
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="bottom"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            پایین
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="bottom-start"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            شروع پایین
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="start-start"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            شروع چپ
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="left"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            Left
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                    <x-base.menu
                                                        class="inline-block mb-2 me-1"
                                                        placement="start-end"
                                                    >
                                                        <x-base.menu.button
                                                            class="w-32"
                                                            as="x-base.button"
                                                            variant="primary"
                                                        >
                                                            پایان چپ
                                                        </x-base.menu.button>
                                                        <x-base.menu.items class="w-40">
                                                            <x-base.menu.item>منو جدید</x-base.menu.item>
                                                            <x-base.menu.item>حذف منو</x-base.menu.item>
                                                        </x-base.menu.items>
                                                    </x-base.menu>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    قرارگیری منو کشویی یک جنبه حیاتی از طراحی منو کشویی است.
                                    با کنترل جایی که منو کشویی ظاهر می‌شود، می‌توانید
                                    تضمین کنید که در چیدمان برنامه‌ی شما جا بیافتد
                                    و تجربه‌ی کاربری بی‌سر و صدا ارائه دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div
                            class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Button</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    عنصر HTML یا نوع مؤلفه React برای رندر کردن
                                                    به عنوان دکمه
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Items</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`placement`</x-base.table.td>
                                                <x-base.table.td>
                                                    `top-start`, `top`, `top-end`, `end-start`,
                                                    `right`, `end-end`, `bottom-end`, `bottom`,
                                                    `bottom-start`, `start-start`, `left`, `start-end`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    موقعیت منو کشویی را تعیین می‌کند
                                                    نسبت به عنصر محرکی که مشخص کننده منو کشویی است. از گزینه‌ها انتخاب کنید
                                                    مانند 'بالا'، 'پایین'، 'چپ' یا 'راست' برای
                                                    کنترل جهتی که منو در آن گسترش می‌یابد.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Item</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Divider</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Header</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Menu.Footer</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منوی پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منوی سربرگ و پاورقی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منو آیکون
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منو با دکمه بستن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منوی مرتبط
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    منوی سربرگ و آیکون
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    قرارگیری منو کشویی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
