@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="mt-4 flex flex-col gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    مدیریت فایل
                </div>
                <div class="flex flex-col gap-x-3 gap-y-2 sm:flex-row md:ms-auto">
                    <x-base.button
                        class="group-[.mode--light]:!border-transparent group-[.mode--light]:!bg-white/[0.12] group-[.mode--light]:!text-slate-200"
                        variant="primary"
                    >
                        <x-base.lucide
                            class="me-2 h-4 w-4 stroke-[1.3]"
                            icon="MailPlus"
                        />
                        بارگذاری فایل‌های جدید
                    </x-base.button>
                    <x-base.button
                        class="group-[.mode--light]:!border-transparent group-[.mode--light]:!bg-white/[0.12] group-[.mode--light]:!text-slate-200"
                        variant="primary"
                    >
                        <x-base.lucide
                            class="me-2 h-4 w-4 stroke-[1.3]"
                            icon="Cog"
                        /> File
                        تنظیمات مدیر
                    </x-base.button>
                </div>
            </div>
            <div class="mt-3.5 flex flex-col gap-5 sm:flex-row">
                <div class="relative">
                    <div class="sticky top-[104px]">
                        <div
                            class="box box--stacked grid grid-cols-3 gap-3.5 px-3.5 py-4 before:z-[-1] before:content-[''] sm:w-[102px] sm:grid-cols-1">
                            <x-base.tippy
                                class="active relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="صندوق دریافت"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="AppWindow"
                                />
                                <div
                                    class="absolute end-0 top-0 -me-1.5 -mt-1.5 flex h-[1.2rem] min-w-[1.15rem] items-center justify-center rounded-full bg-white text-xs font-medium">
                                    <div
                                        class="h-full w-full rounded-full border border-pending/20 bg-pending/10 px-2 text-pending">
                                        12+
                                    </div>
                                </div>
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Starred"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="MailCheck"
                                />
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Snoozed"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="KeyRound"
                                />
                                <div
                                    class="absolute end-0 top-0 -me-1.5 -mt-1.5 flex h-[1.2rem] min-w-[1.15rem] items-center justify-center rounded-full bg-white text-xs font-medium">
                                    <div
                                        class="h-full w-full rounded-full border border-pending/20 bg-pending/10 px-2 text-pending">
                                        3
                                    </div>
                                </div>
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Important"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="PackageCheck"
                                />
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Sent"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="ShieldCheck"
                                />
                                <div
                                    class="absolute end-0 top-0 -me-1.5 -mt-1.5 flex h-[1.2rem] min-w-[1.15rem] items-center justify-center rounded-full bg-white text-xs font-medium">
                                    <div
                                        class="h-full w-full rounded-full border border-pending/20 bg-pending/10 px-2 text-pending">
                                        41
                                    </div>
                                </div>
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Drafts"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="Smartphone"
                                />
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="دسته‌بندی‌ها"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="BellDot"
                                />
                                <div
                                    class="absolute end-0 top-0 -me-1.5 -mt-1.5 flex h-[1.2rem] min-w-[1.15rem] items-center justify-center rounded-full bg-white text-xs font-medium">
                                    <div
                                        class="h-full w-full rounded-full border border-pending/20 bg-pending/10 px-2 text-pending">
                                        21
                                    </div>
                                </div>
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="گفتگوها"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="Workflow"
                                />
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="Scheduled"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="Podcast"
                                />
                            </x-base.tippy>
                            <x-base.tippy
                                class="relative flex h-14 place-content-center items-center rounded-lg border border-slate-200/80 py-3 hover:text-primary [&.active]:border-primary/10 [&.active]:bg-primary/[0.04] [&.active]:font-medium [&.active]:text-primary [&.active]:shadow-sm"
                                href=""
                                as="a"
                                content="All Mail"
                                placement="right"
                            >
                                <x-base.lucide
                                    class="h-5 w-5 fill-theme-1/10 stroke-[0.8]"
                                    icon="Trash2"
                                />
                            </x-base.tippy>
                        </div>
                    </div>
                </div>
                <div class="box box--stacked flex w-full flex-col">
                    <div class="mb-1 flex flex-col gap-y-2 p-5 sm:flex-row sm:items-center">
                        <div>
                            <div class="relative">
                                <x-base.lucide
                                    class="absolute inset-y-0 start-0 z-10 my-auto ms-3 h-4 w-4 stroke-[1.3] text-slate-500"
                                    icon="Search"
                                />
                                <x-base.form-input
                                    class="rounded-[0.5rem] ps-9 sm:w-64"
                                    type="text"
                                    placeholder="Search mails..."
                                />
                            </div>
                        </div>
                        <div class="flex flex-col gap-x-3 gap-y-2 sm:ms-auto sm:flex-row">
                            <x-base.menu>
                                <x-base.menu.button
                                    class="w-full sm:w-auto"
                                    as="x-base.button"
                                    variant="outline-secondary"
                                >
                                    <x-base.lucide
                                        class="me-2 h-4 w-4 stroke-[1.3]"
                                        icon="Download"
                                    />
                                    خروجی گرفتن
                                    <x-base.lucide
                                        class="ms-2 h-4 w-4 stroke-[1.3]"
                                        icon="ChevronDown"
                                    />
                                </x-base.menu.button>
                                <x-base.menu.items class="w-40">
                                    <x-base.menu.item>
                                        <x-base.lucide
                                            class="me-2 h-4 w-4"
                                            icon="FileBarChart"
                                        />
                                        PDF
                                    </x-base.menu.item>
                                    <x-base.menu.item>
                                        <x-base.lucide
                                            class="me-2 h-4 w-4"
                                            icon="FileBarChart"
                                        />
                                        CSV
                                    </x-base.menu.item>
                                </x-base.menu.items>
                            </x-base.menu>
                            <x-base.popover class="inline-block">
                                <x-base.popover.button
                                    class="w-full sm:w-auto"
                                    as="x-base.button"
                                    variant="outline-secondary"
                                >
                                    <x-base.lucide
                                        class="me-2 h-4 w-4 stroke-[1.3]"
                                        icon="ArrowDownWideNarrow"
                                    />
                                    فیلتر
                                    <span
                                        class="ms-2 flex h-5 items-center justify-center rounded-full border bg-slate-100 px-1.5 text-xs font-medium"
                                    >
                                        3
                                    </span>
                                </x-base.popover.button>
                                <x-base.popover.panel>
                                    <div class="p-2">
                                        <div>
                                            <div class="text-start text-slate-500">
                                                آپلودر
                                            </div>
                                            <x-base.tom-select
                                                class="mt-2 flex-1"
                                                data-placeholder="Search user"
                                            >
                                                @foreach ($users as $fakerKey => $faker)
                                                    <option value="{{ $fakerKey }}">
                                                        {{ $faker['name'] }}
                                                    </option>
                                                @endforeach
                                            </x-base.tom-select>
                                        </div>
                                        <div class="mt-3">
                                            <div class="text-start text-slate-500">
                                                نوع فایل
                                            </div>
                                            <x-base.form-select class="mt-2 flex-1">
                                                <option value="سند">سند</option>
                                                <option value="موسیقی">موسیقی</option>
                                                <option value="ویدئو">ویدئو</option>
                                            </x-base.form-select>
                                        </div>
                                        <div class="mt-4 flex items-center">
                                            <x-base.button
                                                class="ms-auto w-32"
                                                variant="secondary"
                                            >
                                                Close
                                            </x-base.button>
                                            <x-base.button
                                                class="ms-2 w-32"
                                                variant="primary"
                                            >
                                                اعمال
                                            </x-base.button>
                                        </div>
                                    </div>
                                </x-base.popover.panel>
                            </x-base.popover>
                        </div>
                    </div>
                    <div class="flex flex-col gap-6 px-5">
                        <div>
                            <div
                                class="relative mb-5 mt-1 h-4 text-xs uppercase text-slate-500/60 before:absolute before:inset-y-0 before:my-auto before:h-px before:w-full before:bg-slate-200/70 before:content-['']">
                                <span class="absolute ms-4 flex items-center bg-white px-2.5">
                                    <x-base.lucide
                                        class="me-1.5 h-[15px] w-[15px] stroke-slate-400/70 stroke-[1.7]"
                                        icon="Clock"
                                    />
                                    فایل‌های به‌روز شده اخیر
                                </span>
                            </div>
                            <div class="grid grid-cols-12 gap-3 sm:gap-3.5">
                                @foreach ($files->take(6) as $fakerKey => $faker)
                                    <div class="col-span-6 sm:col-span-4 md:col-span-3 xl:col-span-2">
                                        <div
                                            class="relative cursor-pointer rounded-[0.6rem] border border-slate-200/80 px-3 pb-5 pt-8 shadow-sm transition hover:bg-slate-50 sm:px-5">
                                            <div class="absolute start-0 top-0 ms-3 mt-3">
                                                <x-base.form-check.input
                                                    class="border"
                                                    type="checkbox"
                                                    checked="{{ mt_rand(0, 1) ? true : false }}"
                                                />
                                            </div>

                                            @if ($faker['type'] == 'Empty Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="empty-directory"
                                                />
                                            @elseif ($faker['type'] == 'Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="directory"
                                                />
                                            @elseif ($faker['type'] == 'Image')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    src="{{ Vite::asset(strtolower($faker['fileName'])) }}"
                                                    variant="image"
                                                />
                                            @else
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4 text-xs"
                                                    type="{{ $faker['type'] }}"
                                                    variant="file"
                                                />
                                            @endif
                                            <a
                                                class="mt-4 block truncate text-center font-medium capitalize"
                                                href=""
                                            >
                                                {{ explode('/', $faker['fileName'])[count(explode('/', $faker['fileName'])) - 1] }}
                                            </a>
                                            <div class="mt-1 text-center text-xs text-slate-500">
                                                {{ $faker['size'] }}
                                            </div>
                                            <x-base.menu class="absolute end-0 top-0 ms-auto me-2 mt-3">
                                                <x-base.menu.button
                                                    class="block h-5 w-5"
                                                    href="#"
                                                    as="a"
                                                >
                                                    <x-base.lucide
                                                        class="h-5 w-5 fill-slate-400/70 stroke-slate-400/70 stroke-[1]"
                                                        icon="MoreVertical"
                                                    />
                                                </x-base.menu.button>
                                                <x-base.menu.items class="w-40">
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Users"
                                                        />
                                                        اشتراک‌گذاری فایل
                                                    </x-base.menu.item>
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Trash"
                                                        />
                                                        حذف
                                                    </x-base.menu.item>
                                                </x-base.menu.items>
                                            </x-base.menu>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div>
                            <div
                                class="relative mb-5 mt-1 h-4 text-xs uppercase text-slate-500/60 before:absolute before:inset-y-0 before:my-auto before:h-px before:w-full before:bg-slate-200/70 before:content-['']">
                                <span class="absolute ms-4 flex items-center bg-white px-2.5">
                                    <x-base.lucide
                                        class="me-1.5 h-[15px] w-[15px] stroke-slate-400/70 stroke-[1.7]"
                                        icon="Pin"
                                    />
                                    فایل‌های سنجاق شده
                                </span>
                            </div>
                            <div class="grid grid-cols-12 gap-3 sm:gap-3.5">
                                @foreach ($files->take(3) as $fakerKey => $faker)
                                    <div class="col-span-6 sm:col-span-4 md:col-span-3 xl:col-span-2">
                                        <div
                                            class="relative cursor-pointer rounded-[0.6rem] border border-slate-200/80 px-3 pb-5 pt-8 shadow-sm transition hover:bg-slate-50 sm:px-5">
                                            <div class="absolute start-0 top-0 ms-3 mt-3">
                                                <x-base.form-check.input
                                                    class="border"
                                                    type="checkbox"
                                                    checked="{{ mt_rand(0, 1) ? true : false }}"
                                                />
                                            </div>

                                            @if ($faker['type'] == 'Empty Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="empty-directory"
                                                />
                                            @elseif ($faker['type'] == 'Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="directory"
                                                />
                                            @elseif ($faker['type'] == 'Image')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    src="{{ Vite::asset(strtolower($faker['fileName'])) }}"
                                                    variant="image"
                                                />
                                            @else
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4 text-xs"
                                                    type="{{ $faker['type'] }}"
                                                    variant="file"
                                                />
                                            @endif
                                            <a
                                                class="mt-4 block truncate text-center font-medium capitalize"
                                                href=""
                                            >
                                                {{ explode('/', $faker['fileName'])[count(explode('/', $faker['fileName'])) - 1] }}
                                            </a>
                                            <div class="mt-1 text-center text-xs text-slate-500">
                                                {{ $faker['size'] }}
                                            </div>
                                            <x-base.menu class="absolute end-0 top-0 ms-auto me-2 mt-3">
                                                <x-base.menu.button
                                                    class="block h-5 w-5"
                                                    href="#"
                                                    as="a"
                                                >
                                                    <x-base.lucide
                                                        class="h-5 w-5 fill-slate-400/70 stroke-slate-400/70 stroke-[1]"
                                                        icon="MoreVertical"
                                                    />
                                                </x-base.menu.button>
                                                <x-base.menu.items class="w-40">
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Users"
                                                        />
                                                        اشتراک‌گذاری فایل
                                                    </x-base.menu.item>
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Trash"
                                                        />
                                                        حذف
                                                    </x-base.menu.item>
                                                </x-base.menu.items>
                                            </x-base.menu>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div>
                            <div
                                class="relative mb-5 mt-1 h-4 text-xs uppercase text-slate-500/60 before:absolute before:inset-y-0 before:my-auto before:h-px before:w-full before:bg-slate-200/70 before:content-['']">
                                <span class="absolute ms-4 flex items-center bg-white px-2.5">
                                    <x-base.lucide
                                        class="me-1.5 h-[15px] w-[15px] stroke-slate-400/70 stroke-[1.7]"
                                        icon="Trash2"
                                    />
                                    فایل‌های حذف شده
                                </span>
                            </div>
                            <div class="grid grid-cols-12 gap-3 sm:gap-3.5">
                                @foreach ($files->take(10) as $fakerKey => $faker)
                                    <div class="col-span-6 sm:col-span-4 md:col-span-3 xl:col-span-2">
                                        <div
                                            class="relative cursor-pointer rounded-[0.6rem] border border-slate-200/80 px-3 pb-5 pt-8 shadow-sm transition hover:bg-slate-50 sm:px-5">
                                            <div class="absolute start-0 top-0 ms-3 mt-3">
                                                <x-base.form-check.input
                                                    class="border"
                                                    type="checkbox"
                                                    checked="{{ mt_rand(0, 1) ? true : false }}"
                                                />
                                            </div>

                                            @if ($faker['type'] == 'Empty Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="empty-directory"
                                                />
                                            @elseif ($faker['type'] == 'Folder')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    variant="directory"
                                                />
                                            @elseif ($faker['type'] == 'Image')
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4"
                                                    src="{{ Vite::asset(strtolower($faker['fileName'])) }}"
                                                    variant="image"
                                                />
                                            @else
                                                <x-base.file-icon
                                                    class="mx-auto w-2/4 text-xs"
                                                    type="{{ $faker['type'] }}"
                                                    variant="file"
                                                />
                                            @endif
                                            <a
                                                class="mt-4 block truncate text-center font-medium capitalize"
                                                href=""
                                            >
                                                {{ explode('/', $faker['fileName'])[count(explode('/', $faker['fileName'])) - 1] }}
                                            </a>
                                            <div class="mt-1 text-center text-xs text-slate-500">
                                                {{ $faker['size'] }}
                                            </div>
                                            <x-base.menu class="absolute end-0 top-0 ms-auto me-2 mt-3">
                                                <x-base.menu.button
                                                    class="block h-5 w-5"
                                                    href="#"
                                                    as="a"
                                                >
                                                    <x-base.lucide
                                                        class="h-5 w-5 fill-slate-400/70 stroke-slate-400/70 stroke-[1]"
                                                        icon="MoreVertical"
                                                    />
                                                </x-base.menu.button>
                                                <x-base.menu.items class="w-40">
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Users"
                                                        />
                                                        اشتراک‌گذاری فایل
                                                    </x-base.menu.item>
                                                    <x-base.menu.item>
                                                        <x-base.lucide
                                                            class="me-2 h-4 w-4"
                                                            icon="Trash"
                                                        />
                                                        حذف
                                                    </x-base.menu.item>
                                                </x-base.menu.items>
                                            </x-base.menu>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div
                        class="my-1 flex flex-col items-center p-5 text-center text-slate-500/80 sm:flex-row sm:text-start">
                        <div>4.41 گیگابایت (25%) از 17 گیگابایت استفاده شده</div>
                        <div class="mt-2 sm:ms-auto sm:mt-0">
                            آخرین فعالیت حساب: 36 دقیقه پیش
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
