@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    Dropzone
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت مؤثر ماژول Dropzone ما را برای آپلود آسان و انعطاف‌پذیر
                    فایل در برنامه‌های وبی خود کشف کنید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    آپلود تک فایل
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "Dropzone" راه آسانی را برای
                                    پیاده‌سازی قابلیت آپلود فایل در وب
                                    برنامه‌ی خود فراهم می‌کند. این مثال نشان می‌دهد چگونه یک
                                    "Dropzone" برای آپلود تک فایل، با گزینه‌هایی برای
                                    تنظیم محدودیت‌های آپلود فایل و سربرگ‌های اضافی.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.dropzone
                                                class="dropzone"
                                                data-single="true"
                                                action="/file-upload"
                                            >
                                                <div class="text-lg font-medium">
                                                    Drop files here or click to upload.
                                                </div>
                                                <div class="text-gray-600">
                                                    این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                    <span class="font-medium">not</span> actually
                                                    uploaded.
                                                </div>
                                            </x-base.dropzone>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.dropzone
                                                    class="dropzone"
                                                    data-single="true"
                                                    action="/file-upload"
                                                >
                                                    <div class="text-lg font-medium">
                                                        Drop files here or click to upload.
                                                    </div>
                                                    <div class="text-gray-600">
                                                        این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                        <span class="font-medium">not</span> actually
                                                        uploaded.
                                                    </div>
                                                </x-base.dropzone>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "Dropzone" پیاده‌سازی آپلود تک فایل را در برنامه‌های وب شما ساده‌تر می‌کند. شما می‌توانید گزینه‌های مختلفی مانند آدرس URL آپلود،
                                    حداکثر اندازه فایل و سربرگ‌ها را پیکربندی کنید تا نیازهای خاص خود را برآورده کنید. در این مثال، یک "Dropzone" برای آپلود تک فایل ایجاد شده است، با رابط کاربری اطلاعاتی.
                                    با این حال، مهم است به یاد داشته باشید که فایل‌های انتخاب شده در این نمونه واقعی آپلود نمی‌شوند.
                                    مؤلفه "Dropzone" را برای فعال کردن آپلود فایل واقعی و بهبود قابلیت‌های پردازش فایل برنامه‌ی وب خود سفارشی کنید.
                                    آپلود تک فایل
                                    ایجاد شده است، با یک رابط کاربری اطلاعاتی.
                                    اما، مهم است به یاد داشته باشید که فایل‌های انتخاب شده
                                    در واقع در این نمونه به سرور آپلود نمی‌شوند.
                                    مؤلفه "Dropzone" را به عنوان نیاز برای فعال کردن
                                    آپلود فایل واقعی و بهبود پردازش فایل
                                    قابلیت‌های برنامه‌ی وب خود سفارشی کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    Multiple بارگذاری فایل
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "Dropzone" راه آسانی را برای
                                    پیاده‌سازی قابلیت آپلود فایل در وب
                                    برنامه‌ی خود فراهم می‌کند. این مثال نشان می‌دهد چگونه یک
                                    "Dropzone" برای آپلود چند فایل، با گزینه‌هایی برای
                                    تنظیم محدودیت‌های آپلود فایل و سربرگ‌های اضافی.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.dropzone
                                                class="dropzone"
                                                data-single="true"
                                                action="/file-upload"
                                            >
                                                <div class="text-lg font-medium">
                                                    Drop files here or click to upload.
                                                </div>
                                                <div class="text-gray-600">
                                                    این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                    <span class="font-medium">not</span> actually
                                                    uploaded.
                                                </div>
                                            </x-base.dropzone>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.dropzone
                                                    class="dropzone"
                                                    data-single="true"
                                                    action="/file-upload"
                                                >
                                                    <div class="text-lg font-medium">
                                                        Drop files here or click to upload.
                                                    </div>
                                                    <div class="text-gray-600">
                                                        این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                        <span class="font-medium">not</span> actually
                                                        uploaded.
                                                    </div>
                                                </x-base.dropzone>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مؤلفه "Dropzone" پیاده‌سازی آپلود تک فایل را در برنامه‌های وب شما ساده‌تر می‌کند. شما می‌توانید گزینه‌های مختلفی مانند آدرس URL آپلود،
                                    آپلود چند فایل در برنامه‌های وب شما. شما می‌توانید گزینه‌های مختلفی مانند آدرس URL آپلود،
                                    حداکثر اندازه فایل و سربرگ‌ها را پیکربندی کنید تا نیازهای خاص خود را برآورده کنید. در این مثال، یک "Dropzone" برای آپلود چند فایل
                                    مؤلفه "Dropzone" را برای فعال کردن آپلود فایل واقعی و بهبود قابلیت‌های پردازش فایل برنامه‌ی وب خود سفارشی کنید.
                                    ایجاد شده است.
                                    ایجاد شده است، با یک رابط کاربری اطلاعاتی.
                                    اما، مهم است به یاد داشته باشید که فایل‌های انتخاب شده
                                    در واقع در این نمونه به سرور آپلود نمی‌شوند.
                                    مؤلفه "Dropzone" را به عنوان نیاز برای فعال کردن
                                    آپلود فایل واقعی و بهبود پردازش فایل
                                    قابلیت‌های برنامه‌ی وب خود سفارشی کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>

                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نوع فایل اعتبارسنجی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "Dropzone" به شما امکان پیاده‌سازی عملکرد آپلود فایل را در برنامه‌ی وب خود با امکان
                                    اعتبارسنجی نوع فایل قبل از آپلود فایل می‌دهد. این مثال نشان می‌دهد که چگونه یک "Dropzone" با
                                    اعتبارسنجی نوع فایل با استفاده از فرمت‌های فایل پذیرفته شده ایجاد شود.
                                    مؤلفه "Dropzone" با اعتبارسنجی نوع فایل
                                    قابلیت‌های آپلود فایل برنامه‌ی وب شما را با امکان
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.dropzone
                                                class="dropzone"
                                                data-single="true"
                                                action="/file-upload"
                                            >
                                                <div class="text-lg font-medium">
                                                    Drop files here or click to upload.
                                                </div>
                                                <div class="text-gray-600">
                                                    این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                    <span class="font-medium">not</span> actually
                                                    uploaded.
                                                </div>
                                            </x-base.dropzone>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.dropzone
                                                    class="dropzone"
                                                    data-single="true"
                                                    action="/file-upload"
                                                >
                                                    <div class="text-lg font-medium">
                                                        Drop files here or click to upload.
                                                    </div>
                                                    <div class="text-gray-600">
                                                        این فقط یک Dropzone نمونه است. فایل‌های انتخاب شده
                                                        <span class="font-medium">not</span> actually
                                                        uploaded.
                                                    </div>
                                                </x-base.dropzone>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مشخص کردن فرمت‌های فایل پذیرفته شده بهبود می‌بخشد. در این مثال، یک "Dropzone" با
                                    قواعد اعتبارسنجی برای فرمت‌های فایل تصویر (JPEG، PNG، و JPG) ایجاد شده است.
                                    کاربران فقط محدود به آپلود فقط فرمت‌های فایل مشخص شده هستند. مؤلفه "Dropzone" را و اعتبارسنجی فرمت فایل به عنوان نیازها برای اطمینان از
                                    آپلود امن و کنترل‌شده فایل در برنامه‌ی خود سفارشی کنید.
                                    قوانین اعتبارسنجی برای فرمت‌های فایل تصویر (JPEG، PNG و
                                    JPG). کاربران محدود به آپلود فقط انواع فایل مشخص شده خواهند بود.
                                    اجزای مؤلفه "Dropzone" را و اعتبارسنجی فرمت فایل را به عنوان نیازها برای اطمینان از آپلود فایل امن و کنترل‌شده در برنامه‌ی شما سفارشی کنید.


                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dropzone</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`DropzoneOptions`</x-base.table.td>
                                                <x-base.table.td>گزینه‌های پیکربندی "Dropzone".</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: DropzoneElement) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    تابعی که مرجعی به عنصر "Dropzone" را دریافت می‌کند.
                                                    element.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    آپلود تک فایل
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    آپلود چند فایل
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نوع فایل اعتبارسنجی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
