@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    Icon
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت مؤلفه آیکون ما را به‌کار گیرید تا یک لمس بصری را اضافه کنید
                    و معنایی به محتوای وب خود بدهید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    آیکون Lucide
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    آیکون‌ها نمادهای گرافیکی هستند که برای نمایش اشیاء،
                                    عملیات یا مفاهیم به صورت بصری استفاده می‌شوند. آن‌ها به طور معمول
                                    در توسعه وب برای بهبود رابط کاربری استفاده می‌شوند
                                    و یک تجربه بصری جذاب‌تر و بیشتر
                                    تجربه ارائه دهند. این بخش درباره نحوه استفاده از آیکون‌ها در
                                    برنامه‌های وب شما پوشش داده شده است و نمونه‌هایی از چگونگی
                                    ادغام و استایل آن‌ها به‌طور موثر ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="grid grid-cols-12 gap-y-6 py-3 sm:gap-7">
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Activity"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ActivityIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Airplay"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AirplayIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlertCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlertCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlertOctagon"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlertOctagonIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlertTriangle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlertTriangleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlignCenter"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlignCenterIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlignJustify"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlignJustifyIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlignLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlignLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AlignRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AlignRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Anchor"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AnchorIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Aperture"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ApertureIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Archive"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArchiveIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowDownCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowDownCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowDownLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowDownLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowDownRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowDownRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowLeftCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowLeftCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowRightCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowRightCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowUpCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowUpCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowUpLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowUpLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowUpRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowUpRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ArrowUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ArrowUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="AtSign"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AtSignIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Award"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        AwardIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="BarChart2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BarChart2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="BarChart"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BarChartIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="BatteryCharging"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BatteryChargingIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Battery"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BatteryIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="BellOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BellOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Bell"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BellIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Bluetooth"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BluetoothIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Bold"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BoldIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="BookOpen"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BookOpenIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Book"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BookIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Bookmark"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BookmarkIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Box"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BoxIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Briefcase"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        BriefcaseIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Calendar"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CalendarIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CameraOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CameraOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Camera"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CameraIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Cast"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CastIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CheckCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CheckCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CheckSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CheckSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Check"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CheckIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronsDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronsDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronsLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronsLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronsRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronsRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ChevronsUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChevronsUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Chrome"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ChromeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Circle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Clipboard"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ClipboardIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Clock"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ClockIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CloudDrizzle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudDrizzleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CloudLightning"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudLightningIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CloudOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CloudRain"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudRainIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CloudSnow"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudSnowIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Cloud"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CloudIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Code"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CodeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Codepen"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CodepenIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Codesandbox"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CodesandboxIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Coffee"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CoffeeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Columns"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ColumnsIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Command"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CommandIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Compass"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CompassIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Copy"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CopyIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerDownLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerDownLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerDownRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerDownRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerLeftDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerLeftDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerLeftUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerLeftUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerRightDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerRightDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerRightUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerRightUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerUpLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerUpLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CornerUpRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CornerUpRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Cpu"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CpuIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="CreditCard"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CreditCardIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Crop"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CropIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Crosshair"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        CrosshairIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Database"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DatabaseIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Delete"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DeleteIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Disc"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DiscIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="DivideCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DivideCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="DivideSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DivideSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Divide"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DivideIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="DollarSign"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DollarSignIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="DownloadCloud"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DownloadCloudIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Download"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DownloadIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Dribbble"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DribbbleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Droplet"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        DropletIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ExternalLink"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ExternalLinkIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="EyeOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        EyeOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Eye"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        EyeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Facebook"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FacebookIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FastForward"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FastForwardIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Figma"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FigmaIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FileMinus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FileMinusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FilePlus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FilePlusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FileText"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FileTextIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="File"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FileIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Film"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FilmIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Filter"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FilterIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Flag"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FlagIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FolderMinus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FolderMinusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="FolderPlus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FolderPlusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Folder"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FolderIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Framer"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FramerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Frown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        FrownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Gift"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GiftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="GitBranch"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GitBranchIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="GitCommit"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GitCommitIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="GitMerge"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GitMergeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="GitPullRequest"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GitPullRequestIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Github"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GithubIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Gitlab"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GitlabIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Globe"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GlobeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="LayoutGrid"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        GridIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="HardDrive"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HardDriveIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Hash"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HashIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Headphones"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HeadphonesIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Heart"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HeartIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="HelpCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HelpCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Hexagon"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HexagonIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Home"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        HomeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Image"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ImageIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Inbox"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        InboxIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Info"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        InfoIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Instagram"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        InstagramIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Italic"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ItalicIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Key"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        KeyIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Layers"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LayersIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Layout"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LayoutIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="LifeBuoy"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LifeBuoyIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Link2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Link2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Link"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LinkIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Linkedin"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LinkedinIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="List"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ListIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Loader"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LoaderIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Lock"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LockIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="LogIn"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LogInIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="LogOut"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        LogOutIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Mail"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MailIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MapPin"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MapPinIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Map"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MapIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Maximize2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Maximize2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Maximize"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MaximizeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Meh"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MehIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Menu"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MenuIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MessageCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MessageCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MessageSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MessageSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MicOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MicOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Mic"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MicIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Minimize2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Minimize2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Minimize"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MinimizeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MinusCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MinusCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MinusSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MinusSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Minus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MinusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Monitor"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MonitorIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Moon"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MoonIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MoreHorizontal"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MoreHorizontalIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MoreVertical"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MoreVerticalIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="MousePointer"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MousePointerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Move"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MoveIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Music"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        MusicIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Navigation2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Navigation2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Navigation"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        NavigationIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Octagon"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        OctagonIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Package"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PackageIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Paperclip"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PaperclipIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PauseCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PauseCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Pause"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PauseIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PenTool"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PenToolIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Percent"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PercentIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneCall"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneCallIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneForwarded"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneForwardedIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneIncoming"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneIncomingIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneMissed"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneMissedIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PhoneOutgoing"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneOutgoingIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Phone"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PhoneIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PieChart"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PieChartIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PlayCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PlayCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Play"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PlayIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PlusCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PlusCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="PlusSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PlusSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Plus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PlusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Pocket"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PocketIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Power"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PowerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Printer"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        PrinterIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Radio"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RadioIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="RefreshCcw"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RefreshCcwIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="RefreshCw"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RefreshCwIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Repeat"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RepeatIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Rewind"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RewindIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="RotateCcw"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RotateCcwIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="RotateCw"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RotateCwIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Rss"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        RssIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Save"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SaveIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Scissors"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ScissorsIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Search"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SearchIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Send"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SendIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Server"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ServerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Settings"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SettingsIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Share2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Share2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Share"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ShieldOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShieldOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Shield"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShieldIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ShoppingBag"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShoppingBagIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ShoppingCart"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShoppingCartIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Shuffle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ShuffleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="SkipBack"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SkipBackIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="SkipForward"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SkipForwardIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Slack"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SlackIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Sliders"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SlidersIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Smartphone"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SmartphoneIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Smile"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SmileIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Speaker"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SpeakerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Square"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Star"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        StarIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="StopCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        StopCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Sun"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SunIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Sunrise"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SunriseIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Sunset"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        SunsetIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Tablet"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TabletIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Tag"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TagIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Target"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TargetIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Terminal"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TerminalIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Thermometer"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ThermometerIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ThumbsDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ThumbsDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ThumbsUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ThumbsUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ToggleLeft"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ToggleLeftIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ToggleRight"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ToggleRightIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Trash2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Trash2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Trash"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TrashIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Trello"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TrelloIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="TrendingDown"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TrendingDownIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="TrendingUp"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TrendingUpIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Triangle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TriangleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Truck"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TruckIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Tv"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TvIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Twitch"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TwitchIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Twitter"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TwitterIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Type"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        TypeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Umbrella"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UmbrellaIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Underline"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UnderlineIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Unlock"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UnlockIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="UploadCloud"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UploadCloudIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Upload"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UploadIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="UserCheck"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UserCheckIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="UserMinus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UserMinusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="UserPlus"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UserPlusIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="UserX"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UserXIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="User"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UserIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Users"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        UsersIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="VideoOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        VideoOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Video"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        VideoIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Voicemail"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        VoicemailIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Volume1"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Volume1Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Volume2"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        Volume2Icon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="VolumeX"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        VolumeXIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Volume"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        VolumeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Watch"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        WatchIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="WifiOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        WifiOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Wifi"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        WifiIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Wind"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        WindIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="XCircle"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        XCircleIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="XOctagon"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        XOctagonIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="XSquare"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        XSquareIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="X"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        XIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Youtube"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        YoutubeIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ZapOff"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ZapOffIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="Zap"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ZapIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ZoomIn"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ZoomInIcon
                                                    </div>
                                                </div>
                                                <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                    <x-base.lucide
                                                        class="mx-auto block"
                                                        icon="ZoomOut"
                                                    />
                                                    <div class="mt-2 text-center text-xs">
                                                        ZoomOutIcon
                                                    </div>
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="grid grid-cols-12 gap-y-6 py-3 sm:gap-7">
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Activity"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ActivityIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Airplay"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AirplayIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlertCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlertCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlertOctagon"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlertOctagonIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlertTriangle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlertTriangleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlignCenter"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlignCenterIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlignJustify"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlignJustifyIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlignLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlignLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AlignRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AlignRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Anchor"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AnchorIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Aperture"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ApertureIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Archive"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArchiveIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowDownCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowDownCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowDownLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowDownLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowDownRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowDownRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowLeftCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowLeftCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowRightCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowRightCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowUpCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowUpCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowUpLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowUpLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowUpRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowUpRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ArrowUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ArrowUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="AtSign"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AtSignIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Award"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            AwardIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="BarChart2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BarChart2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="BarChart"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BarChartIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="BatteryCharging"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BatteryChargingIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Battery"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BatteryIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="BellOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BellOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Bell"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BellIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Bluetooth"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BluetoothIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Bold"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BoldIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="BookOpen"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BookOpenIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Book"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BookIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Bookmark"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BookmarkIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Box"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BoxIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Briefcase"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            BriefcaseIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Calendar"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CalendarIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CameraOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CameraOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Camera"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CameraIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Cast"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CastIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CheckCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CheckCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CheckSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CheckSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Check"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CheckIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronsDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronsDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronsLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronsLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronsRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronsRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ChevronsUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChevronsUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Chrome"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ChromeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Circle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Clipboard"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ClipboardIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Clock"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ClockIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CloudDrizzle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudDrizzleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CloudLightning"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudLightningIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CloudOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CloudRain"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudRainIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CloudSnow"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudSnowIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Cloud"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CloudIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Code"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CodeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Codepen"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CodepenIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Codesandbox"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CodesandboxIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Coffee"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CoffeeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Columns"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ColumnsIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Command"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CommandIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Compass"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CompassIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Copy"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CopyIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerDownLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerDownLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerDownRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerDownRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerLeftDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerLeftDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerLeftUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerLeftUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerRightDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerRightDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerRightUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerRightUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerUpLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerUpLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CornerUpRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CornerUpRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Cpu"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CpuIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="CreditCard"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CreditCardIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Crop"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CropIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Crosshair"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            CrosshairIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Database"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DatabaseIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Delete"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DeleteIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Disc"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DiscIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="DivideCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DivideCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="DivideSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DivideSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Divide"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DivideIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="DollarSign"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DollarSignIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="DownloadCloud"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DownloadCloudIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Download"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DownloadIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Dribbble"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DribbbleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Droplet"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            DropletIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ExternalLink"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ExternalLinkIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="EyeOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            EyeOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Eye"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            EyeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Facebook"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FacebookIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FastForward"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FastForwardIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Figma"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FigmaIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FileMinus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FileMinusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FilePlus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FilePlusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FileText"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FileTextIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="File"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FileIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Film"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FilmIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Filter"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FilterIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Flag"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FlagIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FolderMinus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FolderMinusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="FolderPlus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FolderPlusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Folder"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FolderIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Framer"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FramerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Frown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            FrownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Gift"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GiftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="GitBranch"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GitBranchIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="GitCommit"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GitCommitIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="GitMerge"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GitMergeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="GitPullRequest"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GitPullRequestIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Github"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GithubIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Gitlab"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GitlabIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Globe"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GlobeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="LayoutGrid"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            GridIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="HardDrive"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HardDriveIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Hash"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HashIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Headphones"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HeadphonesIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Heart"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HeartIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="HelpCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HelpCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Hexagon"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HexagonIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Home"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            HomeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Image"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ImageIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Inbox"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            InboxIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Info"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            InfoIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Instagram"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            InstagramIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Italic"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ItalicIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Key"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            KeyIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Layers"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LayersIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Layout"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LayoutIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="LifeBuoy"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LifeBuoyIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Link2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Link2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Link"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LinkIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Linkedin"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LinkedinIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="List"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ListIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Loader"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LoaderIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Lock"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LockIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="LogIn"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LogInIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="LogOut"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            LogOutIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Mail"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MailIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MapPin"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MapPinIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Map"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MapIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Maximize2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Maximize2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Maximize"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MaximizeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Meh"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MehIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Menu"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MenuIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MessageCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MessageCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MessageSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MessageSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MicOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MicOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Mic"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MicIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Minimize2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Minimize2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Minimize"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MinimizeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MinusCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MinusCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MinusSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MinusSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Minus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MinusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Monitor"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MonitorIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Moon"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MoonIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MoreHorizontal"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MoreHorizontalIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MoreVertical"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MoreVerticalIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="MousePointer"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MousePointerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Move"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MoveIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Music"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            MusicIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Navigation2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Navigation2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Navigation"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            NavigationIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Octagon"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            OctagonIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Package"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PackageIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Paperclip"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PaperclipIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PauseCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PauseCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Pause"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PauseIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PenTool"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PenToolIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Percent"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PercentIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneCall"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneCallIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneForwarded"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneForwardedIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneIncoming"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneIncomingIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneMissed"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneMissedIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PhoneOutgoing"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneOutgoingIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Phone"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PhoneIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PieChart"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PieChartIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PlayCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PlayCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Play"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PlayIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PlusCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PlusCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="PlusSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PlusSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Plus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PlusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Pocket"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PocketIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Power"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PowerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Printer"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            PrinterIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Radio"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RadioIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="RefreshCcw"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RefreshCcwIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="RefreshCw"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RefreshCwIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Repeat"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RepeatIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Rewind"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RewindIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="RotateCcw"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RotateCcwIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="RotateCw"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RotateCwIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Rss"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            RssIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Save"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SaveIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Scissors"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ScissorsIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Search"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SearchIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Send"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SendIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Server"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ServerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Settings"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SettingsIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Share2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Share2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Share"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ShieldOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShieldOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Shield"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShieldIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ShoppingBag"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShoppingBagIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ShoppingCart"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShoppingCartIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Shuffle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ShuffleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="SkipBack"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SkipBackIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="SkipForward"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SkipForwardIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Slack"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SlackIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Sliders"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SlidersIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Smartphone"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SmartphoneIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Smile"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SmileIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Speaker"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SpeakerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Square"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Star"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            StarIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="StopCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            StopCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Sun"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SunIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Sunrise"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SunriseIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Sunset"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            SunsetIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Tablet"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TabletIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Tag"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TagIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Target"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TargetIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Terminal"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TerminalIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Thermometer"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ThermometerIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ThumbsDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ThumbsDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ThumbsUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ThumbsUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ToggleLeft"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ToggleLeftIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ToggleRight"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ToggleRightIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Trash2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Trash2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Trash"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TrashIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Trello"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TrelloIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="TrendingDown"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TrendingDownIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="TrendingUp"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TrendingUpIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Triangle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TriangleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Truck"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TruckIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Tv"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TvIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Twitch"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TwitchIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Twitter"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TwitterIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Type"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            TypeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Umbrella"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UmbrellaIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Underline"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UnderlineIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Unlock"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UnlockIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="UploadCloud"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UploadCloudIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Upload"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UploadIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="UserCheck"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UserCheckIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="UserMinus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UserMinusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="UserPlus"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UserPlusIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="UserX"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UserXIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="User"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UserIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Users"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            UsersIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="VideoOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            VideoOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Video"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            VideoIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Voicemail"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            VoicemailIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Volume1"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Volume1Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Volume2"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            Volume2Icon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="VolumeX"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            VolumeXIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Volume"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            VolumeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Watch"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            WatchIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="WifiOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            WifiOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Wifi"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            WifiIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Wind"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            WindIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="XCircle"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            XCircleIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="XOctagon"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            XOctagonIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="XSquare"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            XSquareIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="X"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            XIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Youtube"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            YoutubeIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ZapOff"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ZapOffIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="Zap"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ZapIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ZoomIn"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ZoomInIcon
                                                        </div>
                                                    </div>
                                                    <div class="col-span-6 sm:col-span-3 lg:col-span-2">
                                                        <x-base.lucide
                                                            class="mx-auto block"
                                                            icon="ZoomOut"
                                                        />
                                                        <div class="mt-2 text-center text-xs">
                                                            ZoomOutIcon
                                                        </div>
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Lucide</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`icon`</x-base.table.td>
                                                <x-base.table.td>`keyof typeof icons`</x-base.table.td>
                                                <x-base.table.td>
                                                    نام آیکون Lucide را که باید نمایش داده شود مشخص می‌کند.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    آیکون Lucide
                                </a>
                            </li>
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
