@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="mt-4 flex flex-col gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    مودال
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    چندگانگی مولفه ماژولار ما را برای باکس‌های نور،
                    اعلان‌های کاربر و ... کشف کنید!
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    ماژول خالی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-21"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-21"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مولفه «ماژول خالی» به شما امکان می‌دهد تا ماژول‌های ساده
                                    و سفارشی‌شده‌ای را ایجاد کنید که می‌تواند برای
                                    نمایش انواع مختلف محتوا یا پیام‌ها به
                                    کاربران شما است. این نوع ماژول به عنوان پایه برای
                                    ایجاد تجربیات ماژول سفارشی کاربرد دارد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#basic-modal-preview"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="basic-modal-preview">
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    این ماژول خالی کاملاً شگفت‌انگیز است!
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#basic-modal-preview"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="basic-modal-preview">
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        این ماژول خالی کاملاً شگفت‌انگیز است!
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مولفه «ماژول خالی» به شما یک نقطه شروع می‌دهد
                                    برای ایجاد ماژول‌ها با محتوای خود و
                                    طراحی می‌دهد که ابزار چندکاره‌ای برای بهبود تجربه کاربر است.
                                    تعاملات درون برنامه وب خود را بهبود بخشید
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اندازه ماژول
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مولفه «اندازه ماژول» به شما امکان می‌دهد تا ماژول‌هایی را ایجاد کنید
                                    که انواع مختلفی از محتوا را جای دهد
                                    یا الزامات طراحی خاص. می‌توانید از
                                    چهار اندازه ماژول مختلف: کوچک، متوسط، بزرگ و
                                    خیلی بزرگ، اطمینان از انعطاف‌پذیری در نمایش شما
                                    content.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Small Modal Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#small-modal-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش ماژول کوچک
                                                </x-base.button>
                                                <!-- END: Small Modal Toggle -->
                                                <!-- BEGIN: Medium Modal Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#medium-modal-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش ماژول متوسط
                                                </x-base.button>
                                                <!-- END: Medium Modal Toggle -->
                                                <!-- BEGIN: Large Modal Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#large-modal-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش ماژول بزرگ
                                                </x-base.button>
                                                <!-- END: Large Modal Toggle -->
                                                <!-- BEGIN: Super Large Modal Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#superlarge-modal-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش ماژول خیلی بزرگ
                                                </x-base.button>
                                                <!-- END: Super Large Modal Toggle -->
                                            </div>
                                            <!-- BEGIN: Small Modal Content -->
                                            <x-base.dialog
                                                id="small-modal-size-preview"
                                                size="sm"
                                            >
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    این ماژول کوچک کاملاً شگفت‌انگیز است!
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Small Modal Content -->
                                            <!-- BEGIN: Medium Modal Content -->
                                            <x-base.dialog id="medium-modal-size-preview">
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    این ماژول متوسط کاملاً شگفت‌انگیز است!
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Medium Modal Content -->
                                            <!-- BEGIN: Large Modal Content -->
                                            <x-base.dialog
                                                id="large-modal-size-preview"
                                                size="lg"
                                            >
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    این ماژول بزرگ کاملاً شگفت‌انگیز است!
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Large Modal Content -->
                                            <!-- BEGIN: Super Large Modal Content -->
                                            <x-base.dialog
                                                id="superlarge-modal-size-preview"
                                                size="xl"
                                            >
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    این کاملاً مدال فوق العاده بزرگ است!
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Super Large Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Small Modal Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#small-modal-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش ماژول کوچک
                                                    </x-base.button>
                                                    <!-- END: Small Modal Toggle -->
                                                    <!-- BEGIN: Medium Modal Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#medium-modal-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش ماژول متوسط
                                                    </x-base.button>
                                                    <!-- END: Medium Modal Toggle -->
                                                    <!-- BEGIN: Large Modal Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#large-modal-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش ماژول بزرگ
                                                    </x-base.button>
                                                    <!-- END: Large Modal Toggle -->
                                                    <!-- BEGIN: Super Large Modal Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#superlarge-modal-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش ماژول خیلی بزرگ
                                                    </x-base.button>
                                                    <!-- END: Super Large Modal Toggle -->
                                                </div>
                                                <!-- BEGIN: Small Modal Content -->
                                                <x-base.dialog
                                                    id="small-modal-size-preview"
                                                    size="sm"
                                                >
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        این ماژول کوچک کاملاً شگفت‌انگیز است!
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Small Modal Content -->
                                                <!-- BEGIN: Medium Modal Content -->
                                                <x-base.dialog id="medium-modal-size-preview">
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        این ماژول متوسط کاملاً شگفت‌انگیز است!
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Medium Modal Content -->
                                                <!-- BEGIN: Large Modal Content -->
                                                <x-base.dialog
                                                    id="large-modal-size-preview"
                                                    size="lg"
                                                >
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        این ماژول بزرگ کاملاً شگفت‌انگیز است!
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Large Modal Content -->
                                                <!-- BEGIN: Super Large Modal Content -->
                                                <x-base.dialog
                                                    id="superlarge-modal-size-preview"
                                                    size="xl"
                                                >
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        این کاملاً مدال فوق العاده بزرگ است!
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Super Large Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "اندازه مدال" قادر می‌سازد تا یک
                                    طراحی سازگار و جذاب از نظر بصری را حفظ کنید در حالی که
                                    انواع مختلف محتوا را می‌پذیرد و اطمینان می‌یابد که یک
                                    تجربه کاربری بی‌درز باشد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال هشدار
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-31"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-31"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال هشدار" یک راه کار کاربرپسند برای نمایش هشدارها، خطاها یا پیام‌های مهم به کاربران شما فراهم می‌کند.
                                    روش نمایش هشدارها، خطاها یا پیام‌های مهم
                                    روشی برای نمایش هشدارها، خطاها یا پیام‌های مهم به کاربران شما فراهم می‌کند. این ویژگی‌ها
                                    طراحی جذاب به نظر می‌رسد و اطمینان می‌یابد که
                                    اطلاعات بطور موثر ارتباط برقرار شود.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#warning-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="warning-modal-preview">
                                                <x-base.dialog.panel>
                                                    <div class="p-5 text-center">
                                                        <x-base.lucide
                                                            class="mx-auto mt-3 h-16 w-16 text-warning"
                                                            icon="XCircle"
                                                        />
                                                        <div class="mt-5 text-3xl">اوه...</div>
                                                        <div class="mt-2 text-slate-500">
                                                            مشکلی پیش آمد!
                                                        </div>
                                                    </div>
                                                    <div class="px-5 pb-8 text-center">
                                                        <x-base.button
                                                            class="w-24"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Ok
                                                        </x-base.button>
                                                    </div>
                                                    <div
                                                        class="border-t border-slate-200/60 p-5 text-center dark:border-darkmode-400">
                                                        <a
                                                            class="text-primary"
                                                            href=""
                                                        >
                                                            چرا این مشکل را دارم؟
                                                        </a>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#warning-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="warning-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <div class="p-5 text-center">
                                                            <x-base.lucide
                                                                class="mx-auto mt-3 h-16 w-16 text-warning"
                                                                icon="XCircle"
                                                            />
                                                            <div class="mt-5 text-3xl">اوه...</div>
                                                            <div class="mt-2 text-slate-500">
                                                                مشکلی پیش آمد!
                                                            </div>
                                                        </div>
                                                        <div class="px-5 pb-8 text-center">
                                                            <x-base.button
                                                                class="w-24"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Ok
                                                            </x-base.button>
                                                        </div>
                                                        <div
                                                            class="border-t border-slate-200/60 p-5 text-center dark:border-darkmode-400">
                                                            <a
                                                                class="text-primary"
                                                                href=""
                                                            >
                                                                چرا این مشکل را دارم؟
                                                            </a>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "مدال هشدار" اطمینان حاصل می‌کند که پیام‌های مهم
                                    بطور روشن و جذاب ارائه شوند و کمک می‌کند
                                    کاربران به سرعت طبیعت هشدار را متوجه شوند و اقدامات مناسب را انجام دهند. آن را به منظور تطبیق با نیازهای خاص و ظاهر طراحی برنامه خود سفارشی سازی کنید.
                                    اقدامات مناسب را انجام دهید. آن را برای سازگاری با
                                    نیازها و ظاهر طراحی برنامه خود سفارشی کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال با دکمه بستن
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال با دکمه بستن" یک راه کار شیوه‌مند و کاربرپسند برای نمایش محتوا در یک دیالوگ مدال را فراهم می‌کند در حالی که به کاربران امکان بستن آسان مدال را می‌دهد.
                                    روشی ساده و کاربرپسند برای نمایش محتوا
                                    در یک دیالوگ مدال نمایش دهد در حالی که به کاربران امکان بستن آسان مدال را می‌دهد.
                                    بستن آسان مدال را می‌دهد. این نوع مدال
                                    برای نمایش پیام‌ها، هشدارها یا اطلاعات اضافی مفید است بدون نیاز به تعاملات پیچیده.
                                    اطلاعات بدون نیاز به تعاملات پیچیده.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#button-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="button-modal-preview">
                                                <x-base.dialog.panel>
                                                    <a
                                                        class="absolute end-0 top-0 me-3 mt-3"
                                                        data-tw-dismiss="modal"
                                                        href="#"
                                                    >
                                                        <x-base.lucide
                                                            class="h-8 w-8 text-slate-400"
                                                            icon="X"
                                                        />
                                                    </a>
                                                    <div class="p-5 text-center">
                                                        <x-base.lucide
                                                            class="mx-auto mt-3 h-16 w-16 text-success"
                                                            icon="CheckCircle"
                                                        />
                                                        <div class="mt-5 text-3xl">مثال مدال</div>
                                                        <div class="mt-2 text-slate-500">
                                                            مدال با دکمه بستن
                                                        </div>
                                                    </div>
                                                    <div class="px-5 pb-8 text-center">
                                                        <x-base.button
                                                            class="w-24"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Ok
                                                        </x-base.button>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#button-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="button-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <a
                                                            class="absolute end-0 top-0 me-3 mt-3"
                                                            data-tw-dismiss="modal"
                                                            href="#"
                                                        >
                                                            <x-base.lucide
                                                                class="h-8 w-8 text-slate-400"
                                                                icon="X"
                                                            />
                                                        </a>
                                                        <div class="p-5 text-center">
                                                            <x-base.lucide
                                                                class="mx-auto mt-3 h-16 w-16 text-success"
                                                                icon="CheckCircle"
                                                            />
                                                            <div class="mt-5 text-3xl">مثال مدال</div>
                                                            <div class="mt-2 text-slate-500">
                                                                مدال با دکمه بستن
                                                            </div>
                                                        </div>
                                                        <div class="px-5 pb-8 text-center">
                                                            <x-base.button
                                                                class="w-24"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Ok
                                                            </x-base.button>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "مدال با دکمه بستن" فرآیند نمایش اطلاعات را در یک دیالوگ مدال ساده‌تر می‌کند
                                    در حالی که اطمینان می‌یابد که کاربران می‌توانند به راحتی آن را بسته کنند وقتی که
                                    ضروری است. آن را به منظور تطبیق با سبک و نیازهای محتوای برنامه خود سفارشی کنید.
                                    ضروری است. آن را برای تطبیق با
                                    سبک و نیازهای محتوای برنامه خود سفارشی کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال زمینه استاتیک
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مدال زمینه استاتیک راه کار کاربرپسندی برای
                                    اطمینان از اینکه پیام‌های مهم شما متوجه شوند. برخلاف
                                    پنجره‌های منبع باز منظم، این یک ویژگی‌های
                                    اضافه نخواهد شد هنگامی که برون از آن کلیک کنید یا کلید فرار را فشار دهید. برای
                                    موقعیت‌هایی که می‌خواهید کاربران خود را کاملاً
                                    توجه دهند، مانند به اشتراک گذاری به‌روزرسانی‌های مهم یا راهنمایی
                                    آن‌ها از طریق مراحل. با "مدال زمینه استاتیک"،
                                    پیام شما تا زمانی که
                                    acknowledged.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#static-backdrop-modal-preview"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog
                                                id="static-backdrop-modal-preview"
                                                staticBackdrop
                                            >
                                                <x-base.dialog.panel class="px-5 py-10">
                                                    <div class="text-center">
                                                        <div class="mb-5">
                                                            اگر برون از من کلیک کنید، من بسته نخواهم شد. حتی امتحان نکنید
                                                            کلید فرار را فشار دهید.
                                                        </div>
                                                        <x-base.button
                                                            class="w-24"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Ok
                                                        </x-base.button>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#static-backdrop-modal-preview"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog
                                                    id="static-backdrop-modal-preview"
                                                    staticBackdrop
                                                >
                                                    <x-base.dialog.panel class="px-5 py-10">
                                                        <div class="text-center">
                                                            <div class="mb-5">
                                                                اگر برون از من کلیک کنید، من بسته نخواهم شد. حتی امتحان نکنید
                                                                کلید فرار را فشار دهید.
                                                            </div>
                                                            <x-base.button
                                                                class="w-24"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Ok
                                                            </x-base.button>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اکنون، شما همه چیز را برای استفاده از
                                    مدال زمینه استاتیک را دارید و اطمینان حاصل کنید که پیام‌های شما دیده و تایید شده‌اند
                                    به راحتی.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال همپوشانی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مدال همپوشانی یک ویژگی فوق‌العاده است که امکان
                                    نمایش مدال‌های چندگانه بر روی یکدیگر را فراهم می‌کند.
                                    این روش عالی برای ارائه اطلاعات به تدریج
                                    بدون بارگذاری کاربران خود با محتوای زیاد در یک بار
                                    این ویژگی به شما امکان می‌دهد که تجارب هدایت شده
                                    یا فرآیندهای مرحله به مرحله را به صورت یکپارچه ایجاد کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#overlapping-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="overlapping-modal-preview">
                                                <x-base.dialog.panel class="px-5 py-10">
                                                    <div class="text-center">
                                                        <div class="mb-5">
                                                            برای نمایش مدال همپوشانی دکمه زیر را کلیک کنید!
                                                        </div>
                                                        <!-- BEGIN: Overlapping Modal Toggle -->
                                                        <x-base.button
                                                            data-tw-toggle="modal"
                                                            data-tw-target="#next-overlapping-modal-preview"
                                                            href="#"
                                                            as="a"
                                                            variant="primary"
                                                        >
                                                            نمایش مدال همپوشانی
                                                        </x-base.button>
                                                        <!-- END: Overlapping Modal Toggle -->
                                                    </div>
                                                    <!-- BEGIN: Overlapping Modal Content -->
                                                    <x-base.dialog id="next-overlapping-modal-preview">
                                                        <x-base.dialog.panel class="p-5 text-center">
                                                            این مدال همپوشانی کاملاً شگفت‌انگیز است!
                                                        </x-base.dialog.panel>
                                                    </x-base.dialog>
                                                    <!-- END: Overlapping Modal Content -->
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#overlapping-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="overlapping-modal-preview">
                                                    <x-base.dialog.panel class="px-5 py-10">
                                                        <div class="text-center">
                                                            <div class="mb-5">
                                                                برای نمایش مدال همپوشانی دکمه زیر را کلیک کنید!
                                                            </div>
                                                            <!-- BEGIN: Overlapping Modal Toggle -->
                                                            <x-base.button
                                                                data-tw-toggle="modal"
                                                                data-tw-target="#next-overlapping-modal-preview"
                                                                href="#"
                                                                as="a"
                                                                variant="primary"
                                                            >
                                                                نمایش مدال همپوشانی
                                                            </x-base.button>
                                                            <!-- END: Overlapping Modal Toggle -->
                                                        </div>
                                                        <!-- BEGIN: Overlapping Modal Content -->
                                                        <x-base.dialog id="next-overlapping-modal-preview">
                                                            <x-base.dialog.panel class="p-5 text-center">
                                                                این مدال همپوشانی کاملاً شگفت‌انگیز است!
                                                            </x-base.dialog.panel>
                                                        </x-base.dialog>
                                                        <!-- END: Overlapping Modal Content -->
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اکنون شما قدرت مدال همپوشانی را در
                                    نوک انگشتان خود دارید. از آن برای ایجاد تجارب کاربری محبوب و
                                    تجارب اطلاعاتی استفاده کنید که کاربران خود را از طریق
                                    برنامه خود به سرعت هدایت می‌کند. این ویژگی اطمینان می‌دهد که
                                    محتوای شما سازمان‌دهی و قابل دسترسی باقی می‌ماند، که این امر
                                    آسان‌تر برای کاربران است تا اطلاعات را در
                                    pace.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال هدر و فوتر
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال هدر و فوتر" یک راه کار انعطاف‌پذیر برای ایجاد مدال‌ها با هدرها و
                                    فوترهای متمایز ارائه می‌دهد. این بخش‌ها برای اضافه کردن عناوین،
                                    اقدامات و اطلاعات اضافی به دیالوگ‌های مدال شما مناسب هستند.
                                    مدال‌های خود را با اضافه کردن عناوین، اقدامات و
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#header-footer-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="header-footer-modal-preview">
                                                <x-base.dialog.panel>
                                                    <x-base.dialog.title>
                                                        <h2 class="me-auto text-base font-medium">
                                                            پیام پخش
                                                        </h2>
                                                        <x-base.button
                                                            class="hidden sm:flex"
                                                            variant="outline-secondary"
                                                        >
                                                            <x-base.lucide
                                                                class="me-2 h-4 w-4"
                                                                icon="File"
                                                            />
                                                            دانلود اسناد
                                                        </x-base.button>
                                                        <x-base.menu class="sm:hidden">
                                                            <x-base.menu.button
                                                                class="block h-5 w-5"
                                                                href="#"
                                                            >
                                                                <x-base.lucide
                                                                    class="h-5 w-5 text-slate-500"
                                                                    icon="MoreHorizontal"
                                                                />
                                                            </x-base.menu.button>
                                                            <x-base.menu.items class="w-40">
                                                                <x-base.menu.item>
                                                                    <x-base.lucide
                                                                        class="me-2 h-4 w-4"
                                                                        icon="File"
                                                                    />
                                                                    دانلود اسناد
                                                                </x-base.menu.item>
                                                            </x-base.menu.items>
                                                        </x-base.menu>
                                                    </x-base.dialog.title>
                                                    <x-base.dialog.description class="grid grid-cols-12 gap-4 gap-y-3">
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-1">From</x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-1"
                                                                type="text"
                                                                placeholder="example@gmail.com"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-2">To</x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-2"
                                                                type="text"
                                                                placeholder="example@gmail.com"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-3">
                                                                Subject
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-3"
                                                                type="text"
                                                                placeholder="Important Meeting"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-4">
                                                                کلمات را دارد
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-4"
                                                                type="text"
                                                                placeholder="Job, Work, مستندات"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-5">
                                                                ندارد
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-5"
                                                                type="text"
                                                                placeholder="Job, Work, مستندات"
                                                            />
                                                        </div>
                                                        <div class="col-span-12 sm:col-span-6">
                                                            <x-base.form-label for="modal-form-6">Size</x-base.form-label>
                                                            <x-base.form-select id="modal-form-6">
                                                                <option>10</option>
                                                                <option>25</option>
                                                                <option>35</option>
                                                                <option>50</option>
                                                            </x-base.form-select>
                                                        </div>
                                                    </x-base.dialog.description>
                                                    <x-base.dialog.footer>
                                                        <x-base.button
                                                            class="me-1 w-20"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="outline-secondary"
                                                        >
                                                            Cancel
                                                        </x-base.button>
                                                        <x-base.button
                                                            class="w-20"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Send
                                                        </x-base.button>
                                                    </x-base.dialog.footer>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#header-footer-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="header-footer-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <x-base.dialog.title>
                                                            <h2 class="me-auto text-base font-medium">
                                                                پیام پخش
                                                            </h2>
                                                            <x-base.button
                                                                class="hidden sm:flex"
                                                                variant="outline-secondary"
                                                            >
                                                                <x-base.lucide
                                                                    class="me-2 h-4 w-4"
                                                                    icon="File"
                                                                />
                                                                دانلود اسناد
                                                            </x-base.button>
                                                            <x-base.menu class="sm:hidden">
                                                                <x-base.menu.button
                                                                    class="block h-5 w-5"
                                                                    href="#"
                                                                >
                                                                    <x-base.lucide
                                                                        class="h-5 w-5 text-slate-500"
                                                                        icon="MoreHorizontal"
                                                                    />
                                                                </x-base.menu.button>
                                                                <x-base.menu.items class="w-40">
                                                                    <x-base.menu.item>
                                                                        <x-base.lucide
                                                                            class="me-2 h-4 w-4"
                                                                            icon="File"
                                                                        />
                                                                        دانلود اسناد
                                                                    </x-base.menu.item>
                                                                </x-base.menu.items>
                                                            </x-base.menu>
                                                        </x-base.dialog.title>
                                                        <x-base.dialog.description class="grid grid-cols-12 gap-4 gap-y-3">
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-1">
                                                                    From
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-1"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-2">
                                                                    To
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-2"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-3">
                                                                    Subject
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-3"
                                                                    type="text"
                                                                    placeholder="Important Meeting"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-4">
                                                                    کلمات را دارد
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-4"
                                                                    type="text"
                                                                    placeholder="Job, Work, مستندات"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-5">
                                                                    ندارد
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-5"
                                                                    type="text"
                                                                    placeholder="Job, Work, مستندات"
                                                                />
                                                            </div>
                                                            <div class="col-span-12 sm:col-span-6">
                                                                <x-base.form-label for="modal-form-6">
                                                                    Size
                                                                </x-base.form-label>
                                                                <x-base.form-select id="modal-form-6">
                                                                    <option>10</option>
                                                                    <option>25</option>
                                                                    <option>35</option>
                                                                    <option>50</option>
                                                                </x-base.form-select>
                                                            </div>
                                                        </x-base.dialog.description>
                                                        <x-base.dialog.footer>
                                                            <x-base.button
                                                                class="me-1 w-20"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="outline-secondary"
                                                            >
                                                                Cancel
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="w-20"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Send
                                                            </x-base.button>
                                                        </x-base.dialog.footer>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اطلاعات اضافی به دیالوگ‌های مدال خود بهبود بخشید.
                                    فیلدهای فرم مربوط را برای جلب توجه کاربران خود به طور موثر اضافه کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال حذف
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال حذف" یک ابزار ارزشمند برای تأیید عملیات حیاتی است که ممکن است
                                    پیامدهای غیرقابل برگشتی داشته باشد، مانند حذف
                                    سوابق یا داده‌ها. این
                                    مدال کاربران را به اتخاذ تصمیم متأنی قبل از
                                    ادامه عملیات تشویق می‌کند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#delete-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="delete-modal-preview">
                                                <x-base.dialog.panel>
                                                    <div class="p-5 text-center">
                                                        <x-base.lucide
                                                            class="mx-auto mt-3 h-16 w-16 text-danger"
                                                            icon="XCircle"
                                                        />
                                                        <div class="mt-5 text-3xl">آیا مطمئن هستید؟</div>
                                                        <div class="mt-2 text-slate-500">
                                                            آیا واقعاً می‌خواهید این سوابق را حذف کنید؟ <br>
                                                            این فرآیند قابل بازگشت نیست.
                                                        </div>
                                                    </div>
                                                    <div class="px-5 pb-8 text-center">
                                                        <x-base.button
                                                            class="me-1 w-24"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="outline-secondary"
                                                        >
                                                            Cancel
                                                        </x-base.button>
                                                        <x-base.button
                                                            class="w-24"
                                                            type="button"
                                                            variant="danger"
                                                        >
                                                            حذف
                                                        </x-base.button>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#delete-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="delete-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <div class="p-5 text-center">
                                                            <x-base.lucide
                                                                class="mx-auto mt-3 h-16 w-16 text-danger"
                                                                icon="XCircle"
                                                            />
                                                            <div class="mt-5 text-3xl">آیا مطمئن هستید؟</div>
                                                            <div class="mt-2 text-slate-500">
                                                                آیا واقعاً می‌خواهید این سوابق را حذف کنید؟ <br>
                                                                این فرآیند قابل بازگشت نیست.
                                                            </div>
                                                        </div>
                                                        <div class="px-5 pb-8 text-center">
                                                            <x-base.button
                                                                class="me-1 w-24"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="outline-secondary"
                                                            >
                                                                Cancel
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="w-24"
                                                                type="button"
                                                                variant="danger"
                                                            >
                                                                حذف
                                                            </x-base.button>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    مدال حذف به عنوان یک حاجز محافظتی عمل می‌کند
                                    در برابر حذف‌های تصادفی و
                                    فرصتی برای تأیید اندیشه‌های خود قبل از
                                    ادامه دادن. این کمک به جلوگیری از از دست دادن داده و ارائه آرامش
                                    ذهن هنگام برخورد با اقدامات حساس می‌کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال موفقیت
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-8"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-8"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال موفقیت" راه کاری ساده و مؤثر برای
                                    ارائه بازخورد مثبت به کاربران و
                                    تأیید اقدامات موفق داخل برنامه شما است.
                                    این مدال احساس موفقیت را منتقل می‌کند و ارائه می‌دهد
                                    کاربران را تأیید می‌کند که یک کار یا
                                    action.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#success-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="success-modal-preview">
                                                <x-base.dialog.panel>
                                                    <div class="p-5 text-center">
                                                        <x-base.lucide
                                                            class="mx-auto mt-3 h-16 w-16 text-success"
                                                            icon="CheckCircle"
                                                        />
                                                        <div class="mt-5 text-3xl">کار خوبی انجام دادید!</div>
                                                        <div class="mt-2 text-slate-500">
                                                            شما دکمه را کلیک کردید!
                                                        </div>
                                                    </div>
                                                    <div class="px-5 pb-8 text-center">
                                                        <x-base.button
                                                            class="w-24"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Ok
                                                        </x-base.button>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#success-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="success-modal-preview">
                                                    <x-base.dialog.panel>
                                                        <div class="p-5 text-center">
                                                            <x-base.lucide
                                                                class="mx-auto mt-3 h-16 w-16 text-success"
                                                                icon="CheckCircle"
                                                            />
                                                            <div class="mt-5 text-3xl">کار خوبی انجام دادید!</div>
                                                            <div class="mt-2 text-slate-500">
                                                                شما دکمه را کلیک کردید!
                                                            </div>
                                                        </div>
                                                        <div class="px-5 pb-8 text-center">
                                                            <x-base.button
                                                                class="w-24"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Ok
                                                            </x-base.button>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "مدال موفقیت" تجربه کاربر را بهبود می‌بخشد با
                                    ارائه بازخورد روشن و انگیزشی. این به کاربران کمک می‌کند
                                    که احساس موفقیت و اعتماد به نفس در اقدامات خود داشته باشند،
                                    بهبود تجربه کاربر به طور کلی.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مدال اسلایدر کوچک
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-9"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-9"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "مدال اسلایدر کوچک" زیبایی را با
                                    دیالوگ‌های مدال به همراه عملکرد پویای یک
                                    اسلایدر کوچک ترکیب می‌کند. این به شما اجازه می‌دهد که تصاویر یا محتوا را
                                    به یک روش جذاب و تعاملی در یک
                                    modal.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#tiny-slider-modal-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="tiny-slider-modal-preview">
                                                <x-base.dialog.panel class="p-5">
                                                    <div class="mx-6">
                                                        <x-base.tiny-slider config="multiple-items">
                                                            <div class="h-56 px-2">
                                                                <div class="image-fit h-full overflow-hidden rounded-md">
                                                                    <img
                                                                        src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                    >
                                                                </div>
                                                            </div>
                                                            <div class="h-56 px-2">
                                                                <div class="image-fit h-full overflow-hidden rounded-md">
                                                                    <img
                                                                        src="{{ Vite::asset($products[1]['images'][0]['path']) }}"
                                                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                    >
                                                                </div>
                                                            </div>
                                                            <div class="h-56 px-2">
                                                                <div class="image-fit h-full overflow-hidden rounded-md">
                                                                    <img
                                                                        src="{{ Vite::asset($products[2]['images'][0]['path']) }}"
                                                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                    >
                                                                </div>
                                                            </div>
                                                            <div class="h-56 px-2">
                                                                <div class="image-fit h-full overflow-hidden rounded-md">
                                                                    <img
                                                                        src="{{ Vite::asset($products[3]['images'][0]['path']) }}"
                                                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                    >
                                                                </div>
                                                            </div>
                                                        </x-base.tiny-slider>
                                                    </div>
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#tiny-slider-modal-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="tiny-slider-modal-preview">
                                                    <x-base.dialog.panel class="p-5">
                                                        <div class="mx-6">
                                                            <x-base.tiny-slider config="multiple-items">
                                                                <div class="h-56 px-2">
                                                                    <div
                                                                        class="image-fit h-full overflow-hidden rounded-md">
                                                                        <img
                                                                            src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                        >
                                                                    </div>
                                                                </div>
                                                                <div class="h-56 px-2">
                                                                    <div
                                                                        class="image-fit h-full overflow-hidden rounded-md">
                                                                        <img
                                                                            src="{{ Vite::asset($products[1]['images'][0]['path']) }}"
                                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                        >
                                                                    </div>
                                                                </div>
                                                                <div class="h-56 px-2">
                                                                    <div
                                                                        class="image-fit h-full overflow-hidden rounded-md">
                                                                        <img
                                                                            src="{{ Vite::asset($products[2]['images'][0]['path']) }}"
                                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                        >
                                                                    </div>
                                                                </div>
                                                                <div class="h-56 px-2">
                                                                    <div
                                                                        class="image-fit h-full overflow-hidden rounded-md">
                                                                        <img
                                                                            src="{{ Vite::asset($products[3]['images'][0]['path']) }}"
                                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                        >
                                                                    </div>
                                                                </div>
                                                            </x-base.tiny-slider>
                                                        </div>
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "مدال اسلایدر کوچک" انتخاب عالی برای
                                    نمایش تصاویر یا محتوا در یک
                                    روش فشرده و تعاملی است. این ترکیب راحتی مدال‌ها
                                    با عملکرد جذاب اسلایدر را فراهم می‌کند و از آنجا
                                    که مناسب برای ارائه گالری محصولات، تصاویر است
                                    یا هر محتوایی که از یک
                                    presentation.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمایش/مخفی کردن مدال به صورت برنامه‌نویسی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-10"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-10"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی "نمایش/مخفی کردن مدال به صورت برنامه‌نویسی" برای
                                    شما قدرت کنترل دیدن مدال از طریق کد را فراهم می‌کند و این امکان را فراهم می‌کند
                                    برای تعاملات پویا در برنامه وب شما فراهم می‌کند.
                                    این بخش توضیح می‌دهد که چگونه به صورت برنامه‌نویسی مدیریت کنید
                                    نمایش مدال‌ها.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Show Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    id="programmatically-show-modal"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش مودال
                                                </x-base.button>
                                            </div>
                                            <!-- END: Show Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.dialog id="programmatically-modal">
                                                <x-base.dialog.panel class="p-10 text-center">
                                                    <!-- BEGIN: Hide Modal Toggle -->
                                                    <x-base.button
                                                        class="me-1"
                                                        id="programmatically-hide-modal"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        پنهان کردن مدال
                                                    </x-base.button>
                                                    <!-- END: Hide Modal Toggle -->
                                                    <!-- BEGIN: Toggle Modal Toggle -->
                                                    <x-base.button
                                                        class="me-1"
                                                        id="programmatically-toggle-modal"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        تغییر وضعیت مدال
                                                    </x-base.button>
                                                    <!-- END: Toggle Modal Toggle -->
                                                </x-base.dialog.panel>
                                            </x-base.dialog>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Show Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        id="programmatically-show-modal"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش مودال
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Show Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.dialog id="programmatically-modal">
                                                    <x-base.dialog.panel class="p-10 text-center">
                                                        <!-- BEGIN: Hide Modal Toggle -->
                                                        <x-base.button
                                                            class="me-1"
                                                            id="programmatically-hide-modal"
                                                            href="#"
                                                            as="a"
                                                            variant="primary"
                                                        >
                                                            پنهان کردن مدال
                                                        </x-base.button>
                                                        <!-- END: Hide Modal Toggle -->
                                                        <!-- BEGIN: Toggle Modal Toggle -->
                                                        <x-base.button
                                                            class="me-1"
                                                            id="programmatically-toggle-modal"
                                                            href="#"
                                                            as="a"
                                                            variant="primary"
                                                        >
                                                            تغییر وضعیت مدال
                                                        </x-base.button>
                                                        <!-- END: Toggle Modal Toggle -->
                                                    </x-base.dialog.panel>
                                                </x-base.dialog>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    ویژگی "نمایش/مخفی کردن مدال به صورت برنامه‌نویسی" قابلیت‌های
                                    تعاملی برنامه وب شما را با
                                    ارائه کنترل دقیق بر دیدن مدال به شما کمک می‌کند. آیا نیاز دارید
                                    به فعال شدن مدال‌ها بر اساس اعمال کاربر، پاسخ‌های از
                                    تماس‌های API یا هر رویداد پویا، این قابلیت اجازه می‌دهد
                                    تا تجربیات کاربر جذابی را که به شما متناسب است
                                    ایجاد کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای مدال (پیش‌فرض "div" است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`open`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    آیا مدال باز است یا بسته است.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onClose`</x-base.table.td>
                                                <x-base.table.td>`function`</x-base.table.td>
                                                <x-base.table.td>
                                                    تابع فراخوانی شود هنگامی که مدال است
                                                    closed.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`staticBackdrop`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    آیا مدال دارای پس‌زمینه استاتیک است (کلیک کردن برون)
                                                    از آن بسته نخواهد کرد).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`size`</x-base.table.td>
                                                <x-base.table.td>`Size`</x-base.table.td>
                                                <x-base.table.td>
                                                    اندازه مدال، یکی از "sm"، "md"، "lg" یا "xl"
                                                    (پیش‌فرض "md" است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog.Panel</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای پنل دیالوگ (پیش‌فرض
                                                    "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog.Title</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای عنوان دیالوگ (پیش‌فرض
                                                    "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog.Description</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای توضیحات دیالوگ (پیش‌فرض
                                                    به "div" است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog.Footer</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای پاورقی دیالوگ (پیش‌فرض
                                                    "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    ماژول خالی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اندازه ماژول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال هشدار
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال با دکمه بستن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال زمینه استاتیک
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال همپوشانی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال هدر و فوتر
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال حذف
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال موفقیت
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مدال اسلایدر کوچک
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمایش/مخفی کردن مدال به صورت برنامه‌نویسی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@pushOnce('scripts')
    @vite('resources/js/pages/modal.js')
@endPushOnce
