@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="mt-4 flex flex-col gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    اطلاعیه
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    اکتشاف مؤلفه اعلان، تجربه کاربر را با اعلان‌های ساده و شادی‌بخش به سطح بالاتر برسانید!
                    و اعلان‌ها!
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌ها راهی برای ارتباط دادن پیام‌ها یا به‌روزرسانی‌های مهم به کاربران شما فراهم می‌کنند. این بخش دو نوع اعلان پایه را پوشش می‌دهد: اعلان‌های چسبان و غیر چسبان.
                                    پیام‌ها یا به‌روزرسانی‌ها را به کاربران خود ارائه می‌دهند. این بخش دو نوع اعلان پایه را پوشش می‌دهد:
                                    دو نوع اعلان پایه: غیر چسبان و چسبان.
                                    اعلان‌ها.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex flex-col sm:flex-row"
                                                    id="basic-non-sticky-notification-content"
                                                >
                                                    <div class="font-medium">
                                                        وای! به‌روزرسانی‌ها منتشر شدند!
                                                    </div>
                                                    <a
                                                        class="mt-1 font-medium text-primary dark:text-slate-400 sm:ms-40 sm:mt-0"
                                                        href=""
                                                    >
                                                        بررسی تغییرات
                                                    </a>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    class="me-1"
                                                    id="basic-non-sticky-notification-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان غیر چسبان
                                                </x-base.button>
                                                <x-base.button
                                                    class="mt-2 sm:mt-0"
                                                    id="basic-sticky-notification-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان چسبان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex flex-col sm:flex-row"
                                                        id="basic-non-sticky-notification-content"
                                                    >
                                                        <div class="font-medium">
                                                            وای! به‌روزرسانی‌ها منتشر شدند!
                                                        </div>
                                                        <a
                                                            class="mt-1 font-medium text-primary dark:text-slate-400 sm:ms-40 sm:mt-0"
                                                            href=""
                                                        >
                                                            بررسی تغییرات
                                                        </a>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        class="me-1"
                                                        id="basic-non-sticky-notification-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان غیر چسبان
                                                    </x-base.button>
                                                    <x-base.button
                                                        class="mt-2 sm:mt-0"
                                                        id="basic-sticky-notification-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان چسبان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Basic non sticky notification
                                                $("#basic-non-sticky-notification-toggle").on("click", function () {
                                                Toastify({
                                                node: $("#basic-non-sticky-notification-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: 3000,
                                                newWindow: true,
                                                close: true,
                                                gravity: "top",
                                                position: "right",
                                                backgroundColor: "white",
                                                stopOnFocus: true,
                                                }).showToast();
                                                });

                                                // Basic sticky notification
                                                $("#basic-sticky-notification-toggle").on("click", function () {
                                                Toastify({
                                                node: $("#basic-non-sticky-notification-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: true,
                                                gravity: "top",
                                                position: "right",
                                                backgroundColor: "white",
                                                stopOnFocus: true,
                                                }).showToast();
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌های پایه راهی ساده اما موثر برای
                                    اطلاع‌رسانی به کاربران درباره به‌روزرسانی‌ها یا اقدامات مهمی که آنها
                                    باید انجام دهند. اینکه اعلان‌های غیر چسبان یا چسبان را انتخاب کنید
                                    بستگی به فوریت و تجربه کاربری دارد که می‌خواهید ارائه دهید. با استفاده از
                                    استایل‌ها و پیام‌های مختلف، اعلان‌هایی ایجاد کنید که تجربه کاربری شما را بهبود بخشد.

                                    کارایی برنامه‌تان را ارتقاء دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان موفقیت
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌های موفقیت راهی برای ارائه بازخورد مثبت به کاربران هنگامی که اقدامات
                                    را با موفقیت انجام می‌دهند. این بخش نشان می‌دهد که چگونه اعلان‌های موفقیت را ایجاد
                                    و استفاده کنید.
                                    و از اعلان‌های موفقیت استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex"
                                                    id="success-notification-content"
                                                >
                                                    <x-base.lucide
                                                        class="text-success"
                                                        icon="CheckCircle"
                                                    />
                                                    <div class="ms-4 me-4">
                                                        <div class="font-medium">پیام ذخیره شد!</div>
                                                        <div class="mt-1 text-slate-500">
                                                            پیام در ۵ دقیقه ارسال خواهد شد.
                                                        </div>
                                                    </div>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    id="success-notification-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex"
                                                        id="success-notification-content"
                                                    >
                                                        <x-base.lucide
                                                            class="text-success"
                                                            icon="CheckCircle"
                                                        />
                                                        <div class="ms-4 me-4">
                                                            <div class="font-medium">پیام ذخیره شد!</div>
                                                            <div class="mt-1 text-slate-500">
                                                                پیام در ۵ دقیقه ارسال خواهد شد.
                                                            </div>
                                                        </div>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        id="success-notification-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Success notification
                                                $("#success-notification-toggle").on("click", function () {
                                                Toastify({
                                                node: $("#success-notification-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: true,
                                                gravity: "top",
                                                position: "right",
                                                stopOnFocus: true,
                                                }).showToast();
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌های موفقیت نقش اساسی در ارتقای
                                    تجربه کاربری با ارائه بازخورد فوری در مورد
                                    اقدامات موفقیت‌آمیز دارند. آن‌ها به کاربران کمک می‌کنند تا درک کنند که
                                    اقدامات آنها با موفقیت انجام شده‌اند، که اعتمادشان به برنامه‌ی شما را افزایش می‌دهد.
                                    در نظر داشته باشید که از اعلان‌های موفقیت برای اقداماتی مانند ذخیره داده‌ها،
                                    کامل کردن وظایف یا ارسال‌های موفق استفاده کنید. پیام و استایل را به‌روز کنید
                                    تا با نیازهای برنامه‌ی شما و انتظارات کاربران همخوانی داشته باشد.
                                    پیام و استایل را به هماهنگی با برنامه‌ی شما تنظیم کنید.
                                    نام‌گذاری و انتظارات کاربر.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان با اقدامات
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با اقدامات به شما امکان می‌دهند که به کاربران
                                    گزینه‌های واضحی پس از دریافت یک
                                    اعلان ارائه دهید. این بخش نشان می‌دهد که چگونه اعلان‌های با اقدامات را ایجاد
                                    و استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex"
                                                    id="notification-with-actions-content"
                                                >
                                                    <x-base.lucide icon="HardDrive" />
                                                    <div class="ms-4 me-4">
                                                        <div class="font-medium">ذخیره سازی حذف شد!</div>
                                                        <div class="mt-1 text-slate-500">
                                                            سرور در ۳۰ ثانیه دوباره راه‌اندازی خواهد شد، اقدامی ننمایید
                                                            <br>
                                                            در طول فرآیند به‌روزرسانی!
                                                        </div>
                                                        <div class="mt-1.5 flex font-medium">
                                                            <a
                                                                class="text-primary dark:text-slate-400"
                                                                href=""
                                                            >
                                                                هم اکنون راه‌اندازی مجدد کنید
                                                            </a>
                                                            <a
                                                                class="ms-3 text-slate-500"
                                                                href=""
                                                            >
                                                                Cancel
                                                            </a>
                                                        </div>
                                                    </div>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    id="notification-with-actions-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex"
                                                        id="notification-with-actions-content"
                                                    >
                                                        <x-base.lucide icon="HardDrive" />
                                                        <div class="ms-4 me-4">
                                                            <div class="font-medium">ذخیره سازی حذف شد!</div>
                                                            <div class="mt-1 text-slate-500">
                                                                سرور در ۳۰ ثانیه دوباره راه‌اندازی خواهد شد، اقدامی ننمایید
                                                                <br>
                                                                در طول فرآیند به‌روزرسانی!
                                                            </div>
                                                            <div class="mt-1.5 flex font-medium">
                                                                <a
                                                                    class="text-primary dark:text-slate-400"
                                                                    href=""
                                                                >
                                                                    هم اکنون راه‌اندازی مجدد کنید
                                                                </a>
                                                                <a
                                                                    class="ms-3 text-slate-500"
                                                                    href=""
                                                                >
                                                                    Cancel
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        id="notification-with-actions-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Notification with actions
                                                $("#notification-with-actions-toggle").on("click", function () {
                                                Toastify({
                                                node: $("#notification-with-actions-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: true,
                                                gravity: "top",
                                                position: "right",
                                                stopOnFocus: true,
                                                }).showToast();
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با اقدامات یک راه قدرتمند برای جذب
                                    کاربران و راهنمایی آن‌ها در مورد مراحل بعدی که می‌توانند انجام دهند هستند.
                                    این اعلان‌ها به ویژه برای هشدارهای حیاتی مفید هستند یا وضعیت‌هایی که نیاز به تعامل کاربر دارند.
                                    با ارائه دکمه‌های عمل واضح و مربوط، می‌توانید به کاربران کمک کنید
                                    تصمیمات مطلع بگیرند و اقدامات مناسب را انجام دهند. پیام، آیکون و اقدامات را
                                    با نیازهای برنامه‌ی شما و نیازهای کاربر همخوانی دهید.
                                    اقدامات را سفارشی کنید. پیام، آیکون‌ها و اقدامات را برای
                                    تطابق با نیازها و نیازهای کاربران برنامه‌ی شما.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان با آواتار
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با آواتار به شما امکان می‌دهند که شخصی‌سازی کنید
                                    اعلان‌ها را با اضافه کردن آواتارهای کاربر یا عکس‌های پروفایل.
                                    این بخش نشان می‌دهد که چگونه اعلان‌های با آواتار ایجاد و
                                    استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex"
                                                    id="notification-with-avatar-content"
                                                >
                                                    <div
                                                        class="image-fit h-10 w-10 flex-none overflow-hidden rounded-full">
                                                        <img
                                                            src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                            alt="تیل وایز - قالب داشبورد مدیریتی"
                                                        >
                                                    </div>
                                                    <div class="ms-4 sm:me-28">
                                                        <div class="font-medium">
                                                            {{ $users[0]['name'] }}
                                                        </div>
                                                        <div class="mt-1 text-slate-500">
                                                            See you later! 😃😃😃
                                                        </div>
                                                    </div>
                                                    <a
                                                        class="absolute bottom-0 end-0 top-0 flex items-center border-s border-slate-200/60 px-6 font-medium text-primary dark:border-darkmode-400 dark:text-slate-400"
                                                        data-dismiss="notification"
                                                        href="#"
                                                    >
                                                        پاسخ
                                                    </a>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    id="notification-with-avatar-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex"
                                                        id="notification-with-avatar-content"
                                                    >
                                                        <div
                                                            class="image-fit h-10 w-10 flex-none overflow-hidden rounded-full">
                                                            <img
                                                                src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                alt="تیل وایز - قالب داشبورد مدیریتی"
                                                            >
                                                        </div>
                                                        <div class="ms-4 sm:me-28">
                                                            <div class="font-medium">
                                                                {{ $users[0]['name'] }}
                                                            </div>
                                                            <div class="mt-1 text-slate-500">
                                                                See you later! 😃😃😃
                                                            </div>
                                                        </div>
                                                        <a
                                                            class="absolute bottom-0 end-0 top-0 flex items-center border-s border-slate-200/60 px-6 font-medium text-primary dark:border-darkmode-400 dark:text-slate-400"
                                                            data-dismiss="notification"
                                                            href="#"
                                                        >
                                                            پاسخ
                                                        </a>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        id="notification-with-avatar-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Notification with avatar
                                                $("#notification-with-avatar-toggle").on("click", function () {
                                                // Init toastify
                                                let avatarNotification = Toastify({
                                                node: $("#notification-with-avatar-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: false,
                                                gravity: "top",
                                                position: "right",
                                                stopOnFocus: true,
                                                }).showToast();

                                                // Close notification event
                                                $(avatarNotification.toastElement)
                                                .find(\'[data-dismiss="notification"]\')
                                                .on("click", function () {
                                                avatarNotification.hideToast();
                                                });
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با آواتار یک لمس شخصی به اعلان‌های شما اضافه می‌کنند
                                    و آنها را جذاب‌تر و قابل ارتباط تر به کاربران می‌کنند.
                                    شما می‌توانید از آواتارها برای شناسایی فرستنده یا
                                    منبع اعلان استفاده کنید، ساختن تجربه‌ای بیشتر
                                    کاربرمحور و تعاملی. آواتار، اطلاعات کاربر و پیام را سفارشی کنید
                                    تا با متناسب با زمینه برنامه‌ی شما و تعاملات کاربر.
                                    زمینه و تعاملات کاربری برنامه.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان با دکمه‌های تقسیم شده
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با دکمه‌های تقسیم شده به شما امکان می‌دهند که
                                    گزینه‌های عمل چندگانه را در یک اعلان فراهم کنید.
                                    این بخش نشان می‌دهد که چگونه اعلان‌های با دکمه‌های تقسیم شده را ایجاد و
                                    استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex"
                                                    id="notification-with-split-buttons-content"
                                                >
                                                    <div class="sm:me-40">
                                                        <div class="font-medium">
                                                            معرفی تم جدید
                                                        </div>
                                                        <div class="mt-1 text-slate-500">
                                                            نسخه 2.3.3 را منتشر کنید
                                                        </div>
                                                    </div>
                                                    <div
                                                        class="absolute bottom-0 end-0 top-0 flex flex-col border-s border-slate-200/60 dark:border-darkmode-400">
                                                        <a
                                                            class="flex flex-1 items-center justify-center border-b border-slate-200/60 px-6 font-medium text-primary dark:border-darkmode-400 dark:text-slate-400"
                                                            href="#"
                                                        >
                                                            مشاهده جزئیات
                                                        </a>
                                                        <a
                                                            class="flex flex-1 items-center justify-center px-6 font-medium text-slate-500"
                                                            data-dismiss="notification"
                                                            href="#"
                                                        >
                                                            رد کردن
                                                        </a>
                                                    </div>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    id="notification-with-split-buttons-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex"
                                                        id="notification-with-split-buttons-content"
                                                    >
                                                        <div class="sm:me-40">
                                                            <div class="font-medium">
                                                                معرفی تم جدید
                                                            </div>
                                                            <div class="mt-1 text-slate-500">
                                                                نسخه 2.3.3 را منتشر کنید
                                                            </div>
                                                        </div>
                                                        <div
                                                            class="absolute bottom-0 end-0 top-0 flex flex-col border-s border-slate-200/60 dark:border-darkmode-400">
                                                            <a
                                                                class="flex flex-1 items-center justify-center border-b border-slate-200/60 px-6 font-medium text-primary dark:border-darkmode-400 dark:text-slate-400"
                                                                href="#"
                                                            >
                                                                مشاهده جزئیات
                                                            </a>
                                                            <a
                                                                class="flex flex-1 items-center justify-center px-6 font-medium text-slate-500"
                                                                data-dismiss="notification"
                                                                href="#"
                                                            >
                                                                رد کردن
                                                            </a>
                                                        </div>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        id="notification-with-split-buttons-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Notification with split buttons
                                                $("#notification-with-split-buttons-toggle").on("click", function () {
                                                // Init toastify
                                                let splitButtonsNotification = Toastify({
                                                node: $("#notification-with-split-buttons-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: false,
                                                gravity: "top",
                                                position: "right",
                                                stopOnFocus: true,
                                                }).showToast();

                                                // Close notification event
                                                $(splitButtonsNotification.toastElement)
                                                .find(\'[data-dismiss="notification"]\')
                                                .on("click", function () {
                                                splitButtonsNotification.hideToast();
                                                });
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با دکمه‌های تقسیم شده تعامل کاربر را بهبود می‌بخشند
                                    با ارائه چندین اقدام در یک اعلان تنها.
                                    این ویژگی برای ارائه گزینه‌ها یا دسترسی سریع به اقدامات مربوط بدون
                                    اشغال کردن رابط اعلان مفید است. دکمه‌ها و اقدامات را
                                    به نیازها و نیازهای برنامه‌ی شما و تجربه کاربری بی‌درنگ
                                    سفارشی کنید.
                                    تجربه کاربری بی‌درزگیری ارائه دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اعلان با دکمه‌های زیر
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با دکمه‌های زیر به شما اجازه می‌دهند که شامل
                                    دکمه‌های عمل مستقیما زیر اعلان
                                    محتوا. این بخش نشان می‌دهد که چگونه اعلان‌ها با دکمه‌های زیر را ایجاد و
                                    استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Notification Content -->
                                                <x-base.notification
                                                    class="flex"
                                                    id="notification-with-buttons-below-content"
                                                >
                                                    <x-base.lucide icon="FileText" />
                                                    <div class="ms-4 me-5 sm:me-20">
                                                        <div class="font-medium">
                                                            {{ $users[0]['name'] }}
                                                        </div>
                                                        <div class="mt-1 text-slate-500">
                                                            سند جدیدی برای شما ارسال شده است.
                                                        </div>
                                                        <div class="mt-2.5">
                                                            <x-base.button
                                                                class="me-2 px-2 py-1"
                                                                href=""
                                                                variant="primary"
                                                                as="a"
                                                            >
                                                                پیش‌نمایش
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="px-2 py-1"
                                                                href=""
                                                                variant="outline-secondary"
                                                                as="a"
                                                            >
                                                                دانلود
                                                            </x-base.button>
                                                        </div>
                                                    </div>
                                                </x-base.notification>
                                                <!-- END: Notification Content -->
                                                <!-- BEGIN: Notification Toggle -->
                                                <x-base.button
                                                    id="notification-with-buttons-below-toggle"
                                                    variant="primary"
                                                >
                                                    نمایش اعلان
                                                </x-base.button>
                                                <!-- END: Notification Toggle -->
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Notification Content -->
                                                    <x-base.notification
                                                        class="flex"
                                                        id="notification-with-buttons-below-content"
                                                    >
                                                        <x-base.lucide icon="FileText" />
                                                        <div class="ms-4 me-5 sm:me-20">
                                                            <div class="font-medium">
                                                                {{ $users[0]['name'] }}
                                                            </div>
                                                            <div class="mt-1 text-slate-500">
                                                                سند جدیدی برای شما ارسال شده است.
                                                            </div>
                                                            <div class="mt-2.5">
                                                                <x-base.button
                                                                    class="me-2 px-2 py-1"
                                                                    href=""
                                                                    variant="primary"
                                                                    as="a"
                                                                >
                                                                    پیش‌نمایش
                                                                </x-base.button>
                                                                <x-base.button
                                                                    class="px-2 py-1"
                                                                    href=""
                                                                    variant="outline-secondary"
                                                                    as="a"
                                                                >
                                                                    دانلود
                                                                </x-base.button>
                                                            </div>
                                                        </div>
                                                    </x-base.notification>
                                                    <!-- END: Notification Content -->
                                                    <!-- BEGIN: Notification Toggle -->
                                                    <x-base.button
                                                        id="notification-with-buttons-below-toggle"
                                                        variant="primary"
                                                    >
                                                        نمایش اعلان
                                                    </x-base.button>
                                                    <!-- END: Notification Toggle -->
                                                </div>
                                            </x-base.highlight>
                                            <x-base.highlight
                                                class="mt-5"
                                                type="javascript"
                                            >
                                                // Notification with buttons below
                                                $("#notification-with-buttons-below-toggle").on("click", function () {
                                                // Init toastify
                                                Toastify({
                                                node: $("#notification-with-buttons-below-content")
                                                .clone()
                                                .removeClass("hidden")[0],
                                                duration: -1,
                                                newWindow: true,
                                                close: true,
                                                gravity: "top",
                                                position: "right",
                                                stopOnFocus: true,
                                                }).showToast();
                                                });
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اعلان‌ها با دکمه‌های زیر تعامل کاربر را بهبود می‌بخشند
                                    با قرار دادن دکمه‌های قابل اجرا مستقیما زیر
                                    پیام اعلان. این طراحی به کاربران امکان می‌دهد که
                                    به سرعت پاسخ دهند یا اقدامات خاصی را انجام دهند که مرتبط با
                                    محتوای اعلان است. دکمه‌ها و
                                    محتوا را سفارشی کنید تا با نیازهای برنامه‌ی شما همخوانی داشته باشد و
                                    تجربه کاربری بی‌درز باشد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Dialog</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`گزینه‌ها`</x-base.table.td>
                                                <x-base.table.td>
                                                    یک شیء حاوی گزینه‌های پیکربندی
                                                    رفتار اعلان است. تمامی رابط‌های برنامه‌نویسی موجود را از طریق پیوندهای
                                                    مستندات مفید زیر بررسی کنید.
                                                    links
                                                    <a
                                                        class="ms-1 text-primary"
                                                        href="https://apvarun.github.io/toastify-js/"
                                                        target="blank"
                                                    >
                                                        https://apvarun.github.io/toastify-js/
                                                    </a>
                                                    .
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: NotificationElement) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابع بازخوانی برای دریافت مرجع به
                                                    عنصر اعلان.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان موفقیت
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان با اقدامات
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان با آواتار
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان با دکمه‌های تقسیم شده
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    اعلان با دکمه‌های زیر
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@pushOnce('scripts')
    @vite('resources/js/pages/notification.js')
@endPushOnce
