@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    نوار پیشرفت
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت اجزای نوار پیشرفت ما برای بصری‌سازی
                    پیشرفت و انتقال اطلاعات به طور موثر را کشف کنید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نوار پیشرفت پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    این اجزای نوار پیشرفت پایه به شما امکان می‌دهد تا به طور بصری
                                    پیشرفت کار یا فرآیند را نمایش دهید و
                                    به کاربران بازخورد زمان واقعی در مورد وضعیت تکمیل ارائه کنید. این
                                    بخش یک مقدمه به نوار پیشرفت پایه ارائه می‌دهد و نحوه استفاده از آن را به طور موثر توضیح می‌دهد.
                                    نوارد و نحوه استفاده مفید از آن.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-1/2"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-2/3"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-3/4"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-1/2"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-2/3"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-3/4"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نوار پیشرفت پایه یک اجزای بنیادین برای
                                    بهبود تجربه کاربری با ارائه بازخورد واضح در مورد
                                    پیشرفت کار است. با پیروی از مراحل بالا،
                                    می‌توانید به راحتی آن را در پروژه خود یکپارچه کنید و
                                    آن را برای برآورده کردن نیازهای خاص خود سفارشی کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>

                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نوار پیشرفت با برچسب
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای نوار پیشرفت با برچسب یک ترکیب بصری
                                    از نوار پیشرفت با برچسب با یک برچسب متنی برای ارائه
                                    کاربران با یک نشانه واضح از پیشرفت ارائه می‌دهد. این بخش
                                    نوار پیشرفت با برچسب و نحوه یکپارچه‌سازی آن با
                                    پروژه خود به طور موثر.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.progress class="h-4">
                                                    <x-base.progress.bar
                                                        class="w-1/2"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    >
                                                        50%
                                                    </x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress class="h-4">
                                                    <x-base.progress.bar
                                                        class="w-2/3"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    >
                                                        60%
                                                    </x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress class="h-4">
                                                    <x-base.progress.bar
                                                        class="w-3/4"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    >
                                                        70%
                                                    </x-base.progress.bar>
                                                </x-base.progress>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.progress class="h-4">
                                                        <x-base.progress.bar
                                                            class="w-1/2"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        >
                                                            50%
                                                        </x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress class="h-4">
                                                        <x-base.progress.bar
                                                            class="w-2/3"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        >
                                                            60%
                                                        </x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress class="h-4">
                                                        <x-base.progress.bar
                                                            class="w-3/4"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        >
                                                            70%
                                                        </x-base.progress.bar>
                                                    </x-base.progress>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای نوار پیشرفت با برچسب یک افزودنی ارزشمند است
                                    برای رابط کاربری شما که هم بصری
                                    هم متنی بروزرسانی‌های پیشرفت را ارائه می‌دهد. با پیروی از مراحل
                                    فوق، می‌توانید آن را به طور یکپارچه در
                                    پروژه خود یکپارچه کنید و آن را برای برآورده کردن نیازهای خاص خود سفارشی کنید.
                                    requirements.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    ارتفاع نوار پیشرفت
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    بخش "ارتفاع نوار پیشرفت" توضیح می‌دهد چگونه
                                    ارتفاع نوارهای پیشرفت را برای مطابقت با
                                    طراحی و طرح پروژه خود کنترل کنید. سفارشی کردن ارتفاع
                                    نوارهای پیشرفت را به طور یکپارچه در
                                    سلسله مراتب بصری برنامه‌ی خود یکپارچه کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.progress class="h-1">
                                                    <x-base.progress.bar
                                                        class="w-1/2"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-2/3"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress class="h-3">
                                                    <x-base.progress.bar
                                                        class="w-3/4"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.progress class="h-1">
                                                        <x-base.progress.bar
                                                            class="w-1/2"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-2/3"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress class="h-3">
                                                        <x-base.progress.bar
                                                            class="w-3/4"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "ارتفاع نوار پیشرفت" نشان داده است چگونه
                                    ارتفاع نوارهای پیشرفت در پروژه خود را کنترل کنید. با پیروی از این راهنماها و حفظ
                                    سریعتر و بهتر نوارهای پیشرفت در پروژه خود را ایجاد کنید. با پیروی از این
                                    راهنماها و حفظ یکپارچگی، می‌توانید نوارهای پیشرفتی را ایجاد کنید که
                                    جذاب و دسترسی‌پذیر هستند که با طرح و طرح برنامه‌ی خود هماهنگ هستند.
                                    طراحی اپلیکیشن
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    رنگ نوار پیشرفت
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    بخش "رنگ نوار پیشرفت" شرح می‌دهد چگونه
                                    رنگ‌های نوار پیشرفت را برای افزایش
                                    جلب توجه بصری برنامه خود سفارشی کنید و اطلاعات را منتقل کنید
                                    به طور موثر. می‌توانید از تنوع رنگ‌ها برای
                                    مطابقت با هویت برند خود یا نشان دادن مراحل مختلف
                                    فرایند استفاده کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col gap-2">
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-1/2"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-2/3 bg-success"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-3/4 bg-warning"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                                <x-base.progress>
                                                    <x-base.progress.bar
                                                        class="w-3/4 bg-danger"
                                                        role="progressbar"
                                                        aria-valuenow="0"
                                                        aria-valuemin="0"
                                                        aria-valuemax="100"
                                                    ></x-base.progress.bar>
                                                </x-base.progress>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col gap-2">
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-1/2"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-2/3 bg-success"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-3/4 bg-warning"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                    <x-base.progress>
                                                        <x-base.progress.bar
                                                            class="w-3/4 bg-danger"
                                                            role="progressbar"
                                                            aria-valuenow="0"
                                                            aria-valuemin="0"
                                                            aria-valuemax="100"
                                                        ></x-base.progress.bar>
                                                    </x-base.progress>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "رنگ نوار پیشرفت" به شما نشان داده است که چگونه
                                    رنگ‌های نوار پیشرفت را برای هماهنگی با
                                    طراحی برنامه خود سفارشی کنید و معنا را به طور موثر منتقل کنید. با
                                    انتخاب رنگ‌های مناسب و در نظر گرفتن دسترسی‌پذیری،
                                    تجربه کاربر را بهبود بخشیده و پیشرفت را
                                    قسمتی اساسی از رابط کاربری برنامه خود کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">پیشرفت</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colSpan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Progress.Bar</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colSpan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نوار پیشرفت پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نوار پیشرفت با برچسب
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    ارتفاع نوار پیشرفت
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رنگ نوار پیشرفت
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
