@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex items-center h-10">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    فرم معمولی
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    پتانسیل مؤلفه فرم ما را برای ایجاد
                    فرم‌های وب کاربرپسند و تعاملی به راحتی را معرفی کنید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative flex flex-col col-span-12 gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">Input</div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    فیلدهای ورودی بخش اساسی یک فرم وب هستند و
                                    به کاربران اجازه می‌دهند تا اطلاعاتی را فراهم کنند یا با برنامه شما تعامل داشته باشند.
                                    این بخش به نحوه استفاده از اجزاء ورودی در برنامه وب شما می‌پردازد و نمونه‌هایی از انواع استایل‌های ورودی را ارائه می‌دهد.
                                    اجزا در برنامه وب شما را فراهم می‌کند و نمونه‌هایی ارائه می‌دهد
                                    از انواع مختلف سبک‌های ورودی را ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <x-base.form-label for="regular-form-1">
                                                    متن ورودی
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-1"
                                                    type="text"
                                                    placeholder="Input text"
                                                />
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="regular-form-6">
                                                    فایل ورودی
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-6"
                                                    type="file"
                                                    placeholder="Input file"
                                                />
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="regular-form-2">
                                                    گرد
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-2"
                                                    type="text"
                                                    rounded
                                                    placeholder="گرد"
                                                />
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="regular-form-3">
                                                    با راهنما
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-3"
                                                    type="text"
                                                    placeholder="With help"
                                                />
                                                <x-base.form-help>
                                                    لورم ایپسوم به طور ساده متن مجازی چاپ و
                                                    صنعت آماده‌سازی می‌باشد.
                                                </x-base.form-help>
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="regular-form-4">
                                                    رمز عبور
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-4"
                                                    type="password"
                                                    placeholder="رمز عبور"
                                                />
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="regular-form-5">
                                                    غیرفعال
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="regular-form-5"
                                                    type="text"
                                                    placeholder="غیرفعال"
                                                    disabled
                                                />
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <x-base.form-label for="regular-form-1">Input
                                                        Text</x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-1"
                                                        type="text"
                                                        placeholder="Input text"
                                                    />
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="regular-form-6">
                                                        فایل ورودی
                                                    </x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-6"
                                                        type="file"
                                                        placeholder="Input file"
                                                    />
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="regular-form-2">گرد</x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-2"
                                                        type="text"
                                                        rounded
                                                        placeholder="گرد"
                                                    />
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="regular-form-3">With
                                                        Help</x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-3"
                                                        type="text"
                                                        placeholder="With help"
                                                    />
                                                    <x-base.form-help>
                                                        لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                        typesetting صنعت.
                                                    </x-base.form-help>
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="regular-form-4">رمز عبور</x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-4"
                                                        type="password"
                                                        placeholder="رمز عبور"
                                                    />
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="regular-form-5">غیرفعال</x-base.form-label>
                                                    <x-base.form-input
                                                        id="regular-form-5"
                                                        type="text"
                                                        placeholder="غیرفعال"
                                                        disabled
                                                    />
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    با استفاده از اجزای `ورودی` و سفارشی‌سازی ویژگی‌های آن، می‌توانید فیلدهای ورودی چند منظوره‌ای ایجاد کنید که
                                    نیازهای برنامه شما را برآورده کنند و تجربه کاربری سریع و بی‌دردسری ارائه دهند. حتماً نوع ورودی مناسب و قوانین اعتبارسنجی را براساس
                                    مورد استفاده خاص خود انتخاب کنید.
                                    تجربه کاربری یکپارچه را فراهم کنید. مطمئن شوید که
                                    نوع ورودی مناسب و قوانین اعتبارسنجی را بر اساس
                                    مورد استفاده خاص خود انتخاب کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    اندازه‌گیری ورودی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اندازه‌گیری ورودی یک جنبه مهم از طراحی رابط کاربری است. این به شما امکان می‌دهد که ابعاد فیلدهای ورودی را کنترل کنید تا مطمئن شوید که به خوبی در چیدمان برنامه شما جا می‌شوند.
                                    طراحی. این به شما امکان می‌دهد تا ابعاد فیلدهای ورودی را کنترل کنید
                                    تا اطمینان حاصل شود که به خوبی در چیدمان برنامه شما جا می‌شوند
                                    این بخش به نحوه تنظیم اندازه
                                    اجزای ورودی را پوشش می‌دهد و نمونه‌هایی از انواع مختلف
                                    این بخش به نحوه تنظیم اندازه اجزای ورودی می‌پردازد و نمونه‌هایی از گزینه‌های مختلف اندازه‌گیری را ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.form-input
                                                formInputSize="lg"
                                                type="text"
                                                aria-label=".form-control-lg example"
                                                placeholder=".form-control-lg"
                                            />
                                            <x-base.form-input
                                                class="mt-2"
                                                type="text"
                                                aria-label="default input example"
                                                placeholder="پیش‌فرض input"
                                            />
                                            <x-base.form-input
                                                class="mt-2"
                                                formInputSize="sm"
                                                type="text"
                                                aria-label=".form-control-sm example"
                                                placeholder=".form-control-sm"
                                            />
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.form-input
                                                    formInputSize="lg"
                                                    type="text"
                                                    aria-label=".form-control-lg example"
                                                    placeholder=".form-control-lg"
                                                />
                                                <x-base.form-input
                                                    class="mt-2"
                                                    type="text"
                                                    aria-label="default input example"
                                                    placeholder="پیش‌فرض input"
                                                />
                                                <x-base.form-input
                                                    class="mt-2"
                                                    formInputSize="sm"
                                                    type="text"
                                                    aria-label=".form-control-sm example"
                                                    placeholder=".form-control-sm"
                                                />
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    کنترل اندازه اجزای ورودی برای دستیابی به یک طراحی دیداری جذاب و کاربرپسند ضروری است. با استفاده از اجزای `ورودی` و مشخص کردن اندازه مورد نظر، می‌توانید مطمئن شوید که فیلدهای ورودی با نیازهای چیدمان و استایل برنامه شما هماهنگی داشته باشند.
                                    برای دستیابی به یک طراحی جذاب و کاربرپسند
                                    طراحی. با استفاده از اجزاء `ورودی` و مشخص کردن
                                    اندازه مورد نظر، می‌توانید مطمئن شوید که فیلدهای ورودی با
                                    نیازهای چیدمان و استایل برنامه شما هماهنگی داشته باشند.
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که
                                    بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    گروه‌های ورودی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    گروه‌های ورودی عنصر رابط کاربری مفیدی برای ترکیب ورودی‌های فرم هستند
                                    ورودی‌ها با متن یا آیکون‌های اضافی استفاده می‌شوند. آن‌ها اغلب
                                    برای ایجاد فیلدهای ورودی با تطابق بصری و متناسب با
                                    از آن‌ها استفاده می‌شود. این بخش به نحوه ایجاد
                                    گروه‌های ورودی با استفاده از اجزاء `InputGroup` و
                                    نمونه‌های مختلف پیکربندی گروه‌های ورودی را ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.input-group>
                                                <x-base.input-group.text id="input-group-email">
                                                    @
                                                </x-base.input-group.text>
                                                <x-base.form-input
                                                    type="text"
                                                    aria-label="ایمیل"
                                                    aria-describedby="input-group-email"
                                                    placeholder="ایمیل"
                                                />
                                            </x-base.input-group>
                                            <x-base.input-group class="mt-2">
                                                <x-base.form-input
                                                    type="text"
                                                    aria-label="قیمت"
                                                    aria-describedby="input-group-price"
                                                    placeholder="قیمت"
                                                />
                                                <x-base.input-group.text id="input-group-price">
                                                    .00
                                                </x-base.input-group.text>
                                            </x-base.input-group>
                                            <x-base.input-group class="mt-2">
                                                <x-base.input-group.text>@</x-base.input-group.text>
                                                <x-base.form-input
                                                    type="text"
                                                    aria-label="مقدار (to the nearest dollar)"
                                                    placeholder="قیمت"
                                                />
                                                <x-base.input-group.text>.00</x-base.input-group.text>
                                            </x-base.input-group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.input-group>
                                                    <x-base.input-group.text id="input-group-email">
                                                        @
                                                    </x-base.input-group.text>
                                                    <x-base.form-input
                                                        type="text"
                                                        aria-label="ایمیل"
                                                        aria-describedby="input-group-email"
                                                        placeholder="ایمیل"
                                                    />
                                                </x-base.input-group>
                                                <x-base.input-group class="mt-2">
                                                    <x-base.form-input
                                                        type="text"
                                                        aria-label="قیمت"
                                                        aria-describedby="input-group-price"
                                                        placeholder="قیمت"
                                                    />
                                                    <x-base.input-group.text id="input-group-price">
                                                        .00
                                                    </x-base.input-group.text>
                                                </x-base.input-group>
                                                <x-base.input-group class="mt-2">
                                                    <x-base.input-group.text>@</x-base.input-group.text>
                                                    <x-base.form-input
                                                        type="text"
                                                        aria-label="مقدار (to the nearest dollar)"
                                                        placeholder="قیمت"
                                                    />
                                                    <x-base.input-group.text>.00</x-base.input-group.text>
                                                </x-base.input-group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    گروه‌های ورودی ابزار چند منظوره‌ای برای افزایش
                                    کارایی و جذابیت بصری فرم‌های شما هستند. آیا شما
                                    نیاز به اضافه کردن آیکون‌ها، برچسب‌ها یا متن‌های اضافی به
                                    فیلدهای ورودی دارید، اجزاء `InputGroup` به شما امکان می‌دهد تا
                                    گروه‌های ورودی متمایز و اطلاعاتی ایجاد کنید. با آزمایش
                                    پیکربندی‌های مختلف، بهترین روش برای
                                    ارائه عناصر فرم و بهبود
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    وضعیت ورودی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    وضعیت یا اعتبار ورودی‌های فرم به کاربران بازخورد بصری می‌دهند. این بخش به نحوه اعمال وضعیت‌های مختلف به ورودی‌های فرم با استفاده از کلاس‌های CSS می‌پردازد و نمونه‌هایی از وضعیت‌های مختلف ورودی را ارائه می‌دهد.
                                    وضعیت یا اعتبار ورودی‌های فرم را پوشش می‌دهد. این بخش
                                    نحوه اعمال وضعیت‌های مختلف به ورودی‌های فرم با استفاده از کلاس‌های CSS را مشخص می‌کند و
                                    نمونه‌هایی از وضعیت‌های مختلف ورودی را ارائه می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <x-base.form-label for="input-state-1">
                                                    موفقیت ورودی
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    class="border-success"
                                                    id="input-state-1"
                                                    type="text"
                                                    placeholder="Input text"
                                                />
                                                <div class="grid w-full h-1 grid-cols-12 gap-4 mt-3">
                                                    <div class="h-full col-span-3 rounded bg-success"></div>
                                                    <div class="h-full col-span-3 rounded bg-success"></div>
                                                    <div class="h-full col-span-3 rounded bg-success"></div>
                                                    <div
                                                        class="h-full col-span-3 rounded bg-slate-100 dark:bg-darkmode-800">
                                                    </div>
                                                </div>
                                                <div class="mt-2 text-success">
                                                    رمز عبور قوی
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="input-state-2">
                                                    اخطار ورودی
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    class="border-warning"
                                                    id="input-state-2"
                                                    type="text"
                                                    placeholder="Input text"
                                                />
                                                <div class="mt-2 text-warning">
                                                    تلاش برای اتصال مجدد به سرور...
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="input-state-3">
                                                    خطا ورودی
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    class="border-danger"
                                                    id="input-state-3"
                                                    type="text"
                                                    placeholder="Input text"
                                                />
                                                <div class="mt-2 text-danger">
                                                    این فیلد اجباری است
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <x-base.form-label for="input-state-1">
                                                        موفقیت ورودی
                                                    </x-base.form-label>
                                                    <x-base.form-input
                                                        class="border-success"
                                                        id="input-state-1"
                                                        type="text"
                                                        placeholder="Input text"
                                                    />
                                                    <div class="grid w-full h-1 grid-cols-12 gap-4 mt-3">
                                                        <div class="h-full col-span-3 rounded bg-success"></div>
                                                        <div class="h-full col-span-3 rounded bg-success"></div>
                                                        <div class="h-full col-span-3 rounded bg-success"></div>
                                                        <div
                                                            class="h-full col-span-3 rounded bg-slate-100 dark:bg-darkmode-800">
                                                        </div>
                                                    </div>
                                                    <div class="mt-2 text-success">رمز عبور قوی</div>
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="input-state-2">
                                                        اخطار ورودی
                                                    </x-base.form-label>
                                                    <x-base.form-input
                                                        class="border-warning"
                                                        id="input-state-2"
                                                        type="text"
                                                        placeholder="Input text"
                                                    />
                                                    <div class="mt-2 text-warning">
                                                        تلاش برای اتصال مجدد به سرور...
                                                    </div>
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="input-state-3">Input
                                                        Error</x-base.form-label>
                                                    <x-base.form-input
                                                        class="border-danger"
                                                        id="input-state-3"
                                                        type="text"
                                                        placeholder="Input text"
                                                    />
                                                    <div class="mt-2 text-danger">
                                                        این فیلد اجباری است
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    وضعیت‌های ورودی برای ارائه بازخورد به کاربران و افزایش تجربه کاربری در فرم‌های شما بسیار حیاتی هستند. با استفاده از کلاس‌های وضعیت مناسب، می‌توانید وضعیت هر فیلد ورودی را به صورت بصری ارتباط برقرار کنید و این امر باعث می‌شود که کاربران بهتر بتوانند با فرم‌های شما تعامل کنند و آن‌ها را درک کنند. با آزمایش انواع استایل‌ها و وضعیت‌ها، طراحی و عملکرد برنامه وب خود را بهتر به هم پیوندید.
                                    و بهبود تجربه کاربری در فرم‌های شما. با
                                    اعمال کلاس‌های مناسب وضعیت، می‌توانید به صورت بصری
                                    وضعیت هر فیلد ورودی را ارتباط برقرار کنید و آن را
                                    برای کاربران آسان‌تر کنید تا با فرم‌های شما درک و تعامل کنند. با
                                    آزمایش استایل‌ها و وضعیت‌های مختلف برای
                                    تطبیق طراحی و عملکرد برنامه وب شما.
                                    اپلیکیشن
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب گزینه‌ها
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجازه می‌دهد تا اجزاء "انتخاب گزینه‌ها" را بسازید
                                    عناصر انتخاب کشویی با گزینه‌های مختلف است. این
                                    بخش به نحوه استفاده از اجزاء و نمونه‌های
                                    گزینه‌های مختلف را پوشش می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex flex-col items-center sm:flex-row">
                                                <x-base.form-select
                                                    class="sm:me-2 sm:mt-2"
                                                    formSelectSize="lg"
                                                    aria-label=".form-select-lg example"
                                                >
                                                    <option>کریس ایوانز</option>
                                                    <option>لیام نیسون</option>
                                                    <option>دنیل کریگ</option>
                                                </x-base.form-select>
                                                <x-base.form-select
                                                    class="mt-2 sm:me-2"
                                                    aria-label="پیش‌فرض select example"
                                                >
                                                    <option>کریس ایوانز</option>
                                                    <option>لیام نیسون</option>
                                                    <option>دنیل کریگ</option>
                                                </x-base.form-select>
                                                <x-base.form-select
                                                    class="mt-2"
                                                    formSelectSize="sm"
                                                    aria-label=".form-select-sm example"
                                                >
                                                    <option>کریس ایوانز</option>
                                                    <option>لیام نیسون</option>
                                                    <option>دنیل کریگ</option>
                                                </x-base.form-select>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex flex-col items-center sm:flex-row">
                                                    <x-base.form-select
                                                        class="sm:me-2 sm:mt-2"
                                                        formSelectSize="lg"
                                                        aria-label=".form-select-lg example"
                                                    >
                                                        <option>کریس ایوانز</option>
                                                        <option>لیام نیسون</option>
                                                        <option>دنیل کریگ</option>
                                                    </x-base.form-select>
                                                    <x-base.form-select
                                                        class="mt-2 sm:me-2"
                                                        aria-label="پیش‌فرض select example"
                                                    >
                                                        <option>کریس ایوانز</option>
                                                        <option>لیام نیسون</option>
                                                        <option>دنیل کریگ</option>
                                                    </x-base.form-select>
                                                    <x-base.form-select
                                                        class="mt-2"
                                                        formSelectSize="sm"
                                                        aria-label=".form-select-sm example"
                                                    >
                                                        <option>کریس ایوانز</option>
                                                        <option>لیام نیسون</option>
                                                        <option>دنیل کریگ</option>
                                                    </x-base.form-select>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "انتخاب گزینه‌ها" ابزار چند منظوره‌ای برای
                                    ایجاد عناصر انتخاب کشویی با طیف گسترده‌ای از
                                    گزینه‌ها هستند. شما می‌توانید از آن برای ساخت انواع فرم‌ها و رابط‌های کاربری استفاده کنید که نیازمند انتخاب کاربر از
                                    گزینه‌های تعریف شده‌اند. گزینه‌ها و استایل‌ها را بر اساس نیازهای پروژه‌تان سفارشی کنید و تجربه کاربری را
                                    هموار و کارآمد کنید.
                                    فرم‌ها را ساده می‌کند، باعث می‌شود به راحتی اطلاعات کاربر را به صورت ساختارمند جمع‌آوری کنید.
                                    به طور صاف و کارآمد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    فرم عمودی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم عمودی" به شما امکان می‌دهد تا فرم‌هایی را ایجاد کنید
                                    با یک چیدمان عمودی، جایی که فیلدها و برچسب‌های فرم
                                    روی یکدیگر قرار می‌گیرند. این بخش به نحوه
                                    استفاده از اجزاء و نمونه‌های فرم‌های عمودی را پوشش می‌دهد.
                                    forms.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <x-base.form-label for="vertical-form-1">
                                                    ایمیل
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="vertical-form-1"
                                                    type="text"
                                                    placeholder="example@gmail.com"
                                                />
                                            </div>
                                            <div class="mt-3">
                                                <x-base.form-label for="vertical-form-2">
                                                    رمز عبور
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="vertical-form-2"
                                                    type="text"
                                                    placeholder="secret"
                                                />
                                            </div>
                                            <x-base.form-check class="mt-5">
                                                <x-base.form-check.input
                                                    id="vertical-form-3"
                                                    type="checkbox"
                                                    value=""
                                                />
                                                <x-base.form-check.label for="vertical-form-3">
                                                    مرا به خاطر بسپار
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                            <x-base.button
                                                class="mt-5"
                                                variant="primary"
                                            >
                                                ورود
                                            </x-base.button>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <x-base.form-label for="vertical-form-1">ایمیل</x-base.form-label>
                                                    <x-base.form-input
                                                        id="vertical-form-1"
                                                        type="text"
                                                        placeholder="example@gmail.com"
                                                    />
                                                </div>
                                                <div class="mt-3">
                                                    <x-base.form-label for="vertical-form-2">رمز عبور</x-base.form-label>
                                                    <x-base.form-input
                                                        id="vertical-form-2"
                                                        type="text"
                                                        placeholder="secret"
                                                    />
                                                </div>
                                                <x-base.form-check class="mt-5">
                                                    <x-base.form-check.input
                                                        id="vertical-form-3"
                                                        type="checkbox"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="vertical-form-3">
                                                        مرا به خاطر بسپار
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <x-base.button
                                                    class="mt-5"
                                                    variant="primary"
                                                >
                                                    ورود
                                                </x-base.button>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم عمودی" برای ایجاد
                                    فرم‌هایی با چیدمانی ساده و روشن، ایده‌آل هستند و
                                    یک تجربه کاربری بی‌درز را تضمین می‌کنند. آن را بر اساس
                                    نیازهای پروژه‌تان سفارشی کنید، مانند اضافه کردن اعتبارسنجی، مدیریت خطا و
                                    استایل کردن. این اجزاء فرایند ایجاد فرم‌ها را ساده‌تر
                                    می‌کند و امکان جمع‌آوری اطلاعات کاربر را به راحتی در یک
                                    ساختار فراهم می‌کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    فرم افقی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم افقی" به شما امکان می‌دهد تا فرم‌هایی را ایجاد کنید
                                    با یک چیدمان افقی، جایی که برچسب‌های فرم
                                    به سمت چپ فیلدهای فرم متمایز می‌شوند. این بخش
                                    نحوه استفاده از اجزاء و نمونه‌های
                                    فرم‌های افقی را پوشش می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.form-inline>
                                                <x-base.form-label
                                                    class="sm:w-20"
                                                    for="horizontal-form-1"
                                                >
                                                    ایمیل
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="horizontal-form-1"
                                                    type="text"
                                                    placeholder="example@gmail.com"
                                                />
                                            </x-base.form-inline>
                                            <x-base.form-inline class="mt-5">
                                                <x-base.form-label
                                                    class="sm:w-20"
                                                    for="horizontal-form-2"
                                                >
                                                    رمز عبور
                                                </x-base.form-label>
                                                <x-base.form-input
                                                    id="horizontal-form-2"
                                                    type="password"
                                                    placeholder="secret"
                                                />
                                            </x-base.form-inline>
                                            <x-base.form-check class="mt-5 sm:ms-20 sm:ps-5">
                                                <x-base.form-check.input
                                                    id="horizontal-form-3"
                                                    type="checkbox"
                                                    value=""
                                                />
                                                <x-base.form-check.label for="horizontal-form-3">
                                                    مرا به خاطر بسپار
                                                </x-base.form-check.label>
                                            </x-base.form-check>
                                            <div class="mt-5 sm:ms-20 sm:ps-5">
                                                <x-base.button variant="primary">ورود</x-base.button>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.form-inline>
                                                    <x-base.form-label
                                                        class="sm:w-20"
                                                        for="horizontal-form-1"
                                                    >
                                                        ایمیل
                                                    </x-base.form-label>
                                                    <x-base.form-input
                                                        id="horizontal-form-1"
                                                        type="text"
                                                        placeholder="example@gmail.com"
                                                    />
                                                </x-base.form-inline>
                                                <x-base.form-inline class="mt-5">
                                                    <x-base.form-label
                                                        class="sm:w-20"
                                                        for="horizontal-form-2"
                                                    >
                                                        رمز عبور
                                                    </x-base.form-label>
                                                    <x-base.form-input
                                                        id="horizontal-form-2"
                                                        type="password"
                                                        placeholder="secret"
                                                    />
                                                </x-base.form-inline>
                                                <x-base.form-check class="mt-5 sm:ms-20 sm:ps-5">
                                                    <x-base.form-check.input
                                                        id="horizontal-form-3"
                                                        type="checkbox"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="horizontal-form-3">
                                                        مرا به خاطر بسپار
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <div class="mt-5 sm:ms-20 sm:ps-5">
                                                    <x-base.button variant="primary">ورود</x-base.button>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم افقی" برای ایجاد
                                    فرم‌هایی با چیدمان افقی سنتی مفید هستند، جایی که برچسب‌ها
                                    به سمت چپ فیلدهای ورودی متمایز می‌شوند. آن را سفارشی کنید
                                    بر اساس نیازهای پروژه‌تان، مانند اضافه کردن
                                    اعتبارسنجی، مدیریت خطا و
                                    استایل. این اجزاء راهی روشن و منظم برای جمع‌آوری ورودی کاربر ارائه می‌دهد
                                    به صورت ساختارمند در حالی که یک چیدمان فرم آشنا را حفظ می‌کند.
                                    layout.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    فرم درون‌خطی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-8"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-8"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم درون‌خطی" به شما امکان می‌دهد تا فرم‌هایی را ایجاد کنید
                                    با عناصر درون‌خطی، جایی که فیلدها و برچسب‌های فرم
                                    به صورت افقی در یک خط ظاهر می‌شوند. این بخش
                                    نحوه استفاده از اجزاء و نمونه‌های
                                    فرم‌های درون‌خطی را پوشش می‌دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="grid grid-cols-12 gap-2">
                                                <x-base.form-input
                                                    class="col-span-4"
                                                    type="text"
                                                    aria-label="default input inline 1"
                                                    placeholder="Input inline 1"
                                                />
                                                <x-base.form-input
                                                    class="col-span-4"
                                                    type="text"
                                                    aria-label="default input inline 2"
                                                    placeholder="Input inline 2"
                                                />
                                                <x-base.form-input
                                                    class="col-span-4"
                                                    type="text"
                                                    aria-label="default input inline 3"
                                                    placeholder="Input inline 3"
                                                />
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="grid grid-cols-12 gap-2">
                                                    <x-base.form-input
                                                        class="col-span-4"
                                                        type="text"
                                                        aria-label="default input inline 1"
                                                        placeholder="Input inline 1"
                                                    />
                                                    <x-base.form-input
                                                        class="col-span-4"
                                                        type="text"
                                                        aria-label="default input inline 2"
                                                        placeholder="Input inline 2"
                                                    />
                                                    <x-base.form-input
                                                        class="col-span-4"
                                                        type="text"
                                                        aria-label="default input inline 3"
                                                        placeholder="Input inline 3"
                                                    />
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "فرم درون‌خطی" برای ایجاد
                                    فرم‌های فشرده و کارآمد از نظر فضایی کاربردی هستند جایی که فیلدها و
                                    برچسب‌ها در یک خط ظاهر می‌شوند. آن را سفارشی کنید
                                    بر اساس نیازهای پروژه‌تان، مانند اضافه کردن
                                    مدیریت خطا و استایل. این اجزاء یک راه ساده و مختصر برای جمع‌آوری ورودی کاربر به صورت درون‌خطی فراهم می‌کنند، که برای نوارهای جستجو، فیلترها و سایر اجزاء فشرده فرم مناسب است.
                                    روش تمیز و مختصری برای جمع‌آوری ورودی کاربر به صورت درون‌خطی فراهم می‌کند،
                                    ایده‌آل برای نوارهای جستجو، فیلترها و سایر
                                    اجزاء فشرده فرم.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    چک باکس و سوییچ
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-9"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-9"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزاء "چک باکس و سوییچ" یک راه برای
                                    ایجاد چک باکس‌ها و سوییچ‌های تعاملی که کاربران می‌توانند روشن و خاموش کنند فراهم می‌کنند. این بخش
                                    نحوه استفاده از این اجزاء را پوشش می‌دهد و نمونه‌های چک باکس و سوییچ‌ها را ارائه می‌دهد.
                                    این اجزاء را ارائه می‌دهد و نمونه‌های چک باکس و
                                    switches.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <label>چک باکس عمودی</label>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-1"
                                                        type="checkbox"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-1">
                                                        کریس ایوانز
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-2"
                                                        type="checkbox"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-2">
                                                        لیام نیسون
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-3"
                                                        type="checkbox"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-3">
                                                        دنیل کریگ
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                            <div class="mt-3">
                                                <label>چک باکس افقی</label>
                                                <div class="flex flex-col mt-2 sm:flex-row">
                                                    <x-base.form-check class="me-2">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-4"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-4">
                                                            کریس ایوانز
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-5"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-5">
                                                            لیام نیسون
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-6"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-6">
                                                            دنیل کریگ
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                <label>سوییچ</label>
                                                <div class="mt-2">
                                                    <x-base.form-switch>
                                                        <x-base.form-switch.input
                                                            id="checkbox-switch-7"
                                                            type="checkbox"
                                                        />
                                                        <x-base.form-switch.label for="checkbox-switch-7">
                                                            ورودی پیش‌فرض چک باکس سوییچ
                                                        </x-base.form-switch.label>
                                                    </x-base.form-switch>
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <label>چک باکس عمودی</label>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-1"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-1">
                                                            کریس ایوانز
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-2"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-2">
                                                            لیام نیسون
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="checkbox-switch-3"
                                                            type="checkbox"
                                                            value=""
                                                        />
                                                        <x-base.form-check.label for="checkbox-switch-3">
                                                            دنیل کریگ
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                </div>
                                                <div class="mt-3">
                                                    <label>چک باکس افقی</label>
                                                    <div class="flex flex-col mt-2 sm:flex-row">
                                                        <x-base.form-check class="me-2">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-4"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                            <x-base.form-check.label for="checkbox-switch-4">
                                                                کریس ایوانز
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                        <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-5"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                            <x-base.form-check.label for="checkbox-switch-5">
                                                                لیام نیسون
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                        <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-6"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                            <x-base.form-check.label for="checkbox-switch-6">
                                                                دنیل کریگ
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                    </div>
                                                </div>
                                                <div class="mt-3">
                                                    <label>سوییچ</label>
                                                    <div class="mt-2">
                                                        <x-base.form-switch>
                                                            <x-base.form-switch.input
                                                                id="checkbox-switch-7"
                                                                type="checkbox"
                                                            />
                                                            <x-base.form-switch.label for="checkbox-switch-7">
                                                                ورودی پیش‌فرض چک باکس سوییچ
                                                            </x-base.form-switch.label>
                                                        </x-base.form-switch>
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "چک باکس و سوییچ" یک راه آسان برای
                                    ایجاد عناصر تعاملی برای ورودی کاربر فراهم می‌کنند. آن‌ها را سفارشی کنید
                                    بر اساس نیازهای پروژه‌تان، و از رویدادها برای پاسخ به تعاملات کاربر استفاده کنید.
                                    این اجزاء معمولاً برای تنظیمات، ترجیحات و فرم‌هایی که کاربران نیاز به انجام انتخاب‌های دودویی دارند، استفاده می‌شوند.
                                    اجزاء معمولاً برای تنظیمات و ترجیحات استفاده می‌شوند.
                                    و فرم‌هایی که کاربران باید انتخاب دودویی انجام دهند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">رادیو</div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-10"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-10"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزاء "رادیو" یک عنصر ورودی اساسی است که به کاربران امکان انتخاب یک گزینه از فهرست گزینه‌ها را می‌دهد.
                                    که برای انتخاب یک گزینه از بین چند گزینه مورد استفاده قرار می‌گیرد.
                                    این مورد عموماً در فرم‌ها و
                                    پرسشنامه‌ها استفاده می‌شود که کاربران باید یک گزینه را انتخاب کنند
                                    از بین چند گزینه.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <label>دکمه رادیویی عمودی</label>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="radio-switch-1"
                                                        name="vertical_radio_button"
                                                        type="radio"
                                                        value="vertical-radio-chris-evans"
                                                    />
                                                    <x-base.form-check.label for="radio-switch-1">
                                                        کریس ایوانز
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="radio-switch-2"
                                                        name="vertical_radio_button"
                                                        type="radio"
                                                        value="vertical-radio-liam-neeson"
                                                    />
                                                    <x-base.form-check.label for="radio-switch-2">
                                                        لیام نیسون
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                                <x-base.form-check class="mt-2">
                                                    <x-base.form-check.input
                                                        id="radio-switch-3"
                                                        name="vertical_radio_button"
                                                        type="radio"
                                                        value="vertical-radio-daniel-craig"
                                                    />
                                                    <x-base.form-check.label for="radio-switch-3">
                                                        دنیل کریگ
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                            <div class="mt-3">
                                                <label>دکمه رادیویی افقی</label>
                                                <div class="flex flex-col mt-2 sm:flex-row">
                                                    <x-base.form-check class="me-2">
                                                        <x-base.form-check.input
                                                            id="radio-switch-4"
                                                            name="horizontal_radio_button"
                                                            type="radio"
                                                            value="horizontal-radio-chris-evans"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-4">
                                                            کریس ایوانز
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                        <x-base.form-check.input
                                                            id="radio-switch-5"
                                                            name="horizontal_radio_button"
                                                            type="radio"
                                                            value="horizontal-radio-liam-neeson"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-5">
                                                            لیام نیسون
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                        <x-base.form-check.input
                                                            id="radio-switch-6"
                                                            name="horizontal_radio_button"
                                                            type="radio"
                                                            value="horizontal-radio-daniel-craig"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-6">
                                                            دنیل کریگ
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <label>دکمه رادیویی عمودی</label>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="radio-switch-1"
                                                            name="vertical_radio_button"
                                                            type="radio"
                                                            value="vertical-radio-chris-evans"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-1">
                                                            کریس ایوانز
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="radio-switch-2"
                                                            name="vertical_radio_button"
                                                            type="radio"
                                                            value="vertical-radio-liam-neeson"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-2">
                                                            لیام نیسون
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                    <x-base.form-check class="mt-2">
                                                        <x-base.form-check.input
                                                            id="radio-switch-3"
                                                            name="vertical_radio_button"
                                                            type="radio"
                                                            value="vertical-radio-daniel-craig"
                                                        />
                                                        <x-base.form-check.label for="radio-switch-3">
                                                            دنیل کریگ
                                                        </x-base.form-check.label>
                                                    </x-base.form-check>
                                                </div>
                                                <div class="mt-3">
                                                    <label>دکمه رادیویی افقی</label>
                                                    <div class="flex flex-col mt-2 sm:flex-row">
                                                        <x-base.form-check class="me-2">
                                                            <x-base.form-check.input
                                                                id="radio-switch-4"
                                                                name="horizontal_radio_button"
                                                                type="radio"
                                                                value="horizontal-radio-chris-evans"
                                                            />
                                                            <x-base.form-check.label for="radio-switch-4">
                                                                کریس ایوانز
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                        <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                            <x-base.form-check.input
                                                                id="radio-switch-5"
                                                                name="horizontal_radio_button"
                                                                type="radio"
                                                                value="horizontal-radio-liam-neeson"
                                                            />
                                                            <x-base.form-check.label for="radio-switch-5">
                                                                لیام نیسون
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                        <x-base.form-check class="mt-2 me-2 sm:mt-0">
                                                            <x-base.form-check.input
                                                                id="radio-switch-6"
                                                                name="horizontal_radio_button"
                                                                type="radio"
                                                                value="horizontal-radio-daniel-craig"
                                                            />
                                                            <x-base.form-check.label for="radio-switch-6">
                                                                دنیل کریگ
                                                            </x-base.form-check.label>
                                                        </x-base.form-check>
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزاء "رادیو" چندمنظوره است و می‌تواند برای ایجاد گروه‌های دکمه‌های رادیویی عمودی و افقی استفاده شود.
                                    این دکمه‌های رادیویی معمولاً در فرم‌ها، نظرسنجی‌ها و هر سناریو که نیاز به انتخاب‌های انحصاری دارد، استفاده می‌شوند.
                                    این دکمه‌های رادیویی معمولاً در فرم‌ها، نظرسنجی‌ها،
                                    و هر سناریویی که نیاز به انتخاب‌های انحصاری دارد، استفاده می‌شوند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div
                            class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormCheck</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormCheck.Label</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormCheck.Input</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormInput</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`formInputSize`</x-base.table.td>
                                                <x-base.table.td>`sm`, `lg`</x-base.table.td>
                                                <x-base.table.td>
                                                    اندازه یا ابعاد میدان ورودی را مشخص می‌کند
                                                    در یک فرم. از این ویژگی برای کنترل ظاهری استفاده کنید
                                                    ظاهر میدان ورودی، با گزینه‌هایی مانند
                                                    'کوچک'، 'متوسط' یا 'بزرگ' برای تطابق با طراحی شما و نیازهای طرح
                                                    و طرح."
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`rounded`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    آیا گوشه‌های گرد به عنصر متن‌گذاری اعمال شود
                                                    element
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormTextarea</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`formTextareaSize`</x-base.table.td>
                                                <x-base.table.td>`sm`, `lg`</x-base.table.td>
                                                <x-base.table.td>
                                                    اندازه یا ابعاد میدان ورودی را مشخص می‌کند
                                                    در یک فرم. از این ویژگی برای کنترل ظاهری استفاده کنید
                                                    ظاهر میدان ورودی، با گزینه‌هایی مانند
                                                    'کوچک'، 'متوسط' یا 'بزرگ' برای تطابق با طراحی شما و نیازهای طرح
                                                    و نیازهای طرح
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`rounded`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    آیا گوشه‌های گرد به عنصر متن‌گذاری اعمال شود
                                                    element
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormHelp</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormInline</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormLabel</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormSelect</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`formSelectSize`</x-base.table.td>
                                                <x-base.table.td>`sm`, `lg`</x-base.table.td>
                                                <x-base.table.td>
                                                    اندازه یا ابعاد عنصر انتخاب را مشخص می‌کند
                                                    در یک فرم. از این ویژگی برای استفاده سفارشی از نمایش بصری عنصر انتخابی استفاده کنید
                                                    ، گزینه‌هایی مانند
                                                    'کوچک'، 'متوسط' یا 'بزرگ' برای هماهنگی با طراحی و نیازهای طراحی شما
                                                    پیشنهاد می‌کند.
                                                    preferences
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormSwitch</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormSwitch.Label</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">FormSwitch.Input</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">InputGroup</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">InputGroup.Text</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    Input
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    اندازه‌گیری ورودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    گروه‌های ورودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    وضعیت ورودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    انتخاب گزینه‌ها
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    فرم عمودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    فرم افقی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    فرم درون‌خطی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    چک باکس و سوییچ
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    رادیو
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
