@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="mt-4 flex flex-col gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    جدول معمولی
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    تنوع‌های مختلف مؤلفه جدول را با استایل ساده‌شده بررسی کنید برای
                    جداول پویا!
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول پایه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-12"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-12"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "جدول پایه" یک راه ساده را برای ایجاد جداول ساختارمند در وب
                                    اپلیکیشن‌ها فراهم می‌کند. این سبک جدول تمیز و کم حجم است،
                                    که مناسب برای موارد استفاده گسترده‌ای است.
                                    این مثال نشان می‌دهد که چگونه یک جدول پایه با ستون‌های "نام اول"، "نام آخر" و
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                                <x-base.table
                                                    class="mt-5"
                                                    dark
                                                >
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                    <x-base.table
                                                        class="mt-5"
                                                        dark
                                                    >
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    کامپوننت "جدول پایه" زمانی استفاده کنید که می‌خواهید یک
                                    جدول ساده،
                                    "پایدار و سفارشی‌سازی شود.
                                    برای سفارشی‌سازی بیشتر و تطابق با نیازهای برنامه‌ی خود استفاده کنید
                                    کامپوننت "جدول پایه" را زمانی استفاده کنید که می‌خواهید یک ساختار جدول ساده،
                                    تمیز و بدون پوشش یا
                                    complexity.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول با حاشیه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-21"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-21"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "جدول با حاشیه" یک نسخه از
                                    جدول پایه است که ویژگی اضافی حاشیه‌ها دور
                                    جدول و سلول‌هایش را دارد. این انتخاب استایلی
                                    تمایز بصری بین ردیف‌ها و ستون‌ها را افزایش می‌دهد و
                                    محتوای جدول را مشخص‌تر و سازمان‌دهی‌شده‌تر می‌کند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table bordered>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table bordered>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، یک "جدول با حاشیه" با
                                    حاشیه‌ها دور جدول و سلول‌هایش ایجاد می‌شود. این تمایز بصری اضافی می‌تواند به‌ویژه زمانی که می‌خواهید
                                    ساختار جدول خود را تأکید دهید، مفید باشد. از کامپوننت
                                    جدول با حاشیه" زمانی استفاده کنید که نیاز به جدول با
                                    حاشیه‌های مشخص برای افزایش تفکیک بصری بین ردیف‌ها و ستون‌ها دارید.
                                    حاشیه‌های مشخص برای بهبود جداکردن بصری
                                    بین ردیف‌ها و ستون‌ها.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول قابل هاور
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "جدول قابل هاور" طراحی شده است تا تجربه کاربر را ارتقا دهد با اضافه کردن یک اثر هاور به
                                    ردیف‌های جدول. زمانی که کاربران موس خود را بر روی یک ردیف قرار می‌دهند، آن ردیف برجسته می‌شود و
                                    یک روند بصری ارائه می‌دهد و تعامل را بهبود می‌بخشد.
                                    در این مثال، یک "جدول قابل هاور" با افزودن prop هاور به کامپوننت جدول ایجاد شده است. هنگامی که کاربران بر روی ردیف‌ها هاور می‌کنند، به طور بصری با برجسته شدن پاسخ می‌دهند، که ارتباطاتشان را ردیابی کردن آسان‌تر می‌کند. از کامپوننت "جدول قابل هاور" زمانی استفاده کنید که می‌خواهید در محتوای مبتنی بر جدولتان تعامل کاربر را بهبود بخشید.
                                    بهبود تعامل
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table
                                                    bordered
                                                    hover
                                                >
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table
                                                        bordered
                                                        hover
                                                    >
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، یک "جدول قابل هاور" با اضافه کردن prop هاور به کامپوننت جدول ایجاد شده است. هنگامی که کاربران
                                    بر روی ردیف‌ها هاور می‌کنند، به طور بصری با برجسته شدن
                                    پاسخ می‌دهند، که ارتباطاتشان را ردیابی کردن آسان‌تر می‌کند.
                                    از کامپوننت "جدول قابل هاور" زمانی استفاده کنید که می‌خواهید
                                    در محتوای مبتنی بر جدولتان تعامل کاربر را بهبود بخشید.
                                    ارتباط کاربری را بهبود بخشید و تجربه‌ای بیشتر از نظر تعاملی
                                    در محتوای مبتنی بر جدولتان فراهم کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    وضعیت ردیف‌های جدول
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی "وضعیت ردیف‌های جدول" به شما امکان می‌دهد که نشانگرهای بصری به ردیف‌های جدول اضافه کنید، بهبود ارائه و انتقال اطلاعات اضافی به کاربران را فراهم می‌کند. شما می‌توانید استایل‌های مختلف را به ردیف‌ها اعمال کنید تا وضعیت‌ها یا دسته‌بندی‌های مختلف را نمایش دهید و جداول خود را اطلاعاتی‌تر و جذاب‌تر کنید.
                                    نشانگرهای به ردیف‌های جدول اضافه کنید تا ارائه و
                                    conveying additional information to users. You can apply
                                    استفاده از استایل‌های مختلف برای نمایش وضعیت‌ها یا دسته‌های مختلف ردیف‌ها
                                    دسته‌بندی‌ها، جداول شما را اطلاعات‌بخش‌تر و
                                    جذاب‌تر می‌کنند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr class="bg-primary text-white">
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr class="bg-danger text-white">
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr class="bg-warning">
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr class="bg-primary text-white">
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr class="bg-danger text-white">
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr class="bg-warning">
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، وضعیت‌های مختلف ردیف‌ها را اعمال کرده‌ایم تا
                                    ردیف‌های خاصی را برجسته کنیم:
                                </p>
                                <ul class="mb-4 ms-7 mt-2 list-decimal leading-relaxed">
                                    <li class="mb-0.5">
                                        ردیف اول با وضعیت اصلی علامت‌گذاری شده است،
                                        که معمولاً برای محتوای مثبت یا برجسته استفاده می‌شود.
                                    </li>
                                    <li class="mb-0.5">
                                        ردیف دوم با وضعیت خطر علامت‌گذاری شده است، که اغلب
                                        برای نشان دادن یک شرایط بحرانی یا منفی استفاده می‌شود.
                                    </li>
                                    <li class="mb-0.5">
                                        ردیف سوم با وضعیت هشدار علامت‌گذاری شده است، مناسب
                                        برای هشدار دادن به کاربران در مواقع هشداردهنده است.
                                    </li>
                                </ul>
                                <p class="leading-relaxed">
                                    با استفاده از "وضعیت‌های ردیف جدول"، می‌توانید به طور بصری
                                    ردیف‌ها را بر اساس اهمیت یا
                                    دسته‌بندی متفاوت کنید که این برای کاربران آسان‌تر می‌شود تا محتوای
                                    محتوای داخل جدول را مشخص می‌کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    گزینه‌های سرجدول
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی «گزینه‌های سرجدول» به شما اجازه می‌دهد تا سفارشی‌سازی کنید
                                    the appearance of the table header to better match your
                                    انتخاب کنید. می‌توانید بین دو نوع مختلف، "تیره" و "روشن"، انتخاب کنید که هر کدام
                                    استایل مختلفی را برای سرصفحه جدول ارائه می‌دهند.
                                    ارائه یک سبک بصری متمایز برای سربرگ جدول.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table>
                                                    <x-base.table.thead variant="dark">
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                                <x-base.table class="mt-5">
                                                    <x-base.table.thead variant="light">
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table>
                                                        <x-base.table.thead variant="dark">
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                    <x-base.table class="mt-5">
                                                        <x-base.table.thead variant="light">
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، دو سرصفحه مختلف جدول را به نمایش می‌گذاریم با استفاده از نوع‌های "تیره" و "روشن":
                                    سرصفحه اول با نوع "تیره" طراحی شده است که باعث ایجاد یک پس‌زمینه تیره و متن سفید مشخص می‌شود.
                                </p>
                                <ul class="mb-4 ms-7 mt-2 list-decimal leading-relaxed">
                                    <li class="mb-0.5">
                                        سربرگ اول جدول با نوع "تاریک" طراحی شده است که رنگ پس‌زمینه تاریک و متن سفید ارائه می‌دهد،
                                        ویژگی که رنگ پس‌زمینه تاریک و
                                        متن سفید ارائه می‌دهد و یک سربرگ متمایز بصری ایجاد می‌کند.
                                    </li>
                                    <li class="mb-0.5">
                                        سرصفحه دوم از نوع "روشن" استفاده می‌کند، که یک پس‌زمینه روشن با متن تیره برای یک ظاهر
                                        ملایم‌تر ارائه می‌دهد.
                                        ظاهری ظریف.
                                    </li>
                                </ul>
                                <p class="leading-relaxed">
                                    با استفاده از "گزینه‌های سرصفحه جدول"، می‌توانید سرصفحه جدول خود را با طرح طراحی برنامه‌ی
                                    شما هماهنگ کنید و یک رابط کاربری سازگار و جذاب
                                    را ایجاد کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول واکنشگرا
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی "جدول واکنشگرا" اطمینان می‌دهد که محتوای جدول شما به بهترین شکل به اندازه‌گیری‌های مختلف صفحه
                                    سازگار باشد، تجربه مشاهده بهینه را برای هر دو اندازه‌ی بزرگ
                                    صفحه و دستگاه‌های تلفن همراه کوچک ارائه می‌دهد.
                                    هنگامی که قابلیت "جدول واکنشگرا" را فعال می‌کنید، به کاربران اجازه می‌دهد که به صورت افقی به جدول کلی دسترسی داشته باشند،
                                    با اطمینان از اینکه هیچ داده‌ای در صفحات کوچک بریده نمی‌شود.
                                    برای اسکرول افقی و مشاهده کامل جدول،
                                    اطمینان حاصل می‌شود که داده‌ها در صفحات کوچک قطع نمی‌شوند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                ایمیل
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                آدرس
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                1
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                آنجلینا
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                چارلی
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                @angelinajolie
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                angelinajolie@gmail.com
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                260 خیابان و. استورم نیویورک، NY 10025.
                                                            </x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                2
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                Brad
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                Pitt
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                @براد پیت
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                براد پیت@gmail.com
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                47 خیابان دیویژن بوفالو، NY 14241.
                                                            </x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                3
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                "نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                @charliehunnam
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                charliehunnam@gmail.com
                                                            </x-base.table.td>
                                                            <x-base.table.td class="whitespace-nowrap">
                                                                8023 خیابان آمریج هریمن، NY 10926.
                                                            </x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    ایمیل
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    آدرس
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td
                                                                    class="whitespace-nowrap">1</x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    آنجلینا
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    چارلی
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    @angelinajolie
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    angelinajolie@gmail.com
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    260 خیابان و. استورم نیویورک، NY 10025.
                                                                </x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td
                                                                    class="whitespace-nowrap">2</x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    Brad
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    Pitt
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    @براد پیت
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    براد پیت@gmail.com
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    47 خیابان دیویژن بوفالو، NY 14241.
                                                                </x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td
                                                                    class="whitespace-nowrap">3</x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    "نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    @charliehunnam
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    charliehunnam@gmail.com
                                                                </x-base.table.td>
                                                                <x-base.table.td class="whitespace-nowrap">
                                                                    8023 خیابان آمریج هریمن، NY 10926.
                                                                </x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، یک «جدول واکنشگرا» توسط
                                    بسته‌بندی آن داخل یک ظرف با سرریز افقی ایجاد می‌شود.
                                    این امکان را به کاربران می‌دهد تا به صورت افقی اسکرول کنند و جدول کامل را ببینند،
                                    اطمینان حاصل می‌شود که تمام ستون‌ها و داده‌ها
                                    قابل دسترسی باقی بماند روی صفحات کوچک. هنگامی که می‌خواهید جدول خود
                                    واکنشگرا را استفاده کنید.
                                    جهت حفظ خوانایی و قابلیت استفاده را در انواع
                                    دستگاه‌ها، بدون توجه به اندازه صفحه نمایش.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول کوچک
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجازه می‌دهد یک جدول کوچک و کارآمد فضا ایجاد کنید، ایده‌آل برای مواقعی که نیاز به نمایش داده‌های جدولی در فضای محدود دارید
                                    یا تأکید بر یک طراحی کم حجم. با اضافه کردن
                                    ویژگی sm (small) به جدول، می‌توانید اندازه کلی جدول را کاهش دهید و آن را مناسب‌تر برای
                                    نمایش اطلاعات به صورت مختصر کنید.
                                    با اضافه کردن ویژگی sm (کوچک) به جدول، می‌توانید اندازه کلی جدول را کاهش دهید و
                                    آن را مناسب‌تر برای
                                    نمایش اطلاعات به صورت مختصر کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table sm>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table sm>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، یک "جدول کوچک" با اعمال
                                    ویژگی sm به جزئیات جدول ایجاد شده است. این باعث کاهش
                                    اندازه کلی جدول می‌شود و
                                    آن را مناسب برای مواقعی که فضا محدود است. از مجموعه
                                    جدول کوچک استفاده کنید هنگامی که نیاز دارید داده‌های جدولی را نمایش دهید
                                    در یک فضای محدود یا زمانی که می‌خواهید
                                    طراحی ساده و کم حجمی را حفظ کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جدول سطرهای موخط
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی «جدول سطرهای موخط» خوانایی و جذابیت بصری جدول‌های شما را با اعمال رنگ‌های پس‌زمینه متناوب به سطرها افزایش می‌دهد.
                                    خوانایی و جذابیت بصری جداول خود را با اعمال
                                    تغییر رنگ‌های پس‌زمینه متناوب به ردیف‌ها افزایش می‌دهد. این باعث می‌شود
                                    تمایز واضح بین ردیف‌های زوج و فرد ایجاد شود، که این کار باعث می‌شود
                                    برای کاربران آسان‌تر شود تا داده‌های جدولی را پیگیری و تفسیر کنند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="overflow-x-auto">
                                                <x-base.table striped>
                                                    <x-base.table.thead>
                                                        <x-base.table.tr>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                #
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                نام کاربری
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                جولی
                                                            </x-base.table.th>
                                                            <x-base.table.th class="whitespace-nowrap">
                                                                پیت
                                                            </x-base.table.th>
                                                        </x-base.table.tr>
                                                    </x-base.table.thead>
                                                    <x-base.table.tbody>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>1</x-base.table.td>
                                                            <x-base.table.td>آنجلینا</x-base.table.td>
                                                            <x-base.table.td>چارلی</x-base.table.td>
                                                            <x-base.table.td>@angelinajolie</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>2</x-base.table.td>
                                                            <x-base.table.td>Brad</x-base.table.td>
                                                            <x-base.table.td>Pitt</x-base.table.td>
                                                            <x-base.table.td>@براد پیت</x-base.table.td>
                                                        </x-base.table.tr>
                                                        <x-base.table.tr>
                                                            <x-base.table.td>3</x-base.table.td>
                                                            <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                            <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                            <x-base.table.td>@charliehunnam</x-base.table.td>
                                                        </x-base.table.tr>
                                                    </x-base.table.tbody>
                                                </x-base.table>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="overflow-x-auto">
                                                    <x-base.table striped>
                                                        <x-base.table.thead>
                                                            <x-base.table.tr>
                                                                <x-base.table.th
                                                                    class="whitespace-nowrap">#</x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    نام کاربری
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    جولی
                                                                </x-base.table.th>
                                                                <x-base.table.th class="whitespace-nowrap">
                                                                    پیت
                                                                </x-base.table.th>
                                                            </x-base.table.tr>
                                                        </x-base.table.thead>
                                                        <x-base.table.tbody>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>1</x-base.table.td>
                                                                <x-base.table.td>آنجلینا</x-base.table.td>
                                                                <x-base.table.td>چارلی</x-base.table.td>
                                                                <x-base.table.td>@angelinajolie</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>2</x-base.table.td>
                                                                <x-base.table.td>Brad</x-base.table.td>
                                                                <x-base.table.td>Pitt</x-base.table.td>
                                                                <x-base.table.td>@براد پیت</x-base.table.td>
                                                            </x-base.table.tr>
                                                            <x-base.table.tr>
                                                                <x-base.table.td>3</x-base.table.td>
                                                                <x-base.table.td>مثال بالا نشان می‌دهد که چگونه یک جدول پایه را با ستون‌های "نام اول"، "نام آخر" و</x-base.table.td>
                                                                <x-base.table.td>"نام کاربری" ایجاد کنید. این جدول آسان به خواندن است و می‌توانید آن را برای نیازهای برنامه‌ی خود سفارشی‌سازی کنید. از</x-base.table.td>
                                                                <x-base.table.td>@charliehunnam</x-base.table.td>
                                                            </x-base.table.tr>
                                                        </x-base.table.tbody>
                                                    </x-base.table>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    در این مثال، یک "جدول ردیف‌های خط‌خطی" با اضافه کردن ویژگی خط‌خطی به جزئیات جدول ایجاد شده است.
                                    ایجاد می‌شود. ردیف‌های زوج با یک رنگ پس‌زمینه طراحی شده‌اند،
                                    در حالی که ردیف‌های فرد با پس‌زمینه پیش‌فرض باقی می‌مانند. این الگوی متناوب بهبود می‌بخشد
                                    جدایی بصری ردیف‌ها و خوانایی کلی جدول را افزایش می‌دهد. از مجموعه
                                    جدول ردیف‌های خط‌خطی استفاده کنید هنگامی که می‌خواهید داده‌های جدولی را به صورت بصری
                                    منظم و آسان خوانده شوند.
                                    از جزئیات "جدول ردیف‌های خط‌خطی" استفاده کنید
                                    زمانی که می‌خواهید داده‌های جدولی را به صورت بصری
                                    منظم و قابل خواندن ارائه دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">جدول</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`dark`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    فعال کردن سبک حالت تاریک برای جدول.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`bordered`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>افزودن حاشیه به سلول‌های جدول.</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`hover`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    فعال کردن افکت‌های هاور بر روی سطرهای جدول.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`striped`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    تغییر رنگ‌های پس‌زمینه سطرها به صورت متناوب برای بهبود
                                                    خوانایی.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`sm`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    کاهش اندازه جدول برای نمایش جدولی
                                                    جمع و جورتر.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">جدول.Thead</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`variant`</x-base.table.td>
                                                <x-base.table.td>`default`, `light`, `dark`</x-base.table.td>
                                                <x-base.table.td>
                                                    استایل نوعی را برای سر جدول تنظیم می‌کند.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.Tbody</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">جدول.Tr</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">جدول.Th</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">جدول.Td</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جدول پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جدول با حاشیه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جدول قابل هاور
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    وضعیت ردیف‌های جدول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    گزینه‌های سرجدول
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جدول واکنشگرا
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جدول کوچک
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    ردیف‌های خط‌خطی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
