@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex flex-col gap-y-3 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    تنظیمات
                </div>
                <div class="flex flex-col gap-x-3 gap-y-2 sm:flex-row md:ms-auto">
                    <x-base.button
                        class="group-[.mode--light]:!border-transparent group-[.mode--light]:!bg-white/[0.12] group-[.mode--light]:!text-slate-200"
                        variant="primary"
                    >
                        <x-base.lucide
                            class="me-3 h-4 w-4 stroke-[1.3]"
                            icon="ExternalLink"
                        />
                        رفتن به پروفایل من
                    </x-base.button>
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-10">
                <div class="relative col-span-12 xl:col-span-3">
                    <div class="sticky top-[104px]">
                        <div class="box box--stacked flex flex-col px-5 pb-6 pt-5">
                            <a
                                href="{{ route('settings') }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => is_null(request()->query('page')),
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="AppWindow"
                                />
                                اطلاعات پروفایل
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'email-settings']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'email-settings',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="MailCheck"
                                />
                                تنظیمات ایمیل
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'security']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'security',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="KeyRound"
                                />
                                امنیت
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'preferences']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'preferences',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="PackageCheck"
                                />
                                ترجیحات
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'two-factor-authentication']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'two-factor-authentication',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="ShieldCheck"
                                />
                                احراز هویت دو عاملی
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'device-history']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'device-history',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="Smartphone"
                                />
                                تاریخچه دستگاه
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'notification-settings']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'notification-settings',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="BellDot"
                                />
                                تنظیمات اعلان
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'connected-services']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'connected-services',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="Workflow"
                                />
                                خدمات متصل
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'social-media-links']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'social-media-links',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="Podcast"
                                />
                                پیوندهای رسانه‌های اجتماعی
                            </a>
                            <a
                                href="{{ route('settings', ['page' => 'account-deactivation']) }}"
                                @class([
                                    'flex items-center py-3 first:-mt-3 last:-mb-3 [&.active]:text-primary [&.active]:font-medium hover:text-primary',
                                    'active' => request()->query('page') === 'account-deactivation',
                                ])
                            >
                                <x-base.lucide
                                    class="me-3 h-4 w-4 stroke-[1.3]"
                                    icon="Trash2"
                                />
                                غیرفعال‌سازی حساب کاربری
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-span-12 flex flex-col gap-y-7 xl:col-span-9">
                    <div class="box box--stacked flex flex-col p-1.5">
                        <div class="relative h-60 w-full rounded-[0.6rem] bg-gradient-to-b from-theme-1/95 to-theme-2/95">
                            <div @class([
                                'w-full h-full relative overflow-hidden',
                                "before:content-[''] before:absolute before:inset-0 before:bg-texture-white before:-mt-[50rem]",
                                "after:content-[''] after:absolute after:inset-0 after:bg-texture-white after:-mt-[50rem]",
                            ])></div>
                            <div class="absolute inset-x-0 top-0 mx-auto mt-36 h-32 w-32">
                                <div
                                    class="box image-fit h-full w-full overflow-hidden rounded-full border-[6px] border-white">
                                    <img
                                        src="{{ Vite::asset($users[0]['photo']) }}"
                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                    >
                                </div>
                                <div
                                    class="box absolute bottom-0 end-0 mb-2.5 me-2.5 h-5 w-5 rounded-full border-2 border-white bg-success">
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col gap-y-3 rounded-[0.6rem] bg-slate-50 p-5 pt-12 sm:flex-row sm:items-end">
                            <div>
                                <x-base.form-label class="flex items-center text-slate-500">
                                    چه کسی می‌تواند عکس پروفایل شما را ببیند؟
                                    <x-base.tippy
                                        class="ms-1.5"
                                        as="span"
                                        content="Low"
                                    >
                                        <x-base.lucide
                                            class="h-3.5 w-3.5 stroke-[1.3] text-slate-500"
                                            icon="Info"
                                        />
                                    </x-base.tippy>
                                </x-base.form-label>
                                <div class="relative mt-2.5">
                                    <x-base.lucide
                                        class="absolute inset-y-0 start-0 z-10 my-auto ms-3 h-4 w-4 stroke-[1.3]"
                                        icon="Globe"
                                    />
                                    <x-base.form-select class="me-3 rounded-[0.5rem] ps-9 sm:w-44">
                                        <option value="custom-date">هر کسی</option>
                                        <option value="daily">فقط شما</option>
                                    </x-base.form-select>
                                </div>
                            </div>
                            <x-base.button
                                class="border-primary/50 sm:ms-auto"
                                variant="outline-primary"
                            >
                                <x-base.lucide
                                    class="me-2.5 h-4 w-4 stroke-[1.3]"
                                    icon="Image"
                                />
                                بارگذاری کاور
                            </x-base.button>
                        </div>
                    </div>
                    @if (is_null(request()->query('page')))
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                اطلاعات پروفایل
                            </div>
                            <div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نام کامل</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نام کامل و قانونی خود را به همان شکلی که در
                                                شناسنامه رسمی شما ظاهر می‌شود وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <div class="flex flex-col items-center md:flex-row">
                                            <x-base.form-input
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                                type="text"
                                                placeholder="{{ explode(' ', $users[0]['name'])[0] }}"
                                            />
                                            <x-base.form-input
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                                type="text"
                                                placeholder="{{ explode(' ', $users[0]['name'])[1] }}"
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">تاریخ تولد</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                این اطلاعات برای تأیید سن شما و
                                                ارائه خدمات مناسب سن مورد نیاز است.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.jalali-datepicker />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">جنسیت</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                جنسیت خود را از گزینه‌ها انتخاب کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <div class="flex flex-col items-center md:flex-row">
                                            <div
                                                class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                                <x-base.form-check>
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-1"
                                                        type="radio"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-1">
                                                        Male
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                            <div
                                                class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                                <x-base.form-check>
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-2"
                                                        type="radio"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-2">
                                                        زن
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                            <div
                                                class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                                <x-base.form-check>
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-3"
                                                        type="radio"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-3">
                                                        ترجیح می‌دهم بگویم
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">ایمیل</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفاً یک آدرس ایمیل معتبر که دسترسی به آن دارید را وارد کنید.
                                                دسترسی دارید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['email'] }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">شماره تلفن</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفاً یک شماره تلفن معتبر ارائه دهید تا در صورت نیاز به شما تماس بگیریم.
                                                اگر شما لازم دارید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <div class="flex flex-col items-center md:flex-row">
                                            <x-base.form-input
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                                type="text"
                                                placeholder="{{ $users[0]['phone'] }}"
                                            />
                                            <x-base.form-select
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 md:w-36 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                            >
                                                <option value="office">دفتر</option>
                                                <option value="home">Home</option>
                                            </x-base.form-select>
                                        </div>
                                        <a
                                            class="-mb-1 mt-3.5 flex items-center font-medium text-primary"
                                            href=""
                                        >
                                            <x-base.lucide
                                                class="me-1 h-4 w-4 stroke-[1.3]"
                                                icon="Plus"
                                            />
                                            افزودن تلفن
                                        </a>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">بخش</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                بخش یا بخش خود را از لیست
                                                گزینه‌های موجود انتخاب کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-select>
                                            @foreach ($users->take(5) as $fakerKey => $faker)
                                                <option value="{{ $faker['department'] }}">
                                                    {{ $faker['department'] }}
                                                </option>
                                            @endforeach
                                        </x-base.form-select>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">نوع حساب</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نوع حساب شما ویژگی‌ها و
                                                امتیازهایی که در این پلتفرم دارید را تعیین می‌کند.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <div class="flex flex-col items-center md:flex-row">
                                            <div
                                                class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                                <x-base.form-check>
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-4"
                                                        type="radio"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-4">
                                                        شخصی
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                            <div
                                                class="w-full rounded-md border border-slate-300/60 bg-white px-3 py-2 shadow-sm first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0">
                                                <x-base.form-check>
                                                    <x-base.form-check.input
                                                        id="checkbox-switch-5"
                                                        type="radio"
                                                        value=""
                                                    />
                                                    <x-base.form-check.label for="checkbox-switch-5">
                                                        شرکت
                                                    </x-base.form-check.label>
                                                </x-base.form-check>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">کشور</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفاً کشوری که در حال حاضر در آن زندگی می‌کنید را مشخص کنید.
                                                in.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.tom-select
                                            class="w-full"
                                            data-placeholder="انتخاب your country"
                                        >
                                            @foreach ($countries as $fakerKey => $faker)
                                                <option value="{{ $fakerKey }}">
                                                    {{ $faker['name'] }}
                                                </option>
                                            @endforeach
                                        </x-base.tom-select>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">خط آدرس ۱</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                خط اصلی آدرس فیزیکی خود را وارد کنید،
                                                معمولاً شامل شماره خانه یا ساختمان و
                                                نام خیابان است.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['location'] }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">خط آدرس ۲</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                این فیلد اختیاری است و می‌تواند برای ارائه هر
                                                جزئیات آدرس اضافی مانند شماره آپارتمان،
                                                سوئیت، طبقه یا هر اطلاعات مرتبط دیگر استفاده شود.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['location'] }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">City</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                نام شهر یا محله‌ای که آدرس شما در آن قرار دارد را وارد کنید.
                                                آدرس قرار دارد.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['location'] }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">ایالت / استان</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفا ایالت یا استان خود را از لیست ارائه شده انتخاب کنید.
                                                list.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['location'] }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">کد پستی</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                کد پستی یا ZIP کد مرتبط با آدرس خود را وارد کنید.
                                                آدرس.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ mt_rand(5000, 9000) }}"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">اختصاصی</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                اگر می خواهید دسترسی اختصاصی به برخی از ویژگی ها یا محتوای پلتفرم ما را فعال کنید، این جعبه را علامت بزنید.
                                                به برخی از ویژگی ها یا محتوای مشخص بر روی پلتفرم ما.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-check>
                                            <x-base.form-check.input
                                                id="checkbox-switch-21"
                                                type="checkbox"
                                                value=""
                                            />
                                            <x-base.form-check.label
                                                class="ms-3.5 leading-relaxed text-slate-500"
                                                for="checkbox-switch-21"
                                            >
                                                انتخاب حفظ اختصاصی برای پروتفویل آیتم های خود بر روی این پلتفرم می تواند درآمد شما را به طور قابل توجهی افزایش دهد.
                                                آیتم ها بر روی این پلتفرم می تواند به طور قابل توجهی درآمد شما را افزایش دهد.
                                                earnings.
                                            </x-base.form-check.label>
                                        </x-base.form-check>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'email-settings')
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                تنظیمات ایمیل
                            </div>
                            <div>
                                <div class="text-slate-500">
                                    آدرس ایمیل فعلی شما
                                    <span class="font-medium">
                                        {{ $users[1]['email'] }}
                                    </span>
                                    .
                                </div>
                                <div
                                    class="mt-2 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">آدرس ایمیل جدید</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفاً یک آدرس ایمیل معتبر که دسترسی به آن دارید را وارد کنید.
                                                دسترسی دارید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="{{ $users[0]['email'] }}"
                                        />
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'security')
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                امنیت
                            </div>
                            <div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-64">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">رمز عبور فعلی</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                رمز عبور فعلی خود را وارد کنید تا هویت شما تأیید شود.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="P**********d"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-64">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">رمز عبور جدید</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                رمز عبور جدید برای حساب خود ایجاد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="P**********d"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-64">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">
                                                    تأیید رمز عبور جدید
                                                </div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                لطفاً رمز عبور جدیدی که به تازگی انتخاب کرده‌اید را دوباره وارد کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="P**********d"
                                        />
                                        <div class="mt-4 text-slate-500">
                                            <div class="font-medium">
                                                الزامات رمز عبور:
                                            </div>
                                            <ul class="mt-2.5 flex list-disc flex-col gap-1 ps-3 text-slate-500">
                                                <li class="ps-0.5">
                                                    رمز عبور باید حداقل 8 کاراکتر باشد.
                                                </li>
                                                <li class="ps-0.5">
                                                    حداقل یک رقم عددی (0-9) را در بر بگیرید.
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'preferences')
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                ترجیحات
                            </div>
                            <div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">زبان</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                زبان مورد نظر خود را از زبان‌های موجود انتخاب کنید
                                                options.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.tom-select
                                            class="w-full"
                                            data-placeholder="انتخاب your language"
                                        >
                                            @foreach ($languages as $fakerKey => $faker)
                                                <option value="{{ $faker['code'] }}">
                                                    {{ $faker['name'] }}
                                                </option>
                                            @endforeach
                                        </x-base.tom-select>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">منطقه زمانی</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                منطقه زمانی فعلی خود را از لیست
                                                گزینه‌های موجود انتخاب کنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.tom-select
                                            class="w-full"
                                            data-placeholder="انتخاب your timezone"
                                        >
                                            @foreach ($timezones as $fakerKey => $faker)
                                                <option value="{{ $faker['offset'] }}">
                                                    {{ $faker['name'] }}
                                                </option>
                                            @endforeach
                                        </x-base.tom-select>
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">پشتیبانی از مورد</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                اگر به پشتیبانی اضافی نیاز دارید یا
                                                کمک با مورد خود، این جعبه را علامت بزنید.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-switch.input
                                            id="checkbox-switch-7"
                                            type="checkbox"
                                        />
                                    </div>
                                </div>
                                <div
                                    class="mt-5 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-60">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">موارد برگزیده</div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                اگر می‌خواهید موارد خود را ویژه کنید
                                                یا برجسته شوند در
                                                <a
                                                    class="text-primary"
                                                    href=""
                                                >
                                                    پلتفرم ما
                                                </a>
                                                .
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-switch.input
                                            id="checkbox-switch-8"
                                            type="checkbox"
                                        />
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'two-factor-authentication')
                        <div class="box box--stacked flex flex-col p-5">
                            <div
                                class="mb-6 flex items-center border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                احراز هویت دوعاملی (2FA)
                                <div
                                    class="ms-3 flex items-center rounded-md border border-success/10 bg-success/10 px-1.5 py-px text-xs font-medium text-success">
                                    <span class="-mt-px">فعال شده</span>
                                </div>
                            </div>
                            <div>
                                <div class="text-slate-500">
                                    امنیت حساب خود را با فعالسازی احراز هویت دوعاملی
                                    در تنظیمات افزایش دهید.
                                </div>
                                <div
                                    class="mt-2 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-64">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">رمز عبور حساب</div>
                                                <div
                                                    class="ms-2.5 rounded-md border border-slate-200 bg-slate-100 px-2 py-0.5 text-xs text-slate-500 dark:bg-darkmode-300 dark:text-slate-400">
                                                    ضروری
                                                </div>
                                            </div>
                                            <div class="mt-1.5 text-xs leading-relaxed text-slate-500/80 xl:mt-3">
                                                رمز عبور فعلی خود را وارد کنید تا هویت شما تأیید شود.
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-input
                                            type="text"
                                            placeholder="P**********d"
                                        />
                                        <x-base.form-help>
                                            این رمز عبوری است که برای ورود به حساب کاربری خود استفاده می‌کنید.
                                        </x-base.form-help>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'device-history')
                        <div class="box box--stacked flex flex-col p-5">
                            <div
                                class="mb-6 flex items-center border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                تاریخچه دستگاه
                            </div>
                            <div>
                                <div class="text-slate-500">
                                    دسترسی و کنترل دستگاه‌هایی که در حال حاضر متصل هستند.
                                </div>
                                <div class="mt-5 rounded-lg border border-slate-200/80">
                                    <div class="overflow-auto xl:overflow-visible">
                                        <x-base.table>
                                            <x-base.table.thead>
                                                <x-base.table.tr>
                                                    <x-base.table.td
                                                        class="whitespace-nowrap border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        Browser
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="whitespace-nowrap border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        Device
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="whitespace-nowrap border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        Location
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="whitespace-nowrap border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        فعالیت‌های اخیر
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                            </x-base.table.thead>
                                            <x-base.table.tbody>
                                                @foreach ($recentDevices as $fakerKey => $faker)
                                                    <x-base.table.tr class="[&_td]:last:border-b-0">
                                                        <x-base.table.td
                                                            class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                        >
                                                            <div class="flex items-center whitespace-nowrap">
                                                                <div class="image-fit zoom-in h-4 w-4">
                                                                    <img
                                                                        class="rounded-full shadow-[0px_0px_0px_2px_#fff,_1px_1px_5px_rgba(0,0,0,0.32)] dark:shadow-[0px_0px_0px_2px_#3f4865,_1px_1px_5px_rgba(0,0,0,0.32)]"
                                                                        src="{{ Vite::asset($faker['browser']['image']) }}"
                                                                        alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                    >
                                                                </div>
                                                                <div class="ms-3.5">
                                                                    {{ $faker['browser']['name'] }} on
                                                                    {{ $faker['operatingSystem'] }}
                                                                </div>
                                                            </div>
                                                        </x-base.table.td>
                                                        <x-base.table.td
                                                            class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                        >
                                                            <div class="flex items-center whitespace-nowrap">
                                                                <x-base.lucide
                                                                    class="me-2 h-4 w-4 stroke-[1.3]"
                                                                    icon="Smartphone"
                                                                />
                                                                {{ $faker['device'] }}
                                                                @if (!$fakerKey)
                                                                    <div
                                                                        class="ms-3 flex items-center rounded-md border border-primary/10 bg-primary/10 px-1.5 py-px text-xs font-medium text-primary">
                                                                        <span class="-mt-px">Current</span>
                                                                    </div>
                                                                @endif
                                                            </div>
                                                        </x-base.table.td>
                                                        <x-base.table.td
                                                            class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                        >
                                                            <div class="whitespace-nowrap">
                                                                {{ $faker['location'] }}
                                                            </div>
                                                        </x-base.table.td>
                                                        <x-base.table.td
                                                            class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                        >
                                                            <div class="whitespace-nowrap">
                                                                {{ $faker['activity'] }}
                                                            </div>
                                                        </x-base.table.td>
                                                    </x-base.table.tr>
                                                @endforeach
                                            </x-base.table.tbody>
                                        </x-base.table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'notification-settings')
                        <div class="box box--stacked flex flex-col p-5">
                            <div
                                class="mb-6 flex items-center border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                تنظیمات اعلان
                            </div>
                            <div>
                                <x-base.alert
                                    class="mb-2 flex items-center border-primary/20 bg-primary/5 px-4"
                                    variant="outline-primary"
                                >
                                    <div>
                                        <x-base.lucide
                                            class="me-3 h-4 w-4 stroke-[1.3] md:me-2"
                                            icon="AlertCircle"
                                        />
                                    </div>
                                    <div class="me-5 leading-relaxed">
                                        ما اجازه مرورگر شما را برای درخواست
                                        نمایش اعلان‌ها می‌خواهیم.
                                        <a
                                            class="ms-1 font-medium underline decoration-warning/50 decoration-dotted underline-offset-[3px]"
                                            href=""
                                        >
                                            درخواست اجازه
                                        </a>
                                        <x-base.alert.dismiss-button class="btn-close inset-y-0">
                                            <x-base.lucide
                                                class="h-4 w-4"
                                                icon="X"
                                            />
                                        </x-base.alert.dismiss-button>
                                    </div>
                                </x-base.alert>
                                <div class="mt-5 rounded-lg border border-slate-200/80">
                                    <div class="overflow-auto xl:overflow-visible">
                                        <x-base.table>
                                            <x-base.table.thead>
                                                <x-base.table.tr>
                                                    <x-base.table.td
                                                        class="border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        Type
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        <div class="flex flex-col items-center">
                                                            <x-base.lucide
                                                                class="h-6 w-6"
                                                                icon="MailCheck"
                                                            />
                                                            <div class="mt-1.5">ایمیل</div>
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        <div class="flex flex-col items-center">
                                                            <x-base.lucide
                                                                class="h-6 w-6"
                                                                icon="Globe"
                                                            />
                                                            <div class="mt-1.5">Browser</div>
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-slate-200/80 bg-slate-50 py-4 font-medium text-slate-500 first:rounded-ss-lg last:rounded-se-lg"
                                                    >
                                                        <div class="flex flex-col items-center">
                                                            <x-base.lucide
                                                                class="h-6 w-6"
                                                                icon="Smartphone"
                                                            />
                                                            <div class="mt-1.5">App</div>
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                            </x-base.table.thead>
                                            <x-base.table.tbody>
                                                <x-base.table.tr class="[&_td]:last:border-b-0">
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="whitespace-nowrap">
                                                            فعالیت ورود غیرمعمول شناسایی شد
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-3"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-4"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-5"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                                <x-base.table.tr class="[&_td]:last:border-b-0">
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="flex items-center whitespace-nowrap">
                                                            درخواست تغییر گذرواژه
                                                            <x-base.lucide
                                                                class="ms-1.5 h-4 w-4 stroke-[1.3] text-slate-400"
                                                                icon="Info"
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-6"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-7"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-8"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                                <x-base.table.tr class="[&_td]:last:border-b-0">
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="whitespace-nowrap">
                                                            پیام جدید دریافت شد
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-9"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-10"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-11"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                                <x-base.table.tr class="[&_td]:last:border-b-0">
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="whitespace-nowrap">
                                                            خلاصه فعالیت حساب
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-12"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-13"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-14"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                                <x-base.table.tr class="[&_td]:last:border-b-0">
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="flex items-center whitespace-nowrap">
                                                            هشدار امنیتی: دستگاه نامشخص
                                                            <x-base.lucide
                                                                class="ms-1.5 h-4 w-4 stroke-[1.3] text-slate-400"
                                                                icon="Info"
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-15"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-16"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                    <x-base.table.td
                                                        class="border-dashed border-slate-300/70 py-4 dark:bg-darkmode-600"
                                                    >
                                                        <div class="text-center">
                                                            <x-base.form-check.input
                                                                id="checkbox-switch-17"
                                                                type="checkbox"
                                                                value=""
                                                            />
                                                        </div>
                                                    </x-base.table.td>
                                                </x-base.table.tr>
                                            </x-base.table.tbody>
                                        </x-base.table>
                                    </div>
                                </div>
                                <div
                                    class="mt-3 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-1/2">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">
                                                    کی مایلید اعلان‌ها را دریافت کنید؟
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <x-base.form-select>
                                            <option value="فوراً">فوراً</option>
                                            <option value="صبح">صبح</option>
                                            <option value="ظهر">ظهر</option>
                                            <option value="عصر">
                                                عصر
                                            </option>
                                            <option value="شب">شب</option>
                                            <option value="شبانه">شبانه</option>
                                            <option value="یکبار در روز">یکبار در روز</option>
                                            <option value="دوبار در روز">دوبار در روز</option>
                                            <option value="زمان‌بندی دلخواه">زمان‌بندی دلخواه</option>
                                            <option value="اعلان‌ها را ارسال نکنید">
                                                اعلان‌ها را ارسال نکنید
                                            </option>
                                        </x-base.form-select>
                                    </div>
                                </div>
                                <div
                                    class="mt-3 block flex-col pt-5 first:mt-0 first:pt-0 sm:flex xl:flex-row xl:items-center">
                                    <div class="mb-2 inline-block sm:mb-0 sm:me-5 sm:text-end xl:me-14 xl:w-1/2">
                                        <div class="text-start">
                                            <div class="flex items-center">
                                                <div class="font-medium">
                                                    یک بررسی روزانه ('خلاصه روزانه') از
                                                    فعالیت وظیفه‌های شما دریافت کنید.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3 w-full flex-1 xl:mt-0">
                                        <div class="flex flex-col items-center md:flex-row">
                                            <x-base.form-select
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                            >
                                                <option value="هر روز">هر روز</option>
                                                <option value="یکبار در روز">یکبار در روز</option>
                                                <option value="دوبار در روز">دوبار در روز</option>
                                                <option value="بدون بررسی روزانه (غیرفعال سازی خلاصه روزانه)">
                                                    بدون بررسی روزانه (غیرفعال سازی خلاصه روزانه)
                                                </option>
                                            </x-base.form-select>
                                            <x-base.form-select
                                                class="first:rounded-b-none last:-mt-px last:rounded-t-none focus:z-10 first:md:rounded-e-none first:md:rounded-es-md last:md:-ms-px last:md:mt-0 last:md:rounded-s-none last:md:rounded-se-md [&:not(:first-child):not(:last-child)]:-mt-px [&:not(:first-child):not(:last-child)]:rounded-none [&:not(:first-child):not(:last-child)]:md:-ms-px [&:not(:first-child):not(:last-child)]:md:mt-0"
                                            >
                                                <option value="ساعت 8:00 صبح">ساعت 8:00 صبح</option>
                                                <option value="ساعت 12:00 ظهر">ساعت 12:00 ظهر</option>
                                                <option value="ساعت 4:00 عصر">ساعت 4:00 عصر</option>
                                                <option value="ساعت 8:00 شب">ساعت 8:00 شب</option>
                                            </x-base.form-select>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-7 text-slate-500">
                                    برای کاهش وقفه‌ها، اعلان‌های ایمیل گروه‌بندی و
                                    زمانی که از دستگاه خود فعال استفاده نمی‌کنید تحویل داده می‌شوند.
                                </div>
                            </div>
                            <div class="mt-6 flex border-t border-dashed border-slate-300/70 pt-5 md:justify-end">
                                <x-base.button
                                    class="w-full border-primary/50 px-4 md:w-auto"
                                    variant="outline-primary"
                                >
                                    ذخیره تغییرات
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'connected-services')
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                خدمات متصل
                            </div>
                            <div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Linkedin"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">لینکدین</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                شبکه حرفه‌ای و پروفایل حرفه‌ای
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.form-switch.input
                                                id="checkbox-switch-71"
                                                type="checkbox"
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Dribbble"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">دریبل</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                نمونه‌کارها و کارهای خلاقانه طراحی
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.form-switch.input
                                                id="checkbox-switch-8"
                                                type="checkbox"
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Facebook"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">فیس‌بوک</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                ارتباطات اجتماعی و به‌روزرسانی‌های شخصی
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.form-switch.input
                                                id="checkbox-switch-9"
                                                type="checkbox"
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Instagram"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">اینستاگرام</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                داستان‌ها و عکس‌های تصویری
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.form-switch.input
                                                id="checkbox-switch-10"
                                                type="checkbox"
                                            />
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Twitter"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">توییتر</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                میکروبلاگینگ و به‌روزرسانی‌های زمان واقعی
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.form-switch.input
                                                id="checkbox-switch-11"
                                                type="checkbox"
                                            />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'social-media-links')
                        <div class="box box--stacked flex flex-col p-5">
                            <div class="mb-6 border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                پیوندهای رسانه‌های اجتماعی
                            </div>
                            <div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Linkedin"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">لینکدین</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                متصل نیست
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.button
                                                class="border-primary/50 bg-primary/5 px-4 text-primary"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                    icon="UserPlus"
                                                />
                                                اتصال
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Twitter"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">دریبل</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                متصل نیست
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.button
                                                class="border-primary/50 bg-primary/5 px-4 text-primary"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                    icon="UserPlus"
                                                />
                                                اتصال
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Facebook"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">فیس‌بوک</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                <a
                                                    class="text-xs text-primary underline decoration-primary/30 decoration-dotted underline-offset-[3px]"
                                                    href=""
                                                >
                                                    www.facebook.com/
                                                    {{ str_replace(' ', '', strtolower($users[0]['name'])) }}
                                                </a>
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.button
                                                class="border-primary/50 bg-primary/5 px-4 text-primary"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                    icon="Check"
                                                />
                                                متصل
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Instagram"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">اینستاگرام</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                متصل نیست
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.button
                                                class="border-primary/50 bg-primary/5 px-4 text-primary"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                    icon="UserPlus"
                                                />
                                                اتصال
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-2.5 flex items-center pt-2.5 first:mt-0 first:pt-0 last:mb-2">
                                    <div>
                                        <div
                                            class="ms-2 flex h-10 w-10 items-center justify-center rounded-full border border-primary/10 bg-primary/10">
                                            <x-base.lucide
                                                class="h-4 w-4 fill-primary/10 stroke-[1.3] text-primary"
                                                icon="Twitter"
                                            />
                                        </div>
                                    </div>
                                    <div class="ms-5 flex w-full flex-col gap-y-2.5 sm:flex-row sm:items-center">
                                        <div>
                                            <div class="flex items-center">
                                                <div class="font-medium">توییتر</div>
                                            </div>
                                            <div class="mt-1 pe-10 text-xs leading-relaxed text-slate-500">
                                                <a
                                                    class="text-xs text-primary underline decoration-primary/30 decoration-dotted underline-offset-[3px]"
                                                    href=""
                                                >
                                                    www.twitter.com/
                                                    {{ str_replace(' ', '', strtolower($users[0]['name'])) }}
                                                </a>
                                            </div>
                                        </div>
                                        <div class="flex w-full flex-1 sm:justify-end">
                                            <x-base.button
                                                class="border-primary/50 bg-primary/5 px-4 text-primary"
                                                variant="primary"
                                            >
                                                <x-base.lucide
                                                    class="-ms-0.5 me-2 h-4 w-4 stroke-[1.3]"
                                                    icon="Check"
                                                />
                                                متصل
                                            </x-base.button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (request()->query('page') === 'account-deactivation')
                        <div class="box box--stacked flex flex-col p-5">
                            <div
                                class="mb-6 flex items-center border-b border-dashed border-slate-300/70 pb-5 text-[0.94rem] font-medium">
                                غیرفعال‌سازی حساب کاربری
                            </div>
                            <div>
                                <div class="leading-relaxed">
                                    زمانی که فرایند حذف حساب کاربری را آغاز می‌کنید، دیگر
                                    دسترسی به خدمات حساب کاربری Front را ندارید و
                                    داده‌های شخصی شما به طور دائم حذف می‌شود. شما یک دوره 10 روزه دارید
                                    برای لغو حذف در صورت نیاز.
                                </div>
                                <x-base.form-check class="mt-5">
                                    <x-base.form-check.input
                                        id="checkbox-switch-1"
                                        type="checkbox"
                                        value=""
                                    />
                                    <x-base.form-check.label for="checkbox-switch-1">
                                        تایید کنید که می‌خواهم حساب کاربری خود را حذف کنم.
                                    </x-base.form-check.label>
                                </x-base.form-check>
                            </div>
                            <div
                                class="mt-6 flex flex-col-reverse gap-3 border-t border-dashed border-slate-300/70 pt-5 md:flex-row md:justify-end">
                                <x-base.button
                                    class="w-full px-4 md:w-auto"
                                    variant="outline-secondary"
                                >
                                    بیشتر بدانید
                                </x-base.button>
                                <x-base.button
                                    class="w-full border-danger/50 bg-danger/5 px-4 md:w-auto"
                                    variant="outline-danger"
                                >
                                    حذف
                                </x-base.button>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
