@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex flex-col mt-4 gap-y-3 md:mt-0 md:h-10 md:flex-row md:items-center">
                <div class="text-base font-medium group-[.mode--light]:text-white">
                    سرریز
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    با استفاده از مؤلفه های اسلاید از بین برده، گفتگوهای چندمنظوره
                    برای محتوای سفارشی، گزینه های اندازه گیری و ...
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative flex flex-col col-span-12 gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    لغوی تهی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    مؤلفه "لغوی تهی" ابزاری چندمنظوره است
                                    که به شما امکان می دهد اسلاید از بین برده قابل تنظیم ایجاد کنید
                                    گفتگوهایی برای اهداف مختلف در وب سایت شما است.
                                    یک کانوا تمیز و ساده برای شما برای اضافه کردن
                                    محتوای خود، این کار را مناسب برای یک مجموعه گسترده از استفاده ها می کند.
                                    cases.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Slide Over Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#basic-slide-over-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش اسلاید بیرونی
                                                </x-base.button>
                                            </div>
                                            <!-- END: Slide Over Toggle -->
                                            <!-- BEGIN: Slide Over Content -->
                                            <x-base.slideover id="basic-slide-over-preview">
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            لغوی تهی
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>

                                                        این کاملاً اسلاید خالی عالی است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Slide Over Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Slide Over Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#basic-slide-over-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش اسلاید بیرونی
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Slide Over Toggle -->
                                                <!-- BEGIN: Slide Over Content -->
                                                <x-base.slideover id="basic-slide-over-preview">
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                لغوی تهی
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>

                                                            این کاملاً اسلاید خالی عالی است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Slide Over Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    آیا می خواهید اطلاعات اضافی را نمایش دهید،
                                    ورودی کاربر را جمع آوری کنید یا به روز رسانی های مهم را ارائه دهید،
                                    "Blank Slideover" یک راه حل انعطاف پذیر است که اطمینان می دهد
                                    محتوای شما قابل دسترس و جذاب باقی مانده است. کاوش کنید
                                    امکانات و راه های جدیدی برای تعامل باز کنید
                                    مخاطب خود با استفاده از مؤلفه "Blank Slideover".
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                     اندازه پنجره کشویی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "اندازه پنجره کشویی" به شما این امکان را می دهد که
                                    ابعاد پنجره های کشویی خود را کنترل کنید و اطمینان حاصل کنید که
                                    آنها از نظر بصری جذاب و کاملاً متناسب با
                                    محتوای شما هستند. با چندین گزینه اندازه در دسترس، شما
                                    می توانید موردی را انتخاب کنید که بهترین تناسب را داشته باشد
                                    case.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <!-- BEGIN: Small Slide Over Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#small-slide-over-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش پنجره کشویی کوچک
                                                </x-base.button>
                                                <!-- END: Small Slide Over Toggle -->
                                                <!-- BEGIN: Medium Slide Over Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#medium-slide-over-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش پنجره کشویی متوسط
                                                </x-base.button>
                                                <!-- END: Medium Slide Over Toggle -->
                                                <!-- BEGIN: Large Slide Over Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#large-slide-over-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش پنجره کشویی بزرگ
                                                </x-base.button>
                                                <!-- END: Large Slide Over Toggle -->
                                                <!-- BEGIN: Super Large Slide Over Toggle -->
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#superlarge-slide-over-size-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش پنجره کشویی بسیار بزرگ
                                                </x-base.button>
                                                <!-- END: Super Large Slide Over Toggle -->
                                            </div>
                                            <!-- BEGIN: Small Slide Over Content -->
                                            <x-base.slideover
                                                id="small-slide-over-size-preview"
                                                size="sm"
                                            >
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی کوچک
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>
                                                        این یک پنجره کشویی کوچک فوق العاده است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Small Slide Over Content -->
                                            <!-- BEGIN: Medium Slide Over Content -->
                                            <x-base.slideover id="medium-slide-over-size-preview">
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی متوسط
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>
                                                        این یک پنجره کشویی متوسط فوق العاده است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Medium Slide Over Content -->
                                            <!-- BEGIN: Large Slide Over Content -->
                                            <x-base.slideover
                                                id="large-slide-over-size-preview"
                                                size="lg"
                                            >
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی بزرگ
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>
                                                        این یک پنجره کشویی بزرگ فوق العاده است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Large Slide Over Content -->
                                            <!-- BEGIN: Super Large Slide Over Content -->
                                            <x-base.slideover
                                                id="superlarge-slide-over-size-preview"
                                                size="xl"
                                            >
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی بسیار بزرگ
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>
                                                        این یک پنجره کشویی فوق العاده با اندازه بزرگ است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Super Large Slide Over Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <!-- BEGIN: Small Slide Over Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#small-slide-over-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش پنجره کشویی کوچک
                                                    </x-base.button>
                                                    <!-- END: Small Slide Over Toggle -->
                                                    <!-- BEGIN: Medium Slide Over Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#medium-slide-over-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش پنجره کشویی متوسط
                                                    </x-base.button>
                                                    <!-- END: Medium Slide Over Toggle -->
                                                    <!-- BEGIN: Large Slide Over Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#large-slide-over-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش پنجره کشویی بزرگ
                                                    </x-base.button>
                                                    <!-- END: Large Slide Over Toggle -->
                                                    <!-- BEGIN: Super Large Slide Over Toggle -->
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#superlarge-slide-over-size-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش پنجره کشویی بسیار بزرگ
                                                    </x-base.button>
                                                    <!-- END: Super Large Slide Over Toggle -->
                                                </div>
                                                <!-- BEGIN: Small Slide Over Content -->
                                                <x-base.slideover
                                                    id="small-slide-over-size-preview"
                                                    size="sm"
                                                >
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی کوچک
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>
                                                            این یک پنجره کشویی کوچک فوق العاده است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Small Slide Over Content -->
                                                <!-- BEGIN: Medium Slide Over Content -->
                                                <x-base.slideover id="medium-slide-over-size-preview">
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی متوسط
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>
                                                            این یک پنجره کشویی متوسط فوق العاده است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Medium Slide Over Content -->
                                                <!-- BEGIN: Large Slide Over Content -->
                                                <x-base.slideover
                                                    id="large-slide-over-size-preview"
                                                    size="lg"
                                                >
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی بزرگ
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>
                                                            این یک پنجره کشویی بزرگ فوق العاده است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Large Slide Over Content -->
                                                <!-- BEGIN: Super Large Slide Over Content -->
                                                <x-base.slideover
                                                    id="superlarge-slide-over-size-preview"
                                                    size="xl"
                                                >
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی بسیار بزرگ
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>
                                                            این یک پنجره کشویی فوق العاده با اندازه بزرگ است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Super Large Slide Over Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اندازه پنجره کشویی خود را برای ایجاد
                                    یک تجربه کاربرپسند و بصری جذاب تنظیم کنید. اینکه
                                    شما به یک اعلان فشرده یا یک فرم جادار نیاز دارید،
                                    “سایز پنجره کشویی” به شما انعطاف پذیری لازم را می دهد
                                    برای دستیابی به چیدمان دلخواه خود. گزینه های اندازه مختلف را کاوش کنید
                                    و تجربه کاربری وب سایت خود را با
                                    “سایز پنجره کشویی” ارتقا دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    پنجره کشویی با دکمه بستن
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "پنجره کشویی با دکمه بستن" لایه اضافی از
                                    راحتی کاربر را به پنجره های کشویی شما اضافه می کند.
                                    گفتگوها. این ویژگی به کاربران امکان می دهد تا به راحتی اسلاید اوور را با کلیک کردن روی دکمه بستن رد کنند و تجربه کلی کاربر را بهبود بخشد.
                                    slide-over by clicking a close button, enhancing the
                                    overall user با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Modal Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#button-slide-over-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش اسلاید بیرونی
                                                </x-base.button>
                                            </div>
                                            <!-- END: Modal Toggle -->
                                            <!-- BEGIN: Modal Content -->
                                            <x-base.slideover
                                                id="button-slide-over-preview"
                                                staticBackdrop
                                            >
                                                <x-base.slideover.panel>
                                                    <a
                                                        class="absolute top-0 start-0 end-auto mt-4 -ms-10 sm:-ms-12"
                                                        data-tw-dismiss="modal"
                                                        href="#"
                                                    >
                                                        <x-base.lucide
                                                            class="w-8 h-8 text-slate-400"
                                                            icon="X"
                                                        />
                                                    </a>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی با دکمه بستن
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description>
                                                        این یک پنجره کشویی فوق العاده با دکمه بستن است!
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Modal Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Modal Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#button-slide-over-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش اسلاید بیرونی
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Modal Toggle -->
                                                <!-- BEGIN: Modal Content -->
                                                <x-base.slideover
                                                    id="button-slide-over-preview"
                                                    staticBackdrop
                                                >
                                                    <x-base.slideover.panel>
                                                        <a
                                                            class="absolute top-0 start-0 end-auto mt-4 -ms-10 sm:-ms-12"
                                                            data-tw-dismiss="modal"
                                                            href="#"
                                                        >
                                                            <x-base.lucide
                                                                class="w-8 h-8 text-slate-400"
                                                                icon="X"
                                                            />
                                                        </a>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی با دکمه بستن
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description>
                                                            این یک پنجره کشویی فوق العاده با دکمه بستن است!
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Modal Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    کامپوننت "پنجره کشویی با دکمه بستن" تعامل کاربر را با ارائه روشی واضح و شهودی برای بستن پنجره کشویی بهبود می بخشد. این مورد به ویژه برای سناریوهایی مفید است که کاربران ممکن است بخواهند بدون اینکه از صفحه فعلی خارج شوند، گفتگو را به سرعت خروج یا به حداقل برسانند.
                                    user interaction by offering a clear and intuitive
                                    method for closing the slide-over. It's particularly
                                    useful for scenarios where users may want to quickly
                                    exit or minimize the dialog without navigating away from
                                    the current page.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    پنجره کشویی روی هم قرار گرفته
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    "پنجره کشویی روی هم قرار گرفته" یک ویژگی همه کاره است که
                                    به شما امکان می دهد گفتگوهای کشویی لایه ای را در برنامه وب خود ایجاد کنید. این ویژگی برای سناریوهایی که نیاز به ارائه اطلاعات یا اقدامات به صورت متوالی در حالی که کاربر را متمرکز نگه می دارد، ایده آل است.
                                    برنامه وب شما. این ویژگی برای سناریوهایی که نیاز به ارائه اطلاعات یا اقدامات به صورت متوالی در حالی که کاربر را متمرکز نگه می دارد، ایده آل است.
                                    سناریوهایی که نیاز به ارائه اطلاعات یا
                                    اقدامات به صورت متوالی در حالی که کاربر را
                                    focused.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Slide Over Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#overlapping-slide-over-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش اسلاید بیرونی
                                                </x-base.button>
                                            </div>
                                            <!-- END: Slide Over Toggle -->
                                            <!-- BEGIN: Slide Over Content -->
                                            <x-base.slideover id="overlapping-slide-over-preview">
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            پنجره کشویی روی هم قرار گرفته
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description class="px-5 py-10">
                                                        <div class="text-center">
                                                            <div class="mb-5">
                                                                برای نمایش اسلاید روی هم بر روی دکمه زیر کلیک کنید!
                                                                روی هم!
                                                            </div>
                                                            <!-- BEGIN: Overlapping Slide Over Toggle -->
                                                            <x-base.button
                                                                data-tw-toggle="modal"
                                                                data-tw-target="#next-overlapping-slide-over-preview"
                                                                href="#"
                                                                as="a"
                                                                variant="primary"
                                                            >
                                                                نمایش اسلاید روی هم
                                                            </x-base.button>
                                                            <!-- END: Overlapping Slide Over Toggle -->
                                                            <!-- BEGIN: Overlapping Slide Over Content -->
                                                            <x-base.slideover id="next-overlapping-slide-over-preview">
                                                                <x-base.slideover.panel>
                                                                    <x-base.slideover.title class="p-5">
                                                                        <h2 class="me-auto text-base font-medium">
                                                                            پنجره کشویی روی هم قرار گرفته
                                                                        </h2>
                                                                    </x-base.slideover.title>
                                                                    <x-base.slideover.description class="text-center">
                                                                        این یک اسلاید روی هم فوق العاده است
                                                                        روی هم!
                                                                    </x-base.slideover.description>
                                                                </x-base.slideover.panel>
                                                            </x-base.slideover>
                                                            <!-- END: Overlapping Slide Over Content -->
                                                        </div>
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Slide Over Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Slide Over Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#overlapping-slide-over-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش اسلاید بیرونی
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Slide Over Toggle -->
                                                <!-- BEGIN: Slide Over Content -->
                                                <x-base.slideover id="overlapping-slide-over-preview">
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                پنجره کشویی روی هم قرار گرفته
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description class="px-5 py-10">
                                                            <div class="text-center">
                                                                <div class="mb-5">
                                                                    برای نمایش اسلاید روی هم بر روی دکمه زیر کلیک کنید!
                                                                    روی هم!
                                                                </div>
                                                                <!-- BEGIN: Overlapping Slide Over Toggle -->
                                                                <x-base.button
                                                                    data-tw-toggle="modal"
                                                                    data-tw-target="#next-overlapping-slide-over-preview"
                                                                    href="#"
                                                                    as="a"
                                                                    variant="primary"
                                                                >
                                                                    نمایش اسلاید روی هم
                                                                </x-base.button>
                                                                <!-- END: Overlapping Slide Over Toggle -->
                                                                <!-- BEGIN: Overlapping Slide Over Content -->
                                                                <x-base.slideover id="next-overlapping-slide-over-preview">
                                                                    <x-base.slideover.panel>
                                                                        <x-base.slideover.title class="p-5">
                                                                            <h2 class="me-auto text-base font-medium">
                                                                                پنجره کشویی روی هم قرار گرفته
                                                                            </h2>
                                                                        </x-base.slideover.title>
                                                                        <x-base.slideover.description class="text-center">
                                                                            این یک اسلاید روی هم فوق العاده است
                                                                            روی هم!
                                                                        </x-base.slideover.description>
                                                                    </x-base.slideover.panel>
                                                                </x-base.slideover>
                                                                <!-- END: Overlapping Slide Over Content -->
                                                            </div>
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Slide Over Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    ویژگی "پنجره کشویی روی هم قرار گرفته" روشی کاربرپسند برای ارائه اطلاعات یا اقدامات به صورت مرحله ای ارائه می دهد و اطمینان می دهد که کاربران می توانند روی یک قطعه محتوا در یک زمان تمرکز کنند. این ابزار ارزشمندی برای ایجاد تجربیات کاربری جذاب و هدایت کاربران در گردش کارهای پیچیده است. امکانات این ویژگی را برای بهبود قابلیت استفاده و تعامل برنامه وب خود کاوش کنید.
                                    روشی کاربرپسند برای ارائه اطلاعات یا اقدامات به صورت مرحله ای
                                    به تدریج، اطمینان حاصل کنید که کاربران می توانند روی یک
                                    قطعه محتوا در یک زمان تمرکز کنند. این ابزار ارزشمندی برای
                                    ایجاد تجربیات کاربری جذاب و هدایت کاربران
                                    در گردش کارهای پیچیده است. امکانات این ویژگی را برای بهبود قابلیت استفاده و تعامل برنامه وب خود کاوش کنید.
                                    این ویژگی برای بهبود قابلیت استفاده و تعامل برنامه وب خود کاوش کنید.
                                    و تعامل.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    پنجره کشویی هدر و فوتر
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "پنجره کشویی هدر و فوتر" ابزاری قدرتمند
                                    برای ایجاد پنجره های کشویی با هدر و فوترهای سفارشی سازی شده است. این ویژگی به شما امکان می دهد محتوا را به کاربران خود ارائه دهید در حالی که یک رابط کاربری ثابت را حفظ می کنید و عملکردهای اضافی را در بخش های هدر و فوتر ارائه می دهید.
                                    هدر و فوتر. این ویژگی به شما امکان می دهد تا
                                    محتوا را به کاربران خود ارائه دهید در حالی که یک رابط کاربری ثابت را حفظ می کنید
                                    و عملکردهای اضافی را در بخش های هدر و فوتر ارائه می دهید.
                                    بخش های هدر و فوتر ارائه می دهید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Slide Over Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tw-toggle="modal"
                                                    data-tw-target="#header-footer-slide-over-preview"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش اسلاید بیرونی
                                                </x-base.button>
                                            </div>
                                            <!-- END: Slide Over Toggle -->
                                            <!-- BEGIN: Slide Over Content -->
                                            <x-base.slideover
                                                id="header-footer-slide-over-preview"
                                                staticBackdrop
                                            >
                                                <!-- BEGIN: Slide Over Header -->
                                                <x-base.slideover.panel>
                                                    <a
                                                        class="absolute top-0 start-0 end-auto mt-4 -ms-10 sm:-ms-12"
                                                        data-tw-dismiss="modal"
                                                        href="#"
                                                    >
                                                        <x-base.lucide
                                                            class="w-8 h-8 text-slate-400"
                                                            icon="X"
                                                        />
                                                    </a>
                                                    <x-base.slideover.title>
                                                        <h2 class="me-auto text-base font-medium">
                                                            پیام پخش
                                                        </h2>
                                                        <x-base.button
                                                            class="hidden sm:flex"
                                                            variant="outline-secondary"
                                                        >
                                                            <x-base.lucide
                                                                class="w-4 h-4 me-2"
                                                                icon="File"
                                                            />
                                                            دانلود اسناد
                                                        </x-base.button>
                                                        <x-base.menu class="sm:hidden">
                                                            <x-base.menu.button
                                                                class="block w-5 h-5"
                                                                href="#"
                                                                as="a"
                                                            >
                                                                <x-base.lucide
                                                                    class="w-5 h-5 text-slate-500"
                                                                    icon="MoreHorizontal"
                                                                />
                                                            </x-base.menu.button>
                                                            <x-base.menu.items class="w-40">
                                                                <x-base.menu.item>
                                                                    <x-base.lucide
                                                                        class="w-4 h-4 me-2"
                                                                        icon="File"
                                                                    />
                                                                    دانلود اسناد
                                                                </x-base.menu.item>
                                                            </x-base.menu.items>
                                                        </x-base.menu>
                                                    </x-base.slideover.title>
                                                    <!-- END: Slide Over Header -->
                                                    <!-- BEGIN: Slide Over Body -->
                                                    <x-base.slideover.description>
                                                        <div>
                                                            <x-base.form-label for="modal-form-1">From</x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-1"
                                                                type="text"
                                                                placeholder="example@gmail.com"
                                                            />
                                                        </div>
                                                        <div class="mt-3">
                                                            <x-base.form-label for="modal-form-2">To</x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-2"
                                                                type="text"
                                                                placeholder="example@gmail.com"
                                                            />
                                                        </div>
                                                        <div class="mt-3">
                                                            <x-base.form-label for="modal-form-3">
                                                                Subject
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-3"
                                                                type="text"
                                                                placeholder="Important Meeting"
                                                            />
                                                        </div>
                                                        <div class="mt-3">
                                                            <x-base.form-label for="modal-form-4">
                                                                کلمات را دارد
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-4"
                                                                type="text"
                                                                placeholder="Job, Work, مستندات"
                                                            />
                                                        </div>
                                                        <div class="mt-3">
                                                            <x-base.form-label for="modal-form-5">
                                                                ندارد
                                                            </x-base.form-label>
                                                            <x-base.form-input
                                                                id="modal-form-5"
                                                                type="text"
                                                                placeholder="Job, Work, مستندات"
                                                            />
                                                        </div>
                                                        <div class="mt-3">
                                                            <x-base.form-label for="modal-form-6">Size</x-base.form-label>
                                                            <x-base.form-select id="modal-form-6">
                                                                <option>10</option>
                                                                <option>25</option>
                                                                <option>35</option>
                                                                <option>50</option>
                                                            </x-base.form-select>
                                                        </div>
                                                    </x-base.slideover.description>
                                                    <!-- END: Slide Over Body -->
                                                    <!-- BEGIN: Slide Over Footer -->
                                                    <x-base.slideover.footer>
                                                        <x-base.button
                                                            class="w-20 me-1"
                                                            data-tw-dismiss="modal"
                                                            type="button"
                                                            variant="outline-secondary"
                                                        >
                                                            Cancel
                                                        </x-base.button>
                                                        <x-base.button
                                                            class="w-20"
                                                            type="button"
                                                            variant="primary"
                                                        >
                                                            Send
                                                        </x-base.button>
                                                    </x-base.slideover.footer>
                                                </x-base.slideover.panel>
                                                <!-- END: Slide Over Footer -->
                                            </x-base.slideover>
                                            <!-- END: Slide Over Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Slide Over Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tw-toggle="modal"
                                                        data-tw-target="#header-footer-slide-over-preview"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش اسلاید بیرونی
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Slide Over Toggle -->
                                                <!-- BEGIN: Slide Over Content -->
                                                <x-base.slideover
                                                    id="header-footer-slide-over-preview"
                                                    staticBackdrop
                                                >
                                                    <!-- BEGIN: Slide Over Header -->
                                                    <x-base.slideover.panel>
                                                        <a
                                                            class="absolute top-0 start-0 end-auto mt-4 -ms-10 sm:-ms-12"
                                                            data-tw-dismiss="modal"
                                                            href="#"
                                                        >
                                                            <x-base.lucide
                                                                class="w-8 h-8 text-slate-400"
                                                                icon="X"
                                                            />
                                                        </a>
                                                        <x-base.slideover.title>
                                                            <h2 class="me-auto text-base font-medium">
                                                                پیام پخش
                                                            </h2>
                                                            <x-base.button
                                                                class="hidden sm:flex"
                                                                variant="outline-secondary"
                                                            >
                                                                <x-base.lucide
                                                                    class="w-4 h-4 me-2"
                                                                    icon="File"
                                                                />
                                                                دانلود اسناد
                                                            </x-base.button>
                                                            <x-base.menu class="sm:hidden">
                                                                <x-base.menu.button
                                                                    class="block w-5 h-5"
                                                                    href="#"
                                                                    as="a"
                                                                >
                                                                    <x-base.lucide
                                                                        class="w-5 h-5 text-slate-500"
                                                                        icon="MoreHorizontal"
                                                                    />
                                                                </x-base.menu.button>
                                                                <x-base.menu.items class="w-40">
                                                                    <x-base.menu.item>
                                                                        <x-base.lucide
                                                                            class="w-4 h-4 me-2"
                                                                            icon="File"
                                                                        />
                                                                        دانلود اسناد
                                                                    </x-base.menu.item>
                                                                </x-base.menu.items>
                                                            </x-base.menu>
                                                        </x-base.slideover.title>
                                                        <!-- END: Slide Over Header -->
                                                        <!-- BEGIN: Slide Over Body -->
                                                        <x-base.slideover.description>
                                                            <div>
                                                                <x-base.form-label for="modal-form-1">
                                                                    From
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-1"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <x-base.form-label for="modal-form-2">
                                                                    To
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-2"
                                                                    type="text"
                                                                    placeholder="example@gmail.com"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <x-base.form-label for="modal-form-3">
                                                                    Subject
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-3"
                                                                    type="text"
                                                                    placeholder="Important Meeting"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <x-base.form-label for="modal-form-4">
                                                                    کلمات را دارد
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-4"
                                                                    type="text"
                                                                    placeholder="Job, Work, مستندات"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <x-base.form-label for="modal-form-5">
                                                                    ندارد
                                                                </x-base.form-label>
                                                                <x-base.form-input
                                                                    id="modal-form-5"
                                                                    type="text"
                                                                    placeholder="Job, Work, مستندات"
                                                                />
                                                            </div>
                                                            <div class="mt-3">
                                                                <x-base.form-label for="modal-form-6">
                                                                    Size
                                                                </x-base.form-label>
                                                                <x-base.form-select id="modal-form-6">
                                                                    <option>10</option>
                                                                    <option>25</option>
                                                                    <option>35</option>
                                                                    <option>50</option>
                                                                </x-base.form-select>
                                                            </div>
                                                        </x-base.slideover.description>
                                                        <!-- END: Slide Over Body -->
                                                        <!-- BEGIN: Slide Over Footer -->
                                                        <x-base.slideover.footer>
                                                            <x-base.button
                                                                class="w-20 me-1"
                                                                data-tw-dismiss="modal"
                                                                type="button"
                                                                variant="outline-secondary"
                                                            >
                                                                Cancel
                                                            </x-base.button>
                                                            <x-base.button
                                                                class="w-20"
                                                                type="button"
                                                                variant="primary"
                                                            >
                                                                Send
                                                            </x-base.button>
                                                        </x-base.slideover.footer>
                                                    </x-base.slideover.panel>
                                                    <!-- END: Slide Over Footer -->
                                                </x-base.slideover>
                                                <!-- END: Slide Over Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    کامپوننت "پنجره کشویی هدر و فوتر" شما را قادر می سازد
                                    گفتگوهای کشویی پویا ایجاد کنید که هم آموزنده و هم تعاملی باشند. شما به راحتی می توانید بخش های هدر و فوتر را برای مطابقت با نیازهای برنامه خود تنظیم کنید و آن را به راه حلی همه کاره برای طیف وسیعی از موارد استفاده تبدیل کنید. تجربه کاربری خود را با ارائه محتوا با وضوح و ارائه اقدامات شهودی به کاربران از طریق این ویژگی ارتقا دهید.
                                    آموزنده و تعاملی باشند. شما به راحتی می توانید
                                    بخش های هدر و فوتر را برای مطابقت با نیازهای برنامه خود تنظیم کنید
                                    با توجه به نیازها، این یک راه حل چند منظوره برای یک دسته گسترده از موارد است.
                                    موارد استفاده. تجربه کاربری خود را با ارائه محتوا با وضوح بهبود دهید
                                     و ارائه عملکردهای مفهومی به کاربران از طریق این ویژگی را بهبود بخشید.
                                    عملیات از طریق این ویژگی را انجام دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمایش/پنهان کردن اسلاید از طریق برنامه نویسی
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    ویژگی "نمایش/پنهان کردن اسلاید از طریق برنامه نویسی" به شما امکان کنترل را از طریق کد می دهد.
                                    این قابلیت را به شما می دهد که قابلیت کنترل ارتباط از طریق کد را داشته باشید.
                                    قابلیت نمایش اسلاید-اور دیالوگ از طریق کد خود را فراهم می کند.
                                    این قابلیت به شما اجازه می دهد تا باز شدن
                                    بستن، یا تغییر وضعیت اسلاید اور را به صورت برنامه نویسی انجام دهید.
                                    تجربه کاربری پیوسته و تعاملی فراهم می کند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Show Slide Over Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    class="mb-2 me-1"
                                                    id="programmatically-show-slideover"
                                                    href="#"
                                                    as="a"
                                                    variant="primary"
                                                >
                                                    نمایش اسلاید بیرونی
                                                </x-base.button>
                                            </div>
                                            <!-- END: Show Slide Over Toggle -->
                                            <!-- BEGIN: Slide Over Content -->
                                            <x-base.slideover id="programmatically-slideover">
                                                <x-base.slideover.panel>
                                                    <x-base.slideover.title class="p-5">
                                                        <h2 class="me-auto text-base font-medium">
                                                            نمایش/پنهان کردن اسلاید از طریق برنامه نویسی
                                                        </h2>
                                                    </x-base.slideover.title>
                                                    <x-base.slideover.description class="p-10 text-center">
                                                        <!-- BEGIN: Hide Slide Over Toggle -->
                                                        <x-base.button
                                                            class="me-1"
                                                            id="programmatically-hide-slideover"
                                                            href="#"
                                                            as="a"
                                                            variant="primary"
                                                        >
                                                            پنهان کردن اسلاید اور
                                                        </x-base.button>
                                                        <!-- END: Hide Slide Over Toggle -->
                                                        <!-- BEGIN: Toggle Slide Over Toggle -->
                                                        <x-base.button
                                                            class="mt-2 me-1 sm:mt-0"
                                                            id="programmatically-toggle-slideover"
                                                            href="#"
                                                            as="a"
                                                            variant="primary"
                                                        >
                                                            تغییر وضعیت اسلاید اور
                                                        </x-base.button>
                                                        <!-- END: Toggle Slide Over Toggle -->
                                                    </x-base.slideover.description>
                                                </x-base.slideover.panel>
                                            </x-base.slideover>
                                            <!-- END: Slide Over Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Show Slide Over Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        class="mb-2 me-1"
                                                        id="programmatically-show-slideover"
                                                        href="#"
                                                        as="a"
                                                        variant="primary"
                                                    >
                                                        نمایش اسلاید بیرونی
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Show Slide Over Toggle -->
                                                <!-- BEGIN: Slide Over Content -->
                                                <x-base.slideover id="programmatically-slideover">
                                                    <x-base.slideover.panel>
                                                        <x-base.slideover.title class="p-5">
                                                            <h2 class="me-auto text-base font-medium">
                                                                نمایش/پنهان کردن اسلاید از طریق برنامه نویسی
                                                            </h2>
                                                        </x-base.slideover.title>
                                                        <x-base.slideover.description class="p-10 text-center">
                                                            <!-- BEGIN: Hide Slide Over Toggle -->
                                                            <x-base.button
                                                                class="me-1"
                                                                id="programmatically-hide-slideover"
                                                                href="#"
                                                                as="a"
                                                                variant="primary"
                                                            >
                                                                پنهان کردن اسلاید اور
                                                            </x-base.button>
                                                            <!-- END: Hide Slide Over Toggle -->
                                                            <!-- BEGIN: Toggle Slide Over Toggle -->
                                                            <x-base.button
                                                                class="mt-2 me-1 sm:mt-0"
                                                                id="programmatically-toggle-slideover"
                                                                href="#"
                                                                as="a"
                                                                variant="primary"
                                                            >
                                                                تغییر وضعیت اسلاید اور
                                                            </x-base.button>
                                                            <!-- END: Toggle Slide Over Toggle -->
                                                        </x-base.slideover.description>
                                                    </x-base.slideover.panel>
                                                </x-base.slideover>
                                                <!-- END: Slide Over Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    ویژگی "نمایش/پنهان کردن اسلاید از طریق برنامه نویسی"
                                    این ویژگی کنترل شما را بر روی اسلاید اور
                                    را ارتقاء می دهد، آن را به یک عنصر پویا و واکنش پذیر در
                                    رابط کاربری خود تبدیل می کند. با استفاده از این
                                    روش های برنامه نویسی، شما می توانید تجربه های کاربری جذابی را ایجاد کنید و
                                    پنهان کردن اسلاید اور را به دلخواه خود تنظیم کنید تا
                                    به نیازهای برنامه خود بپردازید. آیا این برای نمایش اطلاعات اضافی
                                    ، ذخیره ورودی کاربر یا ارائه
                                    تعاملات مبتنی بر متن، این ویژگی به شما قدرت می دهد که
                                    کنترل کاملی بر دیالوگ های اسلاید اور خود را داشته باشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div
                            class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Slideover</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای استفاده از Slideover (پیش‌فرض "div").
                                                    (پیش‌فرض "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`open`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    نشان می‌دهد که Slideover باز یا بسته است (پیش‌فرض نادرست است).
                                                    (پیش‌فرض نادرست است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onClose`</x-base.table.td>
                                                <x-base.table.td>`function`</x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابعی که باید فراخوانی شود زمانی که Slideover بسته شود.
                                                    closed.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`staticBackdrop`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    اگر درست باشد، زمینه Slideover ثابت می‌ماند زمانی که
                                                    Slideover بسته است (پیش‌فرض نادرست است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`size`</x-base.table.td>
                                                <x-base.table.td>`Size`</x-base.table.td>
                                                <x-base.table.td>
                                                    اندازه Slideover که می‌تواند "sm،" "md،" "lg،" یا "xl" باشد (پیش‌فرض "md").
                                                    (پیش‌فرض "md").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Slideover.Panel</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای استفاده از Slideover (پیش‌فرض "div").
                                                    پنل (پیش‌فرض "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Slideover.Title</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای استفاده از Slideover (پیش‌فرض "div").
                                                    عنوان (پیش‌فرض "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Slideover.Description</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای استفاده از Slideover (پیش‌فرض "div").
                                                    توضیحات (پیش‌فرض "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Slideover.Footer</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML برای استفاده از Slideover (پیش‌فرض "div").
                                                    پاورقی (پیش‌فرض "div").
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    لغوی تهی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                     اندازه پنجره کشویی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    پنجره کشویی با دکمه بستن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    پنجره کشویی روی هم قرار گرفته
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    پنجره کشویی هدر و فوتر
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    نمایش/پنهان کردن اسلاید از طریق برنامه نویسی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@pushOnce('scripts')
    @vite('resources/js/pages/slideover.js')
@endPushOnce
