@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    اسلایدر
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    جهان اسلایدرهای تعاملی را با اجزای اسلایدر ما بکاوید.
                    کاربران را جذب کنید، ورودی‌ها را جمع‌آوری کنید، و تجربیات کاربر را بهبود ببخشید
                    effortlessly.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مورد تکی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "اسلایدر کوچک" سبک و
                                    کتابخانه اسلایدر/کاروسل پاسخگو برای نمایش تصاویر
                                    یا محتوا به صورت اسلایدشو. این بخش بر روی
                                    استفاده از Tiny Slider برای ایجاد یک اسلایدر تک موردی ساده تمرکز دارد
                                    که برای نمایش یک قطعه از
                                    محتوا در هر زمان مفید است، مانند تصویر برجسته یا
                                    product.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mx-6">
                                                <x-base.tiny-slider
                                                    id="single-item-slider"
                                                    config="single-item"
                                                >
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                1
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                2
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                3
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                4
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                5
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                6
                                                            </h3>
                                                        </div>
                                                    </div>
                                                </x-base.tiny-slider>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mx-6">
                                                    <x-base.tiny-slider
                                                        id="single-item-slider"
                                                        config="single-item"
                                                    >
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    1
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    2
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    3
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    4
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    5
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    6
                                                                </h3>
                                                            </div>
                                                        </div>
                                                    </x-base.tiny-slider>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اسلایدر تک موردی ایجاد شده با استفاده از Tiny Slider یک
                                    انتخاب عالی است زمانی که باید محتوا را یک
                                    قلمرو از هنری که یک قلمرو زمانی که
                                    بصری دلپذیر و پاسخگو است. شما می‌توانید به راحتی این اسلایدر را به وب سایت خود ادغام کنید
                                    برای نمایش تصاویر برجسته، محصولات،
                                    یا هر محتوای دیگری که از یک
                                    presentation.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    مورد چندگانه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "اسلایدر کوچک" به شما امکان می‌دهد تا اسلایدرها و کاروسل‌های پاسخگو و دارای ویژگی‌های بیشتر را برای
                                    نمایش چند مورد به صورت همزمان ایجاد کنید. این بخش بر روی
                                    استفاده از Tiny Slider برای ایجاد یک اسلایدر چند مورد،
                                    که برای نمایش یک مجموعه از تصاویر،
                                    محصولات یا محتوا به صورت کامپکت و جذاب
                                    مناسب است.
                                    format.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mx-6">
                                                <x-base.tiny-slider
                                                    id="multiple-item-slider"
                                                    config="multiple-items"
                                                >
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                1
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                2
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                3
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                4
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                5
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                6
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                7
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                8
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                9
                                                            </h3>
                                                        </div>
                                                    </div>
                                                </x-base.tiny-slider>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mx-6">
                                                    <x-base.tiny-slider
                                                        id="multiple-item-slider"
                                                        config="multiple-items"
                                                    >
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    1
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    2
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    3
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    4
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    5
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    6
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    7
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    8
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    9
                                                                </h3>
                                                            </div>
                                                        </div>
                                                    </x-base.tiny-slider>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اسلایدر چند موردی که با استفاده از Tiny Slider ایجاد شده است، یک
                                    اجزای چند منظوره برای نمایش مجموعه‌هایی از
                                    محتوا، تصاویر یا محصولات به صورت جذاب و
                                    پاسخگو. با دنبال کردن مراحل مشخص شده بالا
                                    و تنظیمات اسلایدر را برای برآورده کردن
                                    نیازهای خاص خود سفارشی‌سازی کنید، می‌توانید
                                    وب‌سایت یا برنامه خود را با یک
                                    کاروسل تعاملی و کاربرپسند بهبود ببخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    نمایش پاسخگو
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "Tiny Slider" راهی آسان برای
                                    ایجاد اسلایدرها و کاروسل‌های پاسخگو که با
                                    اندازه‌های مختلف صفحه سازگاری دارند. این بخش بر روی
                                    پیکربندی Tiny Slider برای نمایش پاسخگو تمرکز دارد و اطمینان حاصل می‌کند که
                                    که اسلایدر شما به صورت بی‌درز و با
                                    عملکرد صحیح در هر دو دستگاه رایانه شخصی و تلفن همراه عمل می‌کند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mx-6 pb-8">
                                                <x-base.tiny-slider
                                                    id="responsive-slider"
                                                    config="responsive"
                                                >
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                1
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                2
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                3
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                4
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                5
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                6
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                7
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                8
                                                            </h3>
                                                        </div>
                                                    </div>
                                                </x-base.tiny-slider>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mx-6 pb-8">
                                                    <x-base.tiny-slider
                                                        id="responsive-slider"
                                                        config="responsive"
                                                    >
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    1
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    2
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    3
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    4
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    5
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    6
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    7
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    8
                                                                </h3>
                                                            </div>
                                                        </div>
                                                    </x-base.tiny-slider>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    با پیکربندی Tiny Slider با تنظیمات پاسخگو، شما
                                    اطمینان حاصل می‌کنید که اسلایدر شما به زیبایی با
                                    انواع دستگاه‌ها و اندازه‌های صفحه سازگار است. این انعطاف‌پذیری تجربه کاربری را بهبود می‌بخشد و اطمینان می‌دهد که محتوای شما
                                    در هر دو پلتفرم رایانه شخصی و تلفن همراه دیده
                                    شده باشد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    حالت مرکز
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    حالت مرکز یک پیکربندی اسلایدر محبوب است که
                                    اسلاید فعال را در مرکز ظرف اسلایدر قرار می‌دهد و
                                    اسلایدهایی که به صورت جزئی قابل مشاهده هستند را در هر دو طرف قرار می‌دهد. این باعث ایجاد یک افکت کاروسل جذاب و دیدنی می‌شود.
                                    این اقدام باعث ایجاد یک کاروسل جذاب و دیدنی می‌شود. این بخش نحوه پیکربندی Tiny
                                    اسلایدر را برای دستیابی به حالت مرکز را نشان می‌دهد.
                                    با اسلایدر برای دستیابی به حالت مرکز.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mx-6">
                                                <x-base.tiny-slider
                                                    id="center-mode-slider"
                                                    config="center-mode"
                                                >
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                1
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                2
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                3
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                4
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                5
                                                            </h3>
                                                        </div>
                                                    </div>
                                                    <div class="h-32 px-2">
                                                        <div class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                            <h3
                                                                class="flex h-full items-center justify-center text-2xl font-medium">
                                                                6
                                                            </h3>
                                                        </div>
                                                    </div>
                                                </x-base.tiny-slider>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mx-6">
                                                    <x-base.tiny-slider
                                                        id="center-mode-slider"
                                                        config="center-mode"
                                                    >
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    1
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    2
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    3
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    4
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    5
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="h-32 px-2">
                                                            <div
                                                                class="h-full rounded-md bg-slate-100 dark:bg-darkmode-400">
                                                                <h3
                                                                    class="flex h-full items-center justify-center text-2xl font-medium">
                                                                    6
                                                                </h3>
                                                            </div>
                                                        </div>
                                                    </x-base.tiny-slider>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    حالت مرکز یک پیکربندی اسلایدر محبوب است که
                                    اسلاید فعال را در مرکز ظرف اسلایدر قرار می‌دهد و
                                    اسلایدهایی که به صورت جزئی قابل مشاهده هستند را در هر دو طرف قرار می‌دهد. این باعث ایجاد یک افکت کاروسل جذاب و دیدنی می‌شود.
                                    این اقدام باعث ایجاد یک کاروسل جذاب و دیدنی می‌شود. این بخش نحوه پیکربندی Tiny
                                    اسلایدر را برای دستیابی به حالت مرکز را نشان می‌دهد.
                                    با اسلایدر برای دستیابی به حالت مرکز.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انیمیشن محو شدن
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    انیمیشن محو شدن یک روش شیک و زیبا برای انتقال است
                                    بین اسلایدها در یک اسلایدر است. Tiny Slider یک
                                    پیکربندی ساده برای دستیابی به اثر محو شدن را زمانی که
                                    انتقال از یک اسلاید به دیگری. این بخش
                                    نشان می دهد چگونه Tiny Slider را با انیمیشن پژواک راه اندازی کنید.
                                    انیمیشن.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="mx-6 pb-8">
                                                <x-base.tiny-slider
                                                    id="fade-animation-slider"
                                                    config="fade-mode"
                                                >
                                                    <div class="h-64 px-2">
                                                        <div class="image-fit h-full overflow-hidden rounded-md">
                                                            <img
                                                                src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                alt="تیل وایز - قالب داشبورد مدیریتی"
                                                            >
                                                        </div>
                                                    </div>
                                                    <div class="h-64 px-2">
                                                        <div class="image-fit h-full overflow-hidden rounded-md">
                                                            <img
                                                                src="{{ Vite::asset($products[1]['images'][0]['path']) }}"
                                                                alt="تیل وایز - قالب داشبورد مدیریتی"
                                                            >
                                                        </div>
                                                    </div>
                                                    <div class="h-64 px-2">
                                                        <div class="image-fit h-full overflow-hidden rounded-md">
                                                            <img
                                                                src="{{ Vite::asset($products[2]['images'][0]['path']) }}"
                                                                alt="تیل وایز - قالب داشبورد مدیریتی"
                                                            >
                                                        </div>
                                                    </div>
                                                </x-base.tiny-slider>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="mx-6 pb-8">
                                                    <x-base.tiny-slider
                                                        id="fade-animation-slider"
                                                        config="fade-mode"
                                                    >
                                                        <div class="h-64 px-2">
                                                            <div class="image-fit h-full overflow-hidden rounded-md">
                                                                <img
                                                                    src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                    alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                >
                                                            </div>
                                                        </div>
                                                        <div class="h-64 px-2">
                                                            <div class="image-fit h-full overflow-hidden rounded-md">
                                                                <img
                                                                    src="{{ Vite::asset($products[1]['images'][0]['path']) }}"
                                                                    alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                >
                                                            </div>
                                                        </div>
                                                        <div class="h-64 px-2">
                                                            <div class="image-fit h-full overflow-hidden rounded-md">
                                                                <img
                                                                    src="{{ Vite::asset($products[2]['images'][0]['path']) }}"
                                                                    alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                >
                                                            </div>
                                                        </div>
                                                    </x-base.tiny-slider>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    انیمیشن پژواک در Tiny Slider یک روش صاف و
                                    جذاب برای گذر بین اسلایدها فراهم می کند.
                                    به خصوص برای اسلایدرهایی که نیاز به
                                    منتقل کردن حس از روشنایی و شیوه است. با پژواک
                                    انیمیشن فعال شده، اسلایدر شما به طور یکپارچه خواهد آمد
                                    و بیرون برای اسلایدها، ایجاد کاربر جذب کننده ایجاد می کند
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">TinySlider</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: TinySliderElement) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابع که یک مرجع به
                                                    عنصر ظرف TinySlider دریافت می کند.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`TinySliderSettings`</x-base.table.td>
                                                <x-base.table.td>
                                                    تنظیمات و گزینه های پیکربندی برای
                                                    TinySlider. به صورت پیش فرض به یک شیء خالی.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مورد تکی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    مورد چندگانه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نمایش پاسخگو
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    حالت مرکز
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انیمیشن محو شدن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
