@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex items-center h-10">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    Tab
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    کامپوننت تب کشف کنید، ناوبری را با تب‌های چندمنظوره بهبود بخشید –
                    از سبک‌های کلاسیک تا جعبه‌ای!
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative flex flex-col col-span-12 gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    تب پایه
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-11"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-11"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "تب پایه" یک راه ساده و
                                    به طور قابل فهم برای ایجاد محتوای تبی برای وب
                                    اپلیکیشن‌ها فراهم می‌کند. به راحتی اطلاعات را سازماندهی و نمایش دهید
                                    در یک رابط کاربری تمیز تب‌خورده.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tab.group>
                                                <x-base.tab.list variant="tabs">
                                                    <x-base.tab
                                                        id="example-1-tab"
                                                        selected
                                                    >
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 1
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                    <x-base.tab id="example-2-tab">
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 2
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                </x-base.tab.list>
                                                <x-base.tab.panels class="border-b border-s border-e">
                                                    <x-base.tab.panel
                                                        class="p-5 leading-relaxed"
                                                        id="example-1"
                                                        selected
                                                    >
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        از زمان 1500 میلادی، زمانی که یک چاپگر ناشناخته
                                                        یک گالری از نوع و آن را مخلوط کرد تا
                                                        یک کتاب نمونه نوع بسازد. این کتاب نه تنها زنده ماند
                                                        پنج قرن، بلکه به افزایش
                                                        چاپ الکترونیکی نوع، اساسا باقی مانده است
                                                        بدون تغییر. در دهه ۱۹۶۰ محبوب شد
                                                        با انتشار برگه‌های Letraset حاوی
                                                        متون لورم ایپسوم، و اخیراً با
                                                        نرم‌افزارهای دسکتاپ پابلیشینگ مانند Aldus
                                                        PageMaker شامل نسخه‌هایی از لورم ایپسوم بود.
                                                    </x-base.tab.panel>
                                                    <x-base.tab.panel
                                                        class="p-5 leading-relaxed"
                                                        id="example-2"
                                                    >
                                                        این یک واقعیت بسیار قدیمی است که خواننده
                                                        توسط محتوای قابل خواندن یک صفحه
                                                        هنگام نگاه به طرح آن حواس پرت خواهد شد. هدف
                                                        استفاده از Lorem Ipsum این است که یک
                                                        توزیع نسبتاً عادی از حروف داشته باشد،
                                                        برخلاف استفاده از 'محتوا اینجا، محتوا
                                                        اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                        از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                        از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                        جستجو برای 'lorem ipsum' ممکن است
                                                        بسیاری از وب‌سایت‌های هنوز در دوران
                                                        کودکی خود هستند. نسخه‌های مختلف در طول
                                                        سال‌ها تکامل یافته‌اند، گاهی از طریق حادثه، گاهی از روی
                                                        اهداف (طنز و موارد مشابه).
                                                    </x-base.tab.panel>
                                                </x-base.tab.panels>
                                            </x-base.tab.group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tab.group>
                                                    <x-base.tab.list variant="tabs">
                                                        <x-base.tab
                                                            id="example-1-tab"
                                                            selected
                                                        >
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 1
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                        <x-base.tab id="example-2-tab">
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 2
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                    </x-base.tab.list>
                                                    <x-base.tab.panels class="border-b border-s border-e">
                                                        <x-base.tab.panel
                                                            class="p-5 leading-relaxed"
                                                            id="example-1"
                                                            selected
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            تغییر نکرده است. این در دهه ۱۹۶۰ با انتشار
                                                            برگه‌های Letraset شامل Lorem Ipsum
                                                            و به تازگی‌تر با نرم‌افزارهای دسکتاپ
                                                            انتشار صفحه‌مانند Aldus PageMaker شامل نسخه‌هایی از
                                                            Lorem Ipsum.
                                                        </x-base.tab.panel>
                                                        <x-base.tab.panel
                                                            class="p-5 leading-relaxed"
                                                            id="example-2"
                                                        >
                                                            این یک واقعیت بسیار قدیمی است که خواننده will be
                                                            توسط محتوای قابل خواندن یک صفحه هنگام
                                                            نگاه به طرح آن حواس پرت خواهد شد. هدف استفاده از Lorem Ipsum
                                                            این است که یک توزیع نسبتاً عادی از
                                                            حروف داشته باشد، بر خلاف استفاده از 'محتوا اینجا، محتوا
                                                            اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                            از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                            از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                            جستجو برای 'lorem ipsum' ممکن است
                                                            بسیاری از وب‌سایت‌های هنوز در دوران
                                                            کودکی خود هستند. نسخه‌های مختلف در طول
                                                            اهداف (طنز و موارد مشابه).
                                                        </x-base.tab.panel>
                                                    </x-base.tab.panels>
                                                </x-base.tab.group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    تب جعبه‌ای
                                </div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-12"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-12"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "تب جعبه‌ای" یک رابط تبی منحصر به فرد را ارائه می‌دهد
                                    با ظاهر جعبه‌ای. این یک انتخاب عالی است زمانی که می‌خواهید
                                    محتوای تبی را به یک
                                    سبک متمایز نمایش دهید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tab.group>
                                                <x-base.tab.list variant="boxed-tabs">
                                                    <x-base.tab
                                                        id="example-3-tab"
                                                        selected
                                                    >
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 1
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                    <x-base.tab id="example-4-tab">
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 2
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                </x-base.tab.list>
                                                <x-base.tab.panels class="mt-5">
                                                    <x-base.tab.panel
                                                        class="leading-relaxed"
                                                        id="example-3"
                                                        selected
                                                    >
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        از زمان 1500 میلادی، زمانی که یک چاپگر ناشناخته
                                                        یک گالری از نوع و آن را مخلوط کرد تا
                                                        یک کتاب نمونه نوع بسازد. این کتاب نه تنها زنده ماند
                                                        پنج قرن، بلکه به افزایش
                                                        چاپ الکترونیکی نوع، اساسا باقی مانده است
                                                        بدون تغییر. در دهه ۱۹۶۰ محبوب شد
                                                        با انتشار برگه‌های Letraset حاوی
                                                        متون لورم ایپسوم، و اخیراً با
                                                        نرم‌افزارهای دسکتاپ پابلیشینگ مانند Aldus
                                                        PageMaker شامل نسخه‌هایی از لورم ایپسوم بود.
                                                    </x-base.tab.panel>
                                                    <x-base.tab.panel
                                                        class="leading-relaxed"
                                                        id="example-4"
                                                    >
                                                        این یک واقعیت بسیار قدیمی است که خواننده
                                                        توسط محتوای قابل خواندن یک صفحه
                                                        هنگام نگاه به طرح آن حواس پرت خواهد شد. هدف
                                                        استفاده از Lorem Ipsum این است که یک
                                                        توزیع نسبتاً عادی از حروف داشته باشد،
                                                        برخلاف استفاده از 'محتوا اینجا، محتوا
                                                        اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                        از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                        از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                        جستجو برای 'lorem ipsum' ممکن است
                                                        بسیاری از وب‌سایت‌های هنوز در دوران
                                                        کودکی خود هستند. نسخه‌های مختلف در طول
                                                        سال‌ها تکامل یافته‌اند، گاهی از طریق حادثه، گاهی از روی
                                                        اهداف (طنز و موارد مشابه).
                                                    </x-base.tab.panel>
                                                </x-base.tab.panels>
                                            </x-base.tab.group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tab.group>
                                                    <x-base.tab.list variant="boxed-tabs">
                                                        <x-base.tab
                                                            id="example-5-tab"
                                                            selected
                                                        >
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 1
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                        <x-base.tab id="example-6-tab">
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 2
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                    </x-base.tab.list>
                                                    <x-base.tab.panels class="mt-5">
                                                        <x-base.tab.panel
                                                            class="leading-relaxed"
                                                            id="example-5"
                                                            selected
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            تغییر نکرده است. این در دهه ۱۹۶۰ با انتشار
                                                            برگه‌های Letraset شامل Lorem Ipsum
                                                            و به تازگی‌تر با نرم‌افزارهای دسکتاپ
                                                            انتشار صفحه‌مانند Aldus PageMaker شامل نسخه‌هایی از
                                                            Lorem Ipsum.
                                                        </x-base.tab.panel>
                                                        <x-base.tab.panel
                                                            class="leading-relaxed"
                                                            id="example-6"
                                                        >
                                                            این یک واقعیت بسیار قدیمی است که خواننده will be
                                                            توسط محتوای قابل خواندن یک صفحه هنگام
                                                            نگاه به طرح آن حواس پرت خواهد شد. هدف استفاده از Lorem Ipsum
                                                            این است که یک توزیع نسبتاً عادی از
                                                            حروف داشته باشد، بر خلاف استفاده از 'محتوا اینجا، محتوا
                                                            اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                            از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                            از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                            جستجو برای 'lorem ipsum' ممکن است
                                                            بسیاری از وب‌سایت‌های هنوز در دوران
                                                            کودکی خود هستند. نسخه‌های مختلف در طول
                                                            اهداف (طنز و موارد مشابه).
                                                        </x-base.tab.panel>
                                                    </x-base.tab.panels>
                                                </x-base.tab.group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <x-base.preview-component>
                            <div
                                class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">تب لینک</div>
                                <x-base.form-switch class="w-full mt-3 sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-13"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-13"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    کامپوننت "تب لینک" یک رابط تبی تمیز و ساده ارائه می‌دهد
                                    با دکمه‌های مانند لینک. این یک انتخاب عالی است زمانی که می‌خواهید
                                    محتوای تبی را با یک
                                    طراحی کم حجم.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 px-3 ms-4 -mt-2 text-xs uppercase bg-white text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tab.group>
                                                <x-base.tab.list variant="link-tabs">
                                                    <x-base.tab
                                                        id="example-7-tab"
                                                        selected
                                                    >
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 1
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                    <x-base.tab id="example-8-tab">
                                                        <x-base.tab.button
                                                            class="w-full py-2"
                                                            as="button"
                                                        >
                                                            مثال تب 2
                                                        </x-base.tab.button>
                                                    </x-base.tab>
                                                </x-base.tab.list>
                                                <x-base.tab.panels class="mt-5">
                                                    <x-base.tab.panel
                                                        class="leading-relaxed"
                                                        id="example-7"
                                                        selected
                                                    >
                                                        متن آزمایشی است
                                                        صنعت چاپ و تنظیم‌مجدد متن است.
                                                        این متن از سال‌های 1500 میلادی استاندارد صنعتی برای
                                                        از زمان 1500 میلادی، زمانی که یک چاپگر ناشناخته
                                                        یک گالری از نوع و آن را مخلوط کرد تا
                                                        یک کتاب نمونه نوع بسازد. این کتاب نه تنها زنده ماند
                                                        پنج قرن، بلکه به افزایش
                                                        چاپ الکترونیکی نوع، اساسا باقی مانده است
                                                        بدون تغییر. در دهه ۱۹۶۰ محبوب شد
                                                        با انتشار برگه‌های Letraset حاوی
                                                        متون لورم ایپسوم، و اخیراً با
                                                        نرم‌افزارهای دسکتاپ پابلیشینگ مانند Aldus
                                                        PageMaker شامل نسخه‌هایی از لورم ایپسوم بود.
                                                    </x-base.tab.panel>
                                                    <x-base.tab.panel
                                                        class="leading-relaxed"
                                                        id="example-8"
                                                    >
                                                        این یک واقعیت بسیار قدیمی است که خواننده
                                                        توسط محتوای قابل خواندن یک صفحه
                                                        هنگام نگاه به طرح آن حواس پرت خواهد شد. هدف
                                                        استفاده از Lorem Ipsum این است که یک
                                                        توزیع نسبتاً عادی از حروف داشته باشد،
                                                        برخلاف استفاده از 'محتوا اینجا، محتوا
                                                        اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                        از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                        از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                        جستجو برای 'lorem ipsum' ممکن است
                                                        بسیاری از وب‌سایت‌های هنوز در دوران
                                                        کودکی خود هستند. نسخه‌های مختلف در طول
                                                        سال‌ها تکامل یافته‌اند، گاهی از طریق حادثه، گاهی از روی
                                                        اهداف (طنز و موارد مشابه).
                                                    </x-base.tab.panel>
                                                </x-base.tab.panels>
                                            </x-base.tab.group>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tab.group>
                                                    <x-base.tab.list variant="link-tabs">
                                                        <x-base.tab
                                                            id="example-9-tab"
                                                            selected
                                                        >
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 1
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                        <x-base.tab id="example-1-tab0">
                                                            <x-base.tab.button
                                                                class="w-full py-2"
                                                                as="button"
                                                            >
                                                                مثال تب 2
                                                            </x-base.tab.button>
                                                        </x-base.tab>
                                                    </x-base.tab.list>
                                                    <x-base.tab.panels class="mt-5">
                                                        <x-base.tab.panel
                                                            class="leading-relaxed"
                                                            id="example-9"
                                                            selected
                                                        >
                                                            لورم ایپسوم به طور ساده متن مجازی چاپ و and
                                                            صنعت زیبا‌نویسی بوده است. Lorem Ipsum از آن زمان
                                                            متن بی‌هویه استاندارد این صنعت بوده است، از سال 1500 میلادی،
                                                            زمانی که یک چاپگر ناشناخته یک گالری از نوع گرفت و
                                                            آن را برای ساختن یک کتاب نمونه نوع مخلوط کرد. این
                                                            نه تنها پنج قرن زنده مانده است، بلکه همچنین پرش
                                                            به زیبا‌نویسی الکترونیک، اساساً باقی مانده است،
                                                            تغییر نکرده است. این در دهه ۱۹۶۰ با انتشار
                                                            برگه‌های Letraset شامل Lorem Ipsum
                                                            و به تازگی‌تر با نرم‌افزارهای دسکتاپ
                                                            انتشار صفحه‌مانند Aldus PageMaker شامل نسخه‌هایی از
                                                            Lorem Ipsum.
                                                        </x-base.tab.panel>
                                                        <x-base.tab.panel
                                                            class="leading-relaxed"
                                                            id="example-10"
                                                        >
                                                            این یک واقعیت بسیار قدیمی است که خواننده will be
                                                            توسط محتوای قابل خواندن یک صفحه هنگام
                                                            نگاه به طرح آن حواس پرت خواهد شد. هدف استفاده از Lorem Ipsum
                                                            این است که یک توزیع نسبتاً عادی از
                                                            حروف داشته باشد، بر خلاف استفاده از 'محتوا اینجا، محتوا
                                                            اینجا'، آن را شبیه به انگلیسی قابل خواندن می‌کند. بسیاری
                                                            از بسته‌های انتشار دسکتاپ و ویرایشگرهای صفحه وب اکنون
                                                            از Lorem Ipsum به عنوان متن مدل پیش‌فرض خود استفاده می‌کنند، و
                                                            جستجو برای 'lorem ipsum' ممکن است
                                                            بسیاری از وب‌سایت‌های هنوز در دوران
                                                            کودکی خود هستند. نسخه‌های مختلف در طول
                                                            اهداف (طنز و موارد مشابه).
                                                        </x-base.tab.panel>
                                                    </x-base.tab.panels>
                                                </x-base.tab.group>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="flex flex-col p-5 box box--stacked">
                        <div
                            class="flex flex-col pb-5 mb-5 border-b border-dashed border-slate-300/70 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`fullWidth`</x-base.table.td>
                                                <x-base.table.td>`boolean`</x-base.table.td>
                                                <x-base.table.td>
                                                    آیا تب باید عرض کامل را پوشش دهد؟
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.Button</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    Element type (e.g., "a", "button") for the tab
                                                    button.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.Group</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.List</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`variant`</x-base.table.td>
                                                <x-base.table.td>
                                                    `tabs`, `pills`, `boxed-tabs`, `link-tabs`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    استیل متغیر برای سر تصویر (پیش‌فرض
                                                    استایل "تب‌ها" است).
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.Panels</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tab.Panel</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td
                                                    class="text-center"
                                                    colspan="3"
                                                >
                                                    No spesific props
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    تب پایه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    تب جعبه‌ای
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    تب لینک
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="block -mt-px truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
