@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    انتخاب تام
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت اجزای انتخاب تام ما را برای ایجاد
                    ورودی‌های انتخابی قابل تنظیم و کاربرپسند در برنامه‌های وب خود کشف کنید.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب ابتدایی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "انتخاب ابتدایی" یک منوی کشویی ساده فراهم می‌کند
                                    برای انتخاب گزینه‌ها از لیست است. این یک
                                    عنصر رابط کاربری اساسی برای جمع‌آوری ورودی کاربر در
                                    فرم یک گزینه از گزینه‌های متعدد است.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Basic Select -->
                                            <div>
                                                <label>پایه</label>
                                                <div class="mt-2">
                                                    <x-base.tom-select
                                                        class="w-full"
                                                        data-placeholder="انتخاب your favorite actors"
                                                    >
                                                        <option value="1">لئوناردو دی‌کاپریو</option>
                                                        <option value="2">جانی دیپ</option>
                                                        <option value="3">رابرت داونی‌ جونیور</option>
                                                        <option value="4">ساموئل ال. جکسون</option>
                                                        <option value="5">مورگان فریمن</option>
                                                    </x-base.tom-select>
                                                </div>
                                            </div>
                                            <!-- END: Basic Select -->
                                            <!-- BEGIN: Nested Select -->
                                            <div class="mt-3">
                                                <label>تودرتو</label>
                                                <div class="mt-2">
                                                    <x-base.tom-select
                                                        class="w-full"
                                                        data-placeholder="انتخاب your favorite actors"
                                                    >
                                                        <optgroup label="American Actors">
                                                            <option value="1">لئوناردو دی‌کاپریو</option>
                                                            <option value="2">جانی دیپ</option>
                                                            <option value="3">رابرت داونی‌ جونیور</option>
                                                            <option value="4">ساموئل ال. جکسون</option>
                                                            <option value="5">مورگان فریمن</option>
                                                        </optgroup>
                                                        <optgroup label="American Actresses">
                                                            <option value="6">اسکارلت جوهانسون</option>
                                                            <option value="7">جسیکا آلبا</option>
                                                            <option value="8">جنیفر لارنس</option>
                                                            <option value="9">ایما استون</option>
                                                            <option value="10">آنجلینا جولی</option>
                                                        </optgroup>
                                                    </x-base.tom-select>
                                                </div>
                                            </div>
                                            <!-- END: Nested Select -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Basic Select -->
                                                <div>
                                                    <label>پایه</label>
                                                    <div class="mt-2">
                                                        <x-base.tom-select
                                                            class="w-full"
                                                            data-placeholder="انتخاب your favorite actors"
                                                        >
                                                            <option value="1">لئوناردو دی‌کاپریو</option>
                                                            <option value="2">جانی دیپ</option>
                                                            <option value="3">رابرت داونی‌ جونیور</option>
                                                            <option value="4">ساموئل ال. جکسون</option>
                                                            <option value="5">مورگان فریمن</option>
                                                        </x-base.tom-select>
                                                    </div>
                                                </div>
                                                <!-- END: Basic Select -->
                                                <!-- BEGIN: Nested Select -->
                                                <div class="mt-3">
                                                    <label>تودرتو</label>
                                                    <div class="mt-2">
                                                        <x-base.tom-select
                                                            class="w-full"
                                                            data-placeholder="انتخاب your favorite actors"
                                                        >
                                                            <optgroup label="American Actors">
                                                                <option value="1">لئوناردو دی‌کاپریو</option>
                                                                <option value="2">جانی دیپ</option>
                                                                <option value="3">رابرت داونی‌ جونیور</option>
                                                                <option value="4">ساموئل ال. جکسون</option>
                                                                <option value="5">مورگان فریمن</option>
                                                            </optgroup>
                                                            <optgroup label="American Actresses">
                                                                <option value="6">اسکارلت جوهانسون</option>
                                                                <option value="7">جسیکا آلبا</option>
                                                                <option value="8">جنیفر لارنس</option>
                                                                <option value="9">ایما استون</option>
                                                                <option value="10">آنجلینا جولی</option>
                                                            </optgroup>
                                                        </x-base.tom-select>
                                                    </div>
                                                </div>
                                                <!-- END: Nested Select -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "انتخاب پایه" یک روش ساده
                                    برای ادغام منوهای کشویی در برنامه وب خود
                                    با دنبال کردن مراحل ذکر شده بالا، شما
                                    می‌توانید به سادگی منوهای کشویی را ایجاد و سفارشی کنید تا ورودی کاربر را جمع‌آوری کنید یا از فهرستی از گزینه‌ها انتخاب کنید.
                                    ورود کاربر یا انتخاب‌ها را از لیست گزینه‌ها انجام دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    انتخاب چندگانه
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "انتخاب چندگانه" به کاربران اجازه می‌دهد تا گزینه‌های چندگانه را از یک لیست انتخاب کنند. این یک
                                    عنصر رابط کاربری چندمنظوره است که اغلب در صورتی که کاربران نیاز دارند گزینه‌های چندگانه انتخاب کنند، مورد استفاده قرار می‌گیرد، مانند انتخاب چند مورد
                                    از یک لیست گزینه‌های موجود است.
                                    اجزای "انتخاب چندگانه" با استفاده از TomSelect راه‌حلی آسان و کاربرپسند برای کاربران ارائه می‌دهد تا گزینه‌های چندگانه را از یک لیست انتخاب کنند. این قابلیت
                                    بسیار قابل تنظیم است و می‌تواند به موارد استفاده مختلف در
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tom-select
                                                class="w-full"
                                                data-placeholder="انتخاب your favorite actors"
                                                multiple
                                            >
                                                <option
                                                    value="1"
                                                    selected
                                                >لئوناردو دی‌کاپریو</option>
                                                <option value="2">جانی دیپ</option>
                                                <option
                                                    value="3"
                                                    selected
                                                >رابرت داونی‌ جونیور</option>
                                                <option value="4">ساموئل ال. جکسون</option>
                                                <option value="5">مورگان فریمن</option>
                                            </x-base.tom-select>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tom-select
                                                    class="w-full"
                                                    data-placeholder="انتخاب your favorite actors"
                                                    multiple
                                                >
                                                    <option
                                                        value="1"
                                                        selected
                                                    >لئوناردو دی‌کاپریو</option>
                                                    <option value="2">جانی دیپ</option>
                                                    <option
                                                        value="3"
                                                        selected
                                                    >رابرت داونی‌ جونیور</option>
                                                    <option value="4">ساموئل ال. جکسون</option>
                                                    <option value="5">مورگان فریمن</option>
                                                </x-base.tom-select>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "انتخاب چندگانه" با استفاده از TomSelect راه‌حلی آسان و کاربرپسند برای کاربران ارائه می‌دهد تا گزینه‌های چندگانه را از یک لیست انتخاب کنند. این بسیار
                                    قابل تنظیم است و می‌تواند به موارد استفاده مختلف در
                                    راحتی و کاربرپسند برای کاربران ارائه دهد. این بسیار
                                    قابل تنظیم است و می‌تواند به موارد استفاده مختلف در
                                    برنامه وب خود.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">سربرگ</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect" یک کتابخانه ورودی انتخابی چندمنظوره است که به شما اجازه می‌دهد تا منوهای کشویی سفارشی و ورودی‌های چندگانه را ایجاد کنید. در این بخش، ما به بررسی
                                    چگونگی بهبود اجزای "TomSelect" خود با اضافه کردن یک
                                    سربرگ به منوی کشویی می‌پردازیم. این می‌تواند به خصوص مفید باشد
                                    زمانی که می‌خواهید متن کناری یا گروه‌ها را در داخل
                                    منوی کشویی فراهم کنید.
                                    زمانی که می‌خواهید زمینه یا گروه بندی برای موارد داخلی
                                    منوی کشویی فراهم کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tom-select
                                                class="w-full"
                                                data-placeholder="انتخاب your favorite actors"
                                                data-header="Actors"
                                                multiple
                                            >
                                                <option value="1">لئوناردو دی‌کاپریو</option>
                                                <option
                                                    value="2"
                                                    selected
                                                >جانی دیپ</option>
                                                <option
                                                    value="3"
                                                    selected
                                                >رابرت داونی‌ جونیور</option>
                                                <option value="4">ساموئل ال. جکسون</option>
                                                <option
                                                    value="5"
                                                    selected
                                                >مورگان فریمن</option>
                                            </x-base.tom-select>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tom-select
                                                    class="w-full"
                                                    data-placeholder="انتخاب your favorite actors"
                                                    data-header="Actors"
                                                    multiple
                                                >
                                                    <option value="1">لئوناردو دی‌کاپریو</option>
                                                    <option
                                                        value="2"
                                                        selected
                                                    >جانی دیپ</option>
                                                    <option
                                                        value="3"
                                                        selected
                                                    >رابرت داونی‌ جونیور</option>
                                                    <option value="4">ساموئل ال. جکسون</option>
                                                    <option
                                                        value="5"
                                                        selected
                                                    >مورگان فریمن</option>
                                                </x-base.tom-select>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    با اضافه کردن یک سربرگ به اجزای "TomSelect" خود می‌توانید
                                    متن کناری ارزشمند و گروه‌بندی برای
                                    گزینه‌ها درون منوی کشویی ارائه دهید. این تجربه کاربر را بهبود می‌بخشد
                                    و به کاربران کمک می‌کند تا انتخاب‌های آگاهانه داشته باشند.
                                    عنوان سربرگ را برای تطابق با نیازها و طراحی برنامه‌ی شما سفارشی سازی کنید.
                                    نیازها و طراحی. کتابخانه "TomSelect" ارائه می‌دهد
                                    نیازها و طراحی. کتابخانه "TomSelect" افزونه‌های مختلفی ارائه می‌دهد
                                    برای گسترش عملکرد ورودی‌های انتخابی شما.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    گروه ورودی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect"، در کنار یک گروه ورودی،
                                    به شما امکان می‌دهد تا یک ورودی انتخابی شیک و کارآمد را با یک
                                    آیکون یا کاراکتر سفارشی پیش از آن ایجاد کنید. این
                                    زمانی مفید است که می‌خواهید زمینه اضافی را به
                                    ورودی انتخابی فراهم کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="flex">
                                                <div
                                                    class="z-30 -me-1 flex w-10 items-center justify-center rounded-s border bg-slate-100 text-slate-600 dark:border-darkmode-800 dark:bg-darkmode-700 dark:text-slate-400">
                                                    @
                                                </div>
                                                <x-base.tom-select class="w-full">
                                                    <option value="1">لئوناردو دی‌کاپریو</option>
                                                    <option value="2">جانی دیپ</option>
                                                    <option value="3">رابرت داونی‌ جونیور</option>
                                                    <option value="4">ساموئل ال. جکسون</option>
                                                    <option value="5">مورگان فریمن</option>
                                                </x-base.tom-select>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="flex">
                                                    <div class="flex">
                                                        <div
                                                            class="z-30 -me-1 flex w-10 items-center justify-center rounded-s border bg-slate-100 text-slate-600 dark:border-darkmode-800 dark:bg-darkmode-700 dark:text-slate-400">
                                                            @
                                                        </div>
                                                        <x-base.tom-select class="w-full">
                                                            <option value="1">لئوناردو دی‌کاپریو</option>
                                                            <option value="2">جانی دیپ</option>
                                                            <option value="3">رابرت داونی‌ جونیور</option>
                                                            <option value="4">ساموئل ال. جکسون</option>
                                                            <option value="5">مورگان فریمن</option>
                                                        </x-base.tom-select>
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    ترکیب اجزای "TomSelect" با یک گروه ورودی به شما امکان می‌دهد تا
                                    ورودی انتخابی با آیکون یا کاراکتر شخصی سازی شده قبل از آن ایجاد کنید. این ویژگی
                                    واسط کاربر و یک نمایش بصری منحصر به فرد برای ورودی انتخابی شما فراهم می‌کند، که آن را بیشتر
                                    کاربرپسند و جذاب می‌کند.
                                    نمایش برای ورودی انتخابی شما، که آن را بیشتر
                                    کاربرپسند و جذاب تر می‌کند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">غیرفعال</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect" به راحتی قابل پیکربندی برای
                                    غیرفعال سازی، کاربران را از تعامل با آن جلوگیری می‌کند. این ویژگی زمانی مفید است که می‌خواهید یک
                                    ورودی انتخابی را نمایش دهید که توسط کاربر تغییر یافته یا انتخاب نشود.
                                    ورودی که نباید توسط کاربر تغییر یابد یا انتخاب شود.
                                    user.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tom-select
                                                class="w-full"
                                                disabled
                                            >
                                                <option value="1">لئوناردو دی‌کاپریو</option>
                                                <option value="2">جانی دیپ</option>
                                                <option value="3">رابرت داونی‌ جونیور</option>
                                                <option value="4">ساموئل ال. جکسون</option>
                                                <option value="5">مورگان فریمن</option>
                                            </x-base.tom-select>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tom-select
                                                    class="w-full"
                                                    disabled
                                                >
                                                    <option value="1">لئوناردو دی‌کاپریو</option>
                                                    <option value="2">جانی دیپ</option>
                                                    <option value="3">رابرت داونی‌ جونیور</option>
                                                    <option value="4">ساموئل ال. جکسون</option>
                                                    <option value="5">مورگان فریمن</option>
                                                </x-base.tom-select>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect" به راحتی با تنظیم ویژگی غیرفعال به درستی می‌توانند
                                    غیرقابل انتخاب و جلوگیری از تعامل کاربر. این ویژگی به خصوص زمانی مفید است که می‌خواهید یک
                                    ورودی انتخابی را نمایش دهید که فقط برای موارد اطلاعاتی است و توسط کاربران انتخاب نشود. شما می‌توانید
                                    ظاهر و محتوای "TomSelect" غیرفعال شده را به نیازها و طراحی برنامه خود تنظیم کنید. آن را به برنامه خود اضافه کنید تا یک
                                    واسط کاربرپسند و قابل دسترسی ایجاد کنید.
                                    و نباید توسط کاربران تغییر یابد. شما می‌توانید
                                    ظاهر و محتوای "TomSelect" غیرفعال را سفارشی کنید تا با سبک و طرح برنامه‌ی شما همخوانی داشته باشد.
                                    آن را در برنامه‌ی خود به عنوان نیازهای خود، به طوری که یک
                                    رابط کاربری کاربرپسند و قابل دسترسی ایجاد شود.
                                    رابط کاربری کاربرپسند و قابل دسترس.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    گزینه غیرفعال
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect" به شما امکان می‌دهد تا ورودی انتخابی با گزینه‌های غیرفعال ایجاد کنید. گزینه‌های غیرفعال
                                    عناصری در داخل منوی کشویی هستند که توسط کاربران قابل انتخاب نیستند. این می‌تواند برای فراهم کردن
                                    زمینه‌های اضافی یا نشان دادن انتخاب‌های غیرقابل دسترس داخل یک ورودی انتخابی مفید باشد.
                                    توسط کاربران انتخاب شود. این می‌تواند مفید باشد برای ارائه
                                    زمینه اضافی یا نشان دادن گزینه‌های غیرقابل دسترس داخل یک ورودی انتخابی.
                                    در داخل یک ورودی انتخابی.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <x-base.tom-select class="w-full">
                                                <option
                                                    value="1"
                                                    disabled
                                                >
                                                    لئوناردو دی‌کاپریو
                                                </option>
                                                <option value="2">جانی دیپ</option>
                                                <option value="3">رابرت داونی‌ جونیور</option>
                                                <option
                                                    value="4"
                                                    disabled
                                                >
                                                    ساموئل ال. جکسون
                                                </option>
                                                <option value="5">مورگان فریمن</option>
                                            </x-base.tom-select>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <x-base.tom-select class="w-full">
                                                    <option
                                                        value="1"
                                                        disabled
                                                    >لئوناردو دی‌کاپریو</option>
                                                    <option value="2">جانی دیپ</option>
                                                    <option value="3">رابرت داونی‌ جونیور</option>
                                                    <option
                                                        value="4"
                                                        disabled
                                                    >ساموئل ال. جکسون</option>
                                                    <option value="5">مورگان فریمن</option>
                                                </x-base.tom-select>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    اجزای "TomSelect" به شما امکان می‌دهد تا گزینه‌های غیرفعال را در داخل ورودی انتخابی قرار دهید. این گزینه‌های غیرفعال
                                    در منوی کشویی نمایش داده می‌شوند اما توسط کاربران انتخاب نمی‌شوند. شما می‌توانید از گزینه‌های غیرفعال برای
                                    فراهم کردن اطلاعات اضافی یا نمایش گزینه‌هایی که در حال حاضر در دسترس نیستند، استفاده کنید.
                                    توسط کاربران انتخاب شود. می‌توانید از گزینه‌های غیرفعال برای
                                    ارائه اطلاعات اضافی یا نشان دادن گزینه‌هایی که در حال حاضر در دسترس نیستند، استفاده کنید.
                                    در حال حاضر در دسترس نیستند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">TomSelect</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`value`</x-base.table.td>
                                                <x-base.table.td>`string` or `string[]`</x-base.table.td>
                                                <x-base.table.td>
                                                    مقدار(های) انتخاب شده در اجزای TomSelect.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onOptionAdd`</x-base.table.td>
                                                <x-base.table.td>`(value: string) =&gt; void`</x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابع بازخوانی که هنگامی که یک گزینه
                                                    added.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`onChange`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(value: `string` or `string[]`) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    تابع بازخوانی که وقتی مقدار(های) انتخابی تغییر می‌کند فراخوانی می‌شود.
                                                    تغییر می‌کند.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`TomSettings`</x-base.table.td>
                                                <x-base.table.td>گزینه‌های پیکربندی TomSelect.</x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: TomSelectElement) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    یک تابع که یک مرجع به
                                                    عنصر ورودی TomSelect.
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انتخاب ابتدایی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    انتخاب چندگانه
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    سربرگ
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    گروه ورودی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    غیرفعال
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    گزینه غیرفعال
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
