@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    راهنمای ابزار
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    چگونگی استفاده از انعطاف پذیری اجزای ابزارک ما برای افزودن راهنماها و اطلاعات اضافی به رابط کاربری خود را کشف کنید.
                    راهنماها و اطلاعات اضافی به رابط کاربری خود.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    راهنمای ابتدایی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    راهنماها راهی مفید برای ارائه اطلاعات اضافی یا توضیحات برای عناصر در یک صفحه وب هستند.
                                    آنها معمولا زمانی ظاهر می شوند که کاربران روی عنصر موسیقی کرده و یا با آن تعامل دارند.
                                    آنها معمولا زمانی ظاهر می شوند که کاربران روی عنصر موسیقی کرده و یا با آن تعامل دارند.
                                    با ارائه زمینه و روشن شدن.
                                    این بخش توضیح می دهد که چگونه راهنماهای ابتدایی را در برنامه وب خود اجرا کنید.
                                    برنامه وب خود.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <x-base.tippy
                                                    as="x-base.button"
                                                    variant="primary"
                                                    content="This is awesome tooltip example!"
                                                >
                                                    نمایش راهنما
                                                </x-base.tippy>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <x-base.tippy
                                                        as="x-base.button"
                                                        variant="primary"
                                                        content="This is awesome tooltip example!"
                                                    >
                                                        نمایش راهنما
                                                    </x-base.tippy>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "راهنمای ابتدایی" نشان داده است چگونه از راهنماها برای ارائه اطلاعات اضافی و راهنمایی به کاربران زمانی که با عناصر در صفحه وب شما تعامل دارند، استفاده کنید.
                                    راهنماها برای ارائه اطلاعات اضافی و راهنمایی به
                                    به کاربران زمانی که با عناصر در صفحه وب شما تعامل دارند.
                                    با پیروی از این رهنمودها و بهترین روش ها،
                                    می توانید تجربه کاربر را ارتقا دهید و زمینه ارزشمندی را فراهم کنید
                                    بدون اضافه کردن UI شما.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>

                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    راهنمای کلیک بر روی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    راهنمای کلیک بر روی یک نوع از راهنماهای سنتی است که ظاهر می شود زمانی که کاربر بر روی یک عنصر کلیک می کند
                                    به جای هواپیما رفتن به آن. این بخش توضیح می دهد که چگونه
                                    برای پیاده سازی راهنماهای که زمانی ظاهر می شود که کاربران روی
                                    عناصر در برنامه وب خود کلیک کنند.
                                    برنامه وب خود.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <x-base.tippy
                                                    data-trigger="click"
                                                    as="x-base.button"
                                                    variant="primary"
                                                    content="This is awesome tooltip example!"
                                                >
                                                    نمایش راهنما
                                                </x-base.tippy>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <x-base.tippy
                                                        data-trigger="click"
                                                        as="x-base.button"
                                                        variant="primary"
                                                        content="This is awesome tooltip example!"
                                                    >
                                                        نمایش راهنما
                                                    </x-base.tippy>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "راهنمای کلیک بر روی" نشان داده است که چگونه
                                    از راهنماها استفاده کنید که ظاهر می شود زمانی که کاربر بر روی
                                    عناصر در برنامه وب شما کلیک می کند. با پیروی از این
                                    راهنمودها و بهترین روش ها، می توانید
                                    اطلاعات اضافی و زمینه را به کاربران خود زمانی که
                                    آنها نیاز دارند، تجربه کاربر کلی را بهبود بخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    راهنمای نور
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    یک "راهنمای نور" یک نوع از راهنمایی است که اطلاعات اضافی را فراهم می کند زمانی که کاربر روی
                                    عنصر نوری می کند. این بخش توضیح می دهد که چگونه
                                    راهنماهای نور را در برنامه وب خود پیاده سازی کنید.
                                    بخش "راهنمای نور" نشان داده است چگونه از راهنماهای نور برای ارائه اطلاعات اضافی و زمینه به کاربران زمانی که آنها نیاز دارند، استفاده کنید.
                                    برنامه وب خود را پیاده سازی کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="text-center">
                                                <x-base.tippy
                                                    data-theme="light"
                                                    as="x-base.button"
                                                    variant="primary"
                                                    content="This is awesome tooltip example!"
                                                >
                                                    نمایش راهنما
                                                </x-base.tippy>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="text-center">
                                                    <x-base.tippy
                                                        data-theme="light"
                                                        as="x-base.button"
                                                        variant="primary"
                                                        content="This is awesome tooltip example!"
                                                    >
                                                        نمایش راهنما
                                                    </x-base.tippy>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "راهنمای نور" نشان داده است چگونه استفاده کنید
                                    راهنماهایی که اطلاعات اضافی را در هنگام رویت المان‌ها در برنامه وب‌شما فراهم می‌کنند. با پیروی از این راهنماها و بهترین روش‌ها، می‌توانید درک کاربر را افزایش دهید و تجربه کاربری کلی را بهبود ببخشید.
                                    کاربران روی المان‌ها در برنامه وب‌شما را هنگام رویت، توضیحات ارائه می‌دهند. با پیروی از این راهنماها و بهترین روش‌ها، می‌توانید درک کاربر را افزایش دهید و تجربه کاربری کلی را بهبود ببخشید.
                                    با پیروی از این راهنماها و بهترین روش‌ها، می‌توانید
                                    فهم کاربر را ارتقا داده و تجربه کاربری کلی را بهبود بخشید.
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    محتوای راهنمای سفارشی
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    راهنماهای سفارشی به شما امکان ایجاد راهنماها با اطلاعات شخصی و پویا را می‌دهد.
                                    با استفاده از اطلاعات شخصی و پویا. به جای
                                    استفاده از متن استاتیک، می‌توانید راهنماها را با
                                    اطلاعات پویا مانند تصاویر، آیکون‌ها یا حتی اجزای React پر کنید.
                                    این بخش توضیح می‌دهد چگونه
                                    راهنمای سفارشی را در برنامه وب خود پیاده‌سازی کنید.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Custom Tooltip Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tooltip="custom-tooltip-content"
                                                    variant="primary"
                                                >
                                                    نمایش راهنما
                                                </x-base.button>
                                            </div>
                                            <!-- END: Custom Tooltip Toggle -->
                                            <!-- BEGIN: Custom Tooltip Content -->
                                            <div class="tooltip-content">
                                                <x-base.tippy-content to="custom-tooltip-content">
                                                    <div class="relative flex items-center py-1">
                                                        <div class="image-fit h-12 w-12">
                                                            <img
                                                                class="rounded-full"
                                                                src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                alt="تیل وایز - قالب داشبورد مدیریتی"
                                                            >
                                                        </div>
                                                        <div class="ms-4 me-auto">
                                                            <div
                                                                class="whitespace-nowrap font-medium leading-normal dark:text-slate-200">
                                                                {{ $users[0]['name'] }}
                                                            </div>
                                                            <div
                                                                class="mt-0.5 whitespace-nowrap text-xs text-slate-500 dark:text-slate-400">
                                                                قالب مدیریتی HTML تیلویند سی‌اس‌اس ۳+
                                                            </div>
                                                        </div>
                                                    </div>
                                                </x-base.tippy-content>
                                            </div>
                                            <!-- END: Custom Tooltip Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Custom Tooltip Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tooltip="custom-tooltip-content"
                                                        variant="primary"
                                                    >
                                                        نمایش راهنما
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Custom Tooltip Toggle -->
                                                <!-- BEGIN: Custom Tooltip Content -->
                                                <div class="tooltip-content">
                                                    <x-base.tippy-content to="custom-tooltip-content">
                                                        <div class="relative flex items-center py-1">
                                                            <div class="image-fit h-12 w-12">
                                                                <img
                                                                    class="rounded-full"
                                                                    src="{{ Vite::asset($products[0]['images'][0]['path']) }}"
                                                                    alt="تیل وایز - قالب داشبورد مدیریتی"
                                                                >
                                                            </div>
                                                            <div class="ms-4 me-auto">
                                                                <div
                                                                    class="whitespace-nowrap font-medium leading-normal dark:text-slate-200">
                                                                    {{ $users[0]['name'] }}
                                                                </div>
                                                                <div
                                                                    class="mt-0.5 whitespace-nowrap text-xs text-slate-500 dark:text-slate-400">
                                                                    قالب مدیریتی HTML تیلویند سی‌اس‌اس ۳+
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </x-base.tippy-content>
                                                </div>
                                                <!-- END: Custom Tooltip Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "محتوای راهنمای سفارشی" نشان داده است
                                    چگونه راهنماها را با اطلاعات شخصی و پویا ایجاد کنید.
                                    این امکان را به شما می‌دهد تا به کاربران خود راهنماهایی با راهنماهایی غنی و
                                    مربوط به متن ارائه دهید. با بهره‌مندی از این ویژگی،
                                    می‌توانید تجربه کاربری کلی را بهبود ببخشید و
                                    قابلیت استفاده از برنامه وب خود را افزایش دهید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    راهنمای نمودار
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    راهنماهای نمودار جزء مهمی از بصیرت‌های ارزشمندی هستند که
                                    هنگام تعامل با نمودارها و نمودارها، به کاربران ارائه می‌دهند.
                                    این بخش توضیح می‌دهد چگونه راهنماهای نمودار را پیاده‌سازی و سفارشی کنید
                                    در برنامه وب خود.
                                    در برنامه وب خود.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <!-- BEGIN: Custom Tooltip Toggle -->
                                            <div class="text-center">
                                                <x-base.button
                                                    data-tooltip="chart-tooltip"
                                                    variant="primary"
                                                >
                                                    نمایش راهنما
                                                </x-base.button>
                                            </div>
                                            <!-- END: Custom Tooltip Toggle -->
                                            <!-- BEGIN: Custom Tooltip Content -->
                                            <div class="tooltip-content">
                                                <x-base.tippy-content
                                                    class="py-1"
                                                    to="chart-tooltip"
                                                >
                                                    <div class="font-medium dark:text-slate-200">
                                                        ارزش خالص
                                                    </div>
                                                    <div class="mt-2 flex items-center sm:mt-0">
                                                        <div class="me-2 flex w-20 dark:text-slate-400">
                                                            USP:
                                                            <span class="ms-auto font-medium text-success">
                                                                +23%
                                                            </span>
                                                        </div>
                                                        <div class="w-24 sm:w-32 lg:w-56">
                                                            <x-simple-line-chart-1 height="h-[30px]" />
                                                        </div>
                                                    </div>
                                                </x-base.tippy-content>
                                            </div>
                                            <!-- END: Custom Tooltip Content -->
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <!-- BEGIN: Custom Tooltip Toggle -->
                                                <div class="text-center">
                                                    <x-base.button
                                                        data-tooltip="chart-tooltip"
                                                        variant="primary"
                                                    >
                                                        نمایش راهنما
                                                    </x-base.button>
                                                </div>
                                                <!-- END: Custom Tooltip Toggle -->
                                                <!-- BEGIN: Custom Tooltip Content -->
                                                <div class="tooltip-content">
                                                    <x-base.tippy-content
                                                        class="py-1"
                                                        to="chart-tooltip"
                                                    >
                                                        <div class="font-medium dark:text-slate-200">
                                                            ارزش خالص
                                                        </div>
                                                        <div class="mt-2 flex items-center sm:mt-0">
                                                            <div class="me-2 flex w-20 dark:text-slate-400">
                                                                USP:
                                                                <span class="ms-auto font-medium text-success">
                                                                    +23%
                                                                </span>
                                                            </div>
                                                            <div class="w-24 sm:w-32 lg:w-56">
                                                                <x-simple-line-chart-1 height="h-[30px]" />
                                                            </div>
                                                        </div>
                                                    </x-base.tippy-content>
                                                </div>
                                                <!-- END: Custom Tooltip Content -->
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    بخش "راهنمای نمودار" نشان داده است چگونه
                                    راهنماهای نمودار و داده‌های خود را سفارشی کنید.
                                    با پیاده‌سازی راهنماهای نمودار طراحی شده به خوبی،
                                    می‌توانید به کاربران بینش‌های ارزشمندی ارائه دهید،
                                    فهم آن‌ها از داده‌ها را ارتقا داده و
                                    مشارکت کاربران را بهبود ببخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <div
                            class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                            <div class="text-[0.94rem] font-medium">رابط اجزاء</div>
                        </div>
                        <div>
                            <p class="leading-relaxed">
                                در این بخش، اطلاعات جزئی در مورد
                                ویژگی‌ها، کلاس‌ها و گزینه‌های موجود که می‌توانید با
                                اجزاء است. درک این خصوصیات برای
                                سفارشی کردن و پیکربندی اجزاء برای مطابقت با
                                نیازهای خاص شما ضروری است.
                            </p>
                            <p class="mt-2 leading-relaxed">
                                در زیر لیستی از ویژگی‌هایی که می‌توان به اجزاء منتقل کرد، آمده است:
                            </p>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">Tippy</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: PopperElement | null) =&gt; void`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    تابعی برای دریافت مرجع به عنصر Popper
                                                    or null
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`content`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    محتوایی که در راهنما نمایش داده می‌شود
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`as`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    نوع عنصر HTML یا مولفه React برای نمایش
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`Props`</x-base.table.td>
                                                <x-base.table.td>
                                                    گزینه‌های اضافی برای سفارشی‌سازی راهنما
                                                    ظاهر و رفتار
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                            <div
                                class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                <div class="absolute start-0 -mt-2.5 ms-4 bg-white px-3 font-medium text-slate-500">
                                    <div class="-mt-px">TippyContent</div>
                                </div>
                                <div class="mt-2.5 flex flex-col gap-3.5 overflow-x-auto px-5 pb-5 pt-2 leading-relaxed">
                                    <x-base.table sm>
                                        <x-base.table.thead>
                                            <x-base.table.tr>
                                                <x-base.table.th class="w-44 whitespace-nowrap">
                                                    Prop
                                                </x-base.table.th>
                                                <x-base.table.th class="w-56 whitespace-nowrap">
                                                    Type
                                                </x-base.table.th>
                                                <x-base.table.th class="whitespace-nowrap">
                                                    Description
                                                </x-base.table.th>
                                            </x-base.table.tr>
                                        </x-base.table.thead>
                                        <x-base.table.tbody>
                                            <x-base.table.tr>
                                                <x-base.table.td>`to`</x-base.table.td>
                                                <x-base.table.td>`string`</x-base.table.td>
                                                <x-base.table.td>
                                                    انتخاب کننده عنصر هدف برای راهنما
                                                    (استفاده از ویژگی data-tooltip)
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`getRef`</x-base.table.td>
                                                <x-base.table.td>
                                                    `(el: HTMLElement | null) =&gt; HTMLElement`
                                                </x-base.table.td>
                                                <x-base.table.td>
                                                    تابعی برای دریافت مرجع به عنصر راهنما
                                                    or null
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                            <x-base.table.tr>
                                                <x-base.table.td>`options`</x-base.table.td>
                                                <x-base.table.td>`Props`</x-base.table.td>
                                                <x-base.table.td>
                                                    گزینه‌های اضافی برای سفارشی‌سازی راهنما
                                                    ظاهر و رفتار
                                                </x-base.table.td>
                                            </x-base.table.tr>
                                        </x-base.table.tbody>
                                    </x-base.table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    راهنمای ابتدایی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    راهنمای کلیک بر روی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    راهنمای نور
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    محتوای راهنمای سفارشی
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    راهنمای نمودار
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
