@extends('../themes/' . $activeTheme)

@section('subhead')
    <title>تیل وایز - قالب داشبورد مدیریتی</title>
@endsection

@section('subcontent')
    <div class="grid grid-cols-12 gap-x-6 gap-y-10">
        <div class="col-span-12">
            <div class="flex h-10 items-center">
                <div class="text-lg font-medium group-[.mode--light]:text-white">
                    سربرگ
                </div>
                <div class="mx-3 hidden group-[.mode--light]:text-white/80 lg:block">
                    •
                </div>
                <div class="hidden leading-relaxed text-slate-500 group-[.mode--light]:text-white/80 lg:block">
                    قدرت مؤلفه سربرگ ما را به طور آسان برای ایجاد سربرگ‌های جذاب و به‌ساختار برای محتوای وب خود رها کنید.
                    سربرگ‌ها بخش اساسی از ساختاردهی و ترتیب دادن محتوا در برنامه‌ی شما هستند. آنها سلسله‌مراتب را فراهم می‌کنند و به کاربران کمک می‌کنند تا اطلاعات ارائه‌شده را درک و دسترسی داشته باشند. این بخش نحوه استفاده موثر از سربرگ‌ها در پروژه شما را پوشش می‌دهد.
                </div>
            </div>
            <div class="mt-3.5 grid grid-cols-12 gap-x-6 gap-y-7 lg:gap-y-10 xl:grid-cols-10">
                <div class="relative col-span-12 flex flex-col gap-y-7 lg:col-span-9 xl:col-span-8">
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">سربرگ</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-1"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-1"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    Headers are an essential part of structuring and
                                    organizing content in your اپلیکیشن They provide
                                    hierarchy and help users navigate and understand the
                                    information presented. This section covers how to use
                                    headings effectively in your project.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <h1 class="text-4xl font-medium leading-none">
                                                    سربرگ 1
                                                </h1>
                                                <h2 class="mt-3 text-3xl font-medium leading-none">
                                                    سربرگ 2
                                                </h2>
                                                <h3 class="mt-3 text-2xl font-medium leading-none">
                                                    سربرگ 3
                                                </h3>
                                                <h4 class="mt-3 text-xl font-medium leading-none">
                                                    سربرگ 4
                                                </h4>
                                                <h5 class="mt-3 text-lg font-medium leading-none">
                                                    سربرگ 5
                                                </h5>
                                                <h6 class="mt-3 font-medium leading-none">
                                                    سربرگ 6
                                                </h6>
                                            </div>
                                            <div class="mt-5">
                                                <h1 class="text-4xl font-medium leading-none text-primary">
                                                    سربرگ 1
                                                </h1>
                                                <h2
                                                    class="mt-3 text-3xl font-medium leading-none text-slate-600 dark:text-slate-500">
                                                    سربرگ 2
                                                </h2>
                                                <h3 class="mt-3 text-2xl font-medium leading-none text-success">
                                                    سربرگ 3
                                                </h3>
                                                <h4 class="mt-3 text-xl font-medium leading-none text-warning">
                                                    سربرگ 4
                                                </h4>
                                                <h5 class="mt-3 text-lg font-medium leading-none text-danger">
                                                    سربرگ 5
                                                </h5>
                                                <h6 class="mt-3 font-medium leading-none text-slate-500">
                                                    سربرگ 6
                                                </h6>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <h1 class="text-4xl font-medium leading-none">سربرگ 1</h1>
                                                    <h2 class="mt-3 text-3xl font-medium leading-none">
                                                        سربرگ 2
                                                    </h2>
                                                    <h3 class="mt-3 text-2xl font-medium leading-none">
                                                        سربرگ 3
                                                    </h3>
                                                    <h4 class="mt-3 text-xl font-medium leading-none">
                                                        سربرگ 4
                                                    </h4>
                                                    <h5 class="mt-3 text-lg font-medium leading-none">
                                                        سربرگ 5
                                                    </h5>
                                                    <h6 class="mt-3 font-medium leading-none">سربرگ 6</h6>
                                                </div>
                                                <div class="mt-5">
                                                    <h1 class="text-4xl font-medium leading-none text-primary">
                                                        سربرگ 1
                                                    </h1>
                                                    <h2
                                                        class="mt-3 text-3xl font-medium leading-none text-slate-600 dark:text-slate-500">
                                                        سربرگ 2
                                                    </h2>
                                                    <h3 class="mt-3 text-2xl font-medium leading-none text-success">
                                                        سربرگ 3
                                                    </h3>
                                                    <h4 class="mt-3 text-xl font-medium leading-none text-warning">
                                                        سربرگ 4
                                                    </h4>
                                                    <h5 class="mt-3 text-lg font-medium leading-none text-danger">
                                                        سربرگ 5
                                                    </h5>
                                                    <h6 class="mt-3 font-medium leading-none text-slate-500">
                                                        سربرگ 6
                                                    </h6>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    سربرگ‌ها نقش حیاتی در ساختاردهی و
                                    سازماندهی محتوای شما دارند. با استفاده موثر از سربرگ‌ها و
                                    به صورت مداوم، شما می‌توانید قابلیت دسترسی و
                                    خوانایی برنامه‌ی خود را ارتقاء دهید. به یاد داشته باشید که سطح سربرگ مناسب را انتخاب کنید، سربرگ‌ها را به صورت معنایی نگه دارید، و
                                    بهترین روش‌های دسترسی را دنبال کنید تا تجربه کاربر بهتری ایجاد کنید.
                                    تنظیمات متن
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    تنظیمات متن
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-2"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-2"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    تنظیمات و استایل‌های متن برای اطمینان از آنکه
                                    محتوای شما هم جذاب ویژگی‌های بصری داشته باشد و هم راحت قابل خواندن باشد.
                                    این بخش نحوه اعمال تنظیمات متنی مختلف را به محتوای خود می‌پوشاند.

                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <div class="font-normal">متن نمونه</div>
                                                <div class="font-medium">
                                                    متن متوسط نمونه
                                                </div>
                                                <div class="font-semibold">
                                                    متن نیمه‌جسور نمونه
                                                </div>
                                                <div class="font-bold">
                                                    متن پردازش شده نمونه
                                                </div>
                                                <div class="font-extrabold">
                                                    متن بلند شده نمونه
                                                </div>
                                            </div>
                                            <div class="mt-5">
                                                <div class="uppercase">
                                                    متن بزرگ نویسی نمونه
                                                </div>
                                                <div class="lowercase">
                                                    متن کوچک نویسی نمونه
                                                </div>
                                                <div class="capitalize">
                                                    متن بزرگ شده نویسی نمونه
                                                </div>
                                                <div class="normal-case">
                                                    متن دستنویس نمونه
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <div class="font-normal">متن نمونه</div>
                                                    <div class="font-medium">متن متوسط نمونه</div>
                                                    <div class="font-semibold">متن نیمه‌جسور نمونه</div>
                                                    <div class="font-bold">متن پردازش شده نمونه</div>
                                                    <div class="font-extrabold">متن بلند شده نمونه</div>
                                                </div>
                                                <div class="mt-5">
                                                    <div class="uppercase">متن بزرگ نویسی نمونه</div>
                                                    <div class="lowercase">متن کوچک نویسی نمونه</div>
                                                    <div class="capitalize">متن بزرگ شده نویسی نمونه</div>
                                                    <div class="normal-case">متن دستنویس نمونه</div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    سفارشی کردن تنظیمات متن برای ایجاد
                                    محتوایی که هم ظاهراً جذاب است و هم قابل خواندن. با تنظیم
                                    اندازه فونت، ارتفاع خط، رنگ، خانواده فونت، تنظیمات
                                    ترتیب و تزیین متن، می‌توانید متن خود را به طور
                                    بهترین شکل ممکن به طراحی برنامه‌ی خود و بهبود تجربه کاربر تنظیم کنید.
                                    به خاطر داشته باشید که ستونتاری و
                                    تنظیمات متنی خود را در سراسر برنامه‌ی خود برای
                                    look.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    عناصر مشترک
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-3"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-3"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    عناصر HTML مشترک اغلب برای استایل یا انتقال
                                    معانی ویژه درون محتوای شما استفاده می‌شوند. این بخش
                                    به بررسی برخی از عناصر HTML مشترک می‌پردازد که برای
                                    بهبود ارائه محتوای متنی شما مورد استفاده قرار می‌گیرند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                می‌توانید برچسب mark را برای
                                                <mark class="bg-yellow-200 p-1">
                                                    highlight
                                                </mark>
                                                text.
                                            </div>
                                            <del class="mt-1 block">
                                                این خط متن به عنوان
                                                متن حذف شده تلقی می‌شود.
                                            </del>
                                            <s class="mt-1 block">
                                                این خط متن به عنوان متنی که دیگر
                                                دقیق نیست تلقی می‌شود.
                                            </s>
                                            <ins class="mt-1 block">
                                                این خط متن به عنوان متنی که به محتوا اضافه
                                                شده است تلقی می‌شود.
                                            </ins>
                                            <u class="mt-1 block">
                                                این خط متن به صورت مورد زیرخط قرار خواهد گرفت.
                                            </u>
                                            <small class="mt-1 block">
                                                این خط متن به عنوان متنی که به شکل
                                                چاپ کیفی در نظر گرفته شده تلقی می‌شود.
                                            </small>
                                            <strong class="mt-1 block">
                                                این خط به عنوان متنی که بصورت پررنگ نمایش داده شده
                                            </strong>
                                            <em class="mt-1 block">
                                                این خط به عنوان متنی که به صورت کج نمایش داده شده
                                            </em>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    می‌توانید برچسب mark را برای
                                                    <mark class="bg-yellow-200 p-1">highlight</mark> text.
                                                </div>
                                                <del class="mt-1 block">این خط متن به عنوان deleted
                                                    text.</del>
                                                <s class="mt-1 block">این خط متن به عنوان متنی که دیگر longer
                                                    accurate.</s>
                                                <ins class="mt-1 block">این خط متن به عنوان متنی که به محتوا اضافه
                                                    افزودنی به
                                                    document.</ins>
                                                <u class="mt-1 block">این خط متن به صورت مورد زیرخط قرار خواهد گرفت.</u>
                                                <small class="mt-1 block">این خط متن به عنوان متنی که به شکل
                                                    چاپ کیفی در نظر گرفته شده تلقی می‌شود.</small>
                                                <strong class="mt-1 block">این خط به عنوان متنی که بصورت پررنگ نمایش داده شده</strong>
                                                <em class="mt-1 block">این خط به عنوان متنی که به صورت کج نمایش داده شده</em>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    این عناصر معمول HTML مجموعه‌ای از ابزارها را برای بهبود استایل و معنا‌بخشی به محتوای متنی شما فراهم می‌کنند. با استفاده مناسب از این عناصر، می‌توانید خوانایی و ارائه بصری محتوای خود را بهبود بخشیده و در عین حال معانی خاص یا تأکیدات لازم را انتقال دهید.
                                    ابزارهایی برای بهبود استایل و معنای محتوای شما
                                    محتوای متنی مبتنی بر متن. با استفاده از این عناصر
                                    به‌طور مناسب، می‌توانید خوانایی را بهبود بخشیده و
                                    ارائه بصری محتوای خود را بهبود بخشیده و هم‌زمان معانی
                                    مخصوص یا تأکیدات لازم را منتقل کنید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">نشان‌ها</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-4"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-4"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    نشان‌ها، اجزای کوچک و اطلاعاتی هستند که برای
                                    نمایش وضعیت، اعلان‌ها یا سایر موارد را به‌صورت بصری
                                    متادیتای در یک روش مختصر. این بخش درباره نحوه
                                    استفاده موثر از نشان‌ها در برنامه‌های وب شما پوشش داده شده است.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div class="font-medium">نشانه پایه</div>
                                            <div class="mt-2">
                                                <span class="me-1 rounded-full bg-primary px-1 text-xs text-white">
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border px-1 text-xs text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span class="me-1 rounded-full bg-success px-1 text-xs text-white">
                                                    3
                                                </span>
                                                <span class="me-1 rounded-full bg-warning px-1 text-xs text-white">
                                                    4
                                                </span>
                                                <span class="me-1 rounded-full bg-danger px-1 text-xs text-white">
                                                    5
                                                </span>
                                                <span
                                                    class="me-1 rounded-full bg-slate-100 px-1 text-xs text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                >
                                                    6
                                                </span>
                                            </div>
                                            <div class="mt-6 font-medium">اندازه‌های نشانه</div>
                                            <div class="mt-3">
                                                <span class="me-1 rounded-full bg-primary px-2 py-1 text-white">
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border px-2 py-1 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span class="me-1 rounded-full bg-success px-2 py-1 text-white">
                                                    3
                                                </span>
                                                <span class="me-1 rounded-full bg-warning px-2 py-1 text-white">
                                                    4
                                                </span>
                                                <span class="me-1 rounded-full bg-danger px-2 py-1 text-white">
                                                    5
                                                </span>
                                                <span
                                                    class="me-1 rounded-full bg-slate-100 px-2 py-1 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                >
                                                    6
                                                </span>
                                            </div>
                                            <div class="mt-4">
                                                <span class="me-1 rounded-full bg-primary px-3 py-2 text-white">
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border px-3 py-2 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span class="me-1 rounded-full bg-success px-3 py-2 text-white">
                                                    3
                                                </span>
                                                <span class="me-1 rounded-full bg-warning px-3 py-2 text-white">
                                                    4
                                                </span>
                                                <span class="me-1 rounded-full bg-danger px-3 py-2 text-white">
                                                    5
                                                </span>
                                                <span
                                                    class="me-1 rounded-full bg-slate-100 px-3 py-2 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                >
                                                    6
                                                </span>
                                            </div>
                                            <div class="mt-6">
                                                <span class="me-1 rounded-full bg-primary px-4 py-3 text-white">
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border px-4 py-3 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span class="me-1 rounded-full bg-success px-4 py-3 text-white">
                                                    3
                                                </span>
                                                <span class="me-1 rounded-full bg-warning px-4 py-3 text-white">
                                                    4
                                                </span>
                                                <span class="me-1 rounded-full bg-danger px-4 py-3 text-white">
                                                    5
                                                </span>
                                                <span
                                                    class="me-1 rounded-full bg-slate-100 px-4 py-3 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                >
                                                    6
                                                </span>
                                            </div>
                                            <div class="mt-10 font-medium">
                                                نشانه مربعی
                                            </div>
                                            <div class="mt-2">
                                                <span class="me-1 bg-primary px-1 text-xs text-white">
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 border px-1 text-xs text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span class="me-1 bg-success px-1 text-xs text-white">
                                                    3
                                                </span>
                                                <span class="me-1 bg-warning px-1 text-xs text-white">
                                                    4
                                                </span>
                                                <span class="me-1 bg-danger px-1 text-xs text-white">
                                                    5
                                                </span>
                                                <span
                                                    class="me-1 bg-slate-100 px-1 text-xs text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                >
                                                    6
                                                </span>
                                            </div>
                                            <div class="mt-6 font-medium">
                                                نشانه حاشیه
                                            </div>
                                            <div class="mt-4">
                                                <span
                                                    class="me-1 rounded-full border border-primary px-3 py-2 text-primary dark:border-primary"
                                                >
                                                    1
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border px-3 py-2 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                >
                                                    2
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border border-success px-3 py-2 text-success dark:border-success"
                                                >
                                                    3
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border border-warning px-3 py-2 text-warning dark:border-warning"
                                                >
                                                    4
                                                </span>
                                                <span
                                                    class="me-1 rounded-full border border-danger px-3 py-2 text-danger dark:border-danger"
                                                >
                                                    5
                                                </span>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div class="font-medium">نشانه پایه</div>
                                                <div class="mt-2">
                                                    <span
                                                        class="me-1 rounded-full bg-primary px-1 text-xs text-white">1</span>
                                                    <span
                                                        class="me-1 rounded-full border px-1 text-xs text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span
                                                        class="me-1 rounded-full bg-success px-1 text-xs text-white">3</span>
                                                    <span
                                                        class="me-1 rounded-full bg-warning px-1 text-xs text-white">4</span>
                                                    <span
                                                        class="me-1 rounded-full bg-danger px-1 text-xs text-white">5</span>
                                                    <span
                                                        class="me-1 rounded-full bg-slate-100 px-1 text-xs text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                    >6</span>
                                                </div>
                                                <div class="mt-6 font-medium">اندازه‌های نشانه</div>
                                                <div class="mt-3">
                                                    <span
                                                        class="me-1 rounded-full bg-primary px-2 py-1 text-white">1</span>
                                                    <span
                                                        class="me-1 rounded-full border px-2 py-1 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span
                                                        class="me-1 rounded-full bg-success px-2 py-1 text-white">3</span>
                                                    <span
                                                        class="me-1 rounded-full bg-warning px-2 py-1 text-white">4</span>
                                                    <span class="me-1 rounded-full bg-danger px-2 py-1 text-white">5</span>
                                                    <span
                                                        class="me-1 rounded-full bg-slate-100 px-2 py-1 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                    >6</span>
                                                </div>
                                                <div class="mt-4">
                                                    <span
                                                        class="me-1 rounded-full bg-primary px-3 py-2 text-white">1</span>
                                                    <span
                                                        class="me-1 rounded-full border px-3 py-2 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span
                                                        class="me-1 rounded-full bg-success px-3 py-2 text-white">3</span>
                                                    <span
                                                        class="me-1 rounded-full bg-warning px-3 py-2 text-white">4</span>
                                                    <span class="me-1 rounded-full bg-danger px-3 py-2 text-white">5</span>
                                                    <span
                                                        class="me-1 rounded-full bg-slate-100 px-3 py-2 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                    >6</span>
                                                </div>
                                                <div class="mt-6">
                                                    <span
                                                        class="me-1 rounded-full bg-primary px-4 py-3 text-white">1</span>
                                                    <span
                                                        class="me-1 rounded-full border px-4 py-3 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span
                                                        class="me-1 rounded-full bg-success px-4 py-3 text-white">3</span>
                                                    <span
                                                        class="me-1 rounded-full bg-warning px-4 py-3 text-white">4</span>
                                                    <span class="me-1 rounded-full bg-danger px-4 py-3 text-white">5</span>
                                                    <span
                                                        class="me-1 rounded-full bg-slate-100 px-4 py-3 text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                    >6</span>
                                                </div>
                                                <div class="mt-10 font-medium">نشانه مربعی</div>
                                                <div class="mt-2">
                                                    <span class="me-1 bg-primary px-1 text-xs text-white">1</span>
                                                    <span
                                                        class="me-1 border px-1 text-xs text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span class="me-1 bg-success px-1 text-xs text-white">3</span>
                                                    <span class="me-1 bg-warning px-1 text-xs text-white">4</span>
                                                    <span class="me-1 bg-danger px-1 text-xs text-white">5</span>
                                                    <span
                                                        class="me-1 bg-slate-100 px-1 text-xs text-slate-500 dark:bg-darkmode-800 dark:text-slate-300"
                                                    >6</span>
                                                </div>
                                                <div class="mt-6 font-medium">نشانه حاشیه</div>
                                                <div class="mt-4">
                                                    <span
                                                        class="me-1 rounded-full border border-primary px-3 py-2 text-primary dark:border-primary"
                                                    >1</span>
                                                    <span
                                                        class="me-1 rounded-full border px-3 py-2 text-slate-600 dark:border-darkmode-100/40 dark:text-slate-300"
                                                    >2</span>
                                                    <span
                                                        class="me-1 rounded-full border border-success px-3 py-2 text-success dark:border-success"
                                                    >3</span>
                                                    <span
                                                        class="me-1 rounded-full border border-warning px-3 py-2 text-warning dark:border-warning"
                                                    >4</span>
                                                    <span
                                                        class="me-1 rounded-full border border-danger px-3 py-2 text-danger dark:border-danger"
                                                    >5</span>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    نشان‌ها اجزای چندمنظوره‌ای هستند که می‌توانند به شما در انتقال
                                    اطلاعات مهم یا برجسته کردن عناصر خاص در
                                    برنامه‌ی شما کمک کنند. با استفاده از انواع مختلف، آیکون‌ها،
                                    شمارش و استایل دلخواه، می‌توانید نشانه‌هایی ایجاد کنید که
                                    به‌طور یکپارچه در طراحی شما جا بیفتند و تجربه کاربر را بهبود بخشند
                                    با اندازه‌های مختلف آزمایش کنید تا اندازه‌ای را پیدا کنید که بهترین تطابق با اهداف طراحی شما را داشته باشد و تجربه کاربری بهینه را ارائه دهد.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">
                                    جداکننده
                                </div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-5"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-5"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    جداکننده‌ها برای ایجاد تقسیم‌بندی‌های بصری یا
                                    فاصله بین عناصر در یک رابط کاربری استفاده می‌شوند. آن‌ها به
                                    بهبود طرح کلی و خوانایی یک صفحه کمک می‌کنند.
                                    این بخش راه‌های مختلف استفاده از جداکننده‌ها را پوشش می‌دهد
                                    در برنامه‌های وب شما به‌طور موثر.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div
                                                class="w-full border-t border-dashed border-slate-200/60 dark:border-darkmode-400">
                                            </div>
                                            <div class="mt-5 w-full border-t border-slate-200/60 dark:border-darkmode-400">
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div
                                                    class="w-full border-t border-dashed border-slate-200/60 dark:border-darkmode-400">
                                                </div>
                                                <div
                                                    class="mt-5 w-full border-t border-slate-200/60 dark:border-darkmode-400">
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    جداکننده‌ها نقش حیاتی در بهبود طرح
                                    و خوانایی صفحات وب شما دارند. آن‌ها می‌توانند به
                                    ایجاد یک سلسله مراتب بصری و بهبود کلی تجربه کاربر
                                    کمک کنند. با استفاده از انواع مختلف جداکننده‌ها و
                                    استایل‌های دلخواه، می‌توانید آن‌ها را به‌طوری که با
                                    طراحی برنامه شما همخوانی داشته باشند و ساختار موثری را
                                    content.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">Divider</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-6"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-6"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    تقسیم‌کننده‌ها برای ایجاد جدایی‌های بصری روشن
                                    بین بخش‌ها یا محتوا در یک صفحه وب استفاده می‌شوند. آن‌ها به
                                    بهبود ساختار کلی و سازماندهی یک
                                    صفحه کمک می‌کنند. این بخش راه‌های مختلف استفاده از تقسیم‌کننده‌ها را پوشش می‌دهد
                                    در برنامه‌های وب شما به‌طور موثر.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div
                                                class="mt-2 flex w-full justify-center border-t border-slate-200/60 dark:border-darkmode-400">
                                                <div class="-mt-3 bg-white px-5 text-slate-500 dark:bg-darkmode-600">
                                                    or
                                                </div>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div
                                                    class="mt-2 flex w-full justify-center border-t border-slate-200/60 dark:border-darkmode-400">
                                                    <div class="-mt-3 bg-white px-5 text-slate-500 dark:bg-darkmode-600">
                                                        or
                                                    </div>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    تقسیم‌کننده‌ها برای حفظ یک ساختار خوب
                                    در برنامه‌های وب شما ضروری هستند. آن‌ها به
                                    ایجاد یک سلسله مراتب بصری روشن و بهبود کلی تجربه کاربر
                                    را با ارائه احساس سازمان و
                                    جدایی بین بخش‌های محتوا فراهم می‌کنند.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                    <div class="box box--stacked flex flex-col p-5">
                        <x-base.preview-component>
                            <div
                                class="mb-5 flex flex-col border-b border-dashed border-slate-300/70 pb-5 sm:flex-row sm:items-center">
                                <div class="text-[0.94rem] font-medium">Links</div>
                                <x-base.form-switch class="mt-3 w-full sm:ms-auto sm:mt-0 sm:w-auto">
                                    <x-base.form-switch.label
                                        class="ms-0 sm:ms-2"
                                        for="show-example-7"
                                    >
                                        نمایش کد نمونه
                                    </x-base.form-switch.label>
                                    <x-base.form-switch.input
                                        class="ms-3 me-0"
                                        id="show-example-7"
                                        type="checkbox"
                                    />
                                </x-base.form-switch>
                            </div>
                            <div>
                                <p class="leading-relaxed">
                                    پیوندها بخش اساسی از توسعه وب هستند و
                                    هدایت. آن‌ها به کاربران اجازه می‌دهند بین
                                    صفحات یا منابع مختلف در اینترنت پیمایش کنند. این
                                    بخش مروری بر روی استفاده از پیوندها در توسعه وب و
                                    ارائه نمونه‌هایی از چگونگی ایجاد و استایل پیوندها را
                                    به‌طور موثر فراهم می‌کند.
                                </p>
                                <div
                                    class="relative mb-4 mt-7 rounded-[0.6rem] border border-slate-200/80 dark:border-darkmode-400">
                                    <div class="absolute start-0 -mt-2 ms-4 bg-white px-3 text-xs uppercase text-slate-500">
                                        <div class="-mt-px">نمونه کد / پیش‌نمایش</div>
                                    </div>
                                    <div class="mt-4 flex flex-col gap-3.5 px-5 py-2">
                                        <x-base.preview>
                                            <div>
                                                <a
                                                    class="block font-normal text-primary"
                                                    href=""
                                                >
                                                    متن نمونه
                                                </a>
                                                <a
                                                    class="block font-medium text-primary"
                                                    href=""
                                                >
                                                    متن متوسط نمونه
                                                </a>
                                                <a
                                                    class="block font-semibold text-primary"
                                                    href=""
                                                >
                                                    متن نیمه‌جسور نمونه
                                                </a>
                                                <a
                                                    class="block font-bold text-primary"
                                                    href=""
                                                >
                                                    متن پردازش شده نمونه
                                                </a>
                                                <a
                                                    class="block font-extrabold text-primary"
                                                    href=""
                                                >
                                                    متن بلند شده نمونه
                                                </a>
                                            </div>
                                            <div class="mt-5">
                                                <a
                                                    class="block text-primary"
                                                    href=""
                                                >
                                                    حالت اصلی
                                                </a>
                                                <a
                                                    class="block text-slate-600 dark:text-slate-500"
                                                    href=""
                                                >
                                                    حالت ثانویه
                                                </a>
                                                <a
                                                    class="block text-success"
                                                    href=""
                                                >
                                                    حالت موفقیت
                                                </a>
                                                <a
                                                    class="block text-warning"
                                                    href=""
                                                >
                                                    حالت هشدار
                                                </a>
                                                <a
                                                    class="block text-danger"
                                                    href=""
                                                >
                                                    حالت خطر
                                                </a>
                                            </div>
                                        </x-base.preview>
                                        <x-base.source>
                                            <x-base.highlight>
                                                <div>
                                                    <a
                                                        class="block font-normal text-primary"
                                                        href=""
                                                    >متن نمونه</a>
                                                    <a
                                                        class="block font-medium text-primary"
                                                        href=""
                                                    >متن متوسط نمونه</a>
                                                    <a
                                                        class="block font-semibold text-primary"
                                                        href=""
                                                    >متن نیمه‌جسور نمونه</a>
                                                    <a
                                                        class="block font-bold text-primary"
                                                        href=""
                                                    >متن پردازش شده نمونه</a>
                                                    <a
                                                        class="block font-extrabold text-primary"
                                                        href=""
                                                    >متن بلند شده نمونه</a>
                                                </div>
                                                <div class="mt-5">
                                                    <a
                                                        class="block text-primary"
                                                        href=""
                                                    >حالت اصلی</a>
                                                    <a
                                                        class="block text-slate-600 dark:text-slate-500"
                                                        href=""
                                                    >حالت ثانویه</a>
                                                    <a
                                                        class="block text-success"
                                                        href=""
                                                    >حالت موفقیت</a>
                                                    <a
                                                        class="block text-warning"
                                                        href=""
                                                    >حالت هشدار</a>
                                                    <a
                                                        class="block text-danger"
                                                        href=""
                                                    >حالت خطر</a>
                                                </div>
                                            </x-base.highlight>
                                        </x-base.source>
                                    </div>
                                </div>
                                <p class="leading-relaxed">
                                    پیوندها بخش حیاتی از توسعه وب هستند و امکان می‌دهند
                                    کاربران بین صفحات و منابع مختلف حرکت کنند. درک
                                    چگونگی ایجاد و استایل پیوندها به‌طور موثر برای
                                    فراهم کردن یک تجربه یافتنی و کاربرپسند حیاتی است.
                                    تجربه مرور. با استفاده از دستور زبان HTML و CSS مناسب
                                    استایل، می‌توانید پیوندهای خود را جذاب بصری کنید و
                                    کاربردی، تجربه کاربری کلی را در
                                    وب‌سایت یا برنامه وب خود بهبود بخشید.
                                </p>
                            </div>
                        </x-base.preview-component>
                    </div>
                </div>
                <div class="relative order-first col-span-12 lg:order-last lg:col-span-3 xl:col-span-2">
                    <div class="sticky top-[104px]">
                        <ul
                            class="relative flex flex-col rounded-[0.6rem] border border-primary/10 bg-primary/[0.03] py-2.5 text-slate-600/80 group-[.mode--light]:border-slate-300/20 group-[.mode--light]:bg-slate-300/10">
                            <li @class([
                                'relative ps-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white active',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    سربرگ
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    تنظیمات متن
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    عناصر مشترک
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    نشان‌ها
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] group-[.mode--light]:text-white/90 [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70 [.group.mode--light_&.active]:text-white [.group.mode--light_&.active]:before:bg-white',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    جداکننده
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    Divider
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    Links
                                </a>
                            </li>
                            <li @class([
                                'relative px-5 py-[9.2px] [&.active]:text-primary [&.active]:font-medium [&.active]:before:bg-primary/70',
                                "before:content-[''] before:absolute before:h-[60%] before:w-0.5 before:start-0 before:inset-y-0 before:my-auto before:-ms-px",
                            ])>
                                <a
                                    class="-mt-px block truncate"
                                    href=""
                                >
                                    رابط اجزاء
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
